/*
 * Decompiled with CFR 0.152.
 */
package tachyon.client.block;

import com.google.common.io.Closer;
import java.io.Closeable;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.net.InetSocketAddress;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import tachyon.client.ClientContext;
import tachyon.client.block.BlockStoreContext;
import tachyon.client.block.BufferedBlockInStream;
import tachyon.util.io.BufferUtils;
import tachyon.util.network.NetworkAddressUtils;
import tachyon.worker.WorkerClient;

public final class LocalBlockInStream
extends BufferedBlockInStream {
    private final Closer mCloser;
    private final FileChannel mLocalFileChannel;
    private final WorkerClient mWorkerClient;
    private final BlockStoreContext mContext = BlockStoreContext.INSTANCE;

    public LocalBlockInStream(long blockId, long blockSize, InetSocketAddress location) throws IOException {
        super(blockId, blockSize, location);
        this.mCloser = Closer.create();
        this.mWorkerClient = this.mContext.acquireWorkerClient(NetworkAddressUtils.getLocalHostName(ClientContext.getConf()));
        FileChannel localFileChannel = null;
        try {
            String blockPath = this.mWorkerClient.lockBlock(blockId);
            if (blockPath == null) {
                throw new IOException("Block " + this.mBlockId + " is not available on local machine.");
            }
            RandomAccessFile localFile = (RandomAccessFile)this.mCloser.register((Closeable)new RandomAccessFile(blockPath, "r"));
            localFileChannel = (FileChannel)this.mCloser.register((Closeable)localFile.getChannel());
        }
        catch (IOException e) {
            this.mContext.releaseWorkerClient(this.mWorkerClient);
            throw e;
        }
        this.mLocalFileChannel = localFileChannel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        if (this.mClosed) {
            return;
        }
        try {
            if (this.mBlockIsRead) {
                this.mWorkerClient.accessBlock(this.mBlockId);
                ClientContext.getClientMetrics().incBlocksReadLocal(1L);
            }
            this.mWorkerClient.unlockBlock(this.mBlockId);
        }
        finally {
            this.mContext.releaseWorkerClient(this.mWorkerClient);
            this.mCloser.close();
            if (this.mBuffer != null && this.mBuffer.isDirect()) {
                BufferUtils.cleanDirectBuffer(this.mBuffer);
            }
        }
        this.mClosed = true;
    }

    @Override
    protected void bufferedRead(int len) throws IOException {
        if (this.mBuffer.isDirect()) {
            BufferUtils.cleanDirectBuffer(this.mBuffer);
        }
        this.mBuffer = this.mLocalFileChannel.map(FileChannel.MapMode.READ_ONLY, this.getPosition(), len);
    }

    @Override
    public int directRead(byte[] b, int off, int len) throws IOException {
        MappedByteBuffer buf = this.mLocalFileChannel.map(FileChannel.MapMode.READ_ONLY, this.getPosition(), len);
        buf.get(b, off, len);
        BufferUtils.cleanDirectBuffer(buf);
        return len;
    }

    @Override
    protected void incrementBytesReadMetric(int bytes) {
        ClientContext.getClientMetrics().incBytesReadLocal(bytes);
    }
}

