/*
 * Decompiled with CFR 0.152.
 */
package tachyon.network.protocol;

import com.google.common.base.Preconditions;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.FileRegion;
import io.netty.handler.codec.MessageToMessageEncoder;
import java.util.List;
import tachyon.network.protocol.RPCMessage;
import tachyon.network.protocol.databuffer.DataBuffer;

@ChannelHandler.Sharable
public final class RPCMessageEncoder
extends MessageToMessageEncoder<RPCMessage> {
    protected void encode(ChannelHandlerContext ctx, RPCMessage in, List<Object> out) throws Exception {
        RPCMessage.Type type = in.getType();
        long bodyBytes = 0L;
        DataBuffer payload = null;
        if (in.hasPayload()) {
            payload = in.getPayloadDataBuffer();
            bodyBytes = payload.getLength();
        }
        int lengthBytes = 8;
        int typeBytes = type.getEncodedLength();
        int messageBytes = in.getEncodedLength();
        int headerBytes = lengthBytes + typeBytes + messageBytes;
        long frameBytes = (long)headerBytes + bodyBytes;
        ByteBuf buffer = ctx.alloc().buffer();
        buffer.writeLong(frameBytes);
        type.encode(buffer);
        in.encode(buffer);
        out.add(buffer);
        if (payload != null && bodyBytes > 0L) {
            Object output = payload.getNettyOutput();
            Preconditions.checkArgument((output instanceof ByteBuf || output instanceof FileRegion ? 1 : 0) != 0, (Object)"The payload must be a ByteBuf or a FileRegion.");
            out.add(output);
        }
    }
}

