/*
 * Decompiled with CFR 0.152.
 */
package tachyon.underfs;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import tachyon.TachyonURI;
import tachyon.collections.Pair;
import tachyon.conf.TachyonConf;
import tachyon.underfs.UnderFileSystemRegistry;

public abstract class UnderFileSystem {
    protected final TachyonConf mTachyonConf;
    private boolean mProvidesStorage = true;

    public static UnderFileSystem get(String path, TachyonConf tachyonConf) {
        return UnderFileSystem.get(path, null, tachyonConf);
    }

    public static UnderFileSystem get(String path, Object ufsConf, TachyonConf tachyonConf) {
        Preconditions.checkArgument((path != null ? 1 : 0) != 0, (Object)"path may not be null");
        Preconditions.checkNotNull((Object)tachyonConf);
        return UnderFileSystemRegistry.create(path, tachyonConf, ufsConf);
    }

    public abstract UnderFSType getUnderFSType();

    public static boolean isHadoopUnderFS(String path, TachyonConf tachyonConf) {
        for (String prefix : tachyonConf.getList("tachyon.underfs.hdfs.prefixes", ",")) {
            if (!path.startsWith(prefix)) continue;
            return true;
        }
        return false;
    }

    public boolean providesStorage() {
        return this.mProvidesStorage;
    }

    public static Pair<String, String> parse(TachyonURI path, TachyonConf tachyonConf) {
        Preconditions.checkNotNull((Object)path);
        if (path.hasScheme()) {
            String authority;
            String header = path.getScheme() + "://";
            String string = authority = path.hasAuthority() ? path.getAuthority() : "";
            if (header.equals("tachyon://") || header.equals("tachyon-ft://") || UnderFileSystem.isHadoopUnderFS(header, tachyonConf) || header.equals("s3://") || header.equals("s3n://")) {
                if (path.getPath().isEmpty()) {
                    return new Pair<String, String>(header + authority, "/");
                }
                return new Pair<String, String>(header + authority, path.getPath());
            }
            if (header.equals("file://")) {
                return new Pair<String, String>("/", path.getPath());
            }
        } else if (path.isPathAbsolute()) {
            return new Pair<String, String>("/", path.getPath());
        }
        return null;
    }

    protected UnderFileSystem(TachyonConf tachyonConf) {
        this.mTachyonConf = tachyonConf;
    }

    public abstract void connectFromMaster(TachyonConf var1, String var2) throws IOException;

    public abstract void connectFromWorker(TachyonConf var1, String var2) throws IOException;

    public abstract void close() throws IOException;

    public abstract OutputStream create(String var1) throws IOException;

    public abstract OutputStream create(String var1, int var2) throws IOException;

    public abstract OutputStream create(String var1, short var2, int var3) throws IOException;

    public abstract boolean delete(String var1, boolean var2) throws IOException;

    public abstract boolean exists(String var1) throws IOException;

    public abstract long getBlockSizeByte(String var1) throws IOException;

    public abstract Object getConf();

    public abstract List<String> getFileLocations(String var1) throws IOException;

    public abstract List<String> getFileLocations(String var1, long var2) throws IOException;

    public abstract long getFileSize(String var1) throws IOException;

    public abstract long getModificationTimeMs(String var1) throws IOException;

    public abstract long getSpace(String var1, SpaceType var2) throws IOException;

    public abstract boolean isFile(String var1) throws IOException;

    public abstract String[] list(String var1) throws IOException;

    public abstract boolean mkdirs(String var1, boolean var2) throws IOException;

    public abstract InputStream open(String var1) throws IOException;

    public abstract boolean rename(String var1, String var2) throws IOException;

    public abstract void setConf(Object var1);

    public abstract void setPermission(String var1, String var2) throws IOException;

    public static enum UnderFSType {
        LOCAL,
        HDFS,
        S3,
        GLUSTERFS,
        SWIFT;

    }

    public static enum SpaceType {
        SPACE_TOTAL(0),
        SPACE_FREE(1),
        SPACE_USED(2);

        private final int mValue;

        private SpaceType(int value) {
            this.mValue = value;
        }

        public int getValue() {
            return this.mValue;
        }
    }
}

