/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro;

import java.io.File;
import java.io.IOException;
import org.apache.avro.Foo;
import org.apache.avro.Schema;
import org.apache.avro.file.DataFileReader;
import org.apache.avro.file.DataFileWriter;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericDatumWriter;
import org.apache.avro.io.DatumReader;
import org.apache.avro.io.DatumWriter;
import org.apache.avro.specific.SpecificDatumReader;
import org.junit.Assert;
import org.junit.Test;

public class TestDataFileSpecific {
    private static final File DIR = new File(System.getProperty("test.dir", "/tmp"));
    private static final File FILE = new File(DIR, "specific.avro");

    @Test
    public void testSpecificDatumReaderDefaultCtor() throws IOException {
        Schema s1 = Schema.parse((String)"{\"type\":\"record\",\"name\":\"Foo\",\"namespace\":\"org.apache.avro\",\"fields\":[{\"name\":\"label\",\"type\":\"string\"},{\"name\":\"id\",\"type\":\"int\"}]}");
        DataFileWriter writer = new DataFileWriter((DatumWriter)new GenericDatumWriter(s1)).create(s1, FILE);
        for (int i = 0; i < 10; ++i) {
            GenericData.Record r = new GenericData.Record(s1);
            r.put("label", (Object)("" + i));
            r.put("id", (Object)i);
            writer.append((Object)r);
        }
        writer.close();
        DataFileReader reader = new DataFileReader(FILE, (DatumReader)new SpecificDatumReader());
        int i = 0;
        for (Foo f : reader) {
            Assert.assertEquals((Object)("" + i++), (Object)f.getLabel().toString());
        }
        Assert.assertEquals((long)10L, (long)i);
        reader.close();
    }
}

