/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.deploy;

import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.lang.reflect.Method;
import java.security.PrivilegedExceptionAction;
import java.util.Arrays;
import java.util.Comparator;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.hdfs.security.token.delegation.DelegationTokenIdentifier;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.TaskAttemptID;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.TokenIdentifier;
import org.apache.spark.Logging;
import org.apache.spark.Logging$class;
import org.apache.spark.SparkConf;
import org.apache.spark.annotation.DeveloperApi;
import org.apache.spark.deploy.SparkHadoopUtil$;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import org.spark-project.guava.primitives.Longs;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.LinearSeqOptimized;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.StringBuilder;
import scala.concurrent.duration.package;
import scala.math.Numeric;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.TraitSetter;
import scala.util.control.NonFatal$;
import scala.util.matching.Regex;
import scala.util.matching.UnanchoredRegex;

@DeveloperApi
@ScalaSignature(bytes="\u0006\u0001\tmf\u0001B\u0001\u0003\u0001-\u0011qb\u00159be.D\u0015\rZ8paV#\u0018\u000e\u001c\u0006\u0003\u0007\u0011\ta\u0001Z3qY>L(BA\u0003\u0007\u0003\u0015\u0019\b/\u0019:l\u0015\t9\u0001\"\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u0013\u0005\u0019qN]4\u0004\u0001M\u0019\u0001\u0001\u0004\n\u0011\u00055\u0001R\"\u0001\b\u000b\u0003=\tQa]2bY\u0006L!!\u0005\b\u0003\r\u0005s\u0017PU3g!\t\u0019B#D\u0001\u0005\u0013\t)BAA\u0004M_\u001e<\u0017N\\4\t\u000b]\u0001A\u0011\u0001\r\u0002\rqJg.\u001b;?)\u0005I\u0002C\u0001\u000e\u0001\u001b\u0005\u0011\u0001b\u0002\u000f\u0001\u0005\u0004%I!H\u0001\ngB\f'o[\"p]\u001a,\u0012A\b\t\u0003'}I!\u0001\t\u0003\u0003\u0013M\u0003\u0018M]6D_:4\u0007B\u0002\u0012\u0001A\u0003%a$\u0001\u0006ta\u0006\u00148nQ8oM\u0002Bq\u0001\n\u0001C\u0002\u0013\u0005Q%\u0001\u0003d_:4W#\u0001\u0014\u0011\u0005\u001dZS\"\u0001\u0015\u000b\u0005\u0011J#B\u0001\u0016\u0007\u0003\u0019A\u0017\rZ8pa&\u0011A\u0006\u000b\u0002\u000e\u0007>tg-[4ve\u0006$\u0018n\u001c8\t\r9\u0002\u0001\u0015!\u0003'\u0003\u0015\u0019wN\u001c4!\u0011\u0015\u0001\u0004\u0001\"\u00012\u00039\u0011XO\\!t'B\f'o[+tKJ$\"AM\u001b\u0011\u00055\u0019\u0014B\u0001\u001b\u000f\u0005\u0011)f.\u001b;\t\u000bYz\u0003\u0019A\u001c\u0002\t\u0019,hn\u0019\t\u0004\u001ba\u0012\u0014BA\u001d\u000f\u0005%1UO\\2uS>t\u0007\u0007C\u0003<\u0001\u0011\u0005A(A\nue\u0006t7OZ3s\u0007J,G-\u001a8uS\u0006d7\u000fF\u00023{\u0015CQA\u0010\u001eA\u0002}\naa]8ve\u000e,\u0007C\u0001!D\u001b\u0005\t%B\u0001\"*\u0003!\u0019XmY;sSRL\u0018B\u0001#B\u0005Q)6/\u001a:He>,\b/\u00138g_Jl\u0017\r^5p]\")aI\u000fa\u0001\u007f\u0005!A-Z:u\u0011\u0015A\u0005\u0001\"\u0001J\u0003AqWm^\"p]\u001aLw-\u001e:bi&|g\u000eF\u0001'Q\u001195J\u0014)\u0011\u00055a\u0015BA'\u000f\u0005)!W\r\u001d:fG\u0006$X\rZ\u0011\u0002\u001f\u0006aSo]3!]\u0016<8i\u001c8gS\u001e,(/\u0019;j_:\u0004s/\u001b;iAM\u0003\u0018M]6D_:4\u0007%\u0019:hk6,g\u000e^\u0011\u0002#\u0006)\u0011G\f\u001a/a!)\u0001\n\u0001C\u0001'R\u0011a\u0005\u0016\u0005\u0006II\u0003\rA\b\u0005\u0006-\u0002!\taV\u0001\u000fC\u0012$7I]3eK:$\u0018.\u00197t)\t\u0011\u0004\fC\u0003%+\u0002\u0007\u0011\f\u0005\u0002[;6\t1L\u0003\u0002]S\u00051Q.\u00199sK\u0012L!AX.\u0003\u000f){'mQ8oM\")\u0001\r\u0001C\u0001C\u0006Q\u0011n]-be:lu\u000eZ3\u0015\u0003\t\u0004\"!D2\n\u0005\u0011t!a\u0002\"p_2,\u0017M\u001c\u0005\u0006M\u0002!\taZ\u0001\u001aO\u0016$8)\u001e:sK:$Xk]3s\u0007J,G-\u001a8uS\u0006d7\u000fF\u0001i!\t\u0001\u0015.\u0003\u0002k\u0003\nY1I]3eK:$\u0018.\u00197t\u0011\u0015a\u0007\u0001\"\u0001n\u0003e\tG\rZ\"veJ,g\u000e^+tKJ\u001c%/\u001a3f]RL\u0017\r\\:\u0015\u0005Ir\u0007\"B8l\u0001\u0004A\u0017!B2sK\u0012\u001c\b\"B9\u0001\t\u0003\u0011\u0018!H1eIN+7M]3u\u0017\u0016LHk\\+tKJ\u001c%/\u001a3f]RL\u0017\r\\:\u0015\u0007I\u001aH\u0010C\u0003ua\u0002\u0007Q/A\u0002lKf\u0004\"A^=\u000f\u000559\u0018B\u0001=\u000f\u0003\u0019\u0001&/\u001a3fM&\u0011!p\u001f\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005at\u0001\"B?q\u0001\u0004)\u0018AB:fGJ,G\u000f\u0003\u0004\u0000\u0001\u0011\u0005\u0011\u0011A\u0001 O\u0016$8+Z2sKR\\U-\u001f$s_6,6/\u001a:De\u0016$WM\u001c;jC2\u001cH\u0003BA\u0002\u0003\u001f\u0001R!DA\u0003\u0003\u0013I1!a\u0002\u000f\u0005\u0015\t%O]1z!\ri\u00111B\u0005\u0004\u0003\u001bq!\u0001\u0002\"zi\u0016DQ\u0001\u001e@A\u0002UDq!a\u0005\u0001\t\u0003\t)\"A\nm_\u001eLg.V:fe\u001a\u0013x.\\&fsR\f'\rF\u00033\u0003/\tY\u0002C\u0004\u0002\u001a\u0005E\u0001\u0019A;\u0002\u001bA\u0014\u0018N\\2ja\u0006dg*Y7f\u0011\u001d\ti\"!\u0005A\u0002U\fab[3zi\u0006\u0014g)\u001b7f]\u0006lW\r\u0003\u0005\u0002\"\u0001!\t\u0001BA\u0012\u0003y9W\r\u001e$T\u0005f$Xm\u001d*fC\u0012|e\u000e\u00165sK\u0006$7)\u00197mE\u0006\u001c7\u000e\u0006\u0002\u0002&A)Q\"a\n\u0002,%\u0019\u0011\u0011\u0006\b\u0003\r=\u0003H/[8o!\u0011i\u0001(!\f\u0011\u00075\ty#C\u0002\u000229\u0011A\u0001T8oO\"A\u0011Q\u0007\u0001\u0005\u0002\u0011\t\u0019#A\u0011hKR45KQ=uKN<&/\u001b;uK:|e\u000e\u00165sK\u0006$7)\u00197mE\u0006\u001c7\u000eC\u0004\u0002:\u0001!I!a\u000f\u0002;\u001d,GOR5mKNK8\u000f^3n)\"\u0014X-\u00193Ti\u0006$\u0018n\u001d;jGN$\"!!\u0010\u0011\u000b\u0005}\u0012q\n\u0007\u000f\t\u0005\u0005\u00131\n\b\u0005\u0003\u0007\nI%\u0004\u0002\u0002F)\u0019\u0011q\t\u0006\u0002\rq\u0012xn\u001c;?\u0013\u0005y\u0011bAA'\u001d\u00059\u0001/Y2lC\u001e,\u0017\u0002BA)\u0003'\u00121aU3r\u0015\r\tiE\u0004\u0005\b\u0003/\u0002A\u0011BA-\u0003\r:W\r\u001e$jY\u0016\u001c\u0016p\u001d;f[RC'/Z1e'R\fG/[:uS\u000e\u001cX*\u001a;i_\u0012$B!a\u0017\u0002pA!\u0011QLA6\u001b\t\tyF\u0003\u0003\u0002b\u0005\r\u0014a\u0002:fM2,7\r\u001e\u0006\u0005\u0003K\n9'\u0001\u0003mC:<'BAA5\u0003\u0011Q\u0017M^1\n\t\u00055\u0014q\f\u0002\u0007\u001b\u0016$\bn\u001c3\t\u000f\u0005E\u0014Q\u000ba\u0001k\u0006QQ.\u001a;i_\u0012t\u0015-\\3\t\u000f\u0005U\u0004\u0001\"\u0001\u0002x\u0005qr-\u001a;D_:4\u0017nZ;sCRLwN\u001c$s_6TuNY\"p]R,\u0007\u0010\u001e\u000b\u0004M\u0005e\u0004\u0002CA>\u0003g\u0002\r!! \u0002\u000f\r|g\u000e^3yiB!\u0011qPAC\u001b\t\t\tIC\u0002\u0002\u0004&\n\u0011\"\\1qe\u0016$WoY3\n\t\u0005\u001d\u0015\u0011\u0011\u0002\u000b\u0015>\u00147i\u001c8uKb$\bbBAF\u0001\u0011\u0005\u0011QR\u0001'O\u0016$H+Y:l\u0003R$X-\u001c9u\u0013\u00123%o\\7UCN\\\u0017\t\u001e;f[B$8i\u001c8uKb$H\u0003BAH\u0003+\u0003B!a \u0002\u0012&!\u00111SAA\u00055!\u0016m]6BiR,W\u000e\u001d;J\t\"A\u00111PAE\u0001\u0004\t9\n\u0005\u0003\u0002\u0000\u0005e\u0015\u0002BAN\u0003\u0003\u0013!\u0003V1tW\u0006#H/Z7qi\u000e{g\u000e^3yi\"9\u0011q\u0014\u0001\u0005\u0002\u0005\u0005\u0016\u0001\u00057jgRdU-\u00194Ti\u0006$Xo]3t)\u0019\t\u0019+!-\u0002:B1\u0011qHA(\u0003K\u0003B!a*\u0002.6\u0011\u0011\u0011\u0016\u0006\u0004\u0003WK\u0013A\u00014t\u0013\u0011\ty+!+\u0003\u0015\u0019KG.Z*uCR,8\u000f\u0003\u0005\u0002,\u0006u\u0005\u0019AAZ!\u0011\t9+!.\n\t\u0005]\u0016\u0011\u0016\u0002\u000b\r&dWmU=ti\u0016l\u0007\u0002CA^\u0003;\u0003\r!!0\u0002\u0011\t\f7/\u001a)bi\"\u0004B!a*\u0002@&!\u0011\u0011YAU\u0005\u0011\u0001\u0016\r\u001e5\t\u000f\u0005}\u0005\u0001\"\u0001\u0002FR1\u00111UAd\u0003\u0013D\u0001\"a+\u0002D\u0002\u0007\u00111\u0017\u0005\t\u0003\u0017\f\u0019\r1\u0001\u0002&\u0006Q!-Y:f'R\fG/^:\t\u000f\u0005=\u0007\u0001\"\u0001\u0002R\u0006\u0019B.[:u\u0019\u0016\fg\rR5s'R\fG/^:fgR1\u00111UAj\u0003+D\u0001\"a+\u0002N\u0002\u0007\u00111\u0017\u0005\t\u0003w\u000bi\r1\u0001\u0002>\"9\u0011q\u001a\u0001\u0005\u0002\u0005eGCBAR\u00037\fi\u000e\u0003\u0005\u0002,\u0006]\u0007\u0019AAZ\u0011!\tY-a6A\u0002\u0005\u0015\u0006bBAq\u0001\u0011\u0005\u00111]\u0001\tO2|'\rU1uQR!\u0011Q]At!\u0019\ty$a\u0014\u0002>\"A\u0011\u0011^Ap\u0001\u0004\ti,A\u0004qCR$XM\u001d8\t\u000f\u00055\b\u0001\"\u0001\u0002p\u0006\u0019r\r\\8c!\u0006$\b.\u00134OK\u000e,7o]1ssR!\u0011Q]Ay\u0011!\tI/a;A\u0002\u0005u\u0006bBA{\u0001\u0011\u0005\u0011q_\u0001\u0010Y&\u001cHOR5mKN\u001cvN\u001d;fIRQ\u0011\u0011`A~\u0003\u007f\u0014\u0019Aa\u0002\u0011\u000b5\t)!!*\t\u0011\u0005u\u00181\u001fa\u0001\u0003g\u000b\u0001B]3n_R,gi\u001d\u0005\t\u0005\u0003\t\u0019\u00101\u0001\u0002>\u0006\u0019A-\u001b:\t\u000f\t\u0015\u00111\u001fa\u0001k\u00061\u0001O]3gSbDqA!\u0003\u0002t\u0002\u0007Q/A\bfq\u000edWo]5p]N+hMZ5y\u0011\u001d\u0011i\u0001\u0001C\u0001\u0005\u001f\tqcZ3u)&lWM\u0012:p[:{w\u000fV8SK:,w/\u00197\u0015\u0011\u00055\"\u0011\u0003B\n\u0005;Aa\u0001\bB\u0006\u0001\u0004q\u0002\u0002\u0003B\u000b\u0005\u0017\u0001\rAa\u0006\u0002\u0011\u0019\u0014\u0018m\u0019;j_:\u00042!\u0004B\r\u0013\r\u0011YB\u0004\u0002\u0007\t>,(\r\\3\t\u000f\t}!1\u0002a\u0001Q\u0006Y1M]3eK:$\u0018.\u00197t\u0011!\u0011\u0019\u0003\u0001C\u0001\t\t\u0015\u0012aG4fiN+hMZ5y\r>\u00148I]3eK:$\u0018.\u00197t!\u0006$\b\u000e\u0006\u0003\u0003(\t5\u0002cA\u0007\u0003*%\u0019!1\u0006\b\u0003\u0007%sG\u000f\u0003\u0005\u00030\t\u0005\u0002\u0019AA_\u0003=\u0019'/\u001a3f]RL\u0017\r\\:QCRD\u0007\"\u0003B\u001a\u0001\t\u0007I\u0011\u0002B\u001b\u0003MA\u0015\tR(P!~\u001buJ\u0014$`!\u0006#F+\u0012*O+\t\u00119\u0004\u0005\u0003\u0003:\t\rSB\u0001B\u001e\u0015\u0011\u0011iDa\u0010\u0002\u00115\fGo\u00195j]\u001eT1A!\u0011\u000f\u0003\u0011)H/\u001b7\n\t\t\u0015#1\b\u0002\u0010+:\fgn\u00195pe\u0016$'+Z4fq\"A!\u0011\n\u0001!\u0002\u0013\u00119$\u0001\u000bI\u0003\u0012{u\nU0D\u001f:3u\fU!U)\u0016\u0013f\n\t\u0005\b\u0005\u001b\u0002A\u0011\u0001B(\u0003e\u0019XOY:uSR,H/\u001a%bI>|\u0007OV1sS\u0006\u0014G.Z:\u0015\u000bU\u0014\tF!\u0016\t\u000f\tM#1\na\u0001k\u0006!A/\u001a=u\u0011\u001d\u00119Fa\u0013A\u0002\u0019\n!\u0002[1e_>\u00048i\u001c8g\u0011!\u0011Y\u0006\u0001C\u0001\t\tu\u0013aI:uCJ$X\t_3dkR|'\u000fR3mK\u001e\fG/[8o)>\\WM\u001c*f]\u0016<XM\u001d\u000b\u0004e\t}\u0003B\u0002\u0013\u0003Z\u0001\u0007a\u0004\u0003\u0005\u0003d\u0001!\t\u0001\u0002B3\u0003\t\u001aHo\u001c9Fq\u0016\u001cW\u000f^8s\t\u0016dWmZ1uS>tGk\\6f]J+g.Z<feR\t!\u0007\u0003\u0005\u0003j\u0001!\t\u0001\u0002B6\u0003]9W\r^\"p]\u001a\u0014\u0015\u0010]1tg&twMR*DC\u000eDW\rF\u0003'\u0005[\u0012y\u0007C\u0004\u0003X\t\u001d\u0004\u0019\u0001\u0014\t\u000f\tE$q\ra\u0001k\u000611o\u00195f[\u0016D3\u0001\u0001B;!\u0011\u00119H! \u000e\u0005\te$b\u0001B>\t\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\t}$\u0011\u0010\u0002\r\t\u00164X\r\\8qKJ\f\u0005/[\u0004\b\u0005\u0007\u0013\u0001\u0012\u0001BC\u0003=\u0019\u0006/\u0019:l\u0011\u0006$wn\u001c9Vi&d\u0007c\u0001\u000e\u0003\b\u001a1\u0011A\u0001E\u0001\u0005\u0013\u001b2Aa\"\r\u0011\u001d9\"q\u0011C\u0001\u0005\u001b#\"A!\"\t\u0015)\u00129\t#b\u0001\n\u0013\u0011\t*F\u0001\u001a\u0011)\u0011)Ja\"\t\u0002\u0003\u0006K!G\u0001\bQ\u0006$wn\u001c9!\u0011-\u0011IJa\"\t\u0006\u0004%IA!%\u0002\te\f'O\u001c\u0005\u000b\u0005;\u00139\t#A!B\u0013I\u0012!B=be:\u0004\u0003B\u0003BQ\u0005\u000f\u0013\r\u0011\"\u0001\u0003$\u0006y2\u000bU!S\u0017~K\u0016I\u0015(`\u0007J+EiU0U\u000b6\u0003v,\u0012-U\u000b:\u001b\u0016j\u0014(\u0016\u0005\t\u0015\u0006\u0003\u0002BT\u0005Sk!!a\u0019\n\u0007i\f\u0019\u0007C\u0005\u0003.\n\u001d\u0005\u0015!\u0003\u0003&\u0006\u00013\u000bU!S\u0017~K\u0016I\u0015(`\u0007J+EiU0U\u000b6\u0003v,\u0012-U\u000b:\u001b\u0016j\u0014(!\u0011)\u0011\tLa\"C\u0002\u0013\u0005!1U\u0001\u001f'B\u000b%kS0Z\u0003Jsul\u0011*F\tN{6iT+O)\u0016\u0013v\fR#M\u00136C\u0011B!.\u0003\b\u0002\u0006IA!*\u0002?M\u0003\u0016IU&`3\u0006\u0013fjX\"S\u000b\u0012\u001bvlQ(V\u001dR+%k\u0018#F\u0019&k\u0005\u0005\u0003\u0005\u0003:\n\u001dE\u0011\u0001BI\u0003\r9W\r\u001e")
public class SparkHadoopUtil
implements Logging {
    private final SparkConf sparkConf;
    private final Configuration conf;
    private final UnanchoredRegex org$apache$spark$deploy$SparkHadoopUtil$$HADOOP_CONF_PATTERN;
    private transient Logger org$apache$spark$Logging$$log_;

    public static SparkHadoopUtil get() {
        return SparkHadoopUtil$.MODULE$.get();
    }

    public static String SPARK_YARN_CREDS_COUNTER_DELIM() {
        return SparkHadoopUtil$.MODULE$.SPARK_YARN_CREDS_COUNTER_DELIM();
    }

    public static String SPARK_YARN_CREDS_TEMP_EXTENSION() {
        return SparkHadoopUtil$.MODULE$.SPARK_YARN_CREDS_TEMP_EXTENSION();
    }

    @Override
    public Logger org$apache$spark$Logging$$log_() {
        return this.org$apache$spark$Logging$$log_;
    }

    @Override
    @TraitSetter
    public void org$apache$spark$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$Logging$$log_ = x$1;
    }

    @Override
    public String logName() {
        return Logging$class.logName(this);
    }

    @Override
    public Logger log() {
        return Logging$class.log(this);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logging$class.logInfo(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logging$class.logDebug(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logging$class.logTrace(this, msg);
    }

    @Override
    public void logWarning(Function0<String> msg) {
        Logging$class.logWarning(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logging$class.logError(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging$class.logInfo(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging$class.logDebug(this, msg, throwable);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging$class.logTrace(this, msg, throwable);
    }

    @Override
    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging$class.logWarning(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logging$class.logError(this, msg, throwable);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging$class.isTraceEnabled(this);
    }

    private SparkConf sparkConf() {
        return this.sparkConf;
    }

    public Configuration conf() {
        return this.conf;
    }

    public void runAsSparkUser(Function0<BoxedUnit> func) {
        String user = Utils$.MODULE$.getCurrentUserName();
        this.logDebug((Function0<String>)new Serializable(this, user){
            public static final long serialVersionUID = 0L;
            private final String user$1;

            public final String apply() {
                return new StringBuilder().append((Object)"running as user: ").append((Object)this.user$1).toString();
            }
            {
                this.user$1 = user$1;
            }
        });
        UserGroupInformation ugi = UserGroupInformation.createRemoteUser((String)user);
        this.transferCredentials(UserGroupInformation.getCurrentUser(), ugi);
        ugi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<BoxedUnit>(this, func){
            private final Function0 func$1;

            public void run() {
                this.func$1.apply$mcV$sp();
            }
            {
                this.func$1 = func$1;
            }
        });
    }

    public void transferCredentials(UserGroupInformation source, UserGroupInformation dest) {
        ((IterableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(source.getTokens()).asScala()).foreach((Function1)new Serializable(this, dest){
            public static final long serialVersionUID = 0L;
            private final UserGroupInformation dest$1;

            public final boolean apply(Token<? extends TokenIdentifier> token) {
                return this.dest$1.addToken(token);
            }
            {
                this.dest$1 = dest$1;
            }
        });
    }

    public Configuration newConfiguration() {
        return this.newConfiguration(null);
    }

    /*
     * WARNING - void declaration
     */
    public Configuration newConfiguration(SparkConf conf) {
        void var2_2;
        Configuration hadoopConf = new Configuration();
        if (conf != null) {
            if (System.getenv("AWS_ACCESS_KEY_ID") != null && System.getenv("AWS_SECRET_ACCESS_KEY") != null) {
                String keyId = System.getenv("AWS_ACCESS_KEY_ID");
                String accessKey = System.getenv("AWS_SECRET_ACCESS_KEY");
                hadoopConf.set("fs.s3.awsAccessKeyId", keyId);
                hadoopConf.set("fs.s3n.awsAccessKeyId", keyId);
                hadoopConf.set("fs.s3a.access.key", keyId);
                hadoopConf.set("fs.s3.awsSecretAccessKey", accessKey);
                hadoopConf.set("fs.s3n.awsSecretAccessKey", accessKey);
                hadoopConf.set("fs.s3a.secret.key", accessKey);
            }
            Predef$.MODULE$.refArrayOps((Object[])conf.getAll()).foreach((Function1)new Serializable(this, hadoopConf){
                public static final long serialVersionUID = 0L;
                private final Configuration hadoopConf$1;

                public final void apply(Tuple2<String, String> x0$1) {
                    Tuple2<String, String> tuple2 = x0$1;
                    if (tuple2 != null) {
                        BoxedUnit boxedUnit;
                        String key = (String)tuple2._1();
                        String value = (String)tuple2._2();
                        if (key.startsWith("spark.hadoop.")) {
                            this.hadoopConf$1.set(key.substring("spark.hadoop.".length()), value);
                            boxedUnit = BoxedUnit.UNIT;
                        } else {
                            boxedUnit = BoxedUnit.UNIT;
                        }
                        BoxedUnit boxedUnit2 = boxedUnit;
                        return;
                    }
                    throw new MatchError(tuple2);
                }
                {
                    this.hadoopConf$1 = hadoopConf$1;
                }
            });
            String bufferSize = conf.get("spark.buffer.size", "65536");
            hadoopConf.set("io.file.buffer.size", bufferSize);
        }
        return var2_2;
    }

    public void addCredentials(JobConf conf) {
    }

    public boolean isYarnMode() {
        return false;
    }

    public Credentials getCurrentUserCredentials() {
        return null;
    }

    public void addCurrentUserCredentials(Credentials creds) {
    }

    public void addSecretKeyToUserCredentials(String key, String secret) {
    }

    public byte[] getSecretKeyFromUserCredentials(String key) {
        return null;
    }

    public void loginUserFromKeytab(String principalName, String keytabFilename) {
        UserGroupInformation.loginUserFromKeytab((String)principalName, (String)keytabFilename);
    }

    public Option<Function0<Object>> getFSBytesReadOnThreadCallback() {
        Throwable throwable2;
        block2: {
            Some some;
            try {
                Seq<Object> threadStats = this.getFileSystemThreadStatistics();
                Method getBytesReadMethod = this.getFileSystemThreadStatisticsMethod("getBytesRead");
                Serializable f = new Serializable(this, threadStats, getBytesReadMethod){
                    public static final long serialVersionUID = 0L;
                    private final Seq threadStats$1;
                    public final Method getBytesReadMethod$1;

                    public final long apply() {
                        return this.apply$mcJ$sp();
                    }

                    public long apply$mcJ$sp() {
                        return BoxesRunTime.unboxToLong((Object)((TraversableOnce)this.threadStats$1.map((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ $anonfun$1 $outer;

                            public final long apply(Object x$1) {
                                return BoxesRunTime.unboxToLong((Object)this.$outer.getBytesReadMethod$1.invoke(x$1, new Object[0]));
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                            }
                        }, Seq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
                    }
                    {
                        this.threadStats$1 = threadStats$1;
                        this.getBytesReadMethod$1 = getBytesReadMethod$1;
                    }
                };
                long baselineBytesRead = f.apply$mcJ$sp();
                some = new Some((Object)new Serializable(this, (Function0)f, baselineBytesRead){
                    public static final long serialVersionUID = 0L;
                    private final Function0 f$1;
                    private final long baselineBytesRead$1;

                    public final long apply() {
                        return this.apply$mcJ$sp();
                    }

                    public long apply$mcJ$sp() {
                        return this.f$1.apply$mcJ$sp() - this.baselineBytesRead$1;
                    }
                    {
                        this.f$1 = f$1;
                        this.baselineBytesRead$1 = baselineBytesRead$1;
                    }
                });
            }
            catch (Throwable throwable2) {
                Throwable throwable3 = throwable2;
                boolean bl = throwable3 instanceof NoSuchMethodException ? true : throwable3 instanceof ClassNotFoundException;
                if (!bl) break block2;
                this.logDebug((Function0<String>)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "Couldn't find method for retrieving thread-level FileSystem input data";
                    }
                }, throwable3);
                None$ none$ = None$.MODULE$;
                some = none$;
            }
            return some;
        }
        throw throwable2;
    }

    public Option<Function0<Object>> getFSBytesWrittenOnThreadCallback() {
        Throwable throwable2;
        block2: {
            Some some;
            try {
                Seq<Object> threadStats = this.getFileSystemThreadStatistics();
                Method getBytesWrittenMethod = this.getFileSystemThreadStatisticsMethod("getBytesWritten");
                Serializable f = new Serializable(this, threadStats, getBytesWrittenMethod){
                    public static final long serialVersionUID = 0L;
                    private final Seq threadStats$2;
                    public final Method getBytesWrittenMethod$1;

                    public final long apply() {
                        return this.apply$mcJ$sp();
                    }

                    public long apply$mcJ$sp() {
                        return BoxesRunTime.unboxToLong((Object)((TraversableOnce)this.threadStats$2.map((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ $anonfun$2 $outer;

                            public final long apply(Object x$2) {
                                return BoxesRunTime.unboxToLong((Object)this.$outer.getBytesWrittenMethod$1.invoke(x$2, new Object[0]));
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                            }
                        }, Seq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
                    }
                    {
                        this.threadStats$2 = threadStats$2;
                        this.getBytesWrittenMethod$1 = getBytesWrittenMethod$1;
                    }
                };
                long baselineBytesWritten = f.apply$mcJ$sp();
                some = new Some((Object)new Serializable(this, (Function0)f, baselineBytesWritten){
                    public static final long serialVersionUID = 0L;
                    private final Function0 f$2;
                    private final long baselineBytesWritten$1;

                    public final long apply() {
                        return this.apply$mcJ$sp();
                    }

                    public long apply$mcJ$sp() {
                        return this.f$2.apply$mcJ$sp() - this.baselineBytesWritten$1;
                    }
                    {
                        this.f$2 = f$2;
                        this.baselineBytesWritten$1 = baselineBytesWritten$1;
                    }
                });
            }
            catch (Throwable throwable2) {
                Throwable throwable3 = throwable2;
                boolean bl = throwable3 instanceof NoSuchMethodException ? true : throwable3 instanceof ClassNotFoundException;
                if (!bl) break block2;
                this.logDebug((Function0<String>)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "Couldn't find method for retrieving thread-level FileSystem output data";
                    }
                }, throwable3);
                None$ none$ = None$.MODULE$;
                some = none$;
            }
            return some;
        }
        throw throwable2;
    }

    private Seq<Object> getFileSystemThreadStatistics() {
        return (Seq)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(FileSystem.getAllStatistics()).asScala()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Object apply(FileSystem.Statistics x$3) {
                return Utils$.MODULE$.invoke(FileSystem.Statistics.class, x$3, "getThreadStatistics", (Seq<Tuple2<Class<?>, Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
            }
        }, Buffer$.MODULE$.canBuildFrom());
    }

    private Method getFileSystemThreadStatisticsMethod(String methodName) {
        Class<?> statisticsDataClass = Utils$.MODULE$.classForName("org.apache.hadoop.fs.FileSystem$Statistics$StatisticsData");
        return statisticsDataClass.getDeclaredMethod(methodName, new Class[0]);
    }

    public Configuration getConfigurationFromJobContext(JobContext context) {
        Method method = context.getClass().getMethod("getConfiguration", new Class[0]);
        return (Configuration)method.invoke((Object)context, new Object[0]);
    }

    public TaskAttemptID getTaskAttemptIDFromTaskAttemptContext(TaskAttemptContext context) {
        Method method = context.getClass().getMethod("getTaskAttemptID", new Class[0]);
        return (TaskAttemptID)method.invoke((Object)context, new Object[0]);
    }

    public Seq<FileStatus> listLeafStatuses(FileSystem fs, Path basePath) {
        return this.listLeafStatuses(fs, fs.getFileStatus(basePath));
    }

    public Seq<FileStatus> listLeafStatuses(FileSystem fs, FileStatus baseStatus) {
        return baseStatus.isDir() ? this.recurse$1(baseStatus, fs) : (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new FileStatus[]{baseStatus}));
    }

    public Seq<FileStatus> listLeafDirStatuses(FileSystem fs, Path basePath) {
        return this.listLeafDirStatuses(fs, fs.getFileStatus(basePath));
    }

    public Seq<FileStatus> listLeafDirStatuses(FileSystem fs, FileStatus baseStatus) {
        Predef$.MODULE$.assert(baseStatus.isDir());
        return this.recurse$2(baseStatus, fs);
    }

    public Seq<Path> globPath(Path pattern) {
        FileSystem fs = pattern.getFileSystem(this.conf());
        return (Seq)Option$.MODULE$.apply((Object)fs.globStatus(pattern)).map((Function1)new Serializable(this, fs){
            public static final long serialVersionUID = 0L;
            public final FileSystem fs$3;

            public final Seq<Path> apply(FileStatus[] statuses) {
                return Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])statuses).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$globPath$1 $outer;

                    public final Path apply(FileStatus x$8) {
                        return x$8.getPath().makeQualified(this.$outer.fs$3.getUri(), this.$outer.fs$3.getWorkingDirectory());
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Path.class)))).toSeq();
            }
            {
                this.fs$3 = fs$3;
            }
        }).getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Seq<Path> apply() {
                return (Seq)Seq$.MODULE$.empty();
            }
        });
    }

    public Seq<Path> globPathIfNecessary(Path pattern) {
        Set set = new StringOps(Predef$.MODULE$.augmentString("{}[]*?\\")).toSet();
        return new StringOps(Predef$.MODULE$.augmentString(pattern.toString())).exists((Function1)new Serializable(this, set){
            public static final long serialVersionUID = 0L;
            private final Set eta$0$1$1;

            public final boolean apply(Object elem) {
                return this.eta$0$1$1.contains(elem);
            }
            {
                this.eta$0$1$1 = eta$0$1$1;
            }
        }) ? this.globPath(pattern) : (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Path[]{pattern}));
    }

    public FileStatus[] listFilesSorted(FileSystem remoteFs, Path dir, String prefix, String exclusionSuffix) {
        FileStatus[] fileStatusArray;
        try {
            FileStatus[] fileStatuses = remoteFs.listStatus(dir, new PathFilter(this, prefix, exclusionSuffix){
                private final String prefix$1;
                private final String exclusionSuffix$1;

                public boolean accept(Path path) {
                    String name = path.getName();
                    return name.startsWith(this.prefix$1) && !name.endsWith(this.exclusionSuffix$1);
                }
                {
                    this.prefix$1 = prefix$1;
                    this.exclusionSuffix$1 = exclusionSuffix$1;
                }
            });
            Arrays.sort((Object[])fileStatuses, new Comparator<FileStatus>(this){

                public int compare(FileStatus o1, FileStatus o2) {
                    return Longs.compare((long)o1.getModificationTime(), (long)o2.getModificationTime());
                }
            });
            fileStatusArray = fileStatuses;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (option.isEmpty()) {
                throw throwable;
            }
            Throwable e = (Throwable)option.get();
            this.logWarning((Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Error while attempting to list files from application staging dir";
                }
            }, e);
            FileStatus[] fileStatusArray2 = (FileStatus[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(FileStatus.class));
            fileStatusArray = fileStatusArray2;
        }
        return fileStatusArray;
    }

    public long getTimeFromNowToRenewal(SparkConf sparkConf, double fraction, Credentials credentials) {
        long now = System.currentTimeMillis();
        long renewalInterval = sparkConf.getLong("spark.yarn.token.renewal.interval", new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(24)).hours().toMillis());
        return BoxesRunTime.unboxToLong((Object)((TraversableOnce)((TraversableLike)((TraversableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(credentials.getAllTokens()).asScala()).filter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Token<? extends TokenIdentifier> x$9) {
                Text text = x$9.getKind();
                Text text2 = DelegationTokenIdentifier.HDFS_DELEGATION_KIND;
                return !(text != null ? !text.equals(text2) : text2 != null);
            }
        })).map((Function1)new Serializable(this, fraction, now, renewalInterval){
            public static final long serialVersionUID = 0L;
            private final double fraction$1;
            private final long now$1;
            private final long renewalInterval$1;

            public final long apply(Token<? extends TokenIdentifier> t) {
                DelegationTokenIdentifier identifier = new DelegationTokenIdentifier();
                identifier.readFields((DataInput)new DataInputStream(new ByteArrayInputStream(t.getIdentifier())));
                return (long)((double)identifier.getIssueDate() + this.fraction$1 * (double)this.renewalInterval$1) - this.now$1;
            }
            {
                this.fraction$1 = fraction$1;
                this.now$1 = now$1;
                this.renewalInterval$1 = renewalInterval$1;
            }
        }, Iterable$.MODULE$.canBuildFrom())).foldLeft((Object)BoxesRunTime.boxToLong((long)0L), (Function2)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply(long x, long y) {
                return this.apply$mcJJJ$sp(x, y);
            }

            public long apply$mcJJJ$sp(long x, long y) {
                return package$.MODULE$.max(x, y);
            }
        }));
    }

    public int getSuffixForCredentialsPath(Path credentialsPath) {
        String fileName = credentialsPath.getName();
        return new StringOps(Predef$.MODULE$.augmentString(fileName.substring(fileName.lastIndexOf(SparkHadoopUtil$.MODULE$.SPARK_YARN_CREDS_COUNTER_DELIM()) + 1))).toInt();
    }

    public UnanchoredRegex org$apache$spark$deploy$SparkHadoopUtil$$HADOOP_CONF_PATTERN() {
        return this.org$apache$spark$deploy$SparkHadoopUtil$$HADOOP_CONF_PATTERN;
    }

    public String substituteHadoopVariables(String text, Configuration hadoopConf) {
        String string;
        String string2 = text;
        Option option = ((Regex)this.org$apache$spark$deploy$SparkHadoopUtil$$HADOOP_CONF_PATTERN()).unapplySeq((CharSequence)string2);
        if (!option.isEmpty() && option.get() != null && ((LinearSeqOptimized)option.get()).lengthCompare(1) == 0) {
            String matched = (String)((LinearSeqOptimized)option.get()).apply(0);
            this.logDebug((Function0<String>)new Serializable(this, text){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ SparkHadoopUtil $outer;
                private final String text$1;

                public final String apply() {
                    return new StringBuilder().append((Object)this.text$1).append((Object)" matched ").append((Object)this.$outer.org$apache$spark$deploy$SparkHadoopUtil$$HADOOP_CONF_PATTERN()).toString();
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.text$1 = text$1;
                }
            });
            String key = matched.substring(13, matched.length() - 1);
            Option eval = Option$.MODULE$.apply((Object)hadoopConf.get(key)).map((Function1)new Serializable(this, text, matched){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ SparkHadoopUtil $outer;
                private final String text$1;
                public final String matched$1;

                public final String apply(String value) {
                    this.$outer.logDebug((Function0<String>)new Serializable(this, value){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anonfun$5 $outer;
                        private final String value$1;

                        public final String apply() {
                            return new StringBuilder().append((Object)"Substituted ").append((Object)this.$outer.matched$1).append((Object)" with ").append((Object)this.value$1).toString();
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.value$1 = value$1;
                        }
                    });
                    return this.text$1.replace(this.matched$1, value);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.text$1 = text$1;
                    this.matched$1 = matched$1;
                }
            });
            string = eval.isEmpty() ? text : this.substituteHadoopVariables((String)eval.get(), hadoopConf);
        } else {
            this.logDebug((Function0<String>)new Serializable(this, text){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ SparkHadoopUtil $outer;
                private final String text$1;

                public final String apply() {
                    return new StringBuilder().append((Object)this.text$1).append((Object)" didn't match ").append((Object)this.$outer.org$apache$spark$deploy$SparkHadoopUtil$$HADOOP_CONF_PATTERN()).toString();
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.text$1 = text$1;
                }
            });
            string = text;
        }
        return string;
    }

    public void startExecutorDelegationTokenRenewer(SparkConf conf) {
    }

    public void stopExecutorDelegationTokenRenewer() {
    }

    /*
     * WARNING - void declaration
     */
    public Configuration getConfBypassingFSCache(Configuration hadoopConf, String scheme) {
        void var3_3;
        Configuration newConf = new Configuration(hadoopConf);
        String confKey = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"fs.", ".impl.disable.cache"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{scheme}));
        newConf.setBoolean(confKey, true);
        return var3_3;
    }

    private final Seq recurse$1(FileStatus status, FileSystem fs$1) {
        Tuple2 tuple2 = Predef$.MODULE$.refArrayOps((Object[])fs$1.listStatus(status.getPath())).partition((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(FileStatus x$4) {
                return x$4.isDir();
            }
        });
        if (tuple2 != null) {
            Tuple2 tuple22;
            FileStatus[] directories = (FileStatus[])tuple2._1();
            FileStatus[] leaves = (FileStatus[])tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)directories, (Object)leaves);
            FileStatus[] directories2 = (FileStatus[])tuple23._1();
            FileStatus[] leaves2 = (FileStatus[])tuple23._2();
            return (Seq)Predef$.MODULE$.refArrayOps((Object[])leaves2).$plus$plus((GenTraversableOnce)Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])directories2).flatMap((Function1)new Serializable(this, fs$1){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ SparkHadoopUtil $outer;
                private final FileSystem fs$1;

                public final Seq<FileStatus> apply(FileStatus f) {
                    return this.$outer.listLeafStatuses(this.fs$1, f);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.fs$1 = fs$1;
                }
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(FileStatus.class)))), Array$.MODULE$.fallbackCanBuildFrom(Predef.DummyImplicit$.MODULE$.dummyImplicit()));
        }
        throw new MatchError((Object)tuple2);
    }

    private final Seq recurse$2(FileStatus status, FileSystem fs$2) {
        Tuple2 tuple2 = Predef$.MODULE$.refArrayOps((Object[])fs$2.listStatus(status.getPath())).partition((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(FileStatus x$6) {
                return x$6.isDir();
            }
        });
        if (tuple2 != null) {
            Tuple2 tuple22;
            FileStatus[] directories = (FileStatus[])tuple2._1();
            FileStatus[] files = (FileStatus[])tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)directories, (Object)files);
            FileStatus[] directories2 = (FileStatus[])tuple23._1();
            FileStatus[] files2 = (FileStatus[])tuple23._2();
            Seq leaves = Predef$.MODULE$.refArrayOps((Object[])directories2).isEmpty() ? (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new FileStatus[]{status})) : (Seq)Seq$.MODULE$.empty();
            return (Seq)leaves.$plus$plus((GenTraversableOnce)Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])directories2).flatMap((Function1)new Serializable(this, fs$2){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ SparkHadoopUtil $outer;
                private final FileSystem fs$2;

                public final Seq<FileStatus> apply(FileStatus dir) {
                    return this.$outer.listLeafDirStatuses(this.fs$2, dir);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.fs$2 = fs$2;
                }
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(FileStatus.class)))), Seq$.MODULE$.canBuildFrom());
        }
        throw new MatchError((Object)tuple2);
    }

    public SparkHadoopUtil() {
        Logging$class.$init$(this);
        this.sparkConf = new SparkConf();
        this.conf = this.newConfiguration(this.sparkConf());
        UserGroupInformation.setConfiguration((Configuration)this.conf());
        this.org$apache$spark$deploy$SparkHadoopUtil$$HADOOP_CONF_PATTERN = new StringOps(Predef$.MODULE$.augmentString("(\\$\\{hadoopconf-[^\\}\\$\\s]+\\})")).r().unanchored();
    }
}

