/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.deploy.rest;

import com.fasterxml.jackson.core.JsonProcessingException;
import java.io.DataOutputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.SocketException;
import java.net.URL;
import java.util.concurrent.TimeoutException;
import org.apache.spark.Logging;
import org.apache.spark.Logging$class;
import org.apache.spark.SparkConf;
import org.apache.spark.deploy.rest.CreateSubmissionRequest;
import org.apache.spark.deploy.rest.CreateSubmissionResponse;
import org.apache.spark.deploy.rest.ErrorResponse;
import org.apache.spark.deploy.rest.KillSubmissionResponse;
import org.apache.spark.deploy.rest.RestSubmissionClient$;
import org.apache.spark.deploy.rest.SubmissionStatusResponse;
import org.apache.spark.deploy.rest.SubmitRestConnectionException;
import org.apache.spark.deploy.rest.SubmitRestProtocolException;
import org.apache.spark.deploy.rest.SubmitRestProtocolException$;
import org.apache.spark.deploy.rest.SubmitRestProtocolMessage;
import org.apache.spark.deploy.rest.SubmitRestProtocolMessage$;
import org.apache.spark.deploy.rest.SubmitRestProtocolResponse;
import org.apache.spark.package$;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import org.spark-project.guava.base.Charsets;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.HashSet;
import scala.collection.mutable.StringBuilder;
import scala.concurrent.Await$;
import scala.concurrent.Awaitable;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.package;
import scala.io.Codec$;
import scala.io.Source$;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.TraitSetter;

@ScalaSignature(bytes="\u0006\u0001\t-a!B\u0001\u0003\u0001\u0019a!\u0001\u0006*fgR\u001cVOY7jgNLwN\\\"mS\u0016tGO\u0003\u0002\u0004\t\u0005!!/Z:u\u0015\t)a!\u0001\u0004eKBdw.\u001f\u0006\u0003\u000f!\tQa\u001d9be.T!!\u0003\u0006\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005Y\u0011aA8sON\u0019\u0001!D\n\u0011\u00059\tR\"A\b\u000b\u0003A\tQa]2bY\u0006L!AE\b\u0003\r\u0005s\u0017PU3g!\t!R#D\u0001\u0007\u0013\t1bAA\u0004M_\u001e<\u0017N\\4\t\u0011a\u0001!\u0011!Q\u0001\ni\ta!\\1ti\u0016\u00148\u0001\u0001\t\u00037yq!A\u0004\u000f\n\u0005uy\u0011A\u0002)sK\u0012,g-\u0003\u0002 A\t11\u000b\u001e:j]\u001eT!!H\b\t\u000b\t\u0002A\u0011A\u0012\u0002\rqJg.\u001b;?)\t!c\u0005\u0005\u0002&\u00015\t!\u0001C\u0003\u0019C\u0001\u0007!\u0004C\u0004)\u0001\t\u0007I\u0011B\u0015\u0002/M,\b\u000f]8si\u0016$W*Y:uKJ\u0004&/\u001a4jq\u0016\u001cX#\u0001\u0016\u0011\u0007-r\u0003'D\u0001-\u0015\tis\"\u0001\u0006d_2dWm\u0019;j_:L!a\f\u0017\u0003\u0007M+\u0017\u000f\u0005\u00022m5\t!G\u0003\u00024i\u0005!A.\u00198h\u0015\u0005)\u0014\u0001\u00026bm\u0006L!a\b\u001a\t\ra\u0002\u0001\u0015!\u0003+\u0003a\u0019X\u000f\u001d9peR,G-T1ti\u0016\u0014\bK]3gSb,7\u000f\t\u0005\bu\u0001\u0011\r\u0011\"\u0003<\u0003\u001di\u0017m\u001d;feN,\u0012\u0001\u0010\t\u0004\u001duR\u0012B\u0001 \u0010\u0005\u0015\t%O]1z\u0011\u0019\u0001\u0005\u0001)A\u0005y\u0005AQ.Y:uKJ\u001c\b\u0005C\u0004C\u0001\t\u0007I\u0011B\"\u0002\u00171|7\u000f^'bgR,'o]\u000b\u0002\tB\u0019Q\t\u0013\u000e\u000e\u0003\u0019S!a\u0012\u0017\u0002\u000f5,H/\u00192mK&\u0011\u0011J\u0012\u0002\b\u0011\u0006\u001c\bnU3u\u0011\u0019Y\u0005\u0001)A\u0005\t\u0006aAn\\:u\u001b\u0006\u001cH/\u001a:tA!)Q\n\u0001C\u0001\u001d\u0006\u00012M]3bi\u0016\u001cVOY7jgNLwN\u001c\u000b\u0003\u001fJ\u0003\"!\n)\n\u0005E\u0013!AG*vE6LGOU3tiB\u0013x\u000e^8d_2\u0014Vm\u001d9p]N,\u0007\"B*M\u0001\u0004!\u0016a\u0002:fcV,7\u000f\u001e\t\u0003KUK!A\u0016\u0002\u0003/\r\u0013X-\u0019;f'V\u0014W.[:tS>t'+Z9vKN$\b\"\u0002-\u0001\t\u0003I\u0016AD6jY2\u001cVOY7jgNLwN\u001c\u000b\u0003\u001fjCQaW,A\u0002i\tAb];c[&\u001c8/[8o\u0013\u0012DQ!\u0018\u0001\u0005\u0002y\u000bqC]3rk\u0016\u001cHoU;c[&\u001c8/[8o'R\fG/^:\u0015\u0007={\u0006\rC\u0003\\9\u0002\u0007!\u0004C\u0004b9B\u0005\t\u0019\u00012\u0002\u000bE,\u0018.\u001a;\u0011\u00059\u0019\u0017B\u00013\u0010\u0005\u001d\u0011un\u001c7fC:DQA\u001a\u0001\u0005\u0002\u001d\facY8ogR\u0014Xo\u0019;Tk\nl\u0017\u000e\u001e*fcV,7\u000f\u001e\u000b\u0007)\"TGN\\:\t\u000b%,\u0007\u0019\u0001\u000e\u0002\u0017\u0005\u0004\bOU3t_V\u00148-\u001a\u0005\u0006W\u0016\u0004\rAG\u0001\n[\u0006Lgn\u00117bgNDQ!\\3A\u0002q\nq!\u00199q\u0003J<7\u000fC\u0003pK\u0002\u0007\u0001/A\bta\u0006\u00148\u000e\u0015:pa\u0016\u0014H/[3t!\u0011Y\u0012O\u0007\u000e\n\u0005I\u0004#aA'ba\")A/\u001aa\u0001a\u0006!RM\u001c<je>tW.\u001a8u-\u0006\u0014\u0018.\u00192mKNDQA\u001e\u0001\u0005\n]\f1aZ3u)\ty\u0005\u0010C\u0003zk\u0002\u0007!0A\u0002ve2\u0004\"a\u001f@\u000e\u0003qT!! \u001b\u0002\u00079,G/\u0003\u0002\u0000y\n\u0019QK\u0015'\t\u000f\u0005\r\u0001\u0001\"\u0003\u0002\u0006\u0005!\u0001o\\:u)\ry\u0015q\u0001\u0005\u0007s\u0006\u0005\u0001\u0019\u0001>\t\u000f\u0005-\u0001\u0001\"\u0003\u0002\u000e\u0005A\u0001o\\:u\u0015N|g\u000eF\u0003P\u0003\u001f\t\t\u0002\u0003\u0004z\u0003\u0013\u0001\rA\u001f\u0005\b\u0003'\tI\u00011\u0001\u001b\u0003\u0011Q7o\u001c8\t\u0011\u0005]\u0001\u0001\"\u0001\u0003\u00033\tAB]3bIJ+7\u000f]8og\u0016$2aTA\u000e\u0011!\ti\"!\u0006A\u0002\u0005}\u0011AC2p]:,7\r^5p]B\u001910!\t\n\u0007\u0005\rBPA\tIiR\u0004XK\u0015'D_:tWm\u0019;j_:Dq!a\n\u0001\t\u0013\tI#\u0001\u0007hKR\u001cVOY7jiV\u0013H\u000eF\u0002{\u0003WAa\u0001GA\u0013\u0001\u0004Q\u0002bBA\u0018\u0001\u0011%\u0011\u0011G\u0001\u000bO\u0016$8*\u001b7m+JdG#\u0002>\u00024\u0005U\u0002B\u0002\r\u0002.\u0001\u0007!\u0004\u0003\u0004\\\u0003[\u0001\rA\u0007\u0005\b\u0003s\u0001A\u0011BA\u001e\u000319W\r^*uCR,8/\u0016:m)\u0015Q\u0018QHA \u0011\u0019A\u0012q\u0007a\u00015!11,a\u000eA\u0002iAq!a\u0011\u0001\t\u0013\t)%\u0001\u0006hKR\u0014\u0015m]3Ve2$2AGA$\u0011\u0019A\u0012\u0011\ta\u00015!9\u00111\n\u0001\u0005\n\u00055\u0013A\u0004<bY&$\u0017\r^3NCN$XM\u001d\u000b\u0005\u0003\u001f\n)\u0006E\u0002\u000f\u0003#J1!a\u0015\u0010\u0005\u0011)f.\u001b;\t\ra\tI\u00051\u0001\u001b\u0011\u001d\tI\u0006\u0001C\u0005\u00037\naC]3q_J$8+\u001e2nSN\u001c\u0018n\u001c8Ti\u0006$Xo\u001d\u000b\u0005\u0003\u001f\ni\u0006\u0003\u0005\u0002`\u0005]\u0003\u0019AA1\u00039\u0019XOY7jiJ+7\u000f]8og\u0016\u00042!JA2\u0013\r\t)G\u0001\u0002\u0019\u0007J,\u0017\r^3Tk\nl\u0017n]:j_:\u0014Vm\u001d9p]N,\u0007bBA5\u0001\u0011%\u00111N\u0001\u0015a>dGnU;c[&\u001c8/[8o'R\fG/^:\u0015\t\u0005=\u0013Q\u000e\u0005\u00077\u0006\u001d\u0004\u0019\u0001\u000e\t\u000f\u0005E\u0004\u0001\"\u0003\u0002t\u0005\u0011\u0002.\u00198eY\u0016\u0014Vm\u001d;SKN\u0004xN\\:f)\u0011\ty%!\u001e\t\u000f\u0005]\u0014q\u000ea\u0001\u001f\u0006A!/Z:q_:\u001cX\rC\u0004\u0002|\u0001!I!! \u00029!\fg\u000e\u001a7f+:,\u0007\u0010]3di\u0016$'+Z:u%\u0016\u001c\bo\u001c8tKR!\u0011qJA@\u0011\u001d\t\t)!\u001fA\u0002=\u000b!\"\u001e8fqB,7\r^3e\u0011\u001d\t)\t\u0001C\u0005\u0003\u000f\u000b\u0011\u0004[1oI2,7i\u001c8oK\u000e$\u0018n\u001c8Fq\u000e,\u0007\u000f^5p]R\u0019!-!#\t\u000f\u0005-\u00151\u0011a\u00015\u0005IQ.Y:uKJ,&\u000f\u001c\u0005\n\u0003\u001f\u0003\u0011\u0013!C\u0001\u0003#\u000b\u0011E]3rk\u0016\u001cHoU;c[&\u001c8/[8o'R\fG/^:%I\u00164\u0017-\u001e7uII*\"!a%+\u0007\t\f)j\u000b\u0002\u0002\u0018B!\u0011\u0011TAR\u001b\t\tYJ\u0003\u0003\u0002\u001e\u0006}\u0015!C;oG\",7m[3e\u0015\r\t\tkD\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BAS\u00037\u0013\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u000f!\tIK\u0001E\u0001\r\u0005-\u0016\u0001\u0006*fgR\u001cVOY7jgNLwN\\\"mS\u0016tG\u000fE\u0002&\u0003[3q!\u0001\u0002\t\u0002\u0019\tykE\u0002\u0002.6AqAIAW\t\u0003\t\u0019\f\u0006\u0002\u0002,\"Q\u0011qWAW\u0005\u0004%I!!/\u0002;I+\u0005k\u0014*U?\u0012\u0013\u0016JV#S?N#\u0016\tV+T?&sE+\u0012*W\u00032+\"!a/\u0011\u00079\ti,C\u0002\u0002@>\u00111!\u00138u\u0011%\t\u0019-!,!\u0002\u0013\tY,\u0001\u0010S\u000bB{%\u000bV0E%&3VIU0T)\u0006#VkU0J\u001dR+%KV!MA!Q\u0011qYAW\u0005\u0004%I!!/\u0002=I+\u0005k\u0014*U?\u0012\u0013\u0016JV#S?N#\u0016\tV+T?6\u000b\u0005l\u0018+S\u0013\u0016\u001b\u0006\"CAf\u0003[\u0003\u000b\u0011BA^\u0003}\u0011V\tU(S)~#%+\u0013,F%~\u001bF+\u0011+V'~k\u0015\tW0U%&+5\u000b\t\u0005\u000b\u0003\u001f\fiK1A\u0005\u0002\u0005E\u0017\u0001\u0005)S\u001fR{5i\u0014'`-\u0016\u00136+S(O+\u0005\u0001\u0004\u0002CAk\u0003[\u0003\u000b\u0011\u0002\u0019\u0002#A\u0013v\nV(D\u001f2{f+\u0012*T\u0013>s\u0005\u0005\u0003\u0005\u0002Z\u00065F\u0011AAn\u0003\r\u0011XO\u001c\u000b\f\u001f\u0006u\u0017q\\Aq\u0003G\fi\u000f\u0003\u0004j\u0003/\u0004\rA\u0007\u0005\u0007W\u0006]\u0007\u0019\u0001\u000e\t\r5\f9\u000e1\u0001=\u0011!\t)/a6A\u0002\u0005\u001d\u0018\u0001B2p]\u001a\u00042\u0001FAu\u0013\r\tYO\u0002\u0002\n'B\f'o[\"p]\u001aD\u0011\"a<\u0002XB\u0005\t\u0019\u00019\u0002\u0007\u0015tg\u000f\u0003\u0005\u0002t\u00065F\u0011AA{\u0003\u0011i\u0017-\u001b8\u0015\t\u0005=\u0013q\u001f\u0005\b\u0003s\f\t\u00101\u0001=\u0003\u0011\t'oZ:\t\u0013\u0005u\u0018Q\u0016C\u0001\u0005\u0005}\u0018a\u00064jYR,'oU=ti\u0016lWI\u001c<je>tW.\u001a8u)\r\u0001(\u0011\u0001\u0005\b\u0003_\fY\u00101\u0001q\u0011)\u0011)!!,\u0012\u0002\u0013\u0005!qA\u0001\u000eeVtG\u0005Z3gCVdG\u000fJ\u001b\u0016\u0005\t%!f\u00019\u0002\u0016\u0002")
public class RestSubmissionClient
implements Logging {
    public final String org$apache$spark$deploy$rest$RestSubmissionClient$$master;
    private final Seq<String> supportedMasterPrefixes;
    private final String[] masters;
    private final HashSet<String> lostMasters;
    private transient Logger org$apache$spark$Logging$$log_;

    public static Map<String, String> run$default$5() {
        return RestSubmissionClient$.MODULE$.run$default$5();
    }

    public static void main(String[] stringArray) {
        RestSubmissionClient$.MODULE$.main(stringArray);
    }

    public static SubmitRestProtocolResponse run(String string, String string2, String[] stringArray, SparkConf sparkConf, Map<String, String> map2) {
        return RestSubmissionClient$.MODULE$.run(string, string2, stringArray, sparkConf, map2);
    }

    public static String PROTOCOL_VERSION() {
        return RestSubmissionClient$.MODULE$.PROTOCOL_VERSION();
    }

    @Override
    public Logger org$apache$spark$Logging$$log_() {
        return this.org$apache$spark$Logging$$log_;
    }

    @Override
    @TraitSetter
    public void org$apache$spark$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$Logging$$log_ = x$1;
    }

    @Override
    public String logName() {
        return Logging$class.logName(this);
    }

    @Override
    public Logger log() {
        return Logging$class.log(this);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logging$class.logInfo(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logging$class.logDebug(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logging$class.logTrace(this, msg);
    }

    @Override
    public void logWarning(Function0<String> msg) {
        Logging$class.logWarning(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logging$class.logError(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging$class.logInfo(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging$class.logDebug(this, msg, throwable);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging$class.logTrace(this, msg, throwable);
    }

    @Override
    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging$class.logWarning(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logging$class.logError(this, msg, throwable);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging$class.isTraceEnabled(this);
    }

    private Seq<String> supportedMasterPrefixes() {
        return this.supportedMasterPrefixes;
    }

    private String[] masters() {
        return this.masters;
    }

    private HashSet<String> lostMasters() {
        return this.lostMasters;
    }

    public SubmitRestProtocolResponse createSubmission(CreateSubmissionRequest request) {
        this.logInfo((Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RestSubmissionClient $outer;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Submitting a request to launch an application in ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.org$apache$spark$deploy$rest$RestSubmissionClient$$master}));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        BooleanRef handled = BooleanRef.create((boolean)false);
        ObjectRef response = ObjectRef.create(null);
        Predef$.MODULE$.refArrayOps((Object[])this.masters()).withFilter((Function1)new Serializable(this, handled){
            public static final long serialVersionUID = 0L;
            private final BooleanRef handled$1;

            public final boolean apply(String m) {
                return !this.handled$1.elem;
            }
            {
                this.handled$1 = handled$1;
            }
        }).foreach((Function1)new Serializable(this, request, handled, response){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RestSubmissionClient $outer;
            private final CreateSubmissionRequest request$1;
            private final BooleanRef handled$1;
            private final ObjectRef response$1;

            public final void apply(String m) {
                block6: {
                    this.$outer.org$apache$spark$deploy$rest$RestSubmissionClient$$validateMaster(m);
                    URL url = this.$outer.org$apache$spark$deploy$rest$RestSubmissionClient$$getSubmitUrl(m);
                    try {
                        this.response$1.elem = this.$outer.org$apache$spark$deploy$rest$RestSubmissionClient$$postJson(url, this.request$1.toJson());
                        SubmitRestProtocolResponse submitRestProtocolResponse = (SubmitRestProtocolResponse)this.response$1.elem;
                        if (submitRestProtocolResponse instanceof CreateSubmissionResponse) {
                            BoxedUnit boxedUnit;
                            CreateSubmissionResponse createSubmissionResponse = (CreateSubmissionResponse)submitRestProtocolResponse;
                            if (Predef$.MODULE$.Boolean2boolean(createSubmissionResponse.success())) {
                                this.$outer.org$apache$spark$deploy$rest$RestSubmissionClient$$reportSubmissionStatus(createSubmissionResponse);
                                this.$outer.org$apache$spark$deploy$rest$RestSubmissionClient$$handleRestResponse(createSubmissionResponse);
                                this.handled$1.elem = true;
                                boxedUnit = BoxedUnit.UNIT;
                            } else {
                                boxedUnit = BoxedUnit.UNIT;
                            }
                            BoxedUnit boxedUnit2 = boxedUnit;
                        } else {
                            this.$outer.org$apache$spark$deploy$rest$RestSubmissionClient$$handleUnexpectedRestResponse(submitRestProtocolResponse);
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        }
                    }
                    catch (SubmitRestConnectionException submitRestConnectionException) {
                        if (!this.$outer.org$apache$spark$deploy$rest$RestSubmissionClient$$handleConnectionException(m)) break block6;
                        throw new SubmitRestConnectionException("Unable to connect to server", submitRestConnectionException);
                    }
                }
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.request$1 = request$1;
                this.handled$1 = handled$1;
                this.response$1 = response$1;
            }
        });
        return (SubmitRestProtocolResponse)response.elem;
    }

    public SubmitRestProtocolResponse killSubmission(String submissionId) {
        this.logInfo((Function0<String>)new Serializable(this, submissionId){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RestSubmissionClient $outer;
            private final String submissionId$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Submitting a request to kill submission ", " in ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.submissionId$1, this.$outer.org$apache$spark$deploy$rest$RestSubmissionClient$$master}));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.submissionId$1 = submissionId$1;
            }
        });
        BooleanRef handled = BooleanRef.create((boolean)false);
        ObjectRef response = ObjectRef.create(null);
        Predef$.MODULE$.refArrayOps((Object[])this.masters()).withFilter((Function1)new Serializable(this, handled){
            public static final long serialVersionUID = 0L;
            private final BooleanRef handled$2;

            public final boolean apply(String m) {
                return !this.handled$2.elem;
            }
            {
                this.handled$2 = handled$2;
            }
        }).foreach((Function1)new Serializable(this, submissionId, handled, response){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RestSubmissionClient $outer;
            private final String submissionId$1;
            private final BooleanRef handled$2;
            private final ObjectRef response$3;

            public final void apply(String m) {
                block6: {
                    this.$outer.org$apache$spark$deploy$rest$RestSubmissionClient$$validateMaster(m);
                    URL url = this.$outer.org$apache$spark$deploy$rest$RestSubmissionClient$$getKillUrl(m, this.submissionId$1);
                    try {
                        this.response$3.elem = this.$outer.org$apache$spark$deploy$rest$RestSubmissionClient$$post(url);
                        SubmitRestProtocolResponse submitRestProtocolResponse = (SubmitRestProtocolResponse)this.response$3.elem;
                        if (submitRestProtocolResponse instanceof KillSubmissionResponse) {
                            BoxedUnit boxedUnit;
                            KillSubmissionResponse killSubmissionResponse = (KillSubmissionResponse)submitRestProtocolResponse;
                            if (Utils$.MODULE$.responseFromBackup(killSubmissionResponse.message())) {
                                boxedUnit = BoxedUnit.UNIT;
                            } else {
                                this.$outer.org$apache$spark$deploy$rest$RestSubmissionClient$$handleRestResponse(killSubmissionResponse);
                                this.handled$2.elem = true;
                                boxedUnit = BoxedUnit.UNIT;
                            }
                            BoxedUnit boxedUnit2 = boxedUnit;
                        } else {
                            this.$outer.org$apache$spark$deploy$rest$RestSubmissionClient$$handleUnexpectedRestResponse(submitRestProtocolResponse);
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        }
                    }
                    catch (SubmitRestConnectionException submitRestConnectionException) {
                        if (!this.$outer.org$apache$spark$deploy$rest$RestSubmissionClient$$handleConnectionException(m)) break block6;
                        throw new SubmitRestConnectionException("Unable to connect to server", submitRestConnectionException);
                    }
                }
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.submissionId$1 = submissionId$1;
                this.handled$2 = handled$2;
                this.response$3 = response$3;
            }
        });
        return (SubmitRestProtocolResponse)response.elem;
    }

    public SubmitRestProtocolResponse requestSubmissionStatus(String submissionId, boolean quiet) {
        this.logInfo((Function0<String>)new Serializable(this, submissionId){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RestSubmissionClient $outer;
            private final String submissionId$2;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Submitting a request for the status of submission ", " in ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.submissionId$2, this.$outer.org$apache$spark$deploy$rest$RestSubmissionClient$$master}));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.submissionId$2 = submissionId$2;
            }
        });
        BooleanRef handled = BooleanRef.create((boolean)false);
        ObjectRef response = ObjectRef.create(null);
        Predef$.MODULE$.refArrayOps((Object[])this.masters()).withFilter((Function1)new Serializable(this, handled){
            public static final long serialVersionUID = 0L;
            private final BooleanRef handled$3;

            public final boolean apply(String m) {
                return !this.handled$3.elem;
            }
            {
                this.handled$3 = handled$3;
            }
        }).foreach((Function1)new Serializable(this, submissionId, quiet, handled, response){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RestSubmissionClient $outer;
            private final String submissionId$2;
            private final boolean quiet$1;
            private final BooleanRef handled$3;
            private final ObjectRef response$4;

            public final void apply(String m) {
                block5: {
                    this.$outer.org$apache$spark$deploy$rest$RestSubmissionClient$$validateMaster(m);
                    URL url = this.$outer.org$apache$spark$deploy$rest$RestSubmissionClient$$getStatusUrl(m, this.submissionId$2);
                    try {
                        SubmissionStatusResponse submissionStatusResponse;
                        this.response$4.elem = this.$outer.org$apache$spark$deploy$rest$RestSubmissionClient$$get(url);
                        SubmitRestProtocolResponse submitRestProtocolResponse = (SubmitRestProtocolResponse)this.response$4.elem;
                        if (submitRestProtocolResponse instanceof SubmissionStatusResponse && Predef$.MODULE$.Boolean2boolean((submissionStatusResponse = (SubmissionStatusResponse)submitRestProtocolResponse).success())) {
                            if (!this.quiet$1) {
                                this.$outer.org$apache$spark$deploy$rest$RestSubmissionClient$$handleRestResponse(submissionStatusResponse);
                            }
                            this.handled$3.elem = true;
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        } else {
                            this.$outer.org$apache$spark$deploy$rest$RestSubmissionClient$$handleUnexpectedRestResponse(submitRestProtocolResponse);
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        }
                    }
                    catch (SubmitRestConnectionException submitRestConnectionException) {
                        if (!this.$outer.org$apache$spark$deploy$rest$RestSubmissionClient$$handleConnectionException(m)) break block5;
                        throw new SubmitRestConnectionException("Unable to connect to server", submitRestConnectionException);
                    }
                }
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.submissionId$2 = submissionId$2;
                this.quiet$1 = quiet$1;
                this.handled$3 = handled$3;
                this.response$4 = response$4;
            }
        });
        return (SubmitRestProtocolResponse)response.elem;
    }

    public boolean requestSubmissionStatus$default$2() {
        return false;
    }

    public CreateSubmissionRequest constructSubmitRequest(String appResource, String mainClass, String[] appArgs, Map<String, String> sparkProperties, Map<String, String> environmentVariables) {
        CreateSubmissionRequest message = new CreateSubmissionRequest();
        message.clientSparkVersion_$eq(package$.MODULE$.SPARK_VERSION());
        message.appResource_$eq(appResource);
        message.mainClass_$eq(mainClass);
        message.appArgs_$eq(appArgs);
        message.sparkProperties_$eq(sparkProperties);
        message.environmentVariables_$eq(environmentVariables);
        message.validate();
        return message;
    }

    public SubmitRestProtocolResponse org$apache$spark$deploy$rest$RestSubmissionClient$$get(URL url) {
        this.logDebug((Function0<String>)new Serializable(this, url){
            public static final long serialVersionUID = 0L;
            private final URL url$3;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Sending GET request to server at ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.url$3}));
            }
            {
                this.url$3 = url$3;
            }
        });
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setRequestMethod("GET");
        return this.readResponse(conn);
    }

    public SubmitRestProtocolResponse org$apache$spark$deploy$rest$RestSubmissionClient$$post(URL url) {
        this.logDebug((Function0<String>)new Serializable(this, url){
            public static final long serialVersionUID = 0L;
            private final URL url$2;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Sending POST request to server at ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.url$2}));
            }
            {
                this.url$2 = url$2;
            }
        });
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setRequestMethod("POST");
        return this.readResponse(conn);
    }

    public SubmitRestProtocolResponse org$apache$spark$deploy$rest$RestSubmissionClient$$postJson(URL url, String json) {
        this.logDebug((Function0<String>)new Serializable(this, url, json){
            public static final long serialVersionUID = 0L;
            private final URL url$1;
            private final String json$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Sending POST request to server at ", ":\\n", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.url$1, this.json$1}));
            }
            {
                this.url$1 = url$1;
                this.json$1 = json$1;
            }
        });
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setRequestMethod("POST");
        conn.setRequestProperty("Content-Type", "application/json");
        conn.setRequestProperty("charset", "utf-8");
        conn.setDoOutput(true);
        try {
            DataOutputStream out = new DataOutputStream(conn.getOutputStream());
            Utils$.MODULE$.tryWithSafeFinally(new Serializable(this, json, out){
                public static final long serialVersionUID = 0L;
                private final String json$1;
                private final DataOutputStream out$1;

                public final void apply() {
                    this.apply$mcV$sp();
                }

                public void apply$mcV$sp() {
                    this.out$1.write(this.json$1.getBytes(Charsets.UTF_8));
                }
                {
                    this.json$1 = json$1;
                    this.out$1 = out$1;
                }
            }, (Function0<BoxedUnit>)new Serializable(this, out){
                public static final long serialVersionUID = 0L;
                private final DataOutputStream out$1;

                public final void apply() {
                    this.apply$mcV$sp();
                }

                public void apply$mcV$sp() {
                    this.out$1.close();
                }
                {
                    this.out$1 = out$1;
                }
            });
        }
        catch (ConnectException connectException) {
            throw new SubmitRestConnectionException("Connect Exception when connect to server", connectException);
        }
        return this.readResponse(conn);
    }

    public SubmitRestProtocolResponse readResponse(HttpURLConnection connection) {
        Future responseFuture = Future$.MODULE$.apply((Function0)new Serializable(this, connection){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RestSubmissionClient $outer;
            private final HttpURLConnection connection$1;

            public final SubmitRestProtocolResponse apply() {
                SubmitRestProtocolMessage submitRestProtocolMessage;
                block6: {
                    SubmitRestProtocolResponse submitRestProtocolResponse;
                    block5: {
                        SubmitRestProtocolResponse submitRestProtocolResponse2;
                        block4: {
                            InputStream dataStream;
                            InputStream inputStream = dataStream = this.connection$1.getResponseCode() == 200 ? this.connection$1.getInputStream() : this.connection$1.getErrorStream();
                            if (dataStream == null) {
                                throw new SubmitRestProtocolException("Server returned empty body", SubmitRestProtocolException$.MODULE$.$lessinit$greater$default$2());
                            }
                            String responseJson = Source$.MODULE$.fromInputStream(dataStream, Codec$.MODULE$.fallbackSystemCodec()).mkString();
                            this.$outer.logDebug((Function0<String>)new Serializable(this, responseJson){
                                public static final long serialVersionUID = 0L;
                                private final String responseJson$1;

                                public final String apply() {
                                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Response from the server:\\n", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.responseJson$1}));
                                }
                                {
                                    this.responseJson$1 = responseJson$1;
                                }
                            });
                            SubmitRestProtocolMessage response = SubmitRestProtocolMessage$.MODULE$.fromJson(responseJson);
                            response.validate();
                            submitRestProtocolMessage = response;
                            if (!(submitRestProtocolMessage instanceof ErrorResponse)) break block4;
                            ErrorResponse errorResponse = (ErrorResponse)submitRestProtocolMessage;
                            this.$outer.logError((Function0<String>)new Serializable(this, errorResponse){
                                public static final long serialVersionUID = 0L;
                                private final ErrorResponse x2$1;

                                public final String apply() {
                                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Server responded with error:\\n", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.x2$1.message()}));
                                }
                                {
                                    this.x2$1 = x2$1;
                                }
                            });
                            submitRestProtocolResponse = errorResponse;
                            break block5;
                        }
                        if (!(submitRestProtocolMessage instanceof SubmitRestProtocolResponse)) break block6;
                        submitRestProtocolResponse = submitRestProtocolResponse2 = (SubmitRestProtocolResponse)submitRestProtocolMessage;
                    }
                    return submitRestProtocolResponse;
                }
                throw new SubmitRestProtocolException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Message received from server was not a response:\\n", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{submitRestProtocolMessage.toJson()})), SubmitRestProtocolException$.MODULE$.$lessinit$greater$default$2());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.connection$1 = connection$1;
            }
        }, (ExecutionContext)ExecutionContext.Implicits$.MODULE$.global());
        try {
            return (SubmitRestProtocolResponse)Await$.MODULE$.result((Awaitable)responseFuture, (Duration)new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(10)).seconds());
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            boolean bl = throwable2 instanceof FileNotFoundException ? true : throwable2 instanceof SocketException;
            if (bl) {
                throw new SubmitRestConnectionException("Unable to connect to server", throwable2);
            }
            boolean bl2 = throwable2 instanceof JsonProcessingException ? true : throwable2 instanceof SubmitRestProtocolException;
            if (bl2) {
                throw new SubmitRestProtocolException("Malformed response received from server", throwable2);
            }
            if (throwable2 instanceof TimeoutException) {
                TimeoutException timeoutException = (TimeoutException)throwable2;
                throw new SubmitRestConnectionException("No response from server", timeoutException);
            }
            throw throwable;
        }
    }

    public URL org$apache$spark$deploy$rest$RestSubmissionClient$$getSubmitUrl(String master) {
        String baseUrl = this.getBaseUrl(master);
        return new URL(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/create"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{baseUrl})));
    }

    public URL org$apache$spark$deploy$rest$RestSubmissionClient$$getKillUrl(String master, String submissionId) {
        String baseUrl = this.getBaseUrl(master);
        return new URL(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/kill/", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{baseUrl, submissionId})));
    }

    public URL org$apache$spark$deploy$rest$RestSubmissionClient$$getStatusUrl(String master, String submissionId) {
        String baseUrl = this.getBaseUrl(master);
        return new URL(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/status/", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{baseUrl, submissionId})));
    }

    private String getBaseUrl(String master) {
        ObjectRef masterUrl = ObjectRef.create((Object)master);
        this.supportedMasterPrefixes().foreach((Function1)new Serializable(this, master, masterUrl){
            public static final long serialVersionUID = 0L;
            private final String master$2;
            private final ObjectRef masterUrl$2;

            public final void apply(String prefix) {
                if (this.master$2.startsWith(prefix)) {
                    this.masterUrl$2.elem = new StringOps(Predef$.MODULE$.augmentString(this.master$2)).stripPrefix(prefix);
                }
            }
            {
                this.master$2 = master$2;
                this.masterUrl$2 = masterUrl$2;
            }
        });
        masterUrl.elem = new StringOps(Predef$.MODULE$.augmentString((String)masterUrl.elem)).stripSuffix("/");
        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"http://", "/", "/submissions"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{(String)masterUrl.elem, RestSubmissionClient$.MODULE$.PROTOCOL_VERSION()}));
    }

    public void org$apache$spark$deploy$rest$RestSubmissionClient$$validateMaster(String master) {
        boolean valid = this.supportedMasterPrefixes().exists((Function1)new Serializable(this, master){
            public static final long serialVersionUID = 0L;
            private final String master$1;

            public final boolean apply(String prefix) {
                return this.master$1.startsWith(prefix);
            }
            {
                this.master$1 = master$1;
            }
        });
        if (valid) {
            return;
        }
        throw new IllegalArgumentException(new StringBuilder().append((Object)"This REST client only supports master URLs that start with one of the following: ").append((Object)this.supportedMasterPrefixes().mkString(",")).toString());
    }

    public void org$apache$spark$deploy$rest$RestSubmissionClient$$reportSubmissionStatus(CreateSubmissionResponse submitResponse) {
        if (Predef$.MODULE$.Boolean2boolean(submitResponse.success())) {
            String submissionId = submitResponse.submissionId();
            if (submissionId == null) {
                this.logError((Function0<String>)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "Application successfully submitted, but submission ID was not provided!";
                    }
                });
            } else {
                this.logInfo((Function0<String>)new Serializable(this, submissionId){
                    public static final long serialVersionUID = 0L;
                    private final String submissionId$3;

                    public final String apply() {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Submission successfully created as ", ". Polling submission state..."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.submissionId$3}));
                    }
                    {
                        this.submissionId$3 = submissionId$3;
                    }
                });
                this.pollSubmissionStatus(submissionId);
            }
        } else {
            String failMessage = (String)Option$.MODULE$.apply((Object)submitResponse.message()).map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply(String x$1) {
                    return new StringBuilder().append((Object)": ").append((Object)x$1).toString();
                }
            }).getOrElse((Function0)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "";
                }
            });
            this.logError((Function0<String>)new Serializable(this, failMessage){
                public static final long serialVersionUID = 0L;
                private final String failMessage$1;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Application submission failed", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.failMessage$1}));
                }
                {
                    this.failMessage$1 = failMessage$1;
                }
            });
        }
    }

    private void pollSubmissionStatus(String submissionId) {
        NonLocalReturnControl nonLocalReturnControl2;
        block2: {
            Object object = new Object();
            try {
                RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), RestSubmissionClient$.MODULE$.org$apache$spark$deploy$rest$RestSubmissionClient$$REPORT_DRIVER_STATUS_MAX_TRIES()).foreach$mVc$sp((Function1)new Serializable(this, submissionId, object){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ RestSubmissionClient $outer;
                    public final String submissionId$4;
                    private final Object nonLocalReturnKey1$1;

                    public final void apply(int x$2) {
                        this.apply$mcVI$sp(x$2);
                    }

                    /*
                     * Unable to fully structure code
                     */
                    public void apply$mcVI$sp(int x$2) {
                        block4: {
                            block5: {
                                response = this.$outer.requestSubmissionStatus(this.submissionId$4, true);
                                var3_3 = response;
                                if (!(var3_3 instanceof SubmissionStatusResponse)) break block4;
                                var4_4 = (SubmissionStatusResponse)var3_3;
                                var5_5 = var4_4;
                                statusResponse = var5_5;
                                if (!Predef$.MODULE$.Boolean2boolean(statusResponse.success())) break block5;
                                driverState = Option$.MODULE$.apply((Object)statusResponse.driverState());
                                workerId = Option$.MODULE$.apply((Object)statusResponse.workerId());
                                workerHostPort = Option$.MODULE$.apply((Object)statusResponse.workerHostPort());
                                exception = Option$.MODULE$.apply((Object)statusResponse.message());
                                var11_11 = driverState;
                                if (var11_11 instanceof Some) {
                                    var12_12 = (Some)var11_11;
                                    state = (String)var12_12.x();
                                    this.$outer.logInfo((Function0<String>)new Serializable(this, state){
                                        public static final long serialVersionUID = 0L;
                                        private final /* synthetic */ $anonfun$pollSubmissionStatus$1 $outer;
                                        private final String state$1;

                                        public final String apply() {
                                            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"State of driver ", " is now ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.submissionId$4, this.state$1}));
                                        }
                                        {
                                            if ($outer == null) {
                                                throw null;
                                            }
                                            this.$outer = $outer;
                                            this.state$1 = state$1;
                                        }
                                    });
                                    var14_14 = BoxedUnit.UNIT;
                                } else {
                                    this.$outer.logError((Function0<String>)new Serializable(this){
                                        public static final long serialVersionUID = 0L;
                                        private final /* synthetic */ $anonfun$pollSubmissionStatus$1 $outer;

                                        public final String apply() {
                                            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"State of driver ", " was not found!"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.submissionId$4}));
                                        }
                                        {
                                            if ($outer == null) {
                                                throw null;
                                            }
                                            this.$outer = $outer;
                                        }
                                    });
                                    var14_15 = BoxedUnit.UNIT;
                                }
                                var15_16 = new Tuple2((Object)workerId, (Object)workerHostPort);
                                if (var15_16 == null) ** GOTO lbl-1000
                                var16_17 = (Option)var15_16._1();
                                var17_18 = (Option)var15_16._2();
                                if (!(var16_17 instanceof Some)) ** GOTO lbl-1000
                                var18_19 = (Some)var16_17;
                                id = (String)var18_19.x();
                                if (var17_18 instanceof Some) {
                                    var20_21 = (Some)var17_18;
                                    hp = (String)var20_21.x();
                                    this.$outer.logInfo((Function0<String>)new Serializable(this, id, hp){
                                        public static final long serialVersionUID = 0L;
                                        private final String id$1;
                                        private final String hp$1;

                                        public final String apply() {
                                            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Driver is running on worker ", " at ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.id$1, this.hp$1}));
                                        }
                                        {
                                            this.id$1 = id$1;
                                            this.hp$1 = hp$1;
                                        }
                                    });
                                    var22_23 = BoxedUnit.UNIT;
                                } else lbl-1000:
                                // 3 sources

                                {
                                    var22_24 = BoxedUnit.UNIT;
                                }
                                exception.foreach((Function1)new Serializable(this){
                                    public static final long serialVersionUID = 0L;
                                    private final /* synthetic */ $anonfun$pollSubmissionStatus$1 $outer;

                                    public final void apply(String e) {
                                        this.$outer.org$apache$spark$deploy$rest$RestSubmissionClient$$anonfun$$$outer().logError((Function0<String>)new Serializable(this, e){
                                            public static final long serialVersionUID = 0L;
                                            private final String e$1;

                                            public final String apply() {
                                                return this.e$1;
                                            }
                                            {
                                                this.e$1 = e$1;
                                            }
                                        });
                                    }
                                    {
                                        if ($outer == null) {
                                            throw null;
                                        }
                                        this.$outer = $outer;
                                    }
                                });
                                throw new NonLocalReturnControl.mcV.sp(this.nonLocalReturnKey1$1, BoxedUnit.UNIT);
                            }
                            Thread.sleep(RestSubmissionClient$.MODULE$.org$apache$spark$deploy$rest$RestSubmissionClient$$REPORT_DRIVER_STATUS_INTERVAL());
                            return;
                        }
                        throw new NonLocalReturnControl.mcV.sp(this.nonLocalReturnKey1$1, BoxedUnit.UNIT);
                    }

                    public /* synthetic */ RestSubmissionClient org$apache$spark$deploy$rest$RestSubmissionClient$$anonfun$$$outer() {
                        return this.$outer;
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.submissionId$4 = submissionId$4;
                        this.nonLocalReturnKey1$1 = nonLocalReturnKey1$1;
                    }
                });
                this.logError((Function0<String>)new Serializable(this, submissionId){
                    public static final long serialVersionUID = 0L;
                    private final String submissionId$4;

                    public final String apply() {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Error: Master did not recognize driver ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.submissionId$4}));
                    }
                    {
                        this.submissionId$4 = submissionId$4;
                    }
                });
            }
            catch (NonLocalReturnControl nonLocalReturnControl2) {
                if (nonLocalReturnControl2.key() != object) break block2;
                nonLocalReturnControl2.value$mcV$sp();
            }
            return;
        }
        throw nonLocalReturnControl2;
    }

    public void org$apache$spark$deploy$rest$RestSubmissionClient$$handleRestResponse(SubmitRestProtocolResponse response) {
        this.logInfo((Function0<String>)new Serializable(this, response){
            public static final long serialVersionUID = 0L;
            private final SubmitRestProtocolResponse response$2;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Server responded with ", ":\\n", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.response$2.messageType(), this.response$2.toJson()}));
            }
            {
                this.response$2 = response$2;
            }
        });
    }

    public void org$apache$spark$deploy$rest$RestSubmissionClient$$handleUnexpectedRestResponse(SubmitRestProtocolResponse unexpected) {
        this.logError((Function0<String>)new Serializable(this, unexpected){
            public static final long serialVersionUID = 0L;
            private final SubmitRestProtocolResponse unexpected$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Error: Server responded with message of unexpected type ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.unexpected$1.messageType()}));
            }
            {
                this.unexpected$1 = unexpected$1;
            }
        });
    }

    public boolean org$apache$spark$deploy$rest$RestSubmissionClient$$handleConnectionException(String masterUrl) {
        BoxedUnit boxedUnit;
        if (this.lostMasters().contains((Object)masterUrl)) {
            boxedUnit = BoxedUnit.UNIT;
        } else {
            this.logWarning((Function0<String>)new Serializable(this, masterUrl){
                public static final long serialVersionUID = 0L;
                private final String masterUrl$1;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unable to connect to server ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.masterUrl$1}));
                }
                {
                    this.masterUrl$1 = masterUrl$1;
                }
            });
            boxedUnit = this.lostMasters().$plus$eq((Object)masterUrl);
        }
        return this.lostMasters().size() >= Predef$.MODULE$.refArrayOps((Object[])this.masters()).size();
    }

    public RestSubmissionClient(String master) {
        this.org$apache$spark$deploy$rest$RestSubmissionClient$$master = master;
        Logging$class.$init$(this);
        this.supportedMasterPrefixes = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"spark://", "mesos://"}));
        this.masters = master.startsWith("spark://") ? Utils$.MODULE$.parseStandaloneMasterUrls(master) : (String[])((Object[])new String[]{master});
        this.lostMasters = new HashSet();
    }
}

