/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.rpc.netty;

import java.net.URI;
import java.nio.ByteBuffer;
import java.nio.channels.Pipe;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nullable;
import org.apache.spark.Logging;
import org.apache.spark.Logging$class;
import org.apache.spark.SecurityManager;
import org.apache.spark.SparkConf;
import org.apache.spark.network.TransportContext;
import org.apache.spark.network.client.StreamCallback;
import org.apache.spark.network.client.TransportClient;
import org.apache.spark.network.client.TransportClientBootstrap;
import org.apache.spark.network.client.TransportClientFactory;
import org.apache.spark.network.netty.SparkTransportConf$;
import org.apache.spark.network.sasl.SaslClientBootstrap;
import org.apache.spark.network.sasl.SaslServerBootstrap;
import org.apache.spark.network.sasl.SecretKeyHolder;
import org.apache.spark.network.server.NoOpRpcHandler;
import org.apache.spark.network.server.RpcHandler;
import org.apache.spark.network.server.TransportServer;
import org.apache.spark.network.server.TransportServerBootstrap;
import org.apache.spark.network.util.TransportConf;
import org.apache.spark.rpc.RpcAddress;
import org.apache.spark.rpc.RpcEndpoint;
import org.apache.spark.rpc.RpcEndpointNotFoundException;
import org.apache.spark.rpc.RpcEndpointRef;
import org.apache.spark.rpc.RpcEnv;
import org.apache.spark.rpc.RpcEnvFileServer;
import org.apache.spark.rpc.RpcTimeout;
import org.apache.spark.rpc.netty.Dispatcher;
import org.apache.spark.rpc.netty.HttpBasedFileServer;
import org.apache.spark.rpc.netty.NettyRpcEndpointRef;
import org.apache.spark.rpc.netty.NettyRpcEnv$;
import org.apache.spark.rpc.netty.NettyRpcHandler;
import org.apache.spark.rpc.netty.NettyStreamManager;
import org.apache.spark.rpc.netty.OneWayOutboxMessage;
import org.apache.spark.rpc.netty.Outbox;
import org.apache.spark.rpc.netty.OutboxMessage;
import org.apache.spark.rpc.netty.RequestMessage;
import org.apache.spark.rpc.netty.RpcEndpointAddress;
import org.apache.spark.rpc.netty.RpcEndpointAddress$;
import org.apache.spark.rpc.netty.RpcEndpointVerifier;
import org.apache.spark.rpc.netty.RpcEndpointVerifier$;
import org.apache.spark.rpc.netty.RpcFailure;
import org.apache.spark.rpc.netty.RpcOutboxMessage;
import org.apache.spark.serializer.JavaSerializerInstance;
import org.apache.spark.util.ThreadUtils$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.PartialFunction;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.Promise;
import scala.concurrent.Promise$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.TraitSetter;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0001\reh!B\u0001\u0003\u0001\ta!a\u0003(fiRL(\u000b]2F]ZT!a\u0001\u0003\u0002\u000b9,G\u000f^=\u000b\u0005\u00151\u0011a\u0001:qG*\u0011q\u0001C\u0001\u0006gB\f'o\u001b\u0006\u0003\u0013)\ta!\u00199bG\",'\"A\u0006\u0002\u0007=\u0014xmE\u0002\u0001\u001bE\u0001\"AD\b\u000e\u0003\u0011I!\u0001\u0005\u0003\u0003\rI\u00038-\u00128w!\t\u00112#D\u0001\u0007\u0013\t!bAA\u0004M_\u001e<\u0017N\\4\t\u0011Y\u0001!Q1A\u0005\u0002a\tAaY8oM\u000e\u0001Q#A\r\u0011\u0005IQ\u0012BA\u000e\u0007\u0005%\u0019\u0006/\u0019:l\u0007>tg\r\u0003\u0005\u001e\u0001\t\u0005\t\u0015!\u0003\u001a\u0003\u0015\u0019wN\u001c4!\u0011!y\u0002A!A!\u0002\u0013\u0001\u0013A\u00066bm\u0006\u001cVM]5bY&TXM]%ogR\fgnY3\u0011\u0005\u0005\"S\"\u0001\u0012\u000b\u0005\r2\u0011AC:fe&\fG.\u001b>fe&\u0011QE\t\u0002\u0017\u0015\u00064\u0018mU3sS\u0006d\u0017N_3s\u0013:\u001cH/\u00198dK\"Aq\u0005\u0001B\u0001B\u0003%\u0001&\u0001\u0003i_N$\bCA\u00150\u001d\tQS&D\u0001,\u0015\u0005a\u0013!B:dC2\f\u0017B\u0001\u0018,\u0003\u0019\u0001&/\u001a3fM&\u0011\u0001'\r\u0002\u0007'R\u0014\u0018N\\4\u000b\u00059Z\u0003\u0002C\u001a\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u001b\u0002\u001fM,7-\u001e:jifl\u0015M\\1hKJ\u0004\"AE\u001b\n\u0005Y2!aD*fGV\u0014\u0018\u000e^=NC:\fw-\u001a:\t\u000ba\u0002A\u0011A\u001d\u0002\rqJg.\u001b;?)\u0015QD(\u0010 @!\tY\u0004!D\u0001\u0003\u0011\u00151r\u00071\u0001\u001a\u0011\u0015yr\u00071\u0001!\u0011\u00159s\u00071\u0001)\u0011\u0015\u0019t\u00071\u00015\u0011!\t\u0005A1A\u0005\u0002\t\u0011\u0015!\u0004;sC:\u001c\bo\u001c:u\u0007>tg-F\u0001D!\t!\u0015*D\u0001F\u0015\t1u)\u0001\u0003vi&d'B\u0001%\u0007\u0003\u001dqW\r^<pe.L!AS#\u0003\u001bQ\u0013\u0018M\\:q_J$8i\u001c8g\u0011\u0019a\u0005\u0001)A\u0005\u0007\u0006qAO]1ogB|'\u000f^\"p]\u001a\u0004\u0003b\u0002(\u0001\u0005\u0004%IaT\u0001\u000bI&\u001c\b/\u0019;dQ\u0016\u0014X#\u0001)\u0011\u0005m\n\u0016B\u0001*\u0003\u0005)!\u0015n\u001d9bi\u000eDWM\u001d\u0005\u0007)\u0002\u0001\u000b\u0011\u0002)\u0002\u0017\u0011L7\u000f]1uG\",'\u000f\t\u0005\b-\u0002\u0011\r\u0011\"\u0003X\u00035\u0019HO]3b[6\u000bg.Y4feV\t\u0001\f\u0005\u0002<3&\u0011!L\u0001\u0002\u0013\u001d\u0016$H/_*ue\u0016\fW.T1oC\u001e,'\u000f\u0003\u0004]\u0001\u0001\u0006I\u0001W\u0001\u000fgR\u0014X-Y7NC:\fw-\u001a:!\u0011\u001dq\u0006A1A\u0005\n}\u000b1b\u00184jY\u0016\u001cVM\u001d<feV\t\u0001\r\u0005\u0002\u000fC&\u0011!\r\u0002\u0002\u0011%B\u001cWI\u001c<GS2,7+\u001a:wKJDa\u0001\u001a\u0001!\u0002\u0013\u0001\u0017\u0001D0gS2,7+\u001a:wKJ\u0004\u0003b\u00024\u0001\u0005\u0004%IaZ\u0001\u0011iJ\fgn\u001d9peR\u001cuN\u001c;fqR,\u0012\u0001\u001b\t\u0003S*l\u0011aR\u0005\u0003W\u001e\u0013\u0001\u0003\u0016:b]N\u0004xN\u001d;D_:$X\r\u001f;\t\r5\u0004\u0001\u0015!\u0003i\u0003E!(/\u00198ta>\u0014HoQ8oi\u0016DH\u000f\t\u0005\u0006_\u0002!I\u0001]\u0001\u0017GJ,\u0017\r^3DY&,g\u000e\u001e\"p_R\u001cHO]1qgR\t\u0011\u000fE\u0002smbl\u0011a\u001d\u0006\u0003\rRT\u0011!^\u0001\u0005U\u00064\u0018-\u0003\u0002xg\n!A*[:u!\tIH0D\u0001{\u0015\tYx)\u0001\u0004dY&,g\u000e^\u0005\u0003{j\u0014\u0001\u0004\u0016:b]N\u0004xN\u001d;DY&,g\u000e\u001e\"p_R\u001cHO]1q\u0011!y\bA1A\u0005\n\u0005\u0005\u0011!D2mS\u0016tGOR1di>\u0014\u00180\u0006\u0002\u0002\u0004A\u0019\u00110!\u0002\n\u0007\u0005\u001d!P\u0001\fUe\u0006t7\u000f]8si\u000ec\u0017.\u001a8u\r\u0006\u001cGo\u001c:z\u0011!\tY\u0001\u0001Q\u0001\n\u0005\r\u0011AD2mS\u0016tGOR1di>\u0014\u0018\u0010\t\u0005\f\u0003\u001f\u0001\u0001\u0019!a\u0001\n\u0013\t\t!A\ngS2,Gi\\<oY>\fGMR1di>\u0014\u0018\u0010C\u0006\u0002\u0014\u0001\u0001\r\u00111A\u0005\n\u0005U\u0011a\u00064jY\u0016$un\u001e8m_\u0006$g)Y2u_JLx\fJ3r)\u0011\t9\"!\b\u0011\u0007)\nI\"C\u0002\u0002\u001c-\u0012A!\u00168ji\"Q\u0011qDA\t\u0003\u0003\u0005\r!a\u0001\u0002\u0007a$\u0013\u0007\u0003\u0005\u0002$\u0001\u0001\u000b\u0015BA\u0002\u0003Q1\u0017\u000e\\3E_^tGn\\1e\r\u0006\u001cGo\u001c:zA!\"\u0011\u0011EA\u0014!\rQ\u0013\u0011F\u0005\u0004\u0003WY#\u0001\u0003<pY\u0006$\u0018\u000e\\3\t\u0013\u0005=\u0002A1A\u0005\u0002\u0005E\u0012\u0001\u0005;j[\u0016|W\u000f^*dQ\u0016$W\u000f\\3s+\t\t\u0019\u0004\u0005\u0003\u00026\u0005mRBAA\u001c\u0015\r\tId]\u0001\u000bG>t7-\u001e:sK:$\u0018\u0002BA\u001f\u0003o\u0011\u0001dU2iK\u0012,H.\u001a3Fq\u0016\u001cW\u000f^8s'\u0016\u0014h/[2f\u0011!\t\t\u0005\u0001Q\u0001\n\u0005M\u0012!\u0005;j[\u0016|W\u000f^*dQ\u0016$W\u000f\\3sA!Q\u0011Q\t\u0001C\u0002\u0013\u0005!!a\u0012\u00021\rd\u0017.\u001a8u\u0007>tg.Z2uS>tW\t_3dkR|'/\u0006\u0002\u0002JA!\u0011QGA&\u0013\u0011\ti%a\u000e\u0003%QC'/Z1e!>|G.\u0012=fGV$xN\u001d\u0005\t\u0003#\u0002\u0001\u0015!\u0003\u0002J\u0005I2\r\\5f]R\u001cuN\u001c8fGRLwN\\#yK\u000e,Ho\u001c:!\u0011-\t)\u0006\u0001a\u0001\u0002\u0004%I!a\u0016\u0002\rM,'O^3s+\t\tI\u0006\u0005\u0003\u0002\\\u0005}SBAA/\u0015\r\t)fR\u0005\u0005\u0003C\niFA\bUe\u0006t7\u000f]8siN+'O^3s\u0011-\t)\u0007\u0001a\u0001\u0002\u0004%I!a\u001a\u0002\u0015M,'O^3s?\u0012*\u0017\u000f\u0006\u0003\u0002\u0018\u0005%\u0004BCA\u0010\u0003G\n\t\u00111\u0001\u0002Z!A\u0011Q\u000e\u0001!B\u0013\tI&A\u0004tKJ4XM\u001d\u0011)\t\u0005-\u0014q\u0005\u0005\n\u0003g\u0002!\u0019!C\u0005\u0003k\nqa\u001d;paB,G-\u0006\u0002\u0002xA!\u0011\u0011PA@\u001b\t\tYH\u0003\u0003\u0002~\u0005]\u0012AB1u_6L7-\u0003\u0003\u0002\u0002\u0006m$!D!u_6L7MQ8pY\u0016\fg\u000e\u0003\u0005\u0002\u0006\u0002\u0001\u000b\u0011BA<\u0003!\u0019Ho\u001c9qK\u0012\u0004\u0003\"CAE\u0001\t\u0007I\u0011BAF\u0003!yW\u000f\u001e2pq\u0016\u001cXCAAG!!\t)$a$\u0002\u0014\u0006e\u0015\u0002BAI\u0003o\u0011\u0011cQ8oGV\u0014(/\u001a8u\u0011\u0006\u001c\b.T1q!\rq\u0011QS\u0005\u0004\u0003/#!A\u0003*qG\u0006#GM]3tgB\u00191(a'\n\u0007\u0005u%A\u0001\u0004PkR\u0014w\u000e\u001f\u0005\t\u0003C\u0003\u0001\u0015!\u0003\u0002\u000e\u0006Iq.\u001e;c_b,7\u000f\t\u0005\t\u0003K\u0003A\u0011\u0001\u0002\u0002(\u0006a!/Z7pm\u0016|U\u000f\u001e2pqR!\u0011qCAU\u0011!\tY+a)A\u0002\u0005M\u0015aB1eIJ,7o\u001d\u0005\b\u0003_\u0003A\u0011AAY\u0003-\u0019H/\u0019:u'\u0016\u0014h/\u001a:\u0015\t\u0005]\u00111\u0017\u0005\t\u0003k\u000bi\u000b1\u0001\u00028\u0006!\u0001o\u001c:u!\rQ\u0013\u0011X\u0005\u0004\u0003w[#aA%oi\"Q\u00111\u0016\u0001\t\u0006\u0004%\t%a0\u0016\u0005\u0005M\u0005BCAb\u0001!\u0005\t\u0015)\u0003\u0002\u0014\u0006A\u0011\r\u001a3sKN\u001c\b\u0005\u000b\u0003\u0002B\u0006\u001d\u0007\u0003BAe\u0003'l!!a3\u000b\t\u00055\u0017qZ\u0001\u000bC:tw\u000e^1uS>t'BAAi\u0003\u0015Q\u0017M^1y\u0013\u0011\t).a3\u0003\u00119+H\u000e\\1cY\u0016Dq!!7\u0001\t\u0003\nY.A\u0007tKR,\b/\u00128ea>Lg\u000e\u001e\u000b\u0007\u0003;\f\u0019/a:\u0011\u00079\ty.C\u0002\u0002b\u0012\u0011aB\u00159d\u000b:$\u0007o\\5oiJ+g\rC\u0004\u0002f\u0006]\u0007\u0019\u0001\u0015\u0002\t9\fW.\u001a\u0005\t\u0003S\f9\u000e1\u0001\u0002l\u0006AQM\u001c3q_&tG\u000fE\u0002\u000f\u0003[L1!a<\u0005\u0005-\u0011\u0006oY#oIB|\u0017N\u001c;\t\u000f\u0005M\b\u0001\"\u0001\u0002v\u0006Q\u0012m]=oGN+G/\u001e9F]\u0012\u0004x.\u001b8u%\u00164')_+S\u0013R!\u0011q\u001fB\u0001!\u0019\tI0!@\u0002^6\u0011\u00111 \u0006\u0004\u0003sY\u0013\u0002BA\u0000\u0003w\u0014aAR;ukJ,\u0007b\u0002B\u0002\u0003c\u0004\r\u0001K\u0001\u0004kJL\u0007b\u0002B\u0004\u0001\u0011\u0005#\u0011B\u0001\u0005gR|\u0007\u000f\u0006\u0003\u0002\u0018\t-\u0001\u0002\u0003B\u0007\u0005\u000b\u0001\r!!8\u0002\u0017\u0015tG\r]8j]R\u0014VM\u001a\u0005\b\u0005#\u0001A\u0011\u0002B\n\u00031\u0001xn\u001d;U_>+HOY8y)\u0019\t9B!\u0006\u0003 !A!q\u0003B\b\u0001\u0004\u0011I\"\u0001\u0005sK\u000e,\u0017N^3s!\rY$1D\u0005\u0004\u0005;\u0011!a\u0005(fiRL(\u000b]2F]\u0012\u0004x.\u001b8u%\u00164\u0007\u0002\u0003B\u0011\u0005\u001f\u0001\rAa\t\u0002\u000f5,7o]1hKB\u00191H!\n\n\u0007\t\u001d\"AA\u0007PkR\u0014w\u000e_'fgN\fw-\u001a\u0005\t\u0005W\u0001A\u0011\u0001\u0002\u0003.\u0005!1/\u001a8e)\u0011\t9Ba\f\t\u0011\t\u0005\"\u0011\u0006a\u0001\u0005c\u00012a\u000fB\u001a\u0013\r\u0011)D\u0001\u0002\u000f%\u0016\fX/Z:u\u001b\u0016\u001c8/Y4f\u0011!\u0011I\u0004\u0001C\u0001\u0005\tm\u0012\u0001D2sK\u0006$Xm\u00117jK:$H\u0003\u0002B\u001f\u0005\u0007\u00022!\u001fB \u0013\r\u0011\tE\u001f\u0002\u0010)J\fgn\u001d9peR\u001cE.[3oi\"A\u00111\u0016B\u001c\u0001\u0004\t\u0019\n\u0003\u0005\u0003H\u0001!\tA\u0001B%\u0003\r\t7o[\u000b\u0005\u0005\u0017\u0012)\u0006\u0006\u0004\u0003N\t]$\u0011\u0010\u000b\u0005\u0005\u001f\u00129\u0007\u0005\u0004\u0002z\u0006u(\u0011\u000b\t\u0005\u0005'\u0012)\u0006\u0004\u0001\u0005\u0011\t]#Q\tb\u0001\u00053\u0012\u0011\u0001V\t\u0005\u00057\u0012\t\u0007E\u0002+\u0005;J1Aa\u0018,\u0005\u001dqu\u000e\u001e5j]\u001e\u00042A\u000bB2\u0013\r\u0011)g\u000b\u0002\u0004\u0003:L\bB\u0003B5\u0005\u000b\n\t\u0011q\u0001\u0003l\u0005QQM^5eK:\u001cW\rJ\u0019\u0011\r\t5$1\u000fB)\u001b\t\u0011yGC\u0002\u0003r-\nqA]3gY\u0016\u001cG/\u0003\u0003\u0003v\t=$\u0001C\"mCN\u001cH+Y4\t\u0011\t\u0005\"Q\ta\u0001\u0005cA\u0001Ba\u001f\u0003F\u0001\u0007!QP\u0001\bi&lWm\\;u!\rq!qP\u0005\u0004\u0005\u0003#!A\u0003*qGRKW.Z8vi\"A!Q\u0011\u0001\u0005\u0002\t\u00119)A\u0005tKJL\u0017\r\\5{KR!!\u0011\u0012BK!\u0011\u0011YI!%\u000e\u0005\t5%b\u0001BHi\u0006\u0019a.[8\n\t\tM%Q\u0012\u0002\u000b\u0005f$XMQ;gM\u0016\u0014\b\u0002\u0003BL\u0005\u0007\u0003\rA!\u0019\u0002\u000f\r|g\u000e^3oi\"A!1\u0014\u0001\u0005\u0002\t\u0011i*A\u0006eKN,'/[1mSj,W\u0003\u0002BP\u0005K#bA!)\u0003.\n=F\u0003\u0002BR\u0005O\u0003BAa\u0015\u0003&\u0012A!q\u000bBM\u0005\u0004\u0011I\u0006\u0003\u0006\u0003*\ne\u0015\u0011!a\u0002\u0005W\u000b!\"\u001a<jI\u0016t7-\u001a\u00133!\u0019\u0011iGa\u001d\u0003$\"91P!'A\u0002\tu\u0002\u0002\u0003BY\u00053\u0003\rA!#\u0002\u000b\tLH/Z:\t\u000f\t5\u0001\u0001\"\u0011\u00036R!\u0011Q\u001cB\\\u0011!\tIOa-A\u0002\u0005-\bb\u0002B^\u0001\u0011\u0005#QX\u0001\u0006kJLwJ\u001a\u000b\bQ\t}&1\u0019Bc\u0011\u001d\u0011\tM!/A\u0002!\n!b]=ti\u0016lg*Y7f\u0011!\tYK!/A\u0002\u0005M\u0005b\u0002Bd\u0005s\u0003\r\u0001K\u0001\rK:$\u0007o\\5oi:\u000bW.\u001a\u0005\b\u0005\u0017\u0004A\u0011\tBg\u0003!\u0019\b.\u001e;e_^tGCAA\f\u0011\u001d\u0011\t\u000e\u0001C!\u0005\u001b\f\u0001#Y<bSR$VM]7j]\u0006$\u0018n\u001c8\t\u000f\tU\u0007\u0001\"\u0003\u0003N\u000691\r\\3b]V\u0004\bb\u0002BN\u0001\u0011\u0005#\u0011\\\u000b\u0005\u00057\u0014y\u000e\u0006\u0003\u0003^\n\u0005\b\u0003\u0002B*\u0005?$\u0001Ba\u0016\u0003X\n\u0007!\u0011\f\u0005\t\u0005G\u00149\u000e1\u0001\u0003f\u0006)B-Z:fe&\fG.\u001b>bi&|g.Q2uS>t\u0007#\u0002\u0016\u0003h\nu\u0017b\u0001BuW\tIa)\u001e8di&|g\u000e\r\u0005\u0007\u0005[\u0004A\u0011I0\u0002\u0015\u0019LG.Z*feZ,'\u000fC\u0004\u0003r\u0002!\tEa=\u0002\u0017=\u0004XM\\\"iC:tW\r\u001c\u000b\u0005\u0005k\u001c\t\u0001\u0005\u0003\u0003x\nuXB\u0001B}\u0015\u0011\u0011YP!$\u0002\u0011\rD\u0017M\u001c8fYNLAAa@\u0003z\n\u0019\"+Z1eC\ndWMQ=uK\u000eC\u0017M\u001c8fY\"9!1\u0001Bx\u0001\u0004A\u0003bBB\u0003\u0001\u0011%1qA\u0001\u000fI><h\u000e\\8bI\u000ec\u0017.\u001a8u)\u0019\u0011id!\u0003\u0004\f!1qea\u0001A\u0002!B\u0001\"!.\u0004\u0004\u0001\u0007\u0011q\u0017\u0004\u0007\u0007\u001f\u0001Aa!\u0005\u0003'\u0019KG.\u001a#po:dw.\u00193DQ\u0006tg.\u001a7\u0014\r\r511\u0003B{!\u0011\u0019)ba\u0007\u000e\u0005\r]!bAB\ri\u0006!A.\u00198h\u0013\u0011\u0019iba\u0006\u0003\r=\u0013'.Z2u\u0011-\u0019\tc!\u0004\u0003\u0002\u0003\u0006IA!>\u0002\rM|WO]2f\u0011\u001dA4Q\u0002C\u0001\u0007K!Baa\n\u0004,A!1\u0011FB\u0007\u001b\u0005\u0001\u0001\u0002CB\u0011\u0007G\u0001\rA!>\t\u0019\r=2Q\u0002a\u0001\u0002\u0004%Ia!\r\u0002\u000b\u0015\u0014(o\u001c:\u0016\u0005\rM\u0002\u0003BB\u001b\u0007\u000brAaa\u000e\u0004B9!1\u0011HB \u001b\t\u0019YDC\u0002\u0004>]\ta\u0001\u0010:p_Rt\u0014\"\u0001\u0017\n\u0007\r\r3&A\u0004qC\u000e\\\u0017mZ3\n\t\r\u001d3\u0011\n\u0002\n)\"\u0014xn^1cY\u0016T1aa\u0011,\u00111\u0019ie!\u0004A\u0002\u0003\u0007I\u0011BB(\u0003%)'O]8s?\u0012*\u0017\u000f\u0006\u0003\u0002\u0018\rE\u0003BCA\u0010\u0007\u0017\n\t\u00111\u0001\u00044!I1QKB\u0007A\u0003&11G\u0001\u0007KJ\u0014xN\u001d\u0011)\t\rM\u0013q\u0005\u0005\t\u00077\u001ai\u0001\"\u0001\u0004^\u0005A1/\u001a;FeJ|'\u000f\u0006\u0003\u0002\u0018\r}\u0003\u0002CB1\u00073\u0002\raa\r\u0002\u0003\u0015D\u0001b!\u001a\u0004\u000e\u0011\u00053qM\u0001\u0005e\u0016\fG\r\u0006\u0003\u00028\u000e%\u0004\u0002CB6\u0007G\u0002\rA!#\u0002\u0007\u0011\u001cH\u000f\u0003\u0005\u0004p\r5A\u0011\tBg\u0003\u0015\u0019Gn\\:f\u0011!\u0019\u0019h!\u0004\u0005B\rU\u0014AB5t\u001fB,g\u000e\u0006\u0002\u0004xA\u0019!f!\u001f\n\u0007\rm4FA\u0004C_>dW-\u00198\u0007\r\r}\u0004\u0001BBA\u0005Q1\u0015\u000e\\3E_^tGn\\1e\u0007\u0006dGNY1dWN11QPB\n\u0007\u0007\u00032!_BC\u0013\r\u00199I\u001f\u0002\u000f'R\u0014X-Y7DC2d'-Y2l\u0011-\u0019Yi! \u0003\u0002\u0003\u0006Ia!$\u0002\tMLgn\u001b\t\u0005\u0005o\u001cy)\u0003\u0003\u0004\u0012\ne(aE,sSR\f'\r\\3CsR,7\t[1o]\u0016d\u0007bCB\u0011\u0007{\u0012\t\u0011)A\u0005\u0007OA!b_B?\u0005\u0003\u0005\u000b\u0011\u0002B\u001f\u0011\u001dA4Q\u0010C\u0001\u00073#\u0002ba'\u0004\u001e\u000e}5\u0011\u0015\t\u0005\u0007S\u0019i\b\u0003\u0005\u0004\f\u000e]\u0005\u0019ABG\u0011!\u0019\tca&A\u0002\r\u001d\u0002bB>\u0004\u0018\u0002\u0007!Q\b\u0005\t\u0007K\u001bi\b\"\u0011\u0004(\u00061qN\u001c#bi\u0006$b!a\u0006\u0004*\u000e5\u0006bBBV\u0007G\u0003\r\u0001K\u0001\tgR\u0014X-Y7JI\"A1qVBR\u0001\u0004\u0011I)A\u0002ck\u001aD\u0001ba-\u0004~\u0011\u00053QW\u0001\u000b_:\u001cu.\u001c9mKR,G\u0003BA\f\u0007oCqaa+\u00042\u0002\u0007\u0001\u0006\u0003\u0005\u0004<\u000euD\u0011IB_\u0003%ygNR1jYV\u0014X\r\u0006\u0004\u0002\u0018\r}6\u0011\u0019\u0005\b\u0007W\u001bI\f1\u0001)\u0011!\u0019\u0019m!/A\u0002\rM\u0012!B2bkN,w\u0001CBd\u0005!\u0005!a!3\u0002\u00179+G\u000f^=Sa\u000e,eN\u001e\t\u0004w\r-gaB\u0001\u0003\u0011\u0003\u00111QZ\n\u0006\u0007\u0017\u001cy-\u0005\t\u0004U\rE\u0017bABjW\t1\u0011I\\=SK\u001aDq\u0001OBf\t\u0003\u00199\u000e\u0006\u0002\u0004J\"Y11\\Bf\u0005\u0004%\tAABo\u0003)\u0019WO\u001d:f]R,eN^\u000b\u0003\u0007?\u0004Ra!9\u0004fjj!aa9\u000b\u0005\u0019[\u0013\u0002BBt\u0007G\u0014q\u0002R=oC6L7MV1sS\u0006\u0014G.\u001a\u0005\n\u0007W\u001cY\r)A\u0005\u0007?\f1bY;se\u0016tG/\u00128wA!Y1q^Bf\u0005\u0004%\tAABy\u00035\u0019WO\u001d:f]R\u001cE.[3oiV\u001111\u001f\t\u0007\u0007C\u001c)O!\u0010\t\u0013\r]81\u001aQ\u0001\n\rM\u0018AD2veJ,g\u000e^\"mS\u0016tG\u000f\t")
public class NettyRpcEnv
extends RpcEnv
implements Logging {
    private final SparkConf conf;
    public final JavaSerializerInstance org$apache$spark$rpc$netty$NettyRpcEnv$$javaSerializerInstance;
    private final String host;
    private final SecurityManager securityManager;
    private final TransportConf transportConf;
    private final Dispatcher dispatcher;
    private final NettyStreamManager streamManager;
    private final RpcEnvFileServer _fileServer;
    private final TransportContext transportContext;
    private final TransportClientFactory clientFactory;
    private volatile TransportClientFactory fileDownloadFactory;
    private final ScheduledExecutorService timeoutScheduler;
    private final ThreadPoolExecutor clientConnectionExecutor;
    private volatile TransportServer server;
    private final AtomicBoolean stopped;
    private final ConcurrentHashMap<RpcAddress, Outbox> outboxes;
    @Nullable
    private RpcAddress address;
    private transient Logger org$apache$spark$Logging$$log_;
    private volatile boolean bitmap$0;

    private RpcAddress address$lzycompute() {
        NettyRpcEnv nettyRpcEnv = this;
        synchronized (nettyRpcEnv) {
            if (!this.bitmap$0) {
                this.address = this.server() == null ? null : new RpcAddress(this.host, this.server().getPort());
                this.bitmap$0 = true;
            }
            return this.address;
        }
    }

    @Override
    public Logger org$apache$spark$Logging$$log_() {
        return this.org$apache$spark$Logging$$log_;
    }

    @Override
    @TraitSetter
    public void org$apache$spark$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$Logging$$log_ = x$1;
    }

    @Override
    public String logName() {
        return Logging$class.logName(this);
    }

    @Override
    public Logger log() {
        return Logging$class.log(this);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logging$class.logInfo(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logging$class.logDebug(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logging$class.logTrace(this, msg);
    }

    @Override
    public void logWarning(Function0<String> msg) {
        Logging$class.logWarning(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logging$class.logError(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging$class.logInfo(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging$class.logDebug(this, msg, throwable);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging$class.logTrace(this, msg, throwable);
    }

    @Override
    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging$class.logWarning(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logging$class.logError(this, msg, throwable);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging$class.isTraceEnabled(this);
    }

    public SparkConf conf() {
        return this.conf;
    }

    public TransportConf transportConf() {
        return this.transportConf;
    }

    private Dispatcher dispatcher() {
        return this.dispatcher;
    }

    private NettyStreamManager streamManager() {
        return this.streamManager;
    }

    private RpcEnvFileServer _fileServer() {
        return this._fileServer;
    }

    private TransportContext transportContext() {
        return this.transportContext;
    }

    private List<TransportClientBootstrap> createClientBootstraps() {
        return this.securityManager.isAuthenticationEnabled() ? Arrays.asList((Object[])new TransportClientBootstrap[]{new SaslClientBootstrap(this.transportConf(), "", (SecretKeyHolder)this.securityManager, this.securityManager.isSaslEncryptionEnabled())}) : Collections.emptyList();
    }

    private TransportClientFactory clientFactory() {
        return this.clientFactory;
    }

    private TransportClientFactory fileDownloadFactory() {
        return this.fileDownloadFactory;
    }

    private void fileDownloadFactory_$eq(TransportClientFactory x$1) {
        this.fileDownloadFactory = x$1;
    }

    public ScheduledExecutorService timeoutScheduler() {
        return this.timeoutScheduler;
    }

    public ThreadPoolExecutor clientConnectionExecutor() {
        return this.clientConnectionExecutor;
    }

    private TransportServer server() {
        return this.server;
    }

    private void server_$eq(TransportServer x$1) {
        this.server = x$1;
    }

    private AtomicBoolean stopped() {
        return this.stopped;
    }

    private ConcurrentHashMap<RpcAddress, Outbox> outboxes() {
        return this.outboxes;
    }

    public void removeOutbox(RpcAddress address2) {
        Outbox outbox = this.outboxes().remove(address2);
        if (outbox != null) {
            outbox.stop();
        }
    }

    public void startServer(int port) {
        List bootstraps = this.securityManager.isAuthenticationEnabled() ? Arrays.asList((Object[])new TransportServerBootstrap[]{new SaslServerBootstrap(this.transportConf(), (SecretKeyHolder)this.securityManager)}) : Collections.emptyList();
        this.server_$eq(this.transportContext().createServer(this.host, port, bootstraps));
        this.dispatcher().registerRpcEndpoint(RpcEndpointVerifier$.MODULE$.NAME(), new RpcEndpointVerifier(this, this.dispatcher()));
    }

    @Override
    public RpcAddress address() {
        return this.bitmap$0 ? this.address : this.address$lzycompute();
    }

    @Override
    public RpcEndpointRef setupEndpoint(String name, RpcEndpoint endpoint) {
        return this.dispatcher().registerRpcEndpoint(name, endpoint);
    }

    @Override
    public Future<RpcEndpointRef> asyncSetupEndpointRefByURI(String uri) {
        RpcEndpointAddress addr = RpcEndpointAddress$.MODULE$.apply(uri);
        NettyRpcEndpointRef endpointRef = new NettyRpcEndpointRef(this.conf(), addr, this);
        NettyRpcEndpointRef verifier = new NettyRpcEndpointRef(this.conf(), new RpcEndpointAddress(addr.rpcAddress(), RpcEndpointVerifier$.MODULE$.NAME()), this);
        return verifier.ask(new RpcEndpointVerifier.CheckExistence(endpointRef.name()), ClassTag$.MODULE$.Boolean()).flatMap((Function1)new Serializable(this, uri, endpointRef){
            public static final long serialVersionUID = 0L;
            private final String uri$1;
            private final NettyRpcEndpointRef endpointRef$1;

            public final Future<NettyRpcEndpointRef> apply(boolean find) {
                return find ? Future$.MODULE$.successful((Object)this.endpointRef$1) : Future$.MODULE$.failed((Throwable)new RpcEndpointNotFoundException(this.uri$1));
            }
            {
                this.uri$1 = uri$1;
                this.endpointRef$1 = endpointRef$1;
            }
        }, (ExecutionContext)ThreadUtils$.MODULE$.sameThread());
    }

    @Override
    public void stop(RpcEndpointRef endpointRef) {
        Predef$.MODULE$.require(endpointRef instanceof NettyRpcEndpointRef);
        this.dispatcher().stop(endpointRef);
    }

    private void postToOutbox(NettyRpcEndpointRef receiver, OutboxMessage message) {
        if (receiver.client() == null) {
            Outbox targetOutbox;
            Outbox outbox;
            Predef$.MODULE$.require(receiver.address() != null, (Function0)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Cannot send message to client endpoint with no listen address.";
                }
            });
            Outbox outbox2 = this.outboxes().get(receiver.address());
            if (outbox2 == null) {
                Outbox newOutbox = new Outbox(this, receiver.address());
                Outbox oldOutbox = this.outboxes().putIfAbsent(receiver.address(), newOutbox);
                outbox = oldOutbox == null ? newOutbox : oldOutbox;
            } else {
                outbox = targetOutbox = outbox2;
            }
            if (this.stopped().get()) {
                this.outboxes().remove(receiver.address());
                targetOutbox.stop();
            } else {
                targetOutbox.send(message);
            }
        } else {
            message.sendWith(receiver.client());
        }
    }

    public void send(RequestMessage message) {
        RpcAddress remoteAddr;
        RpcAddress rpcAddress = remoteAddr = message.receiver().address();
        RpcAddress rpcAddress2 = this.address();
        if (!(rpcAddress != null ? !((Object)rpcAddress).equals(rpcAddress2) : rpcAddress2 != null)) {
            this.dispatcher().postOneWayMessage(message);
        } else {
            this.postToOutbox(message.receiver(), new OneWayOutboxMessage(this.serialize(message)));
        }
    }

    public TransportClient createClient(RpcAddress address2) {
        return this.clientFactory().createClient(address2.host(), address2.port());
    }

    public <T> Future<T> ask(RequestMessage message, RpcTimeout timeout, ClassTag<T> evidence$1) {
        RpcAddress remoteAddr;
        Promise promise = Promise$.MODULE$.apply();
        RpcAddress rpcAddress = remoteAddr = message.receiver().address();
        RpcAddress rpcAddress2 = this.address();
        if (!(rpcAddress != null ? !((Object)rpcAddress).equals(rpcAddress2) : rpcAddress2 != null)) {
            Promise p = Promise$.MODULE$.apply();
            p.future().onComplete((Function1)new Serializable(this, promise){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ NettyRpcEnv $outer;
                private final Promise promise$1;

                public final void apply(Try<Object> x0$1) {
                    Try<Object> try_;
                    block4: {
                        block3: {
                            block2: {
                                try_ = x0$1;
                                if (!(try_ instanceof Success)) break block2;
                                Success success = (Success)try_;
                                Object response = success.value();
                                this.$outer.org$apache$spark$rpc$netty$NettyRpcEnv$$onSuccess$1(response, this.promise$1);
                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                break block3;
                            }
                            if (!(try_ instanceof Failure)) break block4;
                            Failure failure = (Failure)try_;
                            Throwable e = failure.exception();
                            this.$outer.org$apache$spark$rpc$netty$NettyRpcEnv$$onFailure$1(e, this.promise$1);
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        }
                        return;
                    }
                    throw new MatchError(try_);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.promise$1 = promise$1;
                }
            }, (ExecutionContext)ThreadUtils$.MODULE$.sameThread());
            this.dispatcher().postLocalMessage(message, (Promise<Object>)p);
        } else {
            RpcOutboxMessage rpcMessage = new RpcOutboxMessage(this.serialize(message), (Function1<Throwable, BoxedUnit>)new Serializable(this, promise){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ NettyRpcEnv $outer;
                private final Promise promise$1;

                public final void apply(Throwable e) {
                    this.$outer.org$apache$spark$rpc$netty$NettyRpcEnv$$onFailure$1(e, this.promise$1);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.promise$1 = promise$1;
                }
            }, (Function2<TransportClient, ByteBuffer, BoxedUnit>)new Serializable(this, promise){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ NettyRpcEnv $outer;
                private final Promise promise$1;

                public final void apply(TransportClient client, ByteBuffer response) {
                    this.$outer.org$apache$spark$rpc$netty$NettyRpcEnv$$onSuccess$1(this.$outer.deserialize(client, response, ClassTag$.MODULE$.Any()), this.promise$1);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.promise$1 = promise$1;
                }
            });
            this.postToOutbox(message.receiver(), rpcMessage);
            promise.future().onFailure((PartialFunction)new Serializable(this, rpcMessage){
                public static final long serialVersionUID = 0L;
                private final RpcOutboxMessage rpcMessage$1;

                public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                    BoxedUnit boxedUnit;
                    A1 A1 = x1;
                    if (A1 instanceof TimeoutException) {
                        this.rpcMessage$1.onTimeout();
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    return (B1)boxedUnit;
                }

                public final boolean isDefinedAt(Throwable x1) {
                    Throwable throwable = x1;
                    boolean bl = throwable instanceof TimeoutException ? true : true;
                    return bl;
                }
                {
                    this.rpcMessage$1 = rpcMessage$1;
                }
            }, (ExecutionContext)ThreadUtils$.MODULE$.sameThread());
        }
        ScheduledFuture<?> timeoutCancelable = this.timeoutScheduler().schedule(new Runnable(this, timeout, promise){
            private final RpcTimeout timeout$1;
            private final Promise promise$1;

            public void run() {
                this.promise$1.tryFailure((Throwable)new TimeoutException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Cannot receive any reply in ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.timeout$1.duration()}))));
            }
            {
                this.timeout$1 = timeout$1;
                this.promise$1 = promise$1;
            }
        }, timeout.duration().toNanos(), TimeUnit.NANOSECONDS);
        promise.future().onComplete((Function1)new Serializable(this, timeoutCancelable){
            public static final long serialVersionUID = 0L;
            private final ScheduledFuture timeoutCancelable$1;

            public final boolean apply(Try<Object> v) {
                return this.timeoutCancelable$1.cancel(true);
            }
            {
                this.timeoutCancelable$1 = timeoutCancelable$1;
            }
        }, (ExecutionContext)ThreadUtils$.MODULE$.sameThread());
        return promise.future().mapTo(evidence$1).recover(timeout.addMessageIfTimeout(), (ExecutionContext)ThreadUtils$.MODULE$.sameThread());
    }

    public ByteBuffer serialize(Object content) {
        return this.org$apache$spark$rpc$netty$NettyRpcEnv$$javaSerializerInstance.serialize(content, ClassTag$.MODULE$.Any());
    }

    public <T> T deserialize(TransportClient client, ByteBuffer bytes, ClassTag<T> evidence$2) {
        return (T)NettyRpcEnv$.MODULE$.currentClient().withValue((Object)client, (Function0)new Serializable(this, bytes, evidence$2){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ NettyRpcEnv $outer;
            public final ByteBuffer bytes$1;
            public final ClassTag evidence$2$1;

            public final T apply() {
                return this.$outer.deserialize(new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$deserialize$1 $outer;

                    public final T apply() {
                        return this.$outer.org$apache$spark$rpc$netty$NettyRpcEnv$$anonfun$$$outer().org$apache$spark$rpc$netty$NettyRpcEnv$$javaSerializerInstance.deserialize(this.$outer.bytes$1, this.$outer.evidence$2$1);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            }

            public /* synthetic */ NettyRpcEnv org$apache$spark$rpc$netty$NettyRpcEnv$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.bytes$1 = bytes$1;
                this.evidence$2$1 = evidence$2$1;
            }
        });
    }

    @Override
    public RpcEndpointRef endpointRef(RpcEndpoint endpoint) {
        return this.dispatcher().getRpcEndpointRef(endpoint);
    }

    @Override
    public String uriOf(String systemName, RpcAddress address2, String endpointName) {
        return new RpcEndpointAddress(address2, endpointName).toString();
    }

    @Override
    public void shutdown() {
        this.cleanup();
    }

    @Override
    public void awaitTermination() {
        this.dispatcher().awaitTermination();
    }

    private void cleanup() {
        if (this.stopped().compareAndSet(false, true)) {
            for (Outbox outbox : this.outboxes().values()) {
                this.outboxes().remove(outbox.address());
                outbox.stop();
            }
            Object object = this.timeoutScheduler() == null ? BoxedUnit.UNIT : this.timeoutScheduler().shutdownNow();
            if (this.server() != null) {
                this.server().close();
            }
            if (this.clientFactory() != null) {
                this.clientFactory().close();
            }
            if (this.dispatcher() != null) {
                this.dispatcher().stop();
            }
            Object object2 = this.clientConnectionExecutor() == null ? BoxedUnit.UNIT : this.clientConnectionExecutor().shutdownNow();
            if (this.fileDownloadFactory() != null) {
                this.fileDownloadFactory().close();
            }
            return;
        }
    }

    @Override
    public <T> T deserialize(Function0<T> deserializationAction) {
        return (T)NettyRpcEnv$.MODULE$.currentEnv().withValue((Object)this, deserializationAction);
    }

    @Override
    public RpcEnvFileServer fileServer() {
        return this._fileServer();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ReadableByteChannel openChannel(String uri) {
        URI parsedUri = new URI(uri);
        Predef$.MODULE$.require(parsedUri.getHost() != null, (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Host name must be defined.";
            }
        });
        Predef$.MODULE$.require(parsedUri.getPort() > 0, (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Port must be defined.";
            }
        });
        Predef$.MODULE$.require(parsedUri.getPath() != null && new StringOps(Predef$.MODULE$.augmentString(parsedUri.getPath())).nonEmpty(), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Path must be defined.";
            }
        });
        Pipe pipe2 = Pipe.open();
        FileDownloadChannel source = new FileDownloadChannel(this, pipe2.source());
        try {
            TransportClient client = this.downloadClient(parsedUri.getHost(), parsedUri.getPort());
            FileDownloadCallback callback = new FileDownloadCallback(this, pipe2.sink(), source, client);
            client.stream(parsedUri.getPath(), (StreamCallback)callback);
            return source;
        }
        catch (Exception exception2) {
            void var4_4;
            void var3_3;
            var3_3.sink().close();
            var4_4.close();
            throw exception2;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private TransportClient downloadClient(String host, int port) {
        BoxedUnit boxedUnit;
        if (this.fileDownloadFactory() != null) {
            boxedUnit = BoxedUnit.UNIT;
            return this.fileDownloadFactory().createClient(host, port);
        }
        NettyRpcEnv nettyRpcEnv = this;
        synchronized (nettyRpcEnv) {
            BoxedUnit boxedUnit2;
            if (this.fileDownloadFactory() == null) {
                String module = "files";
                String prefix = "spark.rpc.io.";
                SparkConf clone = this.conf().clone();
                Predef$.MODULE$.refArrayOps((Object[])this.conf().getAll()).foreach((Function1)new Serializable(this, module, prefix, clone){
                    public static final long serialVersionUID = 0L;
                    private final String module$1;
                    private final String prefix$1;
                    private final SparkConf clone$1;

                    public final Object apply(Tuple2<String, String> x0$2) {
                        Tuple2<String, String> tuple2 = x0$2;
                        if (tuple2 != null) {
                            Object object;
                            String key = (String)tuple2._1();
                            String value = (String)tuple2._2();
                            if (key.startsWith(this.prefix$1)) {
                                String opt = key.substring(this.prefix$1.length());
                                object = this.clone$1.setIfMissing(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"spark.", ".io.", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.module$1, opt})), value);
                            } else {
                                object = BoxedUnit.UNIT;
                            }
                            BoxedUnit boxedUnit = object;
                            return boxedUnit;
                        }
                        throw new MatchError(tuple2);
                    }
                    {
                        this.module$1 = module$1;
                        this.prefix$1 = prefix$1;
                        this.clone$1 = clone$1;
                    }
                });
                int ioThreads = clone.getInt("spark.files.io.threads", 1);
                TransportConf downloadConf = SparkTransportConf$.MODULE$.fromSparkConf(clone, module, ioThreads);
                TransportContext downloadContext = new TransportContext(downloadConf, (RpcHandler)new NoOpRpcHandler(), true);
                this.fileDownloadFactory_$eq(downloadContext.createClientFactory(this.createClientBootstraps()));
                boxedUnit2 = BoxedUnit.UNIT;
            } else {
                boxedUnit2 = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit3 = boxedUnit2;
            // MONITOREXIT @DISABLED, blocks:[0, 1] lbl20 : MonitorExitStatement: MONITOREXIT : nettyRpcEnv
            boxedUnit = boxedUnit3;
            return this.fileDownloadFactory().createClient(host, port);
        }
    }

    public final void org$apache$spark$rpc$netty$NettyRpcEnv$$onFailure$1(Throwable e, Promise promise$1) {
        if (!promise$1.tryFailure(e)) {
            this.logWarning((Function0<String>)new Serializable(this, e){
                public static final long serialVersionUID = 0L;
                private final Throwable e$1;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Ignored failure: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.e$1}));
                }
                {
                    this.e$1 = e$1;
                }
            });
        }
    }

    public final void org$apache$spark$rpc$netty$NettyRpcEnv$$onSuccess$1(Object reply, Promise promise$1) {
        Object object = reply;
        if (object instanceof RpcFailure) {
            RpcFailure rpcFailure = (RpcFailure)object;
            Throwable e = rpcFailure.e();
            this.org$apache$spark$rpc$netty$NettyRpcEnv$$onFailure$1(e, promise$1);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit;
            if (promise$1.trySuccess(object)) {
                boxedUnit = BoxedUnit.UNIT;
            } else {
                this.logWarning((Function0<String>)new Serializable(this, reply){
                    public static final long serialVersionUID = 0L;
                    private final Object reply$1;

                    public final String apply() {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Ignored message: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.reply$1}));
                    }
                    {
                        this.reply$1 = reply$1;
                    }
                });
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit2 = boxedUnit;
        }
    }

    public NettyRpcEnv(SparkConf conf, JavaSerializerInstance javaSerializerInstance, String host, SecurityManager securityManager) {
        this.conf = conf;
        this.org$apache$spark$rpc$netty$NettyRpcEnv$$javaSerializerInstance = javaSerializerInstance;
        this.host = host;
        this.securityManager = securityManager;
        super(conf);
        Logging$class.$init$(this);
        this.transportConf = SparkTransportConf$.MODULE$.fromSparkConf(conf.clone().set("spark.rpc.io.numConnectionsPerPeer", "1"), "rpc", conf.getInt("spark.rpc.io.threads", 0));
        this.dispatcher = new Dispatcher(this);
        this.streamManager = new NettyStreamManager(this);
        this._fileServer = conf.getBoolean("spark.rpc.useNettyFileServer", false) ? this.streamManager() : new HttpBasedFileServer(conf, securityManager);
        this.transportContext = new TransportContext(this.transportConf(), (RpcHandler)new NettyRpcHandler(this.dispatcher(), this, this.streamManager()));
        this.clientFactory = this.transportContext().createClientFactory(this.createClientBootstraps());
        this.timeoutScheduler = ThreadUtils$.MODULE$.newDaemonSingleThreadScheduledExecutor("netty-rpc-env-timeout");
        this.clientConnectionExecutor = ThreadUtils$.MODULE$.newDaemonCachedThreadPool("netty-rpc-connection", conf.getInt("spark.rpc.connect.threads", 64), ThreadUtils$.MODULE$.newDaemonCachedThreadPool$default$3());
        this.stopped = new AtomicBoolean(false);
        this.outboxes = new ConcurrentHashMap();
    }

    public class FileDownloadChannel
    implements ReadableByteChannel {
        public final ReadableByteChannel org$apache$spark$rpc$netty$NettyRpcEnv$FileDownloadChannel$$source;
        private volatile Throwable error;
        public final /* synthetic */ NettyRpcEnv $outer;

        private Throwable error() {
            return this.error;
        }

        private void error_$eq(Throwable x$1) {
            this.error = x$1;
        }

        public void setError(Throwable e) {
            this.error_$eq(e);
            this.org$apache$spark$rpc$netty$NettyRpcEnv$FileDownloadChannel$$source.close();
        }

        @Override
        public int read(ByteBuffer dst) {
            Object result = this.error() == null ? Try$.MODULE$.apply((Function0)new Serializable(this, dst){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ FileDownloadChannel $outer;
                private final ByteBuffer dst$1;

                public final int apply() {
                    return this.apply$mcI$sp();
                }

                public int apply$mcI$sp() {
                    return this.$outer.org$apache$spark$rpc$netty$NettyRpcEnv$FileDownloadChannel$$source.read(this.dst$1);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.dst$1 = dst$1;
                }
            }) : new Failure(this.error());
            Failure failure = result;
            if (failure instanceof Success) {
                int bytesRead;
                Success success = (Success)failure;
                int n = bytesRead = BoxesRunTime.unboxToInt((Object)success.value());
                return n;
            }
            if (failure instanceof Failure) {
                Failure failure2 = failure;
                Throwable error2 = failure2.exception();
                throw error2;
            }
            throw new MatchError((Object)failure);
        }

        @Override
        public void close() {
            this.org$apache$spark$rpc$netty$NettyRpcEnv$FileDownloadChannel$$source.close();
        }

        @Override
        public boolean isOpen() {
            return this.org$apache$spark$rpc$netty$NettyRpcEnv$FileDownloadChannel$$source.isOpen();
        }

        public /* synthetic */ NettyRpcEnv org$apache$spark$rpc$netty$NettyRpcEnv$FileDownloadChannel$$$outer() {
            return this.$outer;
        }

        public FileDownloadChannel(NettyRpcEnv $outer, ReadableByteChannel source) {
            this.org$apache$spark$rpc$netty$NettyRpcEnv$FileDownloadChannel$$source = source;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
        }
    }

    public class FileDownloadCallback
    implements StreamCallback {
        private final WritableByteChannel sink;
        private final FileDownloadChannel source;
        public final /* synthetic */ NettyRpcEnv $outer;

        public void onData(String streamId, ByteBuffer buf) {
            while (buf.remaining() > 0) {
                this.sink.write(buf);
            }
        }

        public void onComplete(String streamId) {
            this.sink.close();
        }

        public void onFailure(String streamId, Throwable cause) {
            this.org$apache$spark$rpc$netty$NettyRpcEnv$FileDownloadCallback$$$outer().logError((Function0<String>)new Serializable(this, streamId){
                public static final long serialVersionUID = 0L;
                private final String streamId$1;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Error downloading stream ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.streamId$1}));
                }
                {
                    this.streamId$1 = streamId$1;
                }
            }, cause);
            this.source.setError(cause);
            this.sink.close();
        }

        public /* synthetic */ NettyRpcEnv org$apache$spark$rpc$netty$NettyRpcEnv$FileDownloadCallback$$$outer() {
            return this.$outer;
        }

        public FileDownloadCallback(NettyRpcEnv $outer, WritableByteChannel sink, FileDownloadChannel source, TransportClient client) {
            this.sink = sink;
            this.source = source;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
        }
    }
}

