/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.storage;

import org.apache.spark.Logging;
import org.apache.spark.Logging$class;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkException;
import org.apache.spark.rpc.RpcEndpointRef;
import org.apache.spark.rpc.RpcTimeout;
import org.apache.spark.storage.BlockId;
import org.apache.spark.storage.BlockManagerId;
import org.apache.spark.storage.BlockManagerMaster$;
import org.apache.spark.storage.BlockManagerMessages;
import org.apache.spark.storage.BlockManagerMessages$GetMemoryStatus$;
import org.apache.spark.storage.BlockManagerMessages$GetStorageStatus$;
import org.apache.spark.storage.BlockManagerMessages$StopBlockManagerMaster$;
import org.apache.spark.storage.BlockStatus;
import org.apache.spark.storage.StorageLevel;
import org.apache.spark.storage.StorageStatus;
import org.apache.spark.util.RpcUtils$;
import org.apache.spark.util.ThreadUtils$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.IndexedSeq;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.generic.CanBuildFrom;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.Map;
import scala.collection.mutable.StringBuilder;
import scala.concurrent.ExecutionContext;
import scala.concurrent.ExecutionContextExecutor;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.TraitSetter;

@ScalaSignature(bytes="\u0006\u0001\t]a!B\u0001\u0003\u0001\u0011Q!A\u0005\"m_\u000e\\W*\u00198bO\u0016\u0014X*Y:uKJT!a\u0001\u0003\u0002\u000fM$xN]1hK*\u0011QAB\u0001\u0006gB\f'o\u001b\u0006\u0003\u000f!\ta!\u00199bG\",'\"A\u0005\u0002\u0007=\u0014xmE\u0002\u0001\u0017E\u0001\"\u0001D\b\u000e\u00035Q\u0011AD\u0001\u0006g\u000e\fG.Y\u0005\u0003!5\u0011a!\u00118z%\u00164\u0007C\u0001\n\u0014\u001b\u0005!\u0011B\u0001\u000b\u0005\u0005\u001daunZ4j]\u001eD\u0001B\u0006\u0001\u0003\u0002\u0004%\t\u0001G\u0001\u000fIJLg/\u001a:F]\u0012\u0004x.\u001b8u\u0007\u0001)\u0012!\u0007\t\u00035ui\u0011a\u0007\u0006\u00039\u0011\t1A\u001d9d\u0013\tq2D\u0001\bSa\u000e,e\u000e\u001a9pS:$(+\u001a4\t\u0011\u0001\u0002!\u00111A\u0005\u0002\u0005\n!\u0003\u001a:jm\u0016\u0014XI\u001c3q_&tGo\u0018\u0013fcR\u0011!%\n\t\u0003\u0019\rJ!\u0001J\u0007\u0003\tUs\u0017\u000e\u001e\u0005\bM}\t\t\u00111\u0001\u001a\u0003\rAH%\r\u0005\tQ\u0001\u0011\t\u0011)Q\u00053\u0005yAM]5wKJ,e\u000e\u001a9pS:$\b\u0005\u0003\u0005+\u0001\t\u0005\t\u0015!\u0003,\u0003\u0011\u0019wN\u001c4\u0011\u0005Ia\u0013BA\u0017\u0005\u0005%\u0019\u0006/\u0019:l\u0007>tg\r\u0003\u00050\u0001\t\u0005\t\u0015!\u00031\u0003!I7\u000f\u0012:jm\u0016\u0014\bC\u0001\u00072\u0013\t\u0011TBA\u0004C_>dW-\u00198\t\u000bQ\u0002A\u0011A\u001b\u0002\rqJg.\u001b;?)\u00111\u0004(\u000f\u001e\u0011\u0005]\u0002Q\"\u0001\u0002\t\u000bY\u0019\u0004\u0019A\r\t\u000b)\u001a\u0004\u0019A\u0016\t\u000b=\u001a\u0004\u0019\u0001\u0019\t\u000fq\u0002!\u0019!C\u0001{\u00059A/[7f_V$X#\u0001 \u0011\u0005iy\u0014B\u0001!\u001c\u0005)\u0011\u0006o\u0019+j[\u0016|W\u000f\u001e\u0005\u0007\u0005\u0002\u0001\u000b\u0011\u0002 \u0002\u0011QLW.Z8vi\u0002BQ\u0001\u0012\u0001\u0005\u0002\u0015\u000baB]3n_Z,W\t_3dkR|'\u000f\u0006\u0002#\r\")qi\u0011a\u0001\u0011\u00061Q\r_3d\u0013\u0012\u0004\"!\u0013'\u000f\u00051Q\u0015BA&\u000e\u0003\u0019\u0001&/\u001a3fM&\u0011QJ\u0014\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005-k\u0001\"\u0002)\u0001\t\u0003\t\u0016\u0001\u0006:fO&\u001cH/\u001a:CY>\u001c7.T1oC\u001e,'\u000f\u0006\u0003#%^c\u0006\"B*P\u0001\u0004!\u0016A\u00042m_\u000e\\W*\u00198bO\u0016\u0014\u0018\n\u001a\t\u0003oUK!A\u0016\u0002\u0003\u001d\tcwnY6NC:\fw-\u001a:JI\")\u0001l\u0014a\u00013\u0006QQ.\u0019=NK6\u001c\u0016N_3\u0011\u00051Q\u0016BA.\u000e\u0005\u0011auN\\4\t\u000bu{\u0005\u0019A\r\u0002\u001bMd\u0017M^3F]\u0012\u0004x.\u001b8u\u0011\u0015y\u0006\u0001\"\u0001a\u0003=)\b\u000fZ1uK\ncwnY6J]\u001a|Gc\u0002\u0019bE\u001edg\u000e\u001d\u0005\u0006'z\u0003\r\u0001\u0016\u0005\u0006Gz\u0003\r\u0001Z\u0001\bE2|7m[%e!\t9T-\u0003\u0002g\u0005\t9!\t\\8dW&#\u0007\"\u00025_\u0001\u0004I\u0017\u0001D:u_J\fw-\u001a'fm\u0016d\u0007CA\u001ck\u0013\tY'A\u0001\u0007Ti>\u0014\u0018mZ3MKZ,G\u000eC\u0003n=\u0002\u0007\u0011,A\u0004nK6\u001c\u0016N_3\t\u000b=t\u0006\u0019A-\u0002\u0011\u0011L7o[*ju\u0016DQ!\u001d0A\u0002e\u000ba#\u001a=uKJt\u0017\r\u001c\"m_\u000e\\7\u000b^8sKNK'0\u001a\u0005\u0006g\u0002!\t\u0001^\u0001\rO\u0016$Hj\\2bi&|gn\u001d\u000b\u0004k\u0006\r\u0001c\u0001<\u007f):\u0011q\u000f \b\u0003qnl\u0011!\u001f\u0006\u0003u^\ta\u0001\u0010:p_Rt\u0014\"\u0001\b\n\u0005ul\u0011a\u00029bG.\fw-Z\u0005\u0004\u007f\u0006\u0005!aA*fc*\u0011Q0\u0004\u0005\u0006GJ\u0004\r\u0001\u001a\u0005\u0007g\u0002!\t!a\u0002\u0015\t\u0005%\u0011q\u0002\t\u0005m\u0006-Q/\u0003\u0003\u0002\u000e\u0005\u0005!AC%oI\u0016DX\rZ*fc\"A\u0011\u0011CA\u0003\u0001\u0004\t\u0019\"\u0001\u0005cY>\u001c7.\u00133t!\u0011a\u0011Q\u00033\n\u0007\u0005]QBA\u0003BeJ\f\u0017\u0010C\u0004\u0002\u001c\u0001!\t!!\b\u0002\u0011\r|g\u000e^1j]N$2\u0001MA\u0010\u0011\u0019\u0019\u0017\u0011\u0004a\u0001I\"9\u00111\u0005\u0001\u0005\u0002\u0005\u0015\u0012\u0001C4fiB+WM]:\u0015\u0007U\f9\u0003\u0003\u0004T\u0003C\u0001\r\u0001\u0016\u0005\b\u0003W\u0001A\u0011AA\u0017\u0003Y9W\r^#yK\u000e,Ho\u001c:F]\u0012\u0004x.\u001b8u%\u00164G\u0003BA\u0018\u0003k\u0001B\u0001DA\u00193%\u0019\u00111G\u0007\u0003\r=\u0003H/[8o\u0011\u001d\t9$!\u000bA\u0002!\u000b!\"\u001a=fGV$xN]%e\u0011\u001d\tY\u0004\u0001C\u0001\u0003{\t1B]3n_Z,'\t\\8dWR\u0019!%a\u0010\t\r\r\fI\u00041\u0001e\u0011\u001d\t\u0019\u0005\u0001C\u0001\u0003\u000b\n\u0011B]3n_Z,'\u000b\u001a3\u0015\u000b\t\n9%!\u0015\t\u0011\u0005%\u0013\u0011\ta\u0001\u0003\u0017\nQA\u001d3e\u0013\u0012\u00042\u0001DA'\u0013\r\ty%\u0004\u0002\u0004\u0013:$\bbBA*\u0003\u0003\u0002\r\u0001M\u0001\tE2|7m[5oO\"9\u0011q\u000b\u0001\u0005\u0002\u0005e\u0013!\u0004:f[>4Xm\u00155vM\u001adW\rF\u0003#\u00037\ny\u0006\u0003\u0005\u0002^\u0005U\u0003\u0019AA&\u0003%\u0019\b.\u001e4gY\u0016LE\rC\u0004\u0002T\u0005U\u0003\u0019\u0001\u0019\t\u000f\u0005\r\u0004\u0001\"\u0001\u0002f\u0005y!/Z7pm\u0016\u0014%o\\1eG\u0006\u001cH\u000fF\u0004#\u0003O\nY'a\u001c\t\u000f\u0005%\u0014\u0011\ra\u00013\u0006Y!M]8bI\u000e\f7\u000f^%e\u0011\u001d\ti'!\u0019A\u0002A\n\u0001C]3n_Z,gI]8n\u001b\u0006\u001cH/\u001a:\t\u000f\u0005M\u0013\u0011\ra\u0001a!9\u00111\u000f\u0001\u0005\u0002\u0005U\u0014aD4fi6+Wn\u001c:z'R\fG/^:\u0016\u0005\u0005]\u0004CB%\u0002zQ\u000bi(C\u0002\u0002|9\u00131!T1q!\u0015a\u0011qP-Z\u0013\r\t\t)\u0004\u0002\u0007)V\u0004H.\u001a\u001a\t\u000f\u0005\u0015\u0005\u0001\"\u0001\u0002\b\u0006\u0001r-\u001a;Ti>\u0014\u0018mZ3Ti\u0006$Xo]\u000b\u0003\u0003\u0013\u0003R\u0001DA\u000b\u0003\u0017\u00032aNAG\u0013\r\tyI\u0001\u0002\u000e'R|'/Y4f'R\fG/^:\t\u000f\u0005M\u0005\u0001\"\u0001\u0002\u0016\u0006qq-\u001a;CY>\u001c7n\u0015;biV\u001cHCBAL\u0003?\u000b\t\u000b\u0005\u0004J\u0003s\"\u0016\u0011\u0014\t\u0004o\u0005m\u0015bAAO\u0005\tY!\t\\8dWN#\u0018\r^;t\u0011\u0019\u0019\u0017\u0011\u0013a\u0001I\"I\u00111UAI!\u0003\u0005\r\u0001M\u0001\nCN\\7\u000b\\1wKNDq!a*\u0001\t\u0003\tI+A\nhKRl\u0015\r^2iS:<'\t\\8dW&#7\u000f\u0006\u0004\u0002,\u00065\u0016q\u0017\t\u0004mz$\u0007\u0002CAX\u0003K\u0003\r!!-\u0002\r\u0019LG\u000e^3s!\u0015a\u00111\u001731\u0013\r\t),\u0004\u0002\n\rVt7\r^5p]FBq!a)\u0002&\u0002\u0007\u0001\u0007C\u0004\u0002<\u0002!\t!!0\u0002\u001f!\f7oQ1dQ\u0016$'\t\\8dWN$2\u0001MA`\u0011\u001d\t9$!/A\u0002!Cq!a1\u0001\t\u0003\t)-\u0001\u0003ti>\u0004H#\u0001\u0012\t\u000f\u0005%\u0007\u0001\"\u0003\u0002L\u0006!A/\u001a7m)\r\u0011\u0013Q\u001a\u0005\t\u0003\u001f\f9\r1\u0001\u0002R\u00069Q.Z:tC\u001e,\u0007c\u0001\u0007\u0002T&\u0019\u0011Q[\u0007\u0003\u0007\u0005s\u0017\u0010C\u0005\u0002Z\u0002\t\n\u0011\"\u0001\u0002\\\u0006Ar-\u001a;CY>\u001c7n\u0015;biV\u001cH\u0005Z3gCVdG\u000f\n\u001a\u0016\u0005\u0005u'f\u0001\u0019\u0002`.\u0012\u0011\u0011\u001d\t\u0005\u0003G\fi/\u0004\u0002\u0002f*!\u0011q]Au\u0003%)hn\u00195fG.,GMC\u0002\u0002l6\t!\"\u00198o_R\fG/[8o\u0013\u0011\ty/!:\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cWm\u0002\u0005\u0002t\nA\t\u0001BA{\u0003I\u0011En\\2l\u001b\u0006t\u0017mZ3s\u001b\u0006\u001cH/\u001a:\u0011\u0007]\n9PB\u0004\u0002\u0005!\u0005A!!?\u0014\u0007\u0005]8\u0002C\u00045\u0003o$\t!!@\u0015\u0005\u0005U\bB\u0003B\u0001\u0003o\u0014\r\u0011\"\u0001\u0003\u0004\u0005!BIU%W\u000bJ{VI\u0014#Q\u001f&sEk\u0018(B\u001b\u0016+\"A!\u0002\u0011\t\t\u001d!\u0011C\u0007\u0003\u0005\u0013QAAa\u0003\u0003\u000e\u0005!A.\u00198h\u0015\t\u0011y!\u0001\u0003kCZ\f\u0017bA'\u0003\n!I!QCA|A\u0003%!QA\u0001\u0016\tJKe+\u0012*`\u000b:#\u0005kT%O)~s\u0015)T#!\u0001")
public class BlockManagerMaster
implements Logging {
    private RpcEndpointRef driverEndpoint;
    private final boolean isDriver;
    private final RpcTimeout timeout;
    private transient Logger org$apache$spark$Logging$$log_;

    public static String DRIVER_ENDPOINT_NAME() {
        return BlockManagerMaster$.MODULE$.DRIVER_ENDPOINT_NAME();
    }

    @Override
    public Logger org$apache$spark$Logging$$log_() {
        return this.org$apache$spark$Logging$$log_;
    }

    @Override
    @TraitSetter
    public void org$apache$spark$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$Logging$$log_ = x$1;
    }

    @Override
    public String logName() {
        return Logging$class.logName(this);
    }

    @Override
    public Logger log() {
        return Logging$class.log(this);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logging$class.logInfo(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logging$class.logDebug(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logging$class.logTrace(this, msg);
    }

    @Override
    public void logWarning(Function0<String> msg) {
        Logging$class.logWarning(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logging$class.logError(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging$class.logInfo(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging$class.logDebug(this, msg, throwable);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging$class.logTrace(this, msg, throwable);
    }

    @Override
    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging$class.logWarning(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logging$class.logError(this, msg, throwable);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging$class.isTraceEnabled(this);
    }

    public RpcEndpointRef driverEndpoint() {
        return this.driverEndpoint;
    }

    public void driverEndpoint_$eq(RpcEndpointRef x$1) {
        this.driverEndpoint = x$1;
    }

    public RpcTimeout timeout() {
        return this.timeout;
    }

    public void removeExecutor(String execId) {
        this.tell(new BlockManagerMessages.RemoveExecutor(execId));
        this.logInfo((Function0<String>)new Serializable(this, execId){
            public static final long serialVersionUID = 0L;
            private final String execId$1;

            public final String apply() {
                return new StringBuilder().append((Object)"Removed ").append((Object)this.execId$1).append((Object)" successfully in removeExecutor").toString();
            }
            {
                this.execId$1 = execId$1;
            }
        });
    }

    public void registerBlockManager(BlockManagerId blockManagerId, long maxMemSize, RpcEndpointRef slaveEndpoint) {
        this.logInfo((Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Trying to register BlockManager";
            }
        });
        this.tell(new BlockManagerMessages.RegisterBlockManager(blockManagerId, maxMemSize, slaveEndpoint));
        this.logInfo((Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Registered BlockManager";
            }
        });
    }

    public boolean updateBlockInfo(BlockManagerId blockManagerId, BlockId blockId, StorageLevel storageLevel, long memSize, long diskSize, long externalBlockStoreSize) {
        boolean res = BoxesRunTime.unboxToBoolean(this.driverEndpoint().askWithRetry(new BlockManagerMessages.UpdateBlockInfo(blockManagerId, blockId, storageLevel, memSize, diskSize, externalBlockStoreSize), ClassTag$.MODULE$.Boolean()));
        this.logDebug((Function0<String>)new Serializable(this, blockId){
            public static final long serialVersionUID = 0L;
            private final BlockId blockId$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Updated info of block ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.blockId$1}));
            }
            {
                this.blockId$1 = blockId$1;
            }
        });
        return res;
    }

    public Seq<BlockManagerId> getLocations(BlockId blockId) {
        return (Seq)this.driverEndpoint().askWithRetry(new BlockManagerMessages.GetLocations(blockId), ClassTag$.MODULE$.apply(Seq.class));
    }

    public IndexedSeq<Seq<BlockManagerId>> getLocations(BlockId[] blockIds) {
        return (IndexedSeq)this.driverEndpoint().askWithRetry(new BlockManagerMessages.GetLocationsMultipleBlockIds(blockIds), ClassTag$.MODULE$.apply(IndexedSeq.class));
    }

    public boolean contains(BlockId blockId) {
        return !this.getLocations(blockId).isEmpty();
    }

    public Seq<BlockManagerId> getPeers(BlockManagerId blockManagerId) {
        return (Seq)this.driverEndpoint().askWithRetry(new BlockManagerMessages.GetPeers(blockManagerId), ClassTag$.MODULE$.apply(Seq.class));
    }

    public Option<RpcEndpointRef> getExecutorEndpointRef(String executorId) {
        return (Option)this.driverEndpoint().askWithRetry(new BlockManagerMessages.GetExecutorEndpointRef(executorId), ClassTag$.MODULE$.apply(Option.class));
    }

    public void removeBlock(BlockId blockId) {
        this.driverEndpoint().askWithRetry(new BlockManagerMessages.RemoveBlock(blockId), ClassTag$.MODULE$.Boolean());
    }

    public void removeRdd(int rddId, boolean blocking) {
        Future future = (Future)this.driverEndpoint().askWithRetry(new BlockManagerMessages.RemoveRdd(rddId), ClassTag$.MODULE$.apply(Future.class));
        future.onFailure((PartialFunction)new Serializable(this, rddId){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ BlockManagerMaster $outer;
            public final int rddId$1;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (A1 instanceof Exception) {
                    Exception exception2 = (Exception)A1;
                    this.$outer.logWarning((Function0<String>)new Serializable(this, exception2){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anonfun$removeRdd$1 $outer;
                        private final Exception x2$1;

                        public final String apply() {
                            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to remove RDD ", " - ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.$outer.rddId$1), this.x2$1.getMessage()}));
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.x2$1 = x2$1;
                        }
                    }, exception2);
                    object = BoxedUnit.UNIT;
                } else {
                    object = function1.apply(x1);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(Throwable x1) {
                Throwable throwable = x1;
                boolean bl = throwable instanceof Exception;
                return bl;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.rddId$1 = rddId$1;
            }
        }, (ExecutionContext)ThreadUtils$.MODULE$.sameThread());
        if (blocking) {
            this.timeout().awaitResult(future);
        }
    }

    public void removeShuffle(int shuffleId, boolean blocking) {
        Future future = (Future)this.driverEndpoint().askWithRetry(new BlockManagerMessages.RemoveShuffle(shuffleId), ClassTag$.MODULE$.apply(Future.class));
        future.onFailure((PartialFunction)new Serializable(this, shuffleId){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ BlockManagerMaster $outer;
            public final int shuffleId$1;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x2;
                if (A1 instanceof Exception) {
                    Exception exception2 = (Exception)A1;
                    this.$outer.logWarning((Function0<String>)new Serializable(this, exception2){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anonfun$removeShuffle$1 $outer;
                        private final Exception x2$2;

                        public final String apply() {
                            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to remove shuffle ", " - ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.$outer.shuffleId$1), this.x2$2.getMessage()}));
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.x2$2 = x2$2;
                        }
                    }, exception2);
                    object = BoxedUnit.UNIT;
                } else {
                    object = function1.apply(x2);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(Throwable x2) {
                Throwable throwable = x2;
                boolean bl = throwable instanceof Exception;
                return bl;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.shuffleId$1 = shuffleId$1;
            }
        }, (ExecutionContext)ThreadUtils$.MODULE$.sameThread());
        if (blocking) {
            this.timeout().awaitResult(future);
        }
    }

    public void removeBroadcast(long broadcastId, boolean removeFromMaster, boolean blocking) {
        Future future = (Future)this.driverEndpoint().askWithRetry(new BlockManagerMessages.RemoveBroadcast(broadcastId, removeFromMaster), ClassTag$.MODULE$.apply(Future.class));
        future.onFailure((PartialFunction)new Serializable(this, broadcastId, removeFromMaster){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ BlockManagerMaster $outer;
            public final long broadcastId$1;
            public final boolean removeFromMaster$1;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x3, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x3;
                if (A1 instanceof Exception) {
                    Exception exception2 = (Exception)A1;
                    this.$outer.logWarning((Function0<String>)new Serializable(this, exception2){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anonfun$removeBroadcast$1 $outer;
                        private final Exception x2$3;

                        public final String apply() {
                            return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to remove broadcast ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.$outer.broadcastId$1)}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" with removeFromMaster = ", " - ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToBoolean((boolean)this.$outer.removeFromMaster$1), this.x2$3.getMessage()}))).toString();
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.x2$3 = x2$3;
                        }
                    }, exception2);
                    object = BoxedUnit.UNIT;
                } else {
                    object = function1.apply(x3);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(Throwable x3) {
                Throwable throwable = x3;
                boolean bl = throwable instanceof Exception;
                return bl;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.broadcastId$1 = broadcastId$1;
                this.removeFromMaster$1 = removeFromMaster$1;
            }
        }, (ExecutionContext)ThreadUtils$.MODULE$.sameThread());
        if (blocking) {
            this.timeout().awaitResult(future);
        }
    }

    public Map<BlockManagerId, Tuple2<Object, Object>> getMemoryStatus() {
        return (Map)this.driverEndpoint().askWithRetry(BlockManagerMessages$GetMemoryStatus$.MODULE$, ClassTag$.MODULE$.apply(Map.class));
    }

    public StorageStatus[] getStorageStatus() {
        return (StorageStatus[])this.driverEndpoint().askWithRetry(BlockManagerMessages$GetStorageStatus$.MODULE$, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(StorageStatus.class)));
    }

    public Map<BlockManagerId, BlockStatus> getBlockStatus(BlockId blockId, boolean askSlaves) {
        BlockManagerMessages.GetBlockStatus msg = new BlockManagerMessages.GetBlockStatus(blockId, askSlaves);
        Map response = (Map)this.driverEndpoint().askWithRetry(msg, ClassTag$.MODULE$.apply(Map.class));
        Tuple2 tuple2 = response.unzip((Function1)Predef$.MODULE$.$conforms());
        if (tuple2 != null) {
            Tuple2 tuple22;
            scala.collection.immutable.Iterable blockManagerIds = (scala.collection.immutable.Iterable)tuple2._1();
            scala.collection.immutable.Iterable futures = (scala.collection.immutable.Iterable)tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)blockManagerIds, (Object)futures);
            scala.collection.immutable.Iterable blockManagerIds2 = (scala.collection.immutable.Iterable)tuple23._1();
            scala.collection.immutable.Iterable futures2 = (scala.collection.immutable.Iterable)tuple23._2();
            ExecutionContextExecutor sameThread = ThreadUtils$.MODULE$.sameThread();
            CanBuildFrom cbf = (CanBuildFrom)Predef$.MODULE$.implicitly((Object)scala.collection.Iterable$.MODULE$.canBuildFrom());
            Iterable blockStatus2 = (Iterable)this.timeout().awaitResult(Future$.MODULE$.sequence((TraversableOnce)futures2, cbf, (ExecutionContext)ThreadUtils$.MODULE$.sameThread()));
            if (blockStatus2 == null) {
                throw new SparkException(new StringBuilder().append((Object)"BlockManager returned null for BlockStatus query: ").append((Object)blockId).toString());
            }
            return ((TraversableOnce)((TraversableLike)blockManagerIds2.zip((GenIterable)blockStatus2, Iterable$.MODULE$.canBuildFrom())).flatMap((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final Iterable<Tuple2<BlockManagerId, BlockStatus>> apply(Tuple2<BlockManagerId, Option<BlockStatus>> x0$1) {
                    Tuple2<BlockManagerId, Option<BlockStatus>> tuple2 = x0$1;
                    if (tuple2 != null) {
                        BlockManagerId blockManagerId = (BlockManagerId)tuple2._1();
                        Option status = (Option)tuple2._2();
                        Iterable iterable = Option$.MODULE$.option2Iterable(status.map((Function1)new Serializable(this, blockManagerId){
                            public static final long serialVersionUID = 0L;
                            private final BlockManagerId blockManagerId$1;

                            public final Tuple2<BlockManagerId, BlockStatus> apply(BlockStatus s) {
                                return new Tuple2((Object)this.blockManagerId$1, (Object)s);
                            }
                            {
                                this.blockManagerId$1 = blockManagerId$1;
                            }
                        }));
                        return iterable;
                    }
                    throw new MatchError(tuple2);
                }
            }, Iterable$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        }
        throw new MatchError((Object)tuple2);
    }

    public boolean getBlockStatus$default$2() {
        return true;
    }

    public Seq<BlockId> getMatchingBlockIds(Function1<BlockId, Object> filter2, boolean askSlaves) {
        BlockManagerMessages.GetMatchingBlockIds msg = new BlockManagerMessages.GetMatchingBlockIds(filter2, askSlaves);
        Future future = (Future)this.driverEndpoint().askWithRetry(msg, ClassTag$.MODULE$.apply(Future.class));
        return (Seq)this.timeout().awaitResult(future);
    }

    public boolean hasCachedBlocks(String executorId) {
        return BoxesRunTime.unboxToBoolean(this.driverEndpoint().askWithRetry(new BlockManagerMessages.HasCachedBlocks(executorId), ClassTag$.MODULE$.Boolean()));
    }

    public void stop() {
        if (this.driverEndpoint() != null && this.isDriver) {
            this.tell(BlockManagerMessages$StopBlockManagerMaster$.MODULE$);
            this.driverEndpoint_$eq(null);
            this.logInfo((Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "BlockManagerMaster stopped";
                }
            });
        }
    }

    private void tell(Object message) {
        if (BoxesRunTime.unboxToBoolean(this.driverEndpoint().askWithRetry(message, ClassTag$.MODULE$.Boolean()))) {
            return;
        }
        throw new SparkException("BlockManagerMasterEndpoint returned false, expected true.");
    }

    public BlockManagerMaster(RpcEndpointRef driverEndpoint, SparkConf conf, boolean isDriver) {
        this.driverEndpoint = driverEndpoint;
        this.isDriver = isDriver;
        Logging$class.$init$(this);
        this.timeout = RpcUtils$.MODULE$.askRpcTimeout(conf);
    }
}

