/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.storage;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.nio.channels.FileChannel;
import org.apache.spark.Logging;
import org.apache.spark.Logging$class;
import org.apache.spark.executor.ShuffleWriteMetrics;
import org.apache.spark.serializer.SerializationStream;
import org.apache.spark.serializer.SerializerInstance;
import org.apache.spark.storage.BlockId;
import org.apache.spark.storage.DiskBlockObjectWriter$;
import org.apache.spark.storage.FileSegment;
import org.apache.spark.storage.TimeTrackingOutputStream;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Serializable;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.TraitSetter;

@ScalaSignature(bytes="\u0006\u0001\tub!B\u0001\u0003\u0001\u0011Q!!\u0006#jg.\u0014En\\2l\u001f\nTWm\u0019;Xe&$XM\u001d\u0006\u0003\u0007\u0011\tqa\u001d;pe\u0006<WM\u0003\u0002\u0006\r\u0005)1\u000f]1sW*\u0011q\u0001C\u0001\u0007CB\f7\r[3\u000b\u0003%\t1a\u001c:h'\r\u00011b\u0005\t\u0003\u0019Ei\u0011!\u0004\u0006\u0003\u001d=\t!![8\u000b\u0003A\tAA[1wC&\u0011!#\u0004\u0002\r\u001fV$\b/\u001e;TiJ,\u0017-\u001c\t\u0003)Ui\u0011\u0001B\u0005\u0003-\u0011\u0011q\u0001T8hO&tw\r\u0003\u0005\u0019\u0001\t\u0015\r\u0011\"\u0001\u001b\u0003\u00111\u0017\u000e\\3\u0004\u0001U\t1\u0004\u0005\u0002\r9%\u0011Q$\u0004\u0002\u0005\r&dW\r\u0003\u0005 \u0001\t\u0005\t\u0015!\u0003\u001c\u0003\u00151\u0017\u000e\\3!\u0011!\t\u0003A!A!\u0002\u0013\u0011\u0013AE:fe&\fG.\u001b>fe&s7\u000f^1oG\u0016\u0004\"a\t\u0014\u000e\u0003\u0011R!!\n\u0003\u0002\u0015M,'/[1mSj,'/\u0003\u0002(I\t\u00112+\u001a:jC2L'0\u001a:J]N$\u0018M\\2f\u0011!I\u0003A!A!\u0002\u0013Q\u0013A\u00032vM\u001a,'oU5{KB\u00111FL\u0007\u0002Y)\tQ&A\u0003tG\u0006d\u0017-\u0003\u00020Y\t\u0019\u0011J\u001c;\t\u0011E\u0002!\u0011!Q\u0001\nI\nabY8naJ,7o]*ue\u0016\fW\u000e\u0005\u0003,g-Y\u0011B\u0001\u001b-\u0005%1UO\\2uS>t\u0017\u0007\u0003\u00057\u0001\t\u0005\t\u0015!\u00038\u0003)\u0019\u0018P\\2Xe&$Xm\u001d\t\u0003WaJ!!\u000f\u0017\u0003\u000f\t{w\u000e\\3b]\"A1\b\u0001B\u0001B\u0003%A(\u0001\u0007xe&$X-T3ue&\u001c7\u000f\u0005\u0002>\u00016\taH\u0003\u0002@\t\u0005AQ\r_3dkR|'/\u0003\u0002B}\t\u00192\u000b[;gM2,wK]5uK6+GO]5dg\"A1\t\u0001BC\u0002\u0013\u0005A)A\u0004cY>\u001c7.\u00133\u0016\u0003\u0015\u0003\"AR$\u000e\u0003\tI!\u0001\u0013\u0002\u0003\u000f\tcwnY6JI\"A!\n\u0001B\u0001B\u0003%Q)\u0001\u0005cY>\u001c7.\u00133!\u0011\u0015a\u0005\u0001\"\u0001N\u0003\u0019a\u0014N\\5u}QAaj\u0014)R%N#V\u000b\u0005\u0002G\u0001!)\u0001d\u0013a\u00017!)\u0011e\u0013a\u0001E!)\u0011f\u0013a\u0001U!)\u0011g\u0013a\u0001e!)ag\u0013a\u0001o!)1h\u0013a\u0001y!91i\u0013I\u0001\u0002\u0004)\u0005bB,\u0001\u0001\u0004%I\u0001W\u0001\bG\"\fgN\\3m+\u0005I\u0006C\u0001.`\u001b\u0005Y&B\u0001/^\u0003!\u0019\u0007.\u00198oK2\u001c(B\u00010\u0010\u0003\rq\u0017n\\\u0005\u0003An\u00131BR5mK\u000eC\u0017M\u001c8fY\"9!\r\u0001a\u0001\n\u0013\u0019\u0017aC2iC:tW\r\\0%KF$\"\u0001Z4\u0011\u0005-*\u0017B\u00014-\u0005\u0011)f.\u001b;\t\u000f!\f\u0017\u0011!a\u00013\u0006\u0019\u0001\u0010J\u0019\t\r)\u0004\u0001\u0015)\u0003Z\u0003!\u0019\u0007.\u00198oK2\u0004\u0003b\u00027\u0001\u0001\u0004%I!\\\u0001\u0003EN,\u0012a\u0003\u0005\b_\u0002\u0001\r\u0011\"\u0003q\u0003\u0019\u00117o\u0018\u0013fcR\u0011A-\u001d\u0005\bQ:\f\t\u00111\u0001\f\u0011\u0019\u0019\b\u0001)Q\u0005\u0017\u0005\u0019!m\u001d\u0011\t\u000fU\u0004\u0001\u0019!C\u0005m\u0006\u0019am\\:\u0016\u0003]\u0004\"\u0001\u0004=\n\u0005el!\u0001\u0005$jY\u0016|U\u000f\u001e9viN#(/Z1n\u0011\u001dY\b\u00011A\u0005\nq\fqAZ8t?\u0012*\u0017\u000f\u0006\u0002e{\"9\u0001N_A\u0001\u0002\u00049\bBB@\u0001A\u0003&q/\u0001\u0003g_N\u0004\u0003\"CA\u0002\u0001\u0001\u0007I\u0011BA\u0003\u0003\t!8/\u0006\u0002\u0002\bA\u0019a)!\u0003\n\u0007\u0005-!A\u0001\rUS6,GK]1dW&twmT;uaV$8\u000b\u001e:fC6D\u0011\"a\u0004\u0001\u0001\u0004%I!!\u0005\u0002\rQ\u001cx\fJ3r)\r!\u00171\u0003\u0005\nQ\u00065\u0011\u0011!a\u0001\u0003\u000fA\u0001\"a\u0006\u0001A\u0003&\u0011qA\u0001\u0004iN\u0004\u0003\"CA\u000e\u0001\u0001\u0007I\u0011BA\u000f\u0003\u0019y'M[(viV\u0011\u0011q\u0004\t\u0004G\u0005\u0005\u0012bAA\u0012I\t\u00192+\u001a:jC2L'0\u0019;j_:\u001cFO]3b[\"I\u0011q\u0005\u0001A\u0002\u0013%\u0011\u0011F\u0001\u000b_\nTw*\u001e;`I\u0015\fHc\u00013\u0002,!I\u0001.!\n\u0002\u0002\u0003\u0007\u0011q\u0004\u0005\t\u0003_\u0001\u0001\u0015)\u0003\u0002 \u00059qN\u00196PkR\u0004\u0003\"CA\u001a\u0001\u0001\u0007I\u0011BA\u001b\u0003-Ig.\u001b;jC2L'0\u001a3\u0016\u0003]B\u0011\"!\u000f\u0001\u0001\u0004%I!a\u000f\u0002\u001f%t\u0017\u000e^5bY&TX\rZ0%KF$2\u0001ZA\u001f\u0011!A\u0017qGA\u0001\u0002\u00049\u0004bBA!\u0001\u0001\u0006KaN\u0001\rS:LG/[1mSj,G\r\t\u0005\n\u0003\u000b\u0002\u0001\u0019!C\u0005\u0003k\tQ\u0002[1t\u0005\u0016,gn\u00117pg\u0016$\u0007\"CA%\u0001\u0001\u0007I\u0011BA&\u0003EA\u0017m\u001d\"fK:\u001cEn\\:fI~#S-\u001d\u000b\u0004I\u00065\u0003\u0002\u00035\u0002H\u0005\u0005\t\u0019A\u001c\t\u000f\u0005E\u0003\u0001)Q\u0005o\u0005q\u0001.Y:CK\u0016t7\t\\8tK\u0012\u0004\u0003\"CA+\u0001\u0001\u0007I\u0011BA\u001b\u0003m\u0019w.\\7ji\u0006sGm\u00117pg\u0016D\u0015m\u001d\"fK:\u001c\u0015\r\u001c7fI\"I\u0011\u0011\f\u0001A\u0002\u0013%\u00111L\u0001 G>lW.\u001b;B]\u0012\u001cEn\\:f\u0011\u0006\u001c()Z3o\u0007\u0006dG.\u001a3`I\u0015\fHc\u00013\u0002^!A\u0001.a\u0016\u0002\u0002\u0003\u0007q\u0007C\u0004\u0002b\u0001\u0001\u000b\u0015B\u001c\u00029\r|W.\\5u\u0003:$7\t\\8tK\"\u000b7OQ3f]\u000e\u000bG\u000e\\3eA!I\u0011Q\r\u0001C\u0002\u0013%\u0011qM\u0001\u0010S:LG/[1m!>\u001c\u0018\u000e^5p]V\u0011\u0011\u0011\u000e\t\u0004W\u0005-\u0014bAA7Y\t!Aj\u001c8h\u0011!\t\t\b\u0001Q\u0001\n\u0005%\u0014\u0001E5oSRL\u0017\r\u001c)pg&$\u0018n\u001c8!\u0011%\t)\b\u0001a\u0001\n\u0013\t9'A\u0007gS:\fG\u000eU8tSRLwN\u001c\u0005\n\u0003s\u0002\u0001\u0019!C\u0005\u0003w\n\u0011CZ5oC2\u0004vn]5uS>tw\fJ3r)\r!\u0017Q\u0010\u0005\nQ\u0006]\u0014\u0011!a\u0001\u0003SB\u0001\"!!\u0001A\u0003&\u0011\u0011N\u0001\u000fM&t\u0017\r\u001c)pg&$\u0018n\u001c8!\u0011%\t)\t\u0001a\u0001\n\u0013\t9'\u0001\tsKB|'\u000f^3e!>\u001c\u0018\u000e^5p]\"I\u0011\u0011\u0012\u0001A\u0002\u0013%\u00111R\u0001\u0015e\u0016\u0004xN\u001d;fIB{7/\u001b;j_:|F%Z9\u0015\u0007\u0011\fi\tC\u0005i\u0003\u000f\u000b\t\u00111\u0001\u0002j!A\u0011\u0011\u0013\u0001!B\u0013\tI'A\tsKB|'\u000f^3e!>\u001c\u0018\u000e^5p]\u0002B\u0011\"!&\u0001\u0001\u0004%I!a&\u0002#9,XNU3d_J$7o\u0016:jiR,g.F\u0001+\u0011%\tY\n\u0001a\u0001\n\u0013\ti*A\u000bok6\u0014VmY8sIN<&/\u001b;uK:|F%Z9\u0015\u0007\u0011\fy\n\u0003\u0005i\u00033\u000b\t\u00111\u0001+\u0011\u001d\t\u0019\u000b\u0001Q!\n)\n!C\\;n%\u0016\u001cwN\u001d3t/JLG\u000f^3oA!9\u0011q\u0015\u0001\u0005\u0002\u0005%\u0016\u0001B8qK:$\u0012A\u0014\u0005\b\u0003[\u0003A\u0011IAX\u0003\u0015\u0019Gn\\:f)\u0005!\u0007bBAZ\u0001\u0011\u0005\u0011QG\u0001\u0007SN|\u0005/\u001a8\t\u000f\u0005]\u0006\u0001\"\u0001\u00020\u0006q1m\\7nSR\fe\u000eZ\"m_N,\u0007bBA^\u0001\u0011\u0005\u0011QX\u0001\u001ce\u00164XM\u001d;QCJ$\u0018.\u00197Xe&$Xm]!oI\u000ecwn]3\u0015\u0003mAq!!1\u0001\t\u0003\t\u0019-A\u0003xe&$X\rF\u0003e\u0003\u000b\fy\r\u0003\u0005\u0002H\u0006}\u0006\u0019AAe\u0003\rYW-\u001f\t\u0004W\u0005-\u0017bAAgY\t\u0019\u0011I\\=\t\u0011\u0005E\u0017q\u0018a\u0001\u0003\u0013\fQA^1mk\u0016Dq!!1\u0001\t\u0003\n)\u000eF\u0002e\u0003/Dq!!7\u0002T\u0002\u0007!&A\u0001c\u0011\u001d\t\t\r\u0001C!\u0003;$r\u0001ZAp\u0003_\f\u0019\u0010\u0003\u0005\u0002b\u0006m\u0007\u0019AAr\u0003\u001dYgOQ=uKN\u0004RaKAs\u0003SL1!a:-\u0005\u0015\t%O]1z!\rY\u00131^\u0005\u0004\u0003[d#\u0001\u0002\"zi\u0016Dq!!=\u0002\\\u0002\u0007!&\u0001\u0003pM\u001a\u001c\bbBA{\u00037\u0004\rAK\u0001\u0004Y\u0016t\u0007bBA}\u0001\u0011\u0005\u0011qV\u0001\u000ee\u0016\u001cwN\u001d3Xe&$H/\u001a8\t\u000f\u0005u\b\u0001\"\u0001\u0002\u0000\u0006Ya-\u001b7f'\u0016<W.\u001a8u)\t\u0011\t\u0001E\u0002G\u0005\u0007I1A!\u0002\u0003\u0005-1\u0015\u000e\\3TK\u001elWM\u001c;\t\u000f\t%\u0001\u0001\"\u0003\u00020\u0006\u0011R\u000f\u001d3bi\u0016\u0014\u0015\u0010^3t/JLG\u000f^3o\u0011!\u0011i\u0001\u0001C!\t\u0005=\u0016!\u00024mkNDwA\u0003B\t\u0005\u0005\u0005\t\u0012\u0001\u0003\u0003\u0014\u0005)B)[:l\u00052|7m[(cU\u0016\u001cGo\u0016:ji\u0016\u0014\bc\u0001$\u0003\u0016\u0019I\u0011AAA\u0001\u0012\u0003!!qC\n\u0005\u0005+\u0011I\u0002E\u0002,\u00057I1A!\b-\u0005\u0019\te.\u001f*fM\"9AJ!\u0006\u0005\u0002\t\u0005BC\u0001B\n\u0011)\u0011)C!\u0006\u0012\u0002\u0013\u0005!qE\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000fJ\u001c\u0016\u0005\t%\"fA#\u0003,-\u0012!Q\u0006\t\u0005\u0005_\u0011I$\u0004\u0002\u00032)!!1\u0007B\u001b\u0003%)hn\u00195fG.,GMC\u0002\u000381\n!\"\u00198o_R\fG/[8o\u0013\u0011\u0011YD!\r\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW\r")
public class DiskBlockObjectWriter
extends OutputStream
implements Logging {
    private final File file;
    private final SerializerInstance serializerInstance;
    private final int bufferSize;
    private final Function1<OutputStream, OutputStream> compressStream;
    public final boolean org$apache$spark$storage$DiskBlockObjectWriter$$syncWrites;
    public final ShuffleWriteMetrics org$apache$spark$storage$DiskBlockObjectWriter$$writeMetrics;
    private final BlockId blockId;
    private FileChannel channel;
    private OutputStream bs;
    private FileOutputStream org$apache$spark$storage$DiskBlockObjectWriter$$fos;
    private TimeTrackingOutputStream ts;
    private SerializationStream org$apache$spark$storage$DiskBlockObjectWriter$$objOut;
    private boolean initialized;
    private boolean hasBeenClosed;
    private boolean commitAndCloseHasBeenCalled;
    private final long initialPosition;
    private long finalPosition;
    private long reportedPosition;
    private int numRecordsWritten;
    private transient Logger org$apache$spark$Logging$$log_;

    public static BlockId $lessinit$greater$default$7() {
        return DiskBlockObjectWriter$.MODULE$.$lessinit$greater$default$7();
    }

    @Override
    public Logger org$apache$spark$Logging$$log_() {
        return this.org$apache$spark$Logging$$log_;
    }

    @Override
    @TraitSetter
    public void org$apache$spark$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$Logging$$log_ = x$1;
    }

    @Override
    public String logName() {
        return Logging$class.logName(this);
    }

    @Override
    public Logger log() {
        return Logging$class.log(this);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logging$class.logInfo(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logging$class.logDebug(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logging$class.logTrace(this, msg);
    }

    @Override
    public void logWarning(Function0<String> msg) {
        Logging$class.logWarning(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logging$class.logError(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging$class.logInfo(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging$class.logDebug(this, msg, throwable);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging$class.logTrace(this, msg, throwable);
    }

    @Override
    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging$class.logWarning(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logging$class.logError(this, msg, throwable);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging$class.isTraceEnabled(this);
    }

    public File file() {
        return this.file;
    }

    public BlockId blockId() {
        return this.blockId;
    }

    private FileChannel channel() {
        return this.channel;
    }

    private void channel_$eq(FileChannel x$1) {
        this.channel = x$1;
    }

    private OutputStream bs() {
        return this.bs;
    }

    private void bs_$eq(OutputStream x$1) {
        this.bs = x$1;
    }

    public FileOutputStream org$apache$spark$storage$DiskBlockObjectWriter$$fos() {
        return this.org$apache$spark$storage$DiskBlockObjectWriter$$fos;
    }

    private void org$apache$spark$storage$DiskBlockObjectWriter$$fos_$eq(FileOutputStream x$1) {
        this.org$apache$spark$storage$DiskBlockObjectWriter$$fos = x$1;
    }

    private TimeTrackingOutputStream ts() {
        return this.ts;
    }

    private void ts_$eq(TimeTrackingOutputStream x$1) {
        this.ts = x$1;
    }

    public SerializationStream org$apache$spark$storage$DiskBlockObjectWriter$$objOut() {
        return this.org$apache$spark$storage$DiskBlockObjectWriter$$objOut;
    }

    private void org$apache$spark$storage$DiskBlockObjectWriter$$objOut_$eq(SerializationStream x$1) {
        this.org$apache$spark$storage$DiskBlockObjectWriter$$objOut = x$1;
    }

    private boolean initialized() {
        return this.initialized;
    }

    private void initialized_$eq(boolean x$1) {
        this.initialized = x$1;
    }

    private boolean hasBeenClosed() {
        return this.hasBeenClosed;
    }

    private void hasBeenClosed_$eq(boolean x$1) {
        this.hasBeenClosed = x$1;
    }

    private boolean commitAndCloseHasBeenCalled() {
        return this.commitAndCloseHasBeenCalled;
    }

    private void commitAndCloseHasBeenCalled_$eq(boolean x$1) {
        this.commitAndCloseHasBeenCalled = x$1;
    }

    private long initialPosition() {
        return this.initialPosition;
    }

    private long finalPosition() {
        return this.finalPosition;
    }

    private void finalPosition_$eq(long x$1) {
        this.finalPosition = x$1;
    }

    private long reportedPosition() {
        return this.reportedPosition;
    }

    private void reportedPosition_$eq(long x$1) {
        this.reportedPosition = x$1;
    }

    private int numRecordsWritten() {
        return this.numRecordsWritten;
    }

    private void numRecordsWritten_$eq(int x$1) {
        this.numRecordsWritten = x$1;
    }

    public DiskBlockObjectWriter open() {
        if (this.hasBeenClosed()) {
            throw new IllegalStateException("Writer already closed. Cannot be reopened.");
        }
        this.org$apache$spark$storage$DiskBlockObjectWriter$$fos_$eq(new FileOutputStream(this.file(), true));
        this.ts_$eq(new TimeTrackingOutputStream(this.org$apache$spark$storage$DiskBlockObjectWriter$$writeMetrics, this.org$apache$spark$storage$DiskBlockObjectWriter$$fos()));
        this.channel_$eq(this.org$apache$spark$storage$DiskBlockObjectWriter$$fos().getChannel());
        this.bs_$eq((OutputStream)this.compressStream.apply((Object)new BufferedOutputStream(this.ts(), this.bufferSize)));
        this.org$apache$spark$storage$DiskBlockObjectWriter$$objOut_$eq(this.serializerInstance.serializeStream(this.bs()));
        this.initialized_$eq(true);
        return this;
    }

    @Override
    public void close() {
        if (this.initialized()) {
            Utils$.MODULE$.tryWithSafeFinally(new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ DiskBlockObjectWriter $outer;

                public final void apply() {
                    this.apply$mcV$sp();
                }

                public void apply$mcV$sp() {
                    if (this.$outer.org$apache$spark$storage$DiskBlockObjectWriter$$syncWrites) {
                        this.$outer.org$apache$spark$storage$DiskBlockObjectWriter$$objOut().flush();
                        long start2 = System.nanoTime();
                        this.$outer.org$apache$spark$storage$DiskBlockObjectWriter$$fos().getFD().sync();
                        this.$outer.org$apache$spark$storage$DiskBlockObjectWriter$$writeMetrics.incShuffleWriteTime(System.nanoTime() - start2);
                    }
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            }, (Function0<BoxedUnit>)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ DiskBlockObjectWriter $outer;

                public final void apply() {
                    this.apply$mcV$sp();
                }

                public void apply$mcV$sp() {
                    this.$outer.org$apache$spark$storage$DiskBlockObjectWriter$$objOut().close();
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            });
            this.channel_$eq(null);
            this.bs_$eq(null);
            this.org$apache$spark$storage$DiskBlockObjectWriter$$fos_$eq(null);
            this.ts_$eq(null);
            this.org$apache$spark$storage$DiskBlockObjectWriter$$objOut_$eq(null);
            this.initialized_$eq(false);
            this.hasBeenClosed_$eq(true);
        }
    }

    public boolean isOpen() {
        return this.org$apache$spark$storage$DiskBlockObjectWriter$$objOut() != null;
    }

    public void commitAndClose() {
        if (this.initialized()) {
            this.org$apache$spark$storage$DiskBlockObjectWriter$$objOut().flush();
            this.bs().flush();
            this.close();
            this.finalPosition_$eq(this.file().length());
            this.org$apache$spark$storage$DiskBlockObjectWriter$$writeMetrics.incShuffleBytesWritten(this.finalPosition() - this.reportedPosition());
        } else {
            this.finalPosition_$eq(this.file().length());
        }
        this.commitAndCloseHasBeenCalled_$eq(true);
    }

    /*
     * WARNING - void declaration
     */
    public File revertPartialWritesAndClose() {
        File file;
        try {
            if (this.initialized()) {
                this.org$apache$spark$storage$DiskBlockObjectWriter$$writeMetrics.decShuffleBytesWritten(this.reportedPosition() - this.initialPosition());
                this.org$apache$spark$storage$DiskBlockObjectWriter$$writeMetrics.decShuffleRecordsWritten(this.numRecordsWritten());
                this.org$apache$spark$storage$DiskBlockObjectWriter$$objOut().flush();
                this.bs().flush();
                this.close();
            }
            FileOutputStream truncateStream = new FileOutputStream(this.file(), true);
            try {
                truncateStream.getChannel().truncate(this.initialPosition());
                file = this.file();
            }
            catch (Throwable throwable) {
                void var1_1;
                var1_1.close();
                throw throwable;
            }
            truncateStream.close();
        }
        catch (Exception exception2) {
            this.logError((Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ DiskBlockObjectWriter $outer;

                public final String apply() {
                    return new StringBuilder().append((Object)"Uncaught exception while reverting partial writes to file ").append((Object)this.$outer.file()).toString();
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            }, exception2);
            file = this.file();
        }
        return file;
    }

    public void write(Object key, Object value) {
        Object object = this.initialized() ? BoxedUnit.UNIT : this.open();
        this.org$apache$spark$storage$DiskBlockObjectWriter$$objOut().writeKey(key, ClassTag$.MODULE$.Any());
        this.org$apache$spark$storage$DiskBlockObjectWriter$$objOut().writeValue(value, ClassTag$.MODULE$.Any());
        this.recordWritten();
    }

    @Override
    public void write(int b) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void write(byte[] kvBytes, int offs, int len) {
        Object object = this.initialized() ? BoxedUnit.UNIT : this.open();
        this.bs().write(kvBytes, offs, len);
    }

    public void recordWritten() {
        this.numRecordsWritten_$eq(this.numRecordsWritten() + 1);
        this.org$apache$spark$storage$DiskBlockObjectWriter$$writeMetrics.incShuffleRecordsWritten(1L);
        if (this.numRecordsWritten() % 32 == 0) {
            this.updateBytesWritten();
        }
    }

    public FileSegment fileSegment() {
        if (this.commitAndCloseHasBeenCalled()) {
            return new FileSegment(this.file(), this.initialPosition(), this.finalPosition() - this.initialPosition());
        }
        throw new IllegalStateException("fileSegment() is only valid after commitAndClose() has been called");
    }

    private void updateBytesWritten() {
        long pos = this.channel().position();
        this.org$apache$spark$storage$DiskBlockObjectWriter$$writeMetrics.incShuffleBytesWritten(pos - this.reportedPosition());
        this.reportedPosition_$eq(pos);
    }

    @Override
    public void flush() {
        this.org$apache$spark$storage$DiskBlockObjectWriter$$objOut().flush();
        this.bs().flush();
    }

    public DiskBlockObjectWriter(File file, SerializerInstance serializerInstance, int bufferSize, Function1<OutputStream, OutputStream> compressStream, boolean syncWrites, ShuffleWriteMetrics writeMetrics, BlockId blockId) {
        this.file = file;
        this.serializerInstance = serializerInstance;
        this.bufferSize = bufferSize;
        this.compressStream = compressStream;
        this.org$apache$spark$storage$DiskBlockObjectWriter$$syncWrites = syncWrites;
        this.org$apache$spark$storage$DiskBlockObjectWriter$$writeMetrics = writeMetrics;
        this.blockId = blockId;
        Logging$class.$init$(this);
        this.channel = null;
        this.bs = null;
        this.org$apache$spark$storage$DiskBlockObjectWriter$$fos = null;
        this.ts = null;
        this.org$apache$spark$storage$DiskBlockObjectWriter$$objOut = null;
        this.initialized = false;
        this.hasBeenClosed = false;
        this.commitAndCloseHasBeenCalled = false;
        this.initialPosition = file.length();
        this.finalPosition = -1L;
        this.reportedPosition = this.initialPosition();
        this.numRecordsWritten = 0;
    }
}

