/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.storage;

import org.apache.spark.annotation.DeveloperApi;
import org.apache.spark.storage.BlockId;
import org.apache.spark.storage.BlockManagerId;
import org.apache.spark.storage.BlockStatus;
import org.apache.spark.storage.BlockStatus$;
import org.apache.spark.storage.RDDBlockId;
import org.apache.spark.storage.StorageLevel;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.Tuple3;
import scala.Tuple4;
import scala.collection.Iterable$;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.MapLike;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashMap$;
import scala.math.Numeric;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;

@DeveloperApi
@ScalaSignature(bytes="\u0006\u0001\u0005-e\u0001B\u0001\u0003\u0001-\u0011Qb\u0015;pe\u0006<Wm\u0015;biV\u001c(BA\u0002\u0005\u0003\u001d\u0019Ho\u001c:bO\u0016T!!\u0002\u0004\u0002\u000bM\u0004\u0018M]6\u000b\u0005\u001dA\u0011AB1qC\u000eDWMC\u0001\n\u0003\ry'oZ\u0002\u0001'\t\u0001A\u0002\u0005\u0002\u000e!5\taBC\u0001\u0010\u0003\u0015\u00198-\u00197b\u0013\t\tbB\u0001\u0004B]f\u0014VM\u001a\u0005\t'\u0001\u0011)\u0019!C\u0001)\u0005q!\r\\8dW6\u000bg.Y4fe&#W#A\u000b\u0011\u0005Y9R\"\u0001\u0002\n\u0005a\u0011!A\u0004\"m_\u000e\\W*\u00198bO\u0016\u0014\u0018\n\u001a\u0005\t5\u0001\u0011\t\u0011)A\u0005+\u0005y!\r\\8dW6\u000bg.Y4fe&#\u0007\u0005\u0003\u0005\u001d\u0001\t\u0015\r\u0011\"\u0001\u001e\u0003\u0019i\u0017\r_'f[V\ta\u0004\u0005\u0002\u000e?%\u0011\u0001E\u0004\u0002\u0005\u0019>tw\r\u0003\u0005#\u0001\t\u0005\t\u0015!\u0003\u001f\u0003\u001di\u0017\r_'f[\u0002BQ\u0001\n\u0001\u0005\u0002\u0015\na\u0001P5oSRtDc\u0001\u0014(QA\u0011a\u0003\u0001\u0005\u0006'\r\u0002\r!\u0006\u0005\u00069\r\u0002\rA\b\u0005\bU\u0001\u0011\r\u0011\"\u0003,\u0003)y&\u000f\u001a3CY>\u001c7n]\u000b\u0002YA!QF\r\u001b8\u001b\u0005q#BA\u00181\u0003\u001diW\u000f^1cY\u0016T!!\r\b\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u00024]\t9\u0001*Y:i\u001b\u0006\u0004\bCA\u00076\u0013\t1dBA\u0002J]R\u0004B!\f\u001d;{%\u0011\u0011H\f\u0002\u0004\u001b\u0006\u0004\bC\u0001\f<\u0013\ta$AA\u0004CY>\u001c7.\u00133\u0011\u0005Yq\u0014BA \u0003\u0005-\u0011En\\2l'R\fG/^:\t\r\u0005\u0003\u0001\u0015!\u0003-\u0003-y&\u000f\u001a3CY>\u001c7n\u001d\u0011\t\u000f\r\u0003!\u0019!C\u0005\t\u0006iqL\\8o%\u0012$'\t\\8dWN,\u0012!\u0012\t\u0005[IRT\b\u0003\u0004H\u0001\u0001\u0006I!R\u0001\u000f?:|gN\u00153e\u00052|7m[:!\u0011\u001dI\u0005A1A\u0005\n)\u000bqb\u0018:eIN#xN]1hK&sgm\\\u000b\u0002\u0017B!QF\r\u001bM!\u0019iQJ\b\u0010\u001f\u001f&\u0011aJ\u0004\u0002\u0007)V\u0004H.\u001a\u001b\u0011\u0005Y\u0001\u0016BA)\u0003\u00051\u0019Fo\u001c:bO\u0016dUM^3m\u0011\u0019\u0019\u0006\u0001)A\u0005\u0017\u0006\u0001rL\u001d3e'R|'/Y4f\u0013:4w\u000e\t\u0005\b+\u0002\u0001\r\u0011\"\u0003W\u0003Iyfn\u001c8SI\u0012\u001cFo\u001c:bO\u0016LeNZ8\u0016\u0003]\u0003R!\u0004-\u001f=yI!!\u0017\b\u0003\rQ+\b\u000f\\34\u0011\u001dY\u0006\u00011A\u0005\nq\u000bac\u00188p]J#Gm\u0015;pe\u0006<W-\u00138g_~#S-\u001d\u000b\u0003;\u0002\u0004\"!\u00040\n\u0005}s!\u0001B+oSRDq!\u0019.\u0002\u0002\u0003\u0007q+A\u0002yIEBaa\u0019\u0001!B\u00139\u0016aE0o_:\u0014F\rZ*u_J\fw-Z%oM>\u0004\u0003\"\u0002\u0013\u0001\t\u0003)G\u0003\u0002\u0014gQ&DQa\u001a3A\u0002U\tAAY7jI\")A\u0004\u001aa\u0001=!)!\u000e\u001aa\u0001W\u0006i\u0011N\\5uS\u0006d'\t\\8dWN\u0004B\u0001\\7;{5\t\u0001'\u0003\u0002:a!)q\u000e\u0001C\u0001a\u00061!\r\\8dWN,\u0012a\u001b\u0005\u0006e\u0002!\t\u0001]\u0001\ne\u0012$'\t\\8dWNDQ\u0001\u001e\u0001\u0005\u0002U\fQB\u001d3e\u00052|7m[:Cs&#GCA6w\u0011\u001598\u000f1\u00015\u0003\u0015\u0011H\rZ%e\u0011\u0019I\b\u0001\"\u0001\u0005u\u0006A\u0011\r\u001a3CY>\u001c7\u000eF\u0002^wvDQ\u0001 =A\u0002i\nqA\u00197pG.LE\rC\u0003\u007fq\u0002\u0007Q(A\u0006cY>\u001c7n\u0015;biV\u001c\b\u0002CA\u0001\u0001\u0011\u0005A!a\u0001\u0002\u0017U\u0004H-\u0019;f\u00052|7m\u001b\u000b\u0006;\u0006\u0015\u0011q\u0001\u0005\u0006y~\u0004\rA\u000f\u0005\u0006}~\u0004\r!\u0010\u0005\t\u0003\u0017\u0001A\u0011\u0001\u0003\u0002\u000e\u0005Y!/Z7pm\u0016\u0014En\\2l)\u0011\ty!!\u0006\u0011\t5\t\t\"P\u0005\u0004\u0003'q!AB(qi&|g\u000e\u0003\u0004}\u0003\u0013\u0001\rA\u000f\u0005\b\u00033\u0001A\u0011AA\u000e\u00035\u0019wN\u001c;bS:\u001c(\t\\8dWR!\u0011QDA\u0012!\ri\u0011qD\u0005\u0004\u0003Cq!a\u0002\"p_2,\u0017M\u001c\u0005\u0007y\u0006]\u0001\u0019\u0001\u001e\t\u000f\u0005\u001d\u0002\u0001\"\u0001\u0002*\u0005Aq-\u001a;CY>\u001c7\u000e\u0006\u0003\u0002\u0010\u0005-\u0002B\u0002?\u0002&\u0001\u0007!\bC\u0004\u00020\u0001!\t!!\r\u0002\u00139,XN\u00117pG.\u001cX#\u0001\u001b\t\u000f\u0005U\u0002\u0001\"\u0001\u00022\u0005aa.^7SI\u0012\u0014En\\2lg\"9\u0011\u0011\b\u0001\u0005\u0002\u0005m\u0012\u0001\u00058v[J#GM\u00117pG.\u001c()_%e)\r!\u0014Q\b\u0005\u0007o\u0006]\u0002\u0019\u0001\u001b\t\r\u0005\u0005\u0003\u0001\"\u0001\u001e\u00031iW-\u001c*f[\u0006Lg.\u001b8h\u0011\u0019\t)\u0005\u0001C\u0001;\u00059Q.Z7Vg\u0016$\u0007BBA%\u0001\u0011\u0005Q$\u0001\u0005eSN\\Wk]3e\u0011\u0019\ti\u0005\u0001C\u0001;\u0005YqN\u001a4IK\u0006\u0004Xk]3e\u0011\u001d\t\t\u0006\u0001C\u0001\u0003'\nA\"\\3n+N,GMQ=SI\u0012$2AHA+\u0011\u00199\u0018q\na\u0001i!9\u0011\u0011\f\u0001\u0005\u0002\u0005m\u0013!\u00043jg.,6/\u001a3CsJ#G\rF\u0002\u001f\u0003;Baa^A,\u0001\u0004!\u0004bBA1\u0001\u0011\u0005\u00111M\u0001\u0011_\u001a4\u0007*Z1q+N,GMQ=SI\u0012$2AHA3\u0011\u00199\u0018q\fa\u0001i!9\u0011\u0011\u000e\u0001\u0005\u0002\u0005-\u0014a\u0004:eIN#xN]1hK2+g/\u001a7\u0015\t\u00055\u0014q\u000e\t\u0005\u001b\u0005Eq\n\u0003\u0004x\u0003O\u0002\r\u0001\u000e\u0005\b\u0003g\u0002A\u0011BA;\u0003E)\b\u000fZ1uKN#xN]1hK&sgm\u001c\u000b\u0006;\u0006]\u0014\u0011\u0010\u0005\u0007y\u0006E\u0004\u0019\u0001\u001e\t\u000f\u0005m\u0014\u0011\u000fa\u0001{\u0005qa.Z<CY>\u001c7n\u0015;biV\u001c\bf\u0001\u0001\u0002\u0000A!\u0011\u0011QAD\u001b\t\t\u0019IC\u0002\u0002\u0006\u0012\t!\"\u00198o_R\fG/[8o\u0013\u0011\tI)a!\u0003\u0019\u0011+g/\u001a7pa\u0016\u0014\u0018\t]5")
public class StorageStatus {
    private final BlockManagerId blockManagerId;
    private final long maxMem;
    private final HashMap<Object, scala.collection.mutable.Map<BlockId, BlockStatus>> _rddBlocks;
    private final HashMap<BlockId, BlockStatus> _nonRddBlocks;
    private final HashMap<Object, Tuple4<Object, Object, Object, StorageLevel>> _rddStorageInfo;
    private Tuple3<Object, Object, Object> _nonRddStorageInfo;

    public BlockManagerId blockManagerId() {
        return this.blockManagerId;
    }

    public long maxMem() {
        return this.maxMem;
    }

    private HashMap<Object, scala.collection.mutable.Map<BlockId, BlockStatus>> _rddBlocks() {
        return this._rddBlocks;
    }

    private HashMap<BlockId, BlockStatus> _nonRddBlocks() {
        return this._nonRddBlocks;
    }

    private HashMap<Object, Tuple4<Object, Object, Object, StorageLevel>> _rddStorageInfo() {
        return this._rddStorageInfo;
    }

    private Tuple3<Object, Object, Object> _nonRddStorageInfo() {
        return this._nonRddStorageInfo;
    }

    private void _nonRddStorageInfo_$eq(Tuple3<Object, Object, Object> x$1) {
        this._nonRddStorageInfo = x$1;
    }

    public Map<BlockId, BlockStatus> blocks() {
        return this._nonRddBlocks().$plus$plus(this.rddBlocks());
    }

    public Map<BlockId, BlockStatus> rddBlocks() {
        return (Map)this._rddBlocks().flatMap((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final scala.collection.mutable.Map<BlockId, BlockStatus> apply(Tuple2<Object, scala.collection.mutable.Map<BlockId, BlockStatus>> x0$2) {
                Tuple2<Object, scala.collection.mutable.Map<BlockId, BlockStatus>> tuple2 = x0$2;
                if (tuple2 != null) {
                    scala.collection.mutable.Map blocks;
                    scala.collection.mutable.Map map2 = blocks = (scala.collection.mutable.Map)tuple2._2();
                    return map2;
                }
                throw new MatchError(tuple2);
            }
        }, HashMap$.MODULE$.canBuildFrom());
    }

    public Map<BlockId, BlockStatus> rddBlocksById(int rddId) {
        return (Map)this._rddBlocks().get((Object)BoxesRunTime.boxToInteger((int)rddId)).getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final scala.collection.immutable.Map<BlockId, Nothing$> apply() {
                return Map$.MODULE$.empty();
            }
        });
    }

    public void addBlock(BlockId blockId, BlockStatus blockStatus2) {
        this.updateStorageInfo(blockId, blockStatus2);
        BlockId blockId2 = blockId;
        if (blockId2 instanceof RDDBlockId) {
            RDDBlockId rDDBlockId = (RDDBlockId)blockId2;
            int rddId = rDDBlockId.rddId();
            ((scala.collection.mutable.MapLike)this._rddBlocks().getOrElseUpdate((Object)BoxesRunTime.boxToInteger((int)rddId), (Function0)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final HashMap<BlockId, BlockStatus> apply() {
                    return new HashMap();
                }
            })).update((Object)blockId, (Object)blockStatus2);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            this._nonRddBlocks().update((Object)blockId, (Object)blockStatus2);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    public void updateBlock(BlockId blockId, BlockStatus blockStatus2) {
        this.addBlock(blockId, blockStatus2);
    }

    public Option<BlockStatus> removeBlock(BlockId blockId) {
        Option option;
        this.updateStorageInfo(blockId, BlockStatus$.MODULE$.empty());
        BlockId blockId2 = blockId;
        if (blockId2 instanceof RDDBlockId) {
            None$ none$;
            RDDBlockId rDDBlockId = (RDDBlockId)blockId2;
            int rddId = rDDBlockId.rddId();
            if (this._rddBlocks().contains((Object)BoxesRunTime.boxToInteger((int)rddId))) {
                Option removed = ((scala.collection.mutable.MapLike)this._rddBlocks().apply((Object)BoxesRunTime.boxToInteger((int)rddId))).remove((Object)blockId);
                Object object = ((MapLike)this._rddBlocks().apply((Object)BoxesRunTime.boxToInteger((int)rddId))).isEmpty() ? this._rddBlocks().remove((Object)BoxesRunTime.boxToInteger((int)rddId)) : BoxedUnit.UNIT;
                none$ = removed;
            } else {
                none$ = None$.MODULE$;
            }
            option = none$;
        } else {
            option = this._nonRddBlocks().remove((Object)blockId);
        }
        return option;
    }

    public boolean containsBlock(BlockId blockId) {
        boolean bl;
        BlockId blockId2 = blockId;
        if (blockId2 instanceof RDDBlockId) {
            RDDBlockId rDDBlockId = (RDDBlockId)blockId2;
            int rddId = rDDBlockId.rddId();
            bl = this._rddBlocks().get((Object)BoxesRunTime.boxToInteger((int)rddId)).exists((Function1)new Serializable(this, blockId){
                public static final long serialVersionUID = 0L;
                private final BlockId blockId$1;

                public final boolean apply(scala.collection.mutable.Map<BlockId, BlockStatus> x$1) {
                    return x$1.contains((Object)this.blockId$1);
                }
                {
                    this.blockId$1 = blockId$1;
                }
            });
        } else {
            bl = this._nonRddBlocks().contains((Object)blockId);
        }
        return bl;
    }

    public Option<BlockStatus> getBlock(BlockId blockId) {
        Option option;
        BlockId blockId2 = blockId;
        if (blockId2 instanceof RDDBlockId) {
            RDDBlockId rDDBlockId = (RDDBlockId)blockId2;
            int rddId = rDDBlockId.rddId();
            option = this._rddBlocks().get((Object)BoxesRunTime.boxToInteger((int)rddId)).map((Function1)new Serializable(this, blockId){
                public static final long serialVersionUID = 0L;
                private final BlockId blockId$2;

                public final Option<BlockStatus> apply(scala.collection.mutable.Map<BlockId, BlockStatus> x$2) {
                    return x$2.get((Object)this.blockId$2);
                }
                {
                    this.blockId$2 = blockId$2;
                }
            }).flatten(Predef$.MODULE$.$conforms());
        } else {
            option = this._nonRddBlocks().get((Object)blockId);
        }
        return option;
    }

    public int numBlocks() {
        return this._nonRddBlocks().size() + this.numRddBlocks();
    }

    public int numRddBlocks() {
        return BoxesRunTime.unboxToInt((Object)((TraversableOnce)this._rddBlocks().values().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(scala.collection.mutable.Map<BlockId, BlockStatus> x$3) {
                return x$3.size();
            }
        }, Iterable$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
    }

    public int numRddBlocksById(int rddId) {
        return BoxesRunTime.unboxToInt((Object)this._rddBlocks().get((Object)BoxesRunTime.boxToInteger((int)rddId)).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(scala.collection.mutable.Map<BlockId, BlockStatus> x$4) {
                return x$4.size();
            }
        }).getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply() {
                return this.apply$mcI$sp();
            }

            public int apply$mcI$sp() {
                return 0;
            }
        }));
    }

    public long memRemaining() {
        return this.maxMem() - this.memUsed();
    }

    public long memUsed() {
        return BoxesRunTime.unboxToLong((Object)this._nonRddStorageInfo()._1()) + BoxesRunTime.unboxToLong((Object)((TraversableOnce)this._rddBlocks().keys().toSeq().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ StorageStatus $outer;

            public final long apply(int rddId) {
                return this.apply$mcJI$sp(rddId);
            }

            public long apply$mcJI$sp(int rddId) {
                return this.$outer.memUsedByRdd(rddId);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, Seq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
    }

    public long diskUsed() {
        return BoxesRunTime.unboxToLong((Object)this._nonRddStorageInfo()._2()) + BoxesRunTime.unboxToLong((Object)((TraversableOnce)this._rddBlocks().keys().toSeq().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ StorageStatus $outer;

            public final long apply(int rddId) {
                return this.apply$mcJI$sp(rddId);
            }

            public long apply$mcJI$sp(int rddId) {
                return this.$outer.diskUsedByRdd(rddId);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, Seq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
    }

    public long offHeapUsed() {
        return BoxesRunTime.unboxToLong((Object)this._nonRddStorageInfo()._3()) + BoxesRunTime.unboxToLong((Object)((TraversableOnce)this._rddBlocks().keys().toSeq().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ StorageStatus $outer;

            public final long apply(int rddId) {
                return this.apply$mcJI$sp(rddId);
            }

            public long apply$mcJI$sp(int rddId) {
                return this.$outer.offHeapUsedByRdd(rddId);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, Seq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
    }

    public long memUsedByRdd(int rddId) {
        return BoxesRunTime.unboxToLong((Object)this._rddStorageInfo().get((Object)BoxesRunTime.boxToInteger((int)rddId)).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply(Tuple4<Object, Object, Object, StorageLevel> x$5) {
                return BoxesRunTime.unboxToLong((Object)x$5._1());
            }
        }).getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply() {
                return this.apply$mcJ$sp();
            }

            public long apply$mcJ$sp() {
                return 0L;
            }
        }));
    }

    public long diskUsedByRdd(int rddId) {
        return BoxesRunTime.unboxToLong((Object)this._rddStorageInfo().get((Object)BoxesRunTime.boxToInteger((int)rddId)).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply(Tuple4<Object, Object, Object, StorageLevel> x$6) {
                return BoxesRunTime.unboxToLong((Object)x$6._2());
            }
        }).getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply() {
                return this.apply$mcJ$sp();
            }

            public long apply$mcJ$sp() {
                return 0L;
            }
        }));
    }

    public long offHeapUsedByRdd(int rddId) {
        return BoxesRunTime.unboxToLong((Object)this._rddStorageInfo().get((Object)BoxesRunTime.boxToInteger((int)rddId)).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply(Tuple4<Object, Object, Object, StorageLevel> x$7) {
                return BoxesRunTime.unboxToLong((Object)x$7._3());
            }
        }).getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply() {
                return this.apply$mcJ$sp();
            }

            public long apply$mcJ$sp() {
                return 0L;
            }
        }));
    }

    public Option<StorageLevel> rddStorageLevel(int rddId) {
        return this._rddStorageInfo().get((Object)BoxesRunTime.boxToInteger((int)rddId)).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final StorageLevel apply(Tuple4<Object, Object, Object, StorageLevel> x$8) {
                return (StorageLevel)x$8._4();
            }
        });
    }

    private void updateStorageInfo(BlockId blockId, BlockStatus newBlockStatus) {
        Tuple3 tuple3;
        BlockStatus oldBlockStatus = (BlockStatus)this.getBlock(blockId).getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final BlockStatus apply() {
                return BlockStatus$.MODULE$.empty();
            }
        });
        long changeInMem = newBlockStatus.memSize() - oldBlockStatus.memSize();
        long changeInDisk = newBlockStatus.diskSize() - oldBlockStatus.diskSize();
        long changeInExternalBlockStore = newBlockStatus.externalBlockStoreSize() - oldBlockStatus.externalBlockStoreSize();
        StorageLevel level = newBlockStatus.storageLevel();
        BlockId blockId2 = blockId;
        if (blockId2 instanceof RDDBlockId) {
            RDDBlockId rDDBlockId = (RDDBlockId)blockId2;
            int rddId = rDDBlockId.rddId();
            tuple3 = (Tuple3)this._rddStorageInfo().get((Object)BoxesRunTime.boxToInteger((int)rddId)).map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final Tuple3<Object, Object, Object> apply(Tuple4<Object, Object, Object, StorageLevel> x0$3) {
                    Tuple4<Object, Object, Object, StorageLevel> tuple4 = x0$3;
                    if (tuple4 != null) {
                        long mem = BoxesRunTime.unboxToLong((Object)tuple4._1());
                        long disk = BoxesRunTime.unboxToLong((Object)tuple4._2());
                        long externalBlockStore = BoxesRunTime.unboxToLong((Object)tuple4._3());
                        Tuple3 tuple3 = new Tuple3((Object)BoxesRunTime.boxToLong((long)mem), (Object)BoxesRunTime.boxToLong((long)disk), (Object)BoxesRunTime.boxToLong((long)externalBlockStore));
                        return tuple3;
                    }
                    throw new MatchError(tuple4);
                }
            }).getOrElse((Function0)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final Tuple3<Object, Object, Object> apply() {
                    return new Tuple3((Object)BoxesRunTime.boxToLong((long)0L), (Object)BoxesRunTime.boxToLong((long)0L), (Object)BoxesRunTime.boxToLong((long)0L));
                }
            });
        } else {
            tuple3 = this._nonRddStorageInfo();
        }
        Tuple3 tuple32 = tuple3;
        if (tuple32 != null) {
            Tuple3 tuple33;
            long oldMem = BoxesRunTime.unboxToLong((Object)tuple32._1());
            long oldDisk = BoxesRunTime.unboxToLong((Object)tuple32._2());
            long oldExternalBlockStore = BoxesRunTime.unboxToLong((Object)tuple32._3());
            Tuple3 tuple34 = tuple33 = new Tuple3((Object)BoxesRunTime.boxToLong((long)oldMem), (Object)BoxesRunTime.boxToLong((long)oldDisk), (Object)BoxesRunTime.boxToLong((long)oldExternalBlockStore));
            long oldMem2 = BoxesRunTime.unboxToLong((Object)tuple34._1());
            long oldDisk2 = BoxesRunTime.unboxToLong((Object)tuple34._2());
            long oldExternalBlockStore2 = BoxesRunTime.unboxToLong((Object)tuple34._3());
            long newMem = package$.MODULE$.max(oldMem2 + changeInMem, 0L);
            long newDisk = package$.MODULE$.max(oldDisk2 + changeInDisk, 0L);
            long newExternalBlockStore = package$.MODULE$.max(oldExternalBlockStore2 + changeInExternalBlockStore, 0L);
            BlockId blockId3 = blockId;
            if (blockId3 instanceof RDDBlockId) {
                BoxedUnit boxedUnit;
                RDDBlockId rDDBlockId = (RDDBlockId)blockId3;
                int rddId = rDDBlockId.rddId();
                if (newMem + newDisk + newExternalBlockStore == 0L) {
                    this._rddStorageInfo().remove((Object)BoxesRunTime.boxToInteger((int)rddId));
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    this._rddStorageInfo().update((Object)BoxesRunTime.boxToInteger((int)rddId), (Object)new Tuple4((Object)BoxesRunTime.boxToLong((long)newMem), (Object)BoxesRunTime.boxToLong((long)newDisk), (Object)BoxesRunTime.boxToLong((long)newExternalBlockStore), (Object)level));
                    boxedUnit = BoxedUnit.UNIT;
                }
                BoxedUnit boxedUnit2 = boxedUnit;
            } else {
                this._nonRddStorageInfo_$eq((Tuple3<Object, Object, Object>)new Tuple3((Object)BoxesRunTime.boxToLong((long)newMem), (Object)BoxesRunTime.boxToLong((long)newDisk), (Object)BoxesRunTime.boxToLong((long)newExternalBlockStore)));
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            return;
        }
        throw new MatchError(tuple32);
    }

    public StorageStatus(BlockManagerId blockManagerId, long maxMem) {
        this.blockManagerId = blockManagerId;
        this.maxMem = maxMem;
        this._rddBlocks = new HashMap();
        this._nonRddBlocks = new HashMap();
        this._rddStorageInfo = new HashMap();
        this._nonRddStorageInfo = new Tuple3((Object)BoxesRunTime.boxToLong((long)0L), (Object)BoxesRunTime.boxToLong((long)0L), (Object)BoxesRunTime.boxToLong((long)0L));
    }

    public StorageStatus(BlockManagerId bmid, long maxMem, Map<BlockId, BlockStatus> initialBlocks) {
        this(bmid, maxMem);
        initialBlocks.foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ StorageStatus $outer;

            public final void apply(Tuple2<BlockId, BlockStatus> x0$1) {
                Tuple2<BlockId, BlockStatus> tuple2 = x0$1;
                if (tuple2 != null) {
                    BlockId bid = (BlockId)tuple2._1();
                    BlockStatus bstatus = (BlockStatus)tuple2._2();
                    this.$outer.addBlock(bid, bstatus);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
                throw new MatchError(tuple2);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }
}

