/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ui.storage;

import org.apache.spark.annotation.DeveloperApi;
import org.apache.spark.executor.TaskMetrics;
import org.apache.spark.scheduler.SparkListenerStageCompleted;
import org.apache.spark.scheduler.SparkListenerStageSubmitted;
import org.apache.spark.scheduler.SparkListenerTaskEnd;
import org.apache.spark.scheduler.SparkListenerUnpersistRDD;
import org.apache.spark.storage.BlockId;
import org.apache.spark.storage.BlockStatus;
import org.apache.spark.storage.BlockStatusListener;
import org.apache.spark.storage.RDDBlockId;
import org.apache.spark.storage.RDDInfo;
import org.apache.spark.storage.StorageStatus;
import org.apache.spark.storage.StorageStatusListener;
import org.apache.spark.storage.StorageUtils$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@DeveloperApi
@ScalaSignature(bytes="\u0006\u0001\u00055a\u0001B\u0001\u0003\u00015\u0011qb\u0015;pe\u0006<W\rT5ti\u0016tWM\u001d\u0006\u0003\u0007\u0011\tqa\u001d;pe\u0006<WM\u0003\u0002\u0006\r\u0005\u0011Q/\u001b\u0006\u0003\u000f!\tQa\u001d9be.T!!\u0003\u0006\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005Y\u0011aA8sO\u000e\u00011C\u0001\u0001\u000f!\ty\u0011#D\u0001\u0011\u0015\t\u0019a!\u0003\u0002\u0013!\t\u0019\"\t\\8dWN#\u0018\r^;t\u0019&\u001cH/\u001a8fe\"AA\u0003\u0001B\u0001B\u0003%Q#A\u000bti>\u0014\u0018mZ3Ti\u0006$Xo\u001d'jgR,g.\u001a:\u0011\u0005=1\u0012BA\f\u0011\u0005U\u0019Fo\u001c:bO\u0016\u001cF/\u0019;vg2K7\u000f^3oKJDQ!\u0007\u0001\u0005\u0002i\ta\u0001P5oSRtDCA\u000e\u001e!\ta\u0002!D\u0001\u0003\u0011\u0015!\u0002\u00041\u0001\u0016\u0011!y\u0002A1A\u0005\u0002\u0011\u0001\u0013aC0sI\u0012LeNZ8NCB,\u0012!\t\t\u0005E%Zs&D\u0001$\u0015\t!S%A\u0004nkR\f'\r\\3\u000b\u0005\u0019:\u0013AC2pY2,7\r^5p]*\t\u0001&A\u0003tG\u0006d\u0017-\u0003\u0002+G\t\u0019Q*\u00199\u0011\u00051jS\"A\u0014\n\u00059:#aA%oiB\u0011q\u0002M\u0005\u0003cA\u0011qA\u0015#E\u0013:4w\u000e\u0003\u00044\u0001\u0001\u0006I!I\u0001\r?J$G-\u00138g_6\u000b\u0007\u000f\t\u0005\u0006k\u0001!\tAN\u0001\u0012gR|'/Y4f'R\fG/^:MSN$X#A\u001c\u0011\u0007a\u00025I\u0004\u0002:}9\u0011!(P\u0007\u0002w)\u0011A\bD\u0001\u0007yI|w\u000e\u001e \n\u0003!J!aP\u0014\u0002\u000fA\f7m[1hK&\u0011\u0011I\u0011\u0002\u0004'\u0016\f(BA (!\tyA)\u0003\u0002F!\ti1\u000b^8sC\u001e,7\u000b^1ukNDQa\u0012\u0001\u0005\u0002!\u000b1B\u001d3e\u0013:4w\u000eT5tiV\t\u0011\nE\u00029\u0001>BQa\u0013\u0001\u0005\n1\u000bQ\"\u001e9eCR,'\u000b\u0012#J]\u001a|GCA'Q!\tac*\u0003\u0002PO\t!QK\\5u\u0011\u0015\t&\n1\u0001S\u00035)\b\u000fZ1uK\u0012\u0014En\\2lgB\u0019\u0001\bQ*\u0011\t1\"f+W\u0005\u0003+\u001e\u0012a\u0001V;qY\u0016\u0014\u0004CA\bX\u0013\tA\u0006CA\u0004CY>\u001c7.\u00133\u0011\u0005=Q\u0016BA.\u0011\u0005-\u0011En\\2l'R\fG/^:\t\u000bu\u0003A\u0011\t0\u0002\u0013=tG+Y:l\u000b:$GCA'`\u0011\u0015\u0001G\f1\u0001b\u0003\u001d!\u0018m]6F]\u0012\u0004\"AY3\u000e\u0003\rT!\u0001\u001a\u0004\u0002\u0013M\u001c\u0007.\u001a3vY\u0016\u0014\u0018B\u00014d\u0005Q\u0019\u0006/\u0019:l\u0019&\u001cH/\u001a8feR\u000b7o[#oI\")\u0001\u000e\u0001C!S\u0006\u0001rN\\*uC\u001e,7+\u001e2nSR$X\r\u001a\u000b\u0003\u001b*DQa[4A\u00021\fab\u001d;bO\u0016\u001cVOY7jiR,G\r\u0005\u0002c[&\u0011an\u0019\u0002\u001c'B\f'o\u001b'jgR,g.\u001a:Ti\u0006<WmU;c[&$H/\u001a3\t\u000bA\u0004A\u0011I9\u0002!=t7\u000b^1hK\u000e{W\u000e\u001d7fi\u0016$GCA's\u0011\u0015\u0019x\u000e1\u0001u\u00039\u0019H/Y4f\u0007>l\u0007\u000f\\3uK\u0012\u0004\"AY;\n\u0005Y\u001c'aG*qCJ\\G*[:uK:,'o\u0015;bO\u0016\u001cu.\u001c9mKR,G\rC\u0003y\u0001\u0011\u0005\u00130\u0001\bp]Vs\u0007/\u001a:tSN$(\u000b\u0012#\u0015\u00055S\b\"B>x\u0001\u0004a\u0018\u0001D;oa\u0016\u00148/[:u%\u0012#\u0005C\u00012~\u0013\tq8MA\rTa\u0006\u00148\u000eT5ti\u0016tWM]+oa\u0016\u00148/[:u%\u0012#\u0005f\u0001\u0001\u0002\u0002A!\u00111AA\u0005\u001b\t\t)AC\u0002\u0002\b\u0019\t!\"\u00198o_R\fG/[8o\u0013\u0011\tY!!\u0002\u0003\u0019\u0011+g/\u001a7pa\u0016\u0014\u0018\t]5")
public class StorageListener
extends BlockStatusListener {
    private final StorageStatusListener storageStatusListener;
    private final Map<Object, RDDInfo> _rddInfoMap;

    public Map<Object, RDDInfo> _rddInfoMap() {
        return this._rddInfoMap;
    }

    public Seq<StorageStatus> storageStatusList() {
        return this.storageStatusListener.storageStatusList();
    }

    public synchronized Seq<RDDInfo> rddInfoList() {
        return ((TraversableOnce)this._rddInfoMap().values().filter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(RDDInfo x$1) {
                return x$1.numCachedPartitions() > 0;
            }
        })).toSeq();
    }

    private void updateRDDInfo(Seq<Tuple2<BlockId, BlockStatus>> updatedBlocks) {
        Set rddIdsToUpdate = ((TraversableOnce)updatedBlocks.flatMap((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Iterable<Object> apply(Tuple2<BlockId, BlockStatus> x0$1) {
                Tuple2<BlockId, BlockStatus> tuple2 = x0$1;
                if (tuple2 != null) {
                    BlockId bid = (BlockId)tuple2._1();
                    Iterable iterable = Option$.MODULE$.option2Iterable(bid.asRDDId().map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final int apply(RDDBlockId x$2) {
                            return x$2.rddId();
                        }
                    }));
                    return iterable;
                }
                throw new MatchError(tuple2);
            }
        }, Seq$.MODULE$.canBuildFrom())).toSet();
        Seq rddInfosToUpdate = (Seq)this._rddInfoMap().values().toSeq().filter((Function1)new Serializable(this, rddIdsToUpdate){
            public static final long serialVersionUID = 0L;
            private final Set rddIdsToUpdate$1;

            public final boolean apply(RDDInfo s) {
                return this.rddIdsToUpdate$1.contains((Object)BoxesRunTime.boxToInteger((int)s.id()));
            }
            {
                this.rddIdsToUpdate$1 = rddIdsToUpdate$1;
            }
        });
        StorageUtils$.MODULE$.updateRddInfo((Seq<RDDInfo>)rddInfosToUpdate, this.storageStatusList());
    }

    @Override
    public synchronized void onTaskEnd(SparkListenerTaskEnd taskEnd) {
        TaskMetrics metrics = taskEnd.taskMetrics();
        if (metrics != null && metrics.updatedBlocks().isDefined()) {
            this.updateRDDInfo((Seq<Tuple2<BlockId, BlockStatus>>)((Seq)metrics.updatedBlocks().get()));
        }
    }

    @Override
    public synchronized void onStageSubmitted(SparkListenerStageSubmitted stageSubmitted) {
        Seq<RDDInfo> rddInfos = stageSubmitted.stageInfo().rddInfos();
        rddInfos.foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ StorageListener $outer;

            public final RDDInfo apply(RDDInfo info) {
                return (RDDInfo)this.$outer._rddInfoMap().getOrElseUpdate((Object)BoxesRunTime.boxToInteger((int)info.id()), (Function0)new Serializable(this, info){
                    public static final long serialVersionUID = 0L;
                    private final RDDInfo info$1;

                    public final RDDInfo apply() {
                        return this.info$1;
                    }
                    {
                        this.info$1 = info$1;
                    }
                });
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    @Override
    public void onStageCompleted(SparkListenerStageCompleted stageCompleted) {
        StorageListener storageListener = this;
        synchronized (storageListener) {
            Set completedRddIds = ((TraversableOnce)stageCompleted.stageInfo().rddInfos().map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final int apply(RDDInfo r) {
                    return r.id();
                }
            }, Seq$.MODULE$.canBuildFrom())).toSet();
            this._rddInfoMap().retain((Function2)new Serializable(this, completedRddIds){
                public static final long serialVersionUID = 0L;
                private final Set completedRddIds$1;

                public final boolean apply(int x0$2, RDDInfo x1$1) {
                    Tuple2 tuple2 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)x0$2), (Object)x1$1);
                    if (tuple2 != null) {
                        int id = tuple2._1$mcI$sp();
                        RDDInfo info = (RDDInfo)tuple2._2();
                        boolean bl = !this.completedRddIds$1.contains((Object)BoxesRunTime.boxToInteger((int)id)) || info.numCachedPartitions() > 0;
                        return bl;
                    }
                    throw new MatchError((Object)tuple2);
                }
                {
                    this.completedRddIds$1 = completedRddIds$1;
                }
            });
            return;
        }
    }

    @Override
    public void onUnpersistRDD(SparkListenerUnpersistRDD unpersistRDD) {
        StorageListener storageListener = this;
        synchronized (storageListener) {
            this._rddInfoMap().remove((Object)BoxesRunTime.boxToInteger((int)unpersistRDD.rddId()));
            return;
        }
    }

    public StorageListener(StorageStatusListener storageStatusListener) {
        this.storageStatusListener = storageStatusListener;
        this._rddInfoMap = (Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
    }
}

