/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.util;

import org.apache.spark.SparkConf;
import org.apache.spark.SparkEnv$;
import org.apache.spark.rpc.RpcAddress;
import org.apache.spark.rpc.RpcEndpointRef;
import org.apache.spark.rpc.RpcEnv;
import org.apache.spark.rpc.RpcTimeout;
import org.apache.spark.rpc.RpcTimeout$;
import org.apache.spark.util.Utils$;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.concurrent.duration.FiniteDuration;

public final class RpcUtils$ {
    public static final RpcUtils$ MODULE$;

    static {
        new RpcUtils$();
    }

    public RpcEndpointRef makeDriverRef(String name, SparkConf conf, RpcEnv rpcEnv) {
        String driverActorSystemName = SparkEnv$.MODULE$.driverActorSystemName();
        String driverHost = conf.get("spark.driver.host", "localhost");
        int driverPort = conf.getInt("spark.driver.port", 7077);
        Utils$.MODULE$.checkHost(driverHost, "Expected hostname");
        return rpcEnv.setupEndpointRef(driverActorSystemName, new RpcAddress(driverHost, driverPort), name);
    }

    public int numRetries(SparkConf conf) {
        return conf.getInt("spark.rpc.numRetries", 3);
    }

    public long retryWaitMs(SparkConf conf) {
        return conf.getTimeAsMs("spark.rpc.retry.wait", "3s");
    }

    public RpcTimeout askRpcTimeout(SparkConf conf) {
        return RpcTimeout$.MODULE$.apply(conf, (Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"spark.rpc.askTimeout", "spark.network.timeout"}))), "120s");
    }

    public FiniteDuration askTimeout(SparkConf conf) {
        return this.askRpcTimeout(conf).duration();
    }

    public RpcTimeout lookupRpcTimeout(SparkConf conf) {
        return RpcTimeout$.MODULE$.apply(conf, (Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"spark.rpc.lookupTimeout", "spark.network.timeout"}))), "120s");
    }

    public FiniteDuration lookupTimeout(SparkConf conf) {
        return this.lookupRpcTimeout(conf).duration();
    }

    private RpcUtils$() {
        MODULE$ = this;
    }
}

