/*
 * Decompiled with CFR 0.152.
 */
package org.spark-project.jetty.server.ssl;

import java.io.IOException;
import java.nio.channels.SocketChannel;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLSession;
import org.spark-project.jetty.io.AsyncEndPoint;
import org.spark-project.jetty.io.Buffers;
import org.spark-project.jetty.io.BuffersFactory;
import org.spark-project.jetty.io.EndPoint;
import org.spark-project.jetty.io.RuntimeIOException;
import org.spark-project.jetty.io.nio.AsyncConnection;
import org.spark-project.jetty.io.nio.SslConnection;
import org.spark-project.jetty.server.Request;
import org.spark-project.jetty.server.nio.SelectChannelConnector;
import org.spark-project.jetty.server.ssl.SslCertificates;
import org.spark-project.jetty.server.ssl.SslConnector;
import org.spark-project.jetty.util.ssl.SslContextFactory;

public class SslSelectChannelConnector
extends SelectChannelConnector
implements SslConnector {
    private final SslContextFactory _sslContextFactory;
    private Buffers _sslBuffers;

    public SslSelectChannelConnector() {
        this(new SslContextFactory(SslContextFactory.DEFAULT_KEYSTORE_PATH));
        this.setSoLingerTime(30000);
    }

    public SslSelectChannelConnector(SslContextFactory sslContextFactory) {
        this._sslContextFactory = sslContextFactory;
        this.addBean(this._sslContextFactory);
        this.setUseDirectBuffers(false);
        this.setSoLingerTime(30000);
    }

    @Override
    public void customize(EndPoint endpoint, Request request) throws IOException {
        request.setScheme("https");
        super.customize(endpoint, request);
        SslConnection.SslEndPoint sslEndpoint = (SslConnection.SslEndPoint)endpoint;
        SSLEngine sslEngine = sslEndpoint.getSslEngine();
        SSLSession sslSession = sslEngine.getSession();
        SslCertificates.customize(sslSession, endpoint, request);
    }

    @Override
    @Deprecated
    public boolean isAllowRenegotiate() {
        return this._sslContextFactory.isAllowRenegotiate();
    }

    @Override
    @Deprecated
    public void setAllowRenegotiate(boolean allowRenegotiate) {
        this._sslContextFactory.setAllowRenegotiate(allowRenegotiate);
    }

    @Override
    @Deprecated
    public String[] getExcludeCipherSuites() {
        return this._sslContextFactory.getExcludeCipherSuites();
    }

    @Override
    @Deprecated
    public void setExcludeCipherSuites(String[] cipherSuites) {
        this._sslContextFactory.setExcludeCipherSuites(cipherSuites);
    }

    @Override
    @Deprecated
    public String[] getIncludeCipherSuites() {
        return this._sslContextFactory.getIncludeCipherSuites();
    }

    @Override
    @Deprecated
    public void setIncludeCipherSuites(String[] cipherSuites) {
        this._sslContextFactory.setIncludeCipherSuites(cipherSuites);
    }

    @Override
    @Deprecated
    public void setPassword(String password) {
        this._sslContextFactory.setKeyStorePassword(password);
    }

    @Override
    @Deprecated
    public void setTrustPassword(String password) {
        this._sslContextFactory.setTrustStorePassword(password);
    }

    @Override
    @Deprecated
    public void setKeyPassword(String password) {
        this._sslContextFactory.setKeyManagerPassword(password);
    }

    @Deprecated
    public String getAlgorithm() {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public void setAlgorithm(String algorithm) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public String getProtocol() {
        return this._sslContextFactory.getProtocol();
    }

    @Override
    @Deprecated
    public void setProtocol(String protocol) {
        this._sslContextFactory.setProtocol(protocol);
    }

    @Override
    @Deprecated
    public void setKeystore(String keystore) {
        this._sslContextFactory.setKeyStorePath(keystore);
    }

    @Override
    @Deprecated
    public String getKeystore() {
        return this._sslContextFactory.getKeyStorePath();
    }

    @Override
    @Deprecated
    public String getKeystoreType() {
        return this._sslContextFactory.getKeyStoreType();
    }

    @Override
    @Deprecated
    public boolean getNeedClientAuth() {
        return this._sslContextFactory.getNeedClientAuth();
    }

    @Override
    @Deprecated
    public boolean getWantClientAuth() {
        return this._sslContextFactory.getWantClientAuth();
    }

    @Override
    @Deprecated
    public void setNeedClientAuth(boolean needClientAuth) {
        this._sslContextFactory.setNeedClientAuth(needClientAuth);
    }

    @Override
    @Deprecated
    public void setWantClientAuth(boolean wantClientAuth) {
        this._sslContextFactory.setWantClientAuth(wantClientAuth);
    }

    @Override
    @Deprecated
    public void setKeystoreType(String keystoreType) {
        this._sslContextFactory.setKeyStoreType(keystoreType);
    }

    @Override
    @Deprecated
    public String getProvider() {
        return this._sslContextFactory.getProvider();
    }

    @Override
    @Deprecated
    public String getSecureRandomAlgorithm() {
        return this._sslContextFactory.getSecureRandomAlgorithm();
    }

    @Override
    @Deprecated
    public String getSslKeyManagerFactoryAlgorithm() {
        return this._sslContextFactory.getSslKeyManagerFactoryAlgorithm();
    }

    @Override
    @Deprecated
    public String getSslTrustManagerFactoryAlgorithm() {
        return this._sslContextFactory.getTrustManagerFactoryAlgorithm();
    }

    @Override
    @Deprecated
    public String getTruststore() {
        return this._sslContextFactory.getTrustStore();
    }

    @Override
    @Deprecated
    public String getTruststoreType() {
        return this._sslContextFactory.getTrustStoreType();
    }

    @Override
    @Deprecated
    public void setProvider(String provider) {
        this._sslContextFactory.setProvider(provider);
    }

    @Override
    @Deprecated
    public void setSecureRandomAlgorithm(String algorithm) {
        this._sslContextFactory.setSecureRandomAlgorithm(algorithm);
    }

    @Override
    @Deprecated
    public void setSslKeyManagerFactoryAlgorithm(String algorithm) {
        this._sslContextFactory.setSslKeyManagerFactoryAlgorithm(algorithm);
    }

    @Override
    @Deprecated
    public void setSslTrustManagerFactoryAlgorithm(String algorithm) {
        this._sslContextFactory.setTrustManagerFactoryAlgorithm(algorithm);
    }

    @Override
    @Deprecated
    public void setTruststore(String truststore) {
        this._sslContextFactory.setTrustStore(truststore);
    }

    @Override
    @Deprecated
    public void setTruststoreType(String truststoreType) {
        this._sslContextFactory.setTrustStoreType(truststoreType);
    }

    @Override
    @Deprecated
    public void setSslContext(SSLContext sslContext) {
        this._sslContextFactory.setSslContext(sslContext);
    }

    @Override
    @Deprecated
    public SSLContext getSslContext() {
        return this._sslContextFactory.getSslContext();
    }

    @Override
    public SslContextFactory getSslContextFactory() {
        return this._sslContextFactory;
    }

    @Override
    public boolean isConfidential(Request request) {
        int confidentialPort = this.getConfidentialPort();
        return confidentialPort == 0 || confidentialPort == request.getServerPort();
    }

    @Override
    public boolean isIntegral(Request request) {
        int integralPort = this.getIntegralPort();
        return integralPort == 0 || integralPort == request.getServerPort();
    }

    @Override
    protected AsyncConnection newConnection(SocketChannel channel, AsyncEndPoint endpoint) {
        try {
            SSLEngine engine = this.createSSLEngine(channel);
            SslConnection connection = this.newSslConnection(endpoint, engine);
            AsyncConnection delegate = this.newPlainConnection(channel, connection.getSslEndPoint());
            connection.getSslEndPoint().setConnection(delegate);
            connection.setAllowRenegotiate(this._sslContextFactory.isAllowRenegotiate());
            return connection;
        }
        catch (IOException e) {
            throw new RuntimeIOException(e);
        }
    }

    protected AsyncConnection newPlainConnection(SocketChannel channel, AsyncEndPoint endPoint) {
        return super.newConnection(channel, endPoint);
    }

    protected SslConnection newSslConnection(AsyncEndPoint endpoint, SSLEngine engine) {
        return new SslConnection(engine, endpoint);
    }

    protected SSLEngine createSSLEngine(SocketChannel channel) throws IOException {
        SSLEngine engine;
        if (channel != null) {
            String peerHost = channel.socket().getInetAddress().getHostAddress();
            int peerPort = channel.socket().getPort();
            engine = this._sslContextFactory.newSslEngine(peerHost, peerPort);
        } else {
            engine = this._sslContextFactory.newSslEngine();
        }
        engine.setUseClientMode(false);
        return engine;
    }

    @Override
    protected void doStart() throws Exception {
        this._sslContextFactory.checkKeyStore();
        this._sslContextFactory.start();
        SSLEngine sslEngine = this._sslContextFactory.newSslEngine();
        sslEngine.setUseClientMode(false);
        SSLSession sslSession = sslEngine.getSession();
        this._sslBuffers = BuffersFactory.newBuffers(this.getUseDirectBuffers() ? Buffers.Type.DIRECT : Buffers.Type.INDIRECT, sslSession.getApplicationBufferSize(), this.getUseDirectBuffers() ? Buffers.Type.DIRECT : Buffers.Type.INDIRECT, sslSession.getApplicationBufferSize(), this.getUseDirectBuffers() ? Buffers.Type.DIRECT : Buffers.Type.INDIRECT, this.getMaxBuffers());
        if (this.getRequestHeaderSize() < sslSession.getApplicationBufferSize()) {
            this.setRequestHeaderSize(sslSession.getApplicationBufferSize());
        }
        if (this.getRequestBufferSize() < sslSession.getApplicationBufferSize()) {
            this.setRequestBufferSize(sslSession.getApplicationBufferSize());
        }
        super.doStart();
    }

    @Override
    protected void doStop() throws Exception {
        this._sslBuffers = null;
        super.doStop();
    }

    public Buffers getSslBuffers() {
        return this._sslBuffers;
    }
}

