/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.metrics;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.service.CompositeService;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.timeline.TimelineEntity;
import org.apache.hadoop.yarn.api.records.timeline.TimelineEvent;
import org.apache.hadoop.yarn.client.api.TimelineClient;
import org.apache.hadoop.yarn.event.AsyncDispatcher;
import org.apache.hadoop.yarn.event.Dispatcher;
import org.apache.hadoop.yarn.event.Event;
import org.apache.hadoop.yarn.event.EventHandler;
import org.apache.hadoop.yarn.server.resourcemanager.RMServerUtils;
import org.apache.hadoop.yarn.server.resourcemanager.metrics.AppAttemptFinishedEvent;
import org.apache.hadoop.yarn.server.resourcemanager.metrics.AppAttemptRegisteredEvent;
import org.apache.hadoop.yarn.server.resourcemanager.metrics.ApplicationACLsUpdatedEvent;
import org.apache.hadoop.yarn.server.resourcemanager.metrics.ApplicationCreatedEvent;
import org.apache.hadoop.yarn.server.resourcemanager.metrics.ApplicationFinishedEvent;
import org.apache.hadoop.yarn.server.resourcemanager.metrics.ContainerCreatedEvent;
import org.apache.hadoop.yarn.server.resourcemanager.metrics.ContainerFinishedEvent;
import org.apache.hadoop.yarn.server.resourcemanager.metrics.SystemMetricsEvent;
import org.apache.hadoop.yarn.server.resourcemanager.metrics.SystemMetricsEventType;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMApp;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppMetrics;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppState;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttempt;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttemptState;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainer;
import org.apache.hadoop.yarn.util.timeline.TimelineUtils;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class SystemMetricsPublisher
extends CompositeService {
    private static final Log LOG = LogFactory.getLog(SystemMetricsPublisher.class);
    private Dispatcher dispatcher;
    private TimelineClient client;
    private boolean publishSystemMetrics;

    public SystemMetricsPublisher() {
        super(SystemMetricsPublisher.class.getName());
    }

    protected void serviceInit(Configuration conf) throws Exception {
        boolean bl = this.publishSystemMetrics = conf.getBoolean("yarn.timeline-service.enabled", false) && conf.getBoolean("yarn.resourcemanager.system-metrics-publisher.enabled", false);
        if (this.publishSystemMetrics) {
            this.client = TimelineClient.createTimelineClient();
            this.addIfService(this.client);
            this.dispatcher = this.createDispatcher(conf);
            this.dispatcher.register(SystemMetricsEventType.class, (EventHandler)new ForwardingEventHandler());
            this.addIfService(this.dispatcher);
            LOG.info((Object)"YARN system metrics publishing service is enabled");
        } else {
            LOG.info((Object)"YARN system metrics publishing service is not enabled");
        }
        super.serviceInit(conf);
    }

    public void appCreated(RMApp app, long createdTime) {
        if (this.publishSystemMetrics) {
            this.dispatcher.getEventHandler().handle((Event)new ApplicationCreatedEvent(app.getApplicationId(), app.getName(), app.getApplicationType(), app.getUser(), app.getQueue(), app.getSubmitTime(), createdTime));
        }
    }

    public void appFinished(RMApp app, RMAppState state, long finishedTime) {
        if (this.publishSystemMetrics) {
            this.dispatcher.getEventHandler().handle((Event)new ApplicationFinishedEvent(app.getApplicationId(), app.getDiagnostics().toString(), app.getFinalApplicationStatus(), RMServerUtils.createApplicationState(state), app.getCurrentAppAttempt() == null ? null : app.getCurrentAppAttempt().getAppAttemptId(), finishedTime, app.getRMAppMetrics()));
        }
    }

    public void appACLsUpdated(RMApp app, String appViewACLs, long updatedTime) {
        if (this.publishSystemMetrics) {
            this.dispatcher.getEventHandler().handle((Event)new ApplicationACLsUpdatedEvent(app.getApplicationId(), appViewACLs == null ? "" : appViewACLs, updatedTime));
        }
    }

    public void appAttemptRegistered(RMAppAttempt appAttempt, long registeredTime) {
        if (this.publishSystemMetrics) {
            ContainerId container = appAttempt.getMasterContainer() == null ? null : appAttempt.getMasterContainer().getId();
            this.dispatcher.getEventHandler().handle((Event)new AppAttemptRegisteredEvent(appAttempt.getAppAttemptId(), appAttempt.getHost(), appAttempt.getRpcPort(), appAttempt.getTrackingUrl(), appAttempt.getOriginalTrackingUrl(), container, registeredTime));
        }
    }

    public void appAttemptFinished(RMAppAttempt appAttempt, RMAppAttemptState appAttemtpState, RMApp app, long finishedTime) {
        if (this.publishSystemMetrics) {
            ContainerId container = appAttempt.getMasterContainer() == null ? null : appAttempt.getMasterContainer().getId();
            this.dispatcher.getEventHandler().handle((Event)new AppAttemptFinishedEvent(appAttempt.getAppAttemptId(), appAttempt.getTrackingUrl(), appAttempt.getOriginalTrackingUrl(), appAttempt.getDiagnostics(), app.getFinalApplicationStatus(), RMServerUtils.createApplicationAttemptState(appAttemtpState), finishedTime, container));
        }
    }

    public void containerCreated(RMContainer container, long createdTime) {
        if (this.publishSystemMetrics) {
            this.dispatcher.getEventHandler().handle((Event)new ContainerCreatedEvent(container.getContainerId(), container.getAllocatedResource(), container.getAllocatedNode(), container.getAllocatedPriority(), createdTime, container.getNodeHttpAddress()));
        }
    }

    public void containerFinished(RMContainer container, long finishedTime) {
        if (this.publishSystemMetrics) {
            this.dispatcher.getEventHandler().handle((Event)new ContainerFinishedEvent(container.getContainerId(), container.getDiagnosticsInfo(), container.getContainerExitStatus(), container.getContainerState(), finishedTime, container.getAllocatedNode()));
        }
    }

    protected Dispatcher createDispatcher(Configuration conf) {
        MultiThreadedDispatcher dispatcher = new MultiThreadedDispatcher(conf.getInt("yarn.resourcemanager.system-metrics-publisher.dispatcher.pool-size", 10));
        dispatcher.setDrainEventsOnStop();
        return dispatcher;
    }

    protected void handleSystemMetricsEvent(SystemMetricsEvent event) {
        switch ((SystemMetricsEventType)event.getType()) {
            case APP_CREATED: {
                this.publishApplicationCreatedEvent((ApplicationCreatedEvent)event);
                break;
            }
            case APP_FINISHED: {
                this.publishApplicationFinishedEvent((ApplicationFinishedEvent)event);
                break;
            }
            case APP_ACLS_UPDATED: {
                this.publishApplicationACLsUpdatedEvent((ApplicationACLsUpdatedEvent)event);
                break;
            }
            case APP_ATTEMPT_REGISTERED: {
                this.publishAppAttemptRegisteredEvent((AppAttemptRegisteredEvent)event);
                break;
            }
            case APP_ATTEMPT_FINISHED: {
                this.publishAppAttemptFinishedEvent((AppAttemptFinishedEvent)event);
                break;
            }
            case CONTAINER_CREATED: {
                this.publishContainerCreatedEvent((ContainerCreatedEvent)event);
                break;
            }
            case CONTAINER_FINISHED: {
                this.publishContainerFinishedEvent((ContainerFinishedEvent)event);
                break;
            }
            default: {
                LOG.error((Object)("Unknown SystemMetricsEvent type: " + event.getType()));
            }
        }
    }

    private void publishApplicationCreatedEvent(ApplicationCreatedEvent event) {
        TimelineEntity entity = SystemMetricsPublisher.createApplicationEntity(event.getApplicationId());
        HashMap<String, Object> entityInfo = new HashMap<String, Object>();
        entityInfo.put("YARN_APPLICATION_NAME", event.getApplicationName());
        entityInfo.put("YARN_APPLICATION_TYPE", event.getApplicationType());
        entityInfo.put("YARN_APPLICATION_USER", event.getUser());
        entityInfo.put("YARN_APPLICATION_QUEUE", event.getQueue());
        entityInfo.put("YARN_APPLICATION_SUBMITTED_TIME", event.getSubmittedTime());
        entity.setOtherInfo(entityInfo);
        TimelineEvent tEvent = new TimelineEvent();
        tEvent.setEventType("YARN_APPLICATION_CREATED");
        tEvent.setTimestamp(event.getTimestamp());
        entity.addEvent(tEvent);
        this.putEntity(entity);
    }

    private void publishApplicationFinishedEvent(ApplicationFinishedEvent event) {
        TimelineEntity entity = SystemMetricsPublisher.createApplicationEntity(event.getApplicationId());
        TimelineEvent tEvent = new TimelineEvent();
        tEvent.setEventType("YARN_APPLICATION_FINISHED");
        tEvent.setTimestamp(event.getTimestamp());
        HashMap<String, String> eventInfo = new HashMap<String, String>();
        eventInfo.put("YARN_APPLICATION_DIAGNOSTICS_INFO", event.getDiagnosticsInfo());
        eventInfo.put("YARN_APPLICATION_FINAL_STATUS", event.getFinalApplicationStatus().toString());
        eventInfo.put("YARN_APPLICATION_STATE", event.getYarnApplicationState().toString());
        if (event.getLatestApplicationAttemptId() != null) {
            eventInfo.put("YARN_APPLICATION_LATEST_APP_ATTEMPT", event.getLatestApplicationAttemptId().toString());
        }
        RMAppMetrics appMetrics = event.getAppMetrics();
        entity.addOtherInfo("YARN_APPLICATION_CPU_METRIC", (Object)appMetrics.getVcoreSeconds());
        entity.addOtherInfo("YARN_APPLICATION_MEM_METRIC", (Object)appMetrics.getMemorySeconds());
        tEvent.setEventInfo(eventInfo);
        entity.addEvent(tEvent);
        this.putEntity(entity);
    }

    private void publishApplicationACLsUpdatedEvent(ApplicationACLsUpdatedEvent event) {
        TimelineEntity entity = SystemMetricsPublisher.createApplicationEntity(event.getApplicationId());
        TimelineEvent tEvent = new TimelineEvent();
        HashMap<String, String> entityInfo = new HashMap<String, String>();
        entityInfo.put("YARN_APPLICATION_VIEW_ACLS", event.getViewAppACLs());
        entity.setOtherInfo(entityInfo);
        tEvent.setEventType("YARN_APPLICATION_ACLS_UPDATED");
        tEvent.setTimestamp(event.getTimestamp());
        entity.addEvent(tEvent);
        this.putEntity(entity);
    }

    private static TimelineEntity createApplicationEntity(ApplicationId applicationId) {
        TimelineEntity entity = new TimelineEntity();
        entity.setEntityType("YARN_APPLICATION");
        entity.setEntityId(applicationId.toString());
        return entity;
    }

    private void publishAppAttemptRegisteredEvent(AppAttemptRegisteredEvent event) {
        TimelineEntity entity = SystemMetricsPublisher.createAppAttemptEntity(event.getApplicationAttemptId());
        TimelineEvent tEvent = new TimelineEvent();
        tEvent.setEventType("YARN_APPLICATION_ATTEMPT_REGISTERED");
        tEvent.setTimestamp(event.getTimestamp());
        HashMap<String, Object> eventInfo = new HashMap<String, Object>();
        eventInfo.put("YARN_APPLICATION_ATTEMPT_TRACKING_URL", event.getTrackingUrl());
        eventInfo.put("YARN_APPLICATION_ATTEMPT_ORIGINAL_TRACKING_URL", event.getOriginalTrackingURL());
        eventInfo.put("YARN_APPLICATION_ATTEMPT_HOST", event.getHost());
        eventInfo.put("YARN_APPLICATION_ATTEMPT_RPC_PORT", event.getRpcPort());
        if (event.getMasterContainerId() != null) {
            eventInfo.put("YARN_APPLICATION_ATTEMPT_MASTER_CONTAINER", event.getMasterContainerId().toString());
        }
        tEvent.setEventInfo(eventInfo);
        entity.addEvent(tEvent);
        this.putEntity(entity);
    }

    private void publishAppAttemptFinishedEvent(AppAttemptFinishedEvent event) {
        TimelineEntity entity = SystemMetricsPublisher.createAppAttemptEntity(event.getApplicationAttemptId());
        TimelineEvent tEvent = new TimelineEvent();
        tEvent.setEventType("YARN_APPLICATION_ATTEMPT_FINISHED");
        tEvent.setTimestamp(event.getTimestamp());
        HashMap<String, String> eventInfo = new HashMap<String, String>();
        eventInfo.put("YARN_APPLICATION_ATTEMPT_TRACKING_URL", event.getTrackingUrl());
        eventInfo.put("YARN_APPLICATION_ATTEMPT_ORIGINAL_TRACKING_URL", event.getOriginalTrackingURL());
        eventInfo.put("YARN_APPLICATION_ATTEMPT_DIAGNOSTICS_INFO", event.getDiagnosticsInfo());
        eventInfo.put("YARN_APPLICATION_ATTEMPT_FINAL_STATUS", event.getFinalApplicationStatus().toString());
        eventInfo.put("YARN_APPLICATION_ATTEMPT_STATE", event.getYarnApplicationAttemptState().toString());
        if (event.getMasterContainerId() != null) {
            eventInfo.put("YARN_APPLICATION_ATTEMPT_MASTER_CONTAINER", event.getMasterContainerId().toString());
        }
        tEvent.setEventInfo(eventInfo);
        entity.addEvent(tEvent);
        this.putEntity(entity);
    }

    private static TimelineEntity createAppAttemptEntity(ApplicationAttemptId appAttemptId) {
        TimelineEntity entity = new TimelineEntity();
        entity.setEntityType("YARN_APPLICATION_ATTEMPT");
        entity.setEntityId(appAttemptId.toString());
        entity.addPrimaryFilter("YARN_APPLICATION_ATTEMPT_PARENT", (Object)appAttemptId.getApplicationId().toString());
        return entity;
    }

    private void publishContainerCreatedEvent(ContainerCreatedEvent event) {
        TimelineEntity entity = SystemMetricsPublisher.createContainerEntity(event.getContainerId());
        HashMap<String, Object> entityInfo = new HashMap<String, Object>();
        entityInfo.put("YARN_CONTAINER_ALLOCATED_MEMORY", event.getAllocatedResource().getMemory());
        entityInfo.put("YARN_CONTAINER_ALLOCATED_VCORE", event.getAllocatedResource().getVirtualCores());
        entityInfo.put("YARN_CONTAINER_ALLOCATED_HOST", event.getAllocatedNode().getHost());
        entityInfo.put("YARN_CONTAINER_ALLOCATED_PORT", event.getAllocatedNode().getPort());
        entityInfo.put("YARN_CONTAINER_ALLOCATED_PRIORITY", event.getAllocatedPriority().getPriority());
        entityInfo.put("YARN_CONTAINER_ALLOCATED_HOST_HTTP_ADDRESS", event.getNodeHttpAddress());
        entity.setOtherInfo(entityInfo);
        TimelineEvent tEvent = new TimelineEvent();
        tEvent.setEventType("YARN_CONTAINER_CREATED");
        tEvent.setTimestamp(event.getTimestamp());
        entity.addEvent(tEvent);
        this.putEntity(entity);
    }

    private void publishContainerFinishedEvent(ContainerFinishedEvent event) {
        TimelineEntity entity = SystemMetricsPublisher.createContainerEntity(event.getContainerId());
        TimelineEvent tEvent = new TimelineEvent();
        tEvent.setEventType("YARN_CONTAINER_FINISHED");
        tEvent.setTimestamp(event.getTimestamp());
        HashMap<String, Object> eventInfo = new HashMap<String, Object>();
        eventInfo.put("YARN_CONTAINER_DIAGNOSTICS_INFO", event.getDiagnosticsInfo());
        eventInfo.put("YARN_CONTAINER_EXIT_STATUS", event.getContainerExitStatus());
        eventInfo.put("YARN_CONTAINER_STATE", event.getContainerState().toString());
        HashMap<String, Object> entityInfo = new HashMap<String, Object>();
        entityInfo.put("YARN_CONTAINER_ALLOCATED_HOST", event.getAllocatedNode().getHost());
        entityInfo.put("YARN_CONTAINER_ALLOCATED_PORT", event.getAllocatedNode().getPort());
        entity.setOtherInfo(entityInfo);
        tEvent.setEventInfo(eventInfo);
        entity.addEvent(tEvent);
        this.putEntity(entity);
    }

    private static TimelineEntity createContainerEntity(ContainerId containerId) {
        TimelineEntity entity = new TimelineEntity();
        entity.setEntityType("YARN_CONTAINER");
        entity.setEntityId(containerId.toString());
        entity.addPrimaryFilter("YARN_CONTAINER_PARENT", (Object)containerId.getApplicationAttemptId().toString());
        return entity;
    }

    private void putEntity(TimelineEntity entity) {
        try {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Publishing the entity " + entity.getEntityId() + ", JSON-style content: " + TimelineUtils.dumpTimelineRecordtoJSON((Object)entity)));
            }
            this.client.putEntities(new TimelineEntity[]{entity});
        }
        catch (Exception e) {
            LOG.error((Object)("Error when publishing entity [" + entity.getEntityType() + "," + entity.getEntityId() + "]"), (Throwable)e);
        }
    }

    protected static class MultiThreadedDispatcher
    extends CompositeService
    implements Dispatcher {
        private List<AsyncDispatcher> dispatchers = new ArrayList<AsyncDispatcher>();

        public MultiThreadedDispatcher(int num) {
            super(MultiThreadedDispatcher.class.getName());
            for (int i = 0; i < num; ++i) {
                AsyncDispatcher dispatcher = this.createDispatcher();
                this.dispatchers.add(dispatcher);
                this.addIfService(dispatcher);
            }
        }

        public EventHandler getEventHandler() {
            return new CompositEventHandler();
        }

        public void register(Class<? extends Enum> eventType, EventHandler handler) {
            for (AsyncDispatcher dispatcher : this.dispatchers) {
                dispatcher.register(eventType, handler);
            }
        }

        public void setDrainEventsOnStop() {
            for (AsyncDispatcher dispatcher : this.dispatchers) {
                dispatcher.setDrainEventsOnStop();
            }
        }

        protected AsyncDispatcher createDispatcher() {
            return new AsyncDispatcher();
        }

        private class CompositEventHandler
        implements EventHandler<Event> {
            private CompositEventHandler() {
            }

            public void handle(Event event) {
                int index = (event.hashCode() & Integer.MAX_VALUE) % MultiThreadedDispatcher.this.dispatchers.size();
                ((AsyncDispatcher)MultiThreadedDispatcher.this.dispatchers.get(index)).getEventHandler().handle(event);
            }
        }
    }

    private final class ForwardingEventHandler
    implements EventHandler<SystemMetricsEvent> {
        private ForwardingEventHandler() {
        }

        public void handle(SystemMetricsEvent event) {
            SystemMetricsPublisher.this.handleSystemMetricsEvent(event);
        }
    }
}

