/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity;

import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.LeafQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.common.fica.FiCaSchedulerApp;

public class CapacityHeadroomProvider {
    LeafQueue.User user;
    LeafQueue queue;
    FiCaSchedulerApp application;
    Resource required;
    LeafQueue.QueueResourceLimitsInfo queueResourceLimitsInfo;

    public CapacityHeadroomProvider(LeafQueue.User user, LeafQueue queue, FiCaSchedulerApp application, Resource required, LeafQueue.QueueResourceLimitsInfo queueResourceLimitsInfo) {
        this.user = user;
        this.queue = queue;
        this.application = application;
        this.required = required;
        this.queueResourceLimitsInfo = queueResourceLimitsInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Resource getHeadroom() {
        Resource clusterResource;
        Resource queueCurrentLimit;
        LeafQueue.QueueResourceLimitsInfo queueResourceLimitsInfo = this.queueResourceLimitsInfo;
        synchronized (queueResourceLimitsInfo) {
            queueCurrentLimit = this.queueResourceLimitsInfo.getQueueCurrentLimit();
            clusterResource = this.queueResourceLimitsInfo.getClusterResource();
        }
        Resource headroom = this.queue.getHeadroom(this.user, queueCurrentLimit, clusterResource, this.application, this.required);
        if (headroom.getMemory() < 0) {
            headroom.setMemory(0);
        }
        return headroom;
    }
}

