/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.common.jsonexplain.tez;

import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.common.jsonexplain.tez.Attr;
import org.apache.hadoop.hive.common.jsonexplain.tez.Connection;
import org.apache.hadoop.hive.common.jsonexplain.tez.Op;
import org.apache.hadoop.hive.common.jsonexplain.tez.TezJsonParser;
import org.apache.hadoop.hive.common.jsonexplain.tez.Vertex;
import org.codehaus.jackson.JsonParseException;
import org.codehaus.jackson.map.JsonMappingException;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class Stage {
    String name;
    List<Stage> parentStages;
    List<Stage> childStages;
    Map<String, Vertex> vertexs;
    List<Attr> attrs;
    LinkedHashMap<Vertex, List<Connection>> tezStageDependency;
    Op op;

    public Stage(String name) {
        this.name = name;
        this.parentStages = new ArrayList<Stage>();
        this.childStages = new ArrayList<Stage>();
        this.attrs = new ArrayList<Attr>();
        this.vertexs = new LinkedHashMap<String, Vertex>();
    }

    public void addDependency(JSONObject object, Map<String, Stage> stages) throws JSONException {
        if (!object.has("ROOT STAGE")) {
            String names = object.getString("DEPENDENT STAGES");
            for (String name : names.split(",")) {
                Stage parent = stages.get(name.trim());
                this.parentStages.add(parent);
                parent.childStages.add(this);
            }
        }
    }

    public void extractVertex(JSONObject object) throws Exception {
        if (object.has("Tez")) {
            this.tezStageDependency = new LinkedHashMap();
            JSONObject tez = (JSONObject)object.get("Tez");
            JSONObject vertices = tez.getJSONObject("Vertices:");
            if (tez.has("Edges:")) {
                JSONObject edges = tez.getJSONObject("Edges:");
                for (String to : JSONObject.getNames((JSONObject)edges)) {
                    this.vertexs.put(to, new Vertex(to, vertices.getJSONObject(to)));
                }
                for (String to : JSONObject.getNames((JSONObject)edges)) {
                    Object o = edges.get(to);
                    Vertex v = this.vertexs.get(to);
                    if (o instanceof JSONObject) {
                        String type;
                        JSONObject obj = (JSONObject)o;
                        String parent = obj.getString("parent");
                        Vertex parentVertex = this.vertexs.get(parent);
                        if (parentVertex == null) {
                            parentVertex = new Vertex(parent, vertices.getJSONObject(parent));
                            this.vertexs.put(parent, parentVertex);
                        }
                        if (!"CONTAINS".equals(type = obj.getString("type"))) {
                            v.addDependency(new Connection(type, parentVertex));
                            parentVertex.children.add(v);
                        } else {
                            parentVertex.addDependency(new Connection(type, v));
                            v.children.add(parentVertex);
                        }
                        this.tezStageDependency.put(v, Arrays.asList(new Connection(type, parentVertex)));
                        continue;
                    }
                    JSONArray from = (JSONArray)o;
                    ArrayList<Connection> list = new ArrayList<Connection>();
                    for (int index = 0; index < from.length(); ++index) {
                        String type;
                        JSONObject obj = from.getJSONObject(index);
                        String parent = obj.getString("parent");
                        Vertex parentVertex = this.vertexs.get(parent);
                        if (parentVertex == null) {
                            parentVertex = new Vertex(parent, vertices.getJSONObject(parent));
                            this.vertexs.put(parent, parentVertex);
                        }
                        if (!"CONTAINS".equals(type = obj.getString("type"))) {
                            v.addDependency(new Connection(type, parentVertex));
                            parentVertex.children.add(v);
                        } else {
                            parentVertex.addDependency(new Connection(type, v));
                            v.children.add(parentVertex);
                        }
                        list.add(new Connection(type, parentVertex));
                    }
                    this.tezStageDependency.put(v, list);
                }
            } else {
                for (String vertexName : JSONObject.getNames((JSONObject)vertices)) {
                    this.vertexs.put(vertexName, new Vertex(vertexName, vertices.getJSONObject(vertexName)));
                }
            }
            for (Vertex v : this.vertexs.values()) {
                if (v.union) continue;
                v.extractOpTree();
                v.checkMultiReduceOperator();
            }
        } else {
            String[] names;
            for (String name : names = JSONObject.getNames((JSONObject)object)) {
                if (name.contains("Operator")) {
                    this.op = this.extractOp(name, object.getJSONObject(name));
                    continue;
                }
                this.attrs.add(new Attr(name, object.get(name).toString()));
            }
        }
    }

    Op extractOp(String opName, JSONObject opObj) throws JSONException, JsonParseException, JsonMappingException, IOException, Exception {
        ArrayList<Attr> attrs = new ArrayList<Attr>();
        Vertex v = null;
        if (opObj.length() > 0) {
            String[] names;
            for (String name : names = JSONObject.getNames((JSONObject)opObj)) {
                Object o = opObj.get(name);
                if (this.isPrintable(o)) {
                    attrs.add(new Attr(name, o.toString()));
                    continue;
                }
                if (o instanceof JSONObject) {
                    JSONObject attrObj = (JSONObject)o;
                    if (attrObj.length() <= 0) continue;
                    if (name.equals("Processor Tree:")) {
                        JSONObject object = new JSONObject();
                        object.put(name, (Object)attrObj);
                        v = new Vertex(null, object);
                        v.extractOpTree();
                        continue;
                    }
                    for (String attrName : JSONObject.getNames((JSONObject)attrObj)) {
                        attrs.add(new Attr(attrName, attrObj.get(attrName).toString()));
                    }
                    continue;
                }
                throw new Exception("Unsupported object in " + this.name);
            }
        }
        Op op = new Op(opName, null, null, null, attrs, null, v);
        if (v != null) {
            TezJsonParser.addInline(op, new Connection(null, v));
        }
        return op;
    }

    private boolean isPrintable(Object val) {
        if (val instanceof Boolean || val instanceof String || val instanceof Integer || val instanceof Long || val instanceof Byte || val instanceof Float || val instanceof Double || val instanceof Path) {
            return true;
        }
        return val != null && val.getClass().isPrimitive();
    }

    public void print(PrintStream out, List<Boolean> indentFlag) throws JSONException, Exception {
        if (TezJsonParser.printSet.contains(this)) {
            out.println(TezJsonParser.prefixString(indentFlag) + " Please refer to the previous " + this.name);
            return;
        }
        TezJsonParser.printSet.add(this);
        out.println(TezJsonParser.prefixString(indentFlag) + this.name);
        ArrayList<Boolean> nextIndentFlag = new ArrayList<Boolean>();
        nextIndentFlag.addAll(indentFlag);
        nextIndentFlag.add(false);
        for (Vertex candidate : this.vertexs.values()) {
            if (TezJsonParser.isInline(candidate) || !candidate.children.isEmpty()) continue;
            candidate.print(out, nextIndentFlag, null, null);
        }
        if (!this.attrs.isEmpty()) {
            Collections.sort(this.attrs);
            for (Attr attr : this.attrs) {
                out.println(TezJsonParser.prefixString(nextIndentFlag) + attr.toString());
            }
        }
        if (this.op != null) {
            this.op.print(out, nextIndentFlag, false);
        }
        nextIndentFlag.add(false);
        for (Stage stage : this.parentStages) {
            stage.print(out, nextIndentFlag);
        }
    }
}

