/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.security.access;

import com.google.protobuf.BlockingRpcChannel;
import com.google.protobuf.RpcController;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.MasterNotRunningException;
import org.apache.hadoop.hbase.NamespaceDescriptor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.ZooKeeperConnectionException;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.classification.InterfaceStability;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.ClusterConnection;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.security.SecurityCapability;
import org.apache.hadoop.hbase.ipc.CoprocessorRpcChannel;
import org.apache.hadoop.hbase.ipc.PayloadCarryingRpcController;
import org.apache.hadoop.hbase.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.protobuf.generated.AccessControlProtos;
import org.apache.hadoop.hbase.security.access.Permission;
import org.apache.hadoop.hbase.security.access.UserPermission;
import org.apache.hadoop.hbase.util.Bytes;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class AccessControlClient {
    public static final TableName ACL_TABLE_NAME = TableName.valueOf((String)NamespaceDescriptor.SYSTEM_NAMESPACE_NAME_STR, (String)"acl");

    public static boolean isAuthorizationEnabled(Connection connection) throws IOException {
        return connection.getAdmin().getSecurityCapabilities().contains((Object)SecurityCapability.AUTHORIZATION);
    }

    public static boolean isCellAuthorizationEnabled(Connection connection) throws IOException {
        return connection.getAdmin().getSecurityCapabilities().contains((Object)SecurityCapability.CELL_AUTHORIZATION);
    }

    private static AccessControlProtos.AccessControlService.BlockingInterface getAccessControlServiceStub(Table ht) throws IOException {
        CoprocessorRpcChannel service = ht.coprocessorService(HConstants.EMPTY_START_ROW);
        AccessControlProtos.AccessControlService.BlockingInterface protocol = AccessControlProtos.AccessControlService.newBlockingStub((BlockingRpcChannel)service);
        return protocol;
    }

    public static void grant(Connection connection, TableName tableName, String userName, byte[] family, byte[] qual, Permission.Action ... actions) throws Throwable {
        PayloadCarryingRpcController controller = ((ClusterConnection)connection).getRpcControllerFactory().newController();
        controller.setPriority(tableName);
        try (Table table = connection.getTable(ACL_TABLE_NAME);){
            ProtobufUtil.grant((RpcController)controller, AccessControlClient.getAccessControlServiceStub(table), userName, tableName, family, qual, actions);
        }
    }

    public static void grant(Connection connection, String namespace, String userName, Permission.Action ... actions) throws Throwable {
        PayloadCarryingRpcController controller = ((ClusterConnection)connection).getRpcControllerFactory().newController();
        try (Table table = connection.getTable(ACL_TABLE_NAME);){
            ProtobufUtil.grant((RpcController)controller, AccessControlClient.getAccessControlServiceStub(table), userName, namespace, actions);
        }
    }

    public static void grant(Connection connection, String userName, Permission.Action ... actions) throws Throwable {
        PayloadCarryingRpcController controller = ((ClusterConnection)connection).getRpcControllerFactory().newController();
        try (Table table = connection.getTable(ACL_TABLE_NAME);){
            ProtobufUtil.grant((RpcController)controller, AccessControlClient.getAccessControlServiceStub(table), userName, actions);
        }
    }

    public static boolean isAccessControllerRunning(Connection connection) throws MasterNotRunningException, ZooKeeperConnectionException, IOException {
        try (Admin admin = connection.getAdmin();){
            boolean bl = admin.isTableAvailable(ACL_TABLE_NAME);
            return bl;
        }
    }

    public static void revoke(Connection connection, TableName tableName, String username, byte[] family, byte[] qualifier, Permission.Action ... actions) throws Throwable {
        PayloadCarryingRpcController controller = ((ClusterConnection)connection).getRpcControllerFactory().newController();
        controller.setPriority(tableName);
        try (Table table = connection.getTable(ACL_TABLE_NAME);){
            ProtobufUtil.revoke((RpcController)controller, AccessControlClient.getAccessControlServiceStub(table), username, tableName, family, qualifier, actions);
        }
    }

    public static void revoke(Connection connection, String namespace, String userName, Permission.Action ... actions) throws Throwable {
        PayloadCarryingRpcController controller = ((ClusterConnection)connection).getRpcControllerFactory().newController();
        try (Table table = connection.getTable(ACL_TABLE_NAME);){
            ProtobufUtil.revoke((RpcController)controller, AccessControlClient.getAccessControlServiceStub(table), userName, namespace, actions);
        }
    }

    public static void revoke(Connection connection, String userName, Permission.Action ... actions) throws Throwable {
        PayloadCarryingRpcController controller = ((ClusterConnection)connection).getRpcControllerFactory().newController();
        try (Table table = connection.getTable(ACL_TABLE_NAME);){
            ProtobufUtil.revoke((RpcController)controller, AccessControlClient.getAccessControlServiceStub(table), userName, actions);
        }
    }

    public static List<UserPermission> getUserPermissions(Connection connection, String tableRegex) throws Throwable {
        PayloadCarryingRpcController controller = ((ClusterConnection)connection).getRpcControllerFactory().newController();
        ArrayList<UserPermission> permList = new ArrayList();
        try (Table table = connection.getTable(ACL_TABLE_NAME);
             Admin admin = connection.getAdmin();){
            CoprocessorRpcChannel service = table.coprocessorService(HConstants.EMPTY_START_ROW);
            AccessControlProtos.AccessControlService.BlockingInterface protocol = AccessControlProtos.AccessControlService.newBlockingStub((BlockingRpcChannel)service);
            HTableDescriptor[] htds = null;
            if (tableRegex == null || tableRegex.isEmpty()) {
                permList = ProtobufUtil.getUserPermissions(controller, protocol);
            } else if (tableRegex.charAt(0) == '@') {
                String namespaceRegex = tableRegex.substring(1);
                for (NamespaceDescriptor nsds : admin.listNamespaceDescriptors()) {
                    String namespace = nsds.getName();
                    if (!namespace.matches(namespaceRegex)) continue;
                    permList.addAll(ProtobufUtil.getUserPermissions((RpcController)controller, protocol, Bytes.toBytes((String)namespace)));
                }
            } else {
                for (HTableDescriptor hd : htds = admin.listTables(Pattern.compile(tableRegex), true)) {
                    permList.addAll(ProtobufUtil.getUserPermissions((RpcController)controller, protocol, hd.getTableName()));
                }
            }
        }
        return permList;
    }

    @Deprecated
    public static void grant(Configuration conf, TableName tableName, String userName, byte[] family, byte[] qual, Permission.Action ... actions) throws Throwable {
        try (Connection connection = ConnectionFactory.createConnection(conf);){
            AccessControlClient.grant(connection, tableName, userName, family, qual, actions);
        }
    }

    @Deprecated
    public static void grant(Configuration conf, String namespace, String userName, Permission.Action ... actions) throws Throwable {
        try (Connection connection = ConnectionFactory.createConnection(conf);){
            AccessControlClient.grant(connection, namespace, userName, actions);
        }
    }

    @Deprecated
    public static void grant(Configuration conf, String userName, Permission.Action ... actions) throws Throwable {
        try (Connection connection = ConnectionFactory.createConnection(conf);){
            AccessControlClient.grant(connection, userName, actions);
        }
    }

    @Deprecated
    public static boolean isAccessControllerRunning(Configuration conf) throws MasterNotRunningException, ZooKeeperConnectionException, IOException {
        try (Connection connection = ConnectionFactory.createConnection(conf);){
            boolean bl = AccessControlClient.isAccessControllerRunning(connection);
            return bl;
        }
    }

    @Deprecated
    public static void revoke(Configuration conf, TableName tableName, String username, byte[] family, byte[] qualifier, Permission.Action ... actions) throws Throwable {
        try (Connection connection = ConnectionFactory.createConnection(conf);){
            AccessControlClient.revoke(connection, tableName, username, family, qualifier, actions);
        }
    }

    @Deprecated
    public static void revoke(Configuration conf, String namespace, String userName, Permission.Action ... actions) throws Throwable {
        try (Connection connection = ConnectionFactory.createConnection(conf);){
            AccessControlClient.revoke(connection, namespace, userName, actions);
        }
    }

    @Deprecated
    public static void revoke(Configuration conf, String userName, Permission.Action ... actions) throws Throwable {
        try (Connection connection = ConnectionFactory.createConnection(conf);){
            AccessControlClient.revoke(connection, userName, actions);
        }
    }

    @Deprecated
    public static List<UserPermission> getUserPermissions(Configuration conf, String tableRegex) throws Throwable {
        try (Connection connection = ConnectionFactory.createConnection(conf);){
            List<UserPermission> list = AccessControlClient.getUserPermissions(connection, tableRegex);
            return list;
        }
    }
}

