/*
 * Decompiled with CFR 0.152.
 */
package tachyon.underfs.s3;

import com.google.common.base.Preconditions;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.DigestOutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tachyon.Constants;
import tachyon.org.jets3t.service.S3Service;
import tachyon.org.jets3t.service.ServiceException;
import tachyon.org.jets3t.service.model.S3Object;
import tachyon.util.io.PathUtils;

public class S3OutputStream
extends OutputStream {
    private static final Logger LOG = LoggerFactory.getLogger((String)Constants.LOGGER_TYPE);
    private final String mBucketName;
    private final String mKey;
    private final File mFile;
    private final S3Service mClient;
    private OutputStream mLocalOutputStream;
    private MessageDigest mHash;
    private boolean mClosed;

    public S3OutputStream(String bucketName, String key, S3Service client) throws IOException {
        Preconditions.checkArgument((bucketName != null && !bucketName.isEmpty() ? 1 : 0) != 0, (Object)"Bucket name must not be null or empty.");
        this.mBucketName = bucketName;
        this.mKey = key;
        this.mClient = client;
        this.mFile = new File(PathUtils.concatPath((Object)"/tmp", (Object[])new Object[]{UUID.randomUUID()}));
        try {
            this.mHash = MessageDigest.getInstance("MD5");
            this.mLocalOutputStream = new BufferedOutputStream(new DigestOutputStream(new FileOutputStream(this.mFile), this.mHash));
        }
        catch (NoSuchAlgorithmException nsae) {
            LOG.warn("Algorithm not available for MD5 hash.", (Throwable)nsae);
            this.mHash = null;
            this.mLocalOutputStream = new BufferedOutputStream(new FileOutputStream(this.mFile));
        }
        this.mClosed = false;
    }

    @Override
    public void write(int b) throws IOException {
        this.mLocalOutputStream.write(b);
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.mLocalOutputStream.write(b, 0, b.length);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.mLocalOutputStream.write(b, off, len);
    }

    @Override
    public void flush() throws IOException {
        this.mLocalOutputStream.flush();
    }

    @Override
    public void close() throws IOException {
        if (this.mClosed) {
            return;
        }
        this.mClosed = true;
        this.mLocalOutputStream.close();
        try {
            S3Object obj = new S3Object(this.mKey);
            obj.setBucketName(this.mBucketName);
            obj.setDataInputFile(this.mFile);
            obj.setContentLength(this.mFile.length());
            obj.setContentEncoding("binary/octet-stream");
            if (this.mHash != null) {
                obj.setMd5Hash(this.mHash.digest());
            } else {
                LOG.warn("MD5 was not computed for: " + this.mKey);
            }
            this.mClient.putObject(this.mBucketName, obj);
            this.mFile.delete();
        }
        catch (ServiceException se) {
            LOG.error("Failed to upload " + this.mKey + ". Temporary file @ " + this.mFile.getPath());
            throw new IOException(se);
        }
    }
}

