/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server.master.tableOps;

import org.apache.accumulo.core.client.impl.thrift.ThriftSecurityException;
import org.apache.accumulo.core.security.TablePermission;
import org.apache.accumulo.fate.Repo;
import org.apache.accumulo.server.master.Master;
import org.apache.accumulo.server.master.tableOps.CloneInfo;
import org.apache.accumulo.server.master.tableOps.CloneZookeeper;
import org.apache.accumulo.server.master.tableOps.FinishCloneTable;
import org.apache.accumulo.server.master.tableOps.MasterRepo;
import org.apache.accumulo.server.security.AuditedSecurityOperation;
import org.apache.accumulo.server.security.SecurityConstants;
import org.apache.log4j.Logger;

class ClonePermissions
extends MasterRepo {
    private static final long serialVersionUID = 1L;
    private CloneInfo cloneInfo;

    public ClonePermissions(CloneInfo cloneInfo) {
        this.cloneInfo = cloneInfo;
    }

    @Override
    public long isReady(long tid, Master environment) throws Exception {
        return 0L;
    }

    @Override
    public Repo<Master> call(long tid, Master environment) throws Exception {
        for (TablePermission permission : TablePermission.values()) {
            try {
                AuditedSecurityOperation.getInstance().grantTablePermission(SecurityConstants.getSystemCredentials(), this.cloneInfo.user, this.cloneInfo.tableId, permission);
            }
            catch (ThriftSecurityException e) {
                Logger.getLogger(FinishCloneTable.class).error((Object)e.getMessage(), (Throwable)e);
                throw e;
            }
        }
        return new CloneZookeeper(this.cloneInfo);
    }

    @Override
    public void undo(long tid, Master environment) throws Exception {
        AuditedSecurityOperation.getInstance().deleteTable(SecurityConstants.getSystemCredentials(), this.cloneInfo.tableId);
    }
}

