/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server.master.tableOps;

import org.apache.accumulo.core.client.Instance;
import org.apache.accumulo.core.client.impl.Tables;
import org.apache.accumulo.core.client.impl.thrift.TableOperation;
import org.apache.accumulo.fate.Repo;
import org.apache.accumulo.fate.zookeeper.ZooUtil;
import org.apache.accumulo.server.client.HdfsZooInstance;
import org.apache.accumulo.server.master.Master;
import org.apache.accumulo.server.master.state.tables.TableManager;
import org.apache.accumulo.server.master.tableOps.CloneInfo;
import org.apache.accumulo.server.master.tableOps.CloneMetadata;
import org.apache.accumulo.server.master.tableOps.MasterRepo;
import org.apache.accumulo.server.master.tableOps.Utils;

class CloneZookeeper
extends MasterRepo {
    private static final long serialVersionUID = 1L;
    private CloneInfo cloneInfo;

    public CloneZookeeper(CloneInfo cloneInfo) {
        this.cloneInfo = cloneInfo;
    }

    @Override
    public long isReady(long tid, Master environment) throws Exception {
        return Utils.reserveTable(this.cloneInfo.tableId, tid, true, false, TableOperation.CLONE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Repo<Master> call(long tid, Master environment) throws Exception {
        Utils.tableNameLock.lock();
        try {
            Instance instance = HdfsZooInstance.getInstance();
            Utils.checkTableDoesNotExist(instance, this.cloneInfo.tableName, this.cloneInfo.tableId, TableOperation.CLONE);
            TableManager.getInstance().cloneTable(this.cloneInfo.srcTableId, this.cloneInfo.tableId, this.cloneInfo.tableName, this.cloneInfo.propertiesToSet, this.cloneInfo.propertiesToExclude, ZooUtil.NodeExistsPolicy.OVERWRITE);
            Tables.clearCache((Instance)instance);
            CloneMetadata cloneMetadata = new CloneMetadata(this.cloneInfo);
            return cloneMetadata;
        }
        finally {
            Utils.tableNameLock.unlock();
        }
    }

    @Override
    public void undo(long tid, Master environment) throws Exception {
        Instance instance = HdfsZooInstance.getInstance();
        TableManager.getInstance().removeTable(this.cloneInfo.tableId);
        Utils.unreserveTable(this.cloneInfo.tableId, tid, true);
        Tables.clearCache((Instance)instance);
    }
}

