/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server.master.tableOps;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.accumulo.core.Constants;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.IsolatedScanner;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.KeyExtent;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.fate.Repo;
import org.apache.accumulo.server.client.HdfsZooInstance;
import org.apache.accumulo.server.master.LiveTServerSet;
import org.apache.accumulo.server.master.Master;
import org.apache.accumulo.server.master.state.TServerInstance;
import org.apache.accumulo.server.master.tableOps.CleanUpBulkImport;
import org.apache.accumulo.server.master.tableOps.MasterRepo;
import org.apache.accumulo.server.zookeeper.DistributedWorkQueue;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Text;
import org.apache.thrift.TException;

class CopyFailed
extends MasterRepo {
    private static final long serialVersionUID = 1L;
    private String tableId;
    private String source;
    private String bulk;
    private String error;

    public CopyFailed(String tableId, String source, String bulk, String error) {
        this.tableId = tableId;
        this.source = source;
        this.bulk = bulk;
        this.error = error;
    }

    @Override
    public long isReady(long tid, Master master) throws Exception {
        HashSet<TServerInstance> finished = new HashSet<TServerInstance>();
        Set<TServerInstance> running = master.onlineTabletServers();
        for (TServerInstance server : running) {
            try {
                LiveTServerSet.TServerConnection client = master.getConnection(server);
                if (client == null || client.isActive(tid)) continue;
                finished.add(server);
            }
            catch (TException ex) {
                log.info((Object)("Ignoring error trying to check on tid " + tid + " from server " + server + ": " + (Object)((Object)ex)));
            }
        }
        if (finished.containsAll(running)) {
            return 0L;
        }
        return 500L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Repo<Master> call(long tid, Master master) throws Exception {
        FileSystem fs = master.getFileSystem();
        if (!fs.exists(new Path(this.error, "failures.txt"))) {
            return new CleanUpBulkImport(this.tableId, this.source, this.bulk, this.error);
        }
        HashMap<String, String> failures = new HashMap<String, String>();
        HashMap<String, String> loadedFailures = new HashMap<String, String>();
        FSDataInputStream failFile = fs.open(new Path(this.error, "failures.txt"));
        BufferedReader in = new BufferedReader(new InputStreamReader((InputStream)failFile));
        try {
            String line = null;
            while ((line = in.readLine()) != null) {
                Path path = new Path(line);
                if (fs.exists(new Path(this.error, path.getName()))) continue;
                failures.put("/" + path.getParent().getName() + "/" + path.getName(), line);
            }
        }
        finally {
            failFile.close();
        }
        Connector conn = master.getConnector();
        IsolatedScanner mscanner = new IsolatedScanner(conn.createScanner("!METADATA", Constants.NO_AUTHS));
        mscanner.setRange(new KeyExtent(new Text(this.tableId), null, null).toMetadataRange());
        mscanner.fetchColumnFamily(Constants.METADATA_BULKFILE_COLUMN_FAMILY);
        for (Map.Entry entry : mscanner) {
            String loadedFile;
            String absPath;
            if (Long.parseLong(((Value)entry.getValue()).toString()) != tid || (absPath = (String)failures.remove(loadedFile = ((Key)entry.getKey()).getColumnQualifier().toString())) == null) continue;
            loadedFailures.put(loadedFile, absPath);
        }
        for (String failure : failures.values()) {
            Path orig = new Path(failure);
            Path dest = new Path(this.error, orig.getName());
            fs.rename(orig, dest);
            log.debug((Object)("tid " + tid + " renamed " + orig + " to " + dest + ": import failed"));
        }
        if (loadedFailures.size() > 0) {
            DistributedWorkQueue bifCopyQueue = new DistributedWorkQueue("/accumulo/" + HdfsZooInstance.getInstance().getInstanceID() + "/bulk_failed_copyq");
            HashSet<String> workIds = new HashSet<String>();
            for (String failure : loadedFailures.values()) {
                Path orig = new Path(failure);
                Path dest = new Path(this.error, orig.getName());
                if (fs.exists(dest)) continue;
                bifCopyQueue.addWork(orig.getName(), (failure + "," + dest).getBytes());
                workIds.add(orig.getName());
                log.debug((Object)("tid " + tid + " added to copyq: " + orig + " to " + dest + ": failed"));
            }
            bifCopyQueue.waitUntilDone(workIds);
        }
        fs.delete(new Path(this.error, "failures.txt"), true);
        return new CleanUpBulkImport(this.tableId, this.source, this.bulk, this.error);
    }
}

