/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server.master.tableOps;

import org.apache.accumulo.core.client.impl.thrift.TableOperation;
import org.apache.accumulo.core.master.state.tables.TableState;
import org.apache.accumulo.fate.Repo;
import org.apache.accumulo.server.master.Master;
import org.apache.accumulo.server.master.state.tables.TableManager;
import org.apache.accumulo.server.master.tableOps.CleanUp;
import org.apache.accumulo.server.master.tableOps.MasterRepo;
import org.apache.accumulo.server.master.tableOps.Utils;

public class DeleteTable
extends MasterRepo {
    private static final long serialVersionUID = 1L;
    private String tableId;

    public DeleteTable(String tableId) {
        this.tableId = tableId;
    }

    @Override
    public long isReady(long tid, Master environment) throws Exception {
        return Utils.reserveTable(this.tableId, tid, true, true, TableOperation.DELETE);
    }

    @Override
    public Repo<Master> call(long tid, Master environment) throws Exception {
        TableManager.getInstance().transitionTableState(this.tableId, TableState.DELETING);
        environment.getEventCoordinator().event("deleting table %s ", this.tableId);
        return new CleanUp(this.tableId);
    }

    @Override
    public void undo(long tid, Master environment) throws Exception {
        Utils.unreserveTable(this.tableId, tid, true);
    }
}

