/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server.util;

import javax.servlet.http.HttpServlet;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.server.monitor.Monitor;
import org.mortbay.jetty.Connector;
import org.mortbay.jetty.Handler;
import org.mortbay.jetty.HandlerContainer;
import org.mortbay.jetty.Server;
import org.mortbay.jetty.bio.SocketConnector;
import org.mortbay.jetty.handler.ContextHandlerCollection;
import org.mortbay.jetty.security.SslSocketConnector;
import org.mortbay.jetty.servlet.Context;
import org.mortbay.jetty.servlet.SessionHandler;

public class EmbeddedWebServer {
    Server server = new Server();
    SocketConnector sock;
    ContextHandlerCollection handler = new ContextHandlerCollection();
    Context root = new Context((HandlerContainer)this.handler, "/", new SessionHandler(), null, null, null);
    boolean usingSsl;

    public EmbeddedWebServer() {
        this("0.0.0.0", 0);
    }

    public EmbeddedWebServer(String host, int port) {
        if (Monitor.getSystemConfiguration().get(Property.MONITOR_SSL_KEYSTORE) == "" || Monitor.getSystemConfiguration().get(Property.MONITOR_SSL_KEYSTOREPASS) == "" || Monitor.getSystemConfiguration().get(Property.MONITOR_SSL_TRUSTSTORE) == "" || Monitor.getSystemConfiguration().get(Property.MONITOR_SSL_TRUSTSTOREPASS) == "") {
            this.sock = new SocketConnector();
            this.usingSsl = false;
        } else {
            this.sock = new SslSocketConnector();
            ((SslSocketConnector)this.sock).setKeystore(Monitor.getSystemConfiguration().get(Property.MONITOR_SSL_KEYSTORE));
            ((SslSocketConnector)this.sock).setKeyPassword(Monitor.getSystemConfiguration().get(Property.MONITOR_SSL_KEYSTOREPASS));
            ((SslSocketConnector)this.sock).setTruststore(Monitor.getSystemConfiguration().get(Property.MONITOR_SSL_TRUSTSTORE));
            ((SslSocketConnector)this.sock).setTrustPassword(Monitor.getSystemConfiguration().get(Property.MONITOR_SSL_TRUSTSTOREPASS));
            this.usingSsl = true;
        }
        this.sock.setHost(host);
        this.sock.setPort(port);
    }

    public void addServlet(Class<? extends HttpServlet> klass, String where) {
        this.root.addServlet(klass, where);
    }

    public int getPort() {
        return this.sock.getLocalPort();
    }

    public void start() {
        try {
            this.server.addConnector((Connector)this.sock);
            this.server.setHandler((Handler)this.handler);
            this.server.start();
        }
        catch (Exception e) {
            this.stop();
            throw new RuntimeException(e);
        }
    }

    public void stop() {
        try {
            this.server.stop();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public boolean isUsingSsl() {
        return this.usingSsl;
    }
}

