/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.dag.app.dag.impl;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.tez.dag.api.EdgeManagerPluginContext;
import org.apache.tez.dag.api.EdgeManagerPluginOnDemand;
import org.apache.tez.runtime.api.events.DataMovementEvent;
import org.apache.tez.runtime.api.events.InputReadErrorEvent;

public class BroadcastEdgeManager
extends EdgeManagerPluginOnDemand {
    EdgeManagerPluginOnDemand.EventRouteMetadata[] commonRouteMeta;

    public BroadcastEdgeManager(EdgeManagerPluginContext context) {
        super(context);
    }

    public void initialize() {
    }

    public int getNumDestinationTaskPhysicalInputs(int destinationTaskIndex) {
        return this.getContext().getSourceVertexNumTasks();
    }

    public int getNumSourceTaskPhysicalOutputs(int sourceTaskIndex) {
        return 1;
    }

    public void routeDataMovementEventToDestination(DataMovementEvent event, int sourceTaskIndex, int sourceOutputIndex, Map<Integer, List<Integer>> destinationTaskAndInputIndices) {
        List<Integer> inputIndices = Collections.unmodifiableList(Collections.singletonList(sourceTaskIndex));
        for (int i = 0; i < this.getContext().getDestinationVertexNumTasks(); ++i) {
            destinationTaskAndInputIndices.put(i, inputIndices);
        }
    }

    public void prepareForRouting() throws Exception {
        int numSourceTasks = this.getContext().getSourceVertexNumTasks();
        this.commonRouteMeta = new EdgeManagerPluginOnDemand.EventRouteMetadata[numSourceTasks];
        for (int i = 0; i < numSourceTasks; ++i) {
            this.commonRouteMeta[i] = EdgeManagerPluginOnDemand.EventRouteMetadata.create((int)1, (int[])new int[]{i}, (int[])new int[]{0});
        }
    }

    public EdgeManagerPluginOnDemand.EventRouteMetadata routeDataMovementEventToDestination(int sourceTaskIndex, int sourceOutputIndex, int destinationTaskIndex) throws Exception {
        return this.commonRouteMeta[sourceTaskIndex];
    }

    public EdgeManagerPluginOnDemand.EventRouteMetadata routeCompositeDataMovementEventToDestination(int sourceTaskIndex, int destinationTaskIndex) throws Exception {
        return this.commonRouteMeta[sourceTaskIndex];
    }

    public EdgeManagerPluginOnDemand.EventRouteMetadata routeInputSourceTaskFailedEventToDestination(int sourceTaskIndex, int destinationTaskIndex) throws Exception {
        return this.commonRouteMeta[sourceTaskIndex];
    }

    public void routeInputSourceTaskFailedEventToDestination(int sourceTaskIndex, Map<Integer, List<Integer>> destinationTaskAndInputIndices) {
        List<Integer> inputIndices = Collections.unmodifiableList(Collections.singletonList(sourceTaskIndex));
        for (int i = 0; i < this.getContext().getDestinationVertexNumTasks(); ++i) {
            destinationTaskAndInputIndices.put(i, inputIndices);
        }
    }

    public int routeInputErrorEventToSource(int destinationTaskIndex, int destinationFailedInputIndex) throws Exception {
        return destinationFailedInputIndex;
    }

    public int routeInputErrorEventToSource(InputReadErrorEvent event, int destinationTaskIndex, int destinationFailedInputIndex) {
        return destinationFailedInputIndex;
    }

    public int getNumDestinationConsumerTasks(int sourceTaskIndex) {
        return this.getContext().getDestinationVertexNumTasks();
    }
}

