/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.dag.history.events;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.tez.common.VersionInfo;
import org.apache.tez.dag.history.HistoryEvent;
import org.apache.tez.dag.history.HistoryEventType;

public class AppLaunchedEvent
implements HistoryEvent {
    private ApplicationId applicationId;
    private long launchTime;
    private long appSubmitTime;
    private String user;
    private Configuration conf;
    private VersionInfo version;

    public AppLaunchedEvent() {
    }

    public AppLaunchedEvent(ApplicationId appId, long launchTime, long appSubmitTime, String user, Configuration conf, VersionInfo version) {
        this.applicationId = appId;
        this.launchTime = launchTime;
        this.appSubmitTime = appSubmitTime;
        this.user = user;
        this.conf = conf;
        this.version = version;
    }

    @Override
    public HistoryEventType getEventType() {
        return HistoryEventType.APP_LAUNCHED;
    }

    @Override
    public boolean isRecoveryEvent() {
        return false;
    }

    @Override
    public boolean isHistoryEvent() {
        return true;
    }

    @Override
    public void toProtoStream(OutputStream outputStream) throws IOException {
        throw new UnsupportedOperationException("Not a recovery event");
    }

    @Override
    public void fromProtoStream(InputStream inputStream) throws IOException {
        throw new UnsupportedOperationException("Not a recovery event");
    }

    public String toString() {
        return "applicationId=" + this.applicationId + ", appSubmitTime=" + this.appSubmitTime + ", launchTime=" + this.launchTime;
    }

    public ApplicationId getApplicationId() {
        return this.applicationId;
    }

    public long getLaunchTime() {
        return this.launchTime;
    }

    public long getAppSubmitTime() {
        return this.appSubmitTime;
    }

    public String getUser() {
        return this.user;
    }

    public Configuration getConf() {
        return this.conf;
    }

    public VersionInfo getVersion() {
        return this.version;
    }
}

