/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.backend.hadoop.executionengine.tez.plan.operator;

import java.io.ByteArrayOutputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import org.apache.hadoop.util.bloom.BloomFilter;
import org.apache.hadoop.util.bloom.Filter;
import org.apache.hadoop.util.bloom.Key;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.Result;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.Packager;
import org.apache.pig.builtin.BuildBloomBase;
import org.apache.pig.data.DataBag;
import org.apache.pig.data.DataByteArray;
import org.apache.pig.data.DataType;
import org.apache.pig.data.Tuple;

public class BloomPackager
extends Packager {
    private static final long serialVersionUID = 1L;
    private boolean bloomCreatedInMap;
    private int vectorSizeBytes;
    private int numHash;
    private int hashType;
    private byte bloomKeyType;
    private boolean isCombiner;
    private transient ByteArrayOutputStream baos;
    private transient Iterator<Object> distinctKeyIter;

    public BloomPackager(boolean bloomCreatedInMap, int vectorSizeBytes, int numHash, int hashType) {
        this.bloomCreatedInMap = bloomCreatedInMap;
        this.vectorSizeBytes = vectorSizeBytes;
        this.numHash = numHash;
        this.hashType = hashType;
    }

    public void setBloomKeyType(byte keyType) {
        this.bloomKeyType = keyType;
    }

    public void setCombiner(boolean isCombiner) {
        this.isCombiner = isCombiner;
    }

    @Override
    public void attachInput(Object key, DataBag[] bags, boolean[] readOnce) throws ExecException {
        this.key = key;
        this.bags = bags;
        this.readOnce = readOnce;
    }

    @Override
    public Result getNext() throws ExecException {
        try {
            if (this.bloomCreatedInMap) {
                if (this.bags == null) {
                    return new Result(3, null);
                }
                return this.combineBloomFilters();
            }
            if (this.isCombiner) {
                return this.getDistinctBloomKeys();
            }
            if (this.bags == null) {
                return new Result(3, null);
            }
            return this.createBloomFilter();
        }
        catch (IOException e) {
            throw new ExecException("Error while constructing final bloom filter", e);
        }
    }

    private Result combineBloomFilters() throws IOException {
        Iterator<Tuple> iter = this.bags[0].iterator();
        Tuple tup = iter.next();
        DataByteArray bloomBytes = (DataByteArray)tup.get(0);
        BloomFilter bloomFilter = BuildBloomBase.bloomIn(bloomBytes);
        while (iter.hasNext()) {
            tup = iter.next();
            bloomFilter.or((Filter)BuildBloomBase.bloomIn((DataByteArray)tup.get(0)));
        }
        Object partition = this.key;
        this.detachInput();
        return this.getSerializedBloomFilter(partition, bloomFilter, bloomBytes.get().length);
    }

    private Result createBloomFilter() throws IOException {
        HashSet<Object> bloomKeys = new HashSet<Object>();
        Iterator<Tuple> iter = this.bags[0].iterator();
        while (iter.hasNext()) {
            bloomKeys.add(iter.next().get(0));
        }
        Object partition = this.key;
        this.detachInput();
        BloomFilter bloomFilter = new BloomFilter(this.vectorSizeBytes * 8, this.numHash, this.hashType);
        for (Object e : bloomKeys) {
            Key k = new Key(DataType.toBytes(e, this.bloomKeyType));
            bloomFilter.add(k);
        }
        bloomKeys = null;
        return this.getSerializedBloomFilter(partition, bloomFilter, this.vectorSizeBytes + 64);
    }

    private Result getSerializedBloomFilter(Object partition, BloomFilter bloomFilter, int serializedSize) throws ExecException, IOException {
        if (this.baos == null) {
            this.baos = new ByteArrayOutputStream(serializedSize);
        }
        this.baos.reset();
        DataOutputStream dos = new DataOutputStream(this.baos);
        bloomFilter.write((DataOutput)dos);
        dos.flush();
        Tuple res = mTupleFactory.newTuple(2);
        res.set(0, partition);
        res.set(1, new DataByteArray(this.baos.toByteArray()));
        Result r = new Result();
        r.result = res;
        r.returnStatus = 0;
        return r;
    }

    private Result getDistinctBloomKeys() throws ExecException {
        if (this.distinctKeyIter == null) {
            HashSet<Object> bloomKeys = new HashSet<Object>();
            Iterator<Tuple> iter = this.bags[0].iterator();
            while (iter.hasNext()) {
                bloomKeys.add(iter.next().get(0));
            }
            this.distinctKeyIter = bloomKeys.iterator();
        }
        if (this.distinctKeyIter.hasNext()) {
            Tuple res = mTupleFactory.newTuple(2);
            res.set(0, this.key);
            res.set(1, this.distinctKeyIter.next());
            Result r = new Result();
            r.result = res;
            r.returnStatus = 0;
            return r;
        }
        this.distinctKeyIter = null;
        return new Result(3, null);
    }
}

