/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.backend.hadoop.executionengine.tez.plan.operator;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.PhysicalOperator;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.Result;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.plans.PhyPlanVisitor;
import org.apache.pig.backend.hadoop.executionengine.tez.plan.operator.POValueOutputTez;
import org.apache.pig.backend.hadoop.executionengine.tez.runtime.TezInput;
import org.apache.pig.backend.hadoop.executionengine.tez.runtime.TezOutput;
import org.apache.pig.data.Tuple;
import org.apache.pig.impl.plan.OperatorKey;
import org.apache.pig.impl.plan.VisitorException;
import org.apache.tez.runtime.api.LogicalInput;
import org.apache.tez.runtime.api.LogicalOutput;
import org.apache.tez.runtime.library.api.KeyValueWriter;
import org.apache.tez.runtime.library.api.KeyValuesReader;

public class POCounterStatsTez
extends PhysicalOperator
implements TezInput,
TezOutput {
    private static final long serialVersionUID = 1L;
    private static final Log LOG = LogFactory.getLog(POCounterStatsTez.class);
    private String inputKey;
    private String outputKey;
    private transient KeyValuesReader reader;
    private transient KeyValueWriter writer;
    private transient boolean finished = false;
    private transient boolean hasNext = false;

    public POCounterStatsTez(OperatorKey k) {
        super(k);
    }

    @Override
    public String[] getTezInputs() {
        return new String[]{this.inputKey};
    }

    @Override
    public void replaceInput(String oldInputKey, String newInputKey) {
        if (oldInputKey.equals(this.inputKey)) {
            this.inputKey = newInputKey;
        }
    }

    @Override
    public void addInputsToSkip(Set<String> inputsToSkip) {
    }

    @Override
    public void attachInputs(Map<String, LogicalInput> inputs, Configuration conf) throws ExecException {
        LogicalInput input = inputs.get(this.inputKey);
        if (input == null) {
            throw new ExecException("Input from vertex " + this.inputKey + " is missing");
        }
        try {
            this.reader = (KeyValuesReader)input.getReader();
            LOG.info((Object)("Attached input from vertex " + this.inputKey + " : input=" + input + ", reader=" + this.reader));
            this.hasNext = this.reader.next();
        }
        catch (Exception e) {
            throw new ExecException(e);
        }
    }

    @Override
    public String[] getTezOutputs() {
        return new String[]{this.outputKey};
    }

    @Override
    public void replaceOutput(String oldOutputKey, String newOutputKey) {
        if (oldOutputKey.equals(this.outputKey)) {
            this.outputKey = newOutputKey;
        }
    }

    @Override
    public void attachOutputs(Map<String, LogicalOutput> outputs, Configuration conf) throws ExecException {
        LogicalOutput output = outputs.get(this.outputKey);
        if (output == null) {
            throw new ExecException("Output to vertex " + this.outputKey + " is missing");
        }
        try {
            this.writer = (KeyValueWriter)output.getWriter();
            LOG.info((Object)("Attached output to vertex " + this.outputKey + " : output=" + output + ", writer=" + this.writer));
        }
        catch (Exception e) {
            throw new ExecException(e);
        }
    }

    @Override
    public Result getNextTuple() throws ExecException {
        try {
            if (this.finished) {
                return RESULT_EOP;
            }
            HashMap<Integer, Long> counterRecords = new HashMap<Integer, Long>();
            Integer key = null;
            Long value = null;
            while (this.hasNext) {
                key = ((IntWritable)this.reader.getCurrentKey()).get();
                for (Object val : this.reader.getCurrentValues()) {
                    value = ((LongWritable)val).get();
                    counterRecords.put(key, value);
                }
                this.hasNext = this.reader.next();
            }
            HashMap<String, Long> counterOffsets = new HashMap<String, Long>();
            Long prevTasksCount = (Long)counterRecords.get(0);
            counterOffsets.put("0", 0L);
            for (int i = 1; i < counterRecords.size(); ++i) {
                counterOffsets.put("" + i, prevTasksCount);
                prevTasksCount = prevTasksCount + (Long)counterRecords.get(i);
            }
            Tuple tuple = mTupleFactory.newTuple(1);
            tuple.set(0, counterOffsets);
            this.writer.write((Object)POValueOutputTez.EMPTY_KEY, (Object)tuple);
            this.finished = true;
            return RESULT_EOP;
        }
        catch (IOException e) {
            throw new ExecException(e);
        }
    }

    public void setInputKey(String inputKey) {
        this.inputKey = inputKey;
    }

    public void setOutputKey(String outputKey) {
        this.outputKey = outputKey;
    }

    @Override
    public Tuple illustratorMarkup(Object in, Object out, int eqClassIndex) {
        return null;
    }

    @Override
    public void visit(PhyPlanVisitor v) throws VisitorException {
        v.visit(this);
    }

    @Override
    public boolean supportsMultipleInputs() {
        return false;
    }

    @Override
    public boolean supportsMultipleOutputs() {
        return false;
    }

    @Override
    public String name() {
        return "PORankStatsTez - " + this.mKey.toString() + "\t<-\t " + this.inputKey + "\t->\t " + this.outputKey;
    }
}

