/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.builtin;

import java.io.IOException;
import org.apache.pig.EvalFunc;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.data.DataBag;
import org.apache.pig.data.DataType;
import org.apache.pig.data.Tuple;
import org.apache.pig.impl.logicalLayer.FrontendException;
import org.apache.pig.impl.logicalLayer.schema.Schema;

public class BagToString
extends EvalFunc<String> {
    private static final String USAGE_STRING = "Usage BagToString(dataBag) or BagToString(dataBag, delimiter)";
    private static final String DEFAULT_DELIMITER = "_";

    @Override
    public String exec(Tuple inputTuple) throws IOException {
        if (inputTuple.size() != 1 && inputTuple.size() != 2) {
            throw new ExecException(USAGE_STRING, 2);
        }
        Object firstArg = inputTuple.get(0);
        if (firstArg == null) {
            return null;
        }
        if (!(firstArg instanceof DataBag)) {
            throw new ExecException("Usage BagToString(dataBag) or BagToString(dataBag, delimiter) found type " + firstArg.getClass().getName(), 2);
        }
        if (inputTuple.size() == 2 && !(inputTuple.get(1) instanceof String)) {
            throw new ExecException("Usage BagToTuple(DataBag, String)", 2);
        }
        DataBag bag = (DataBag)inputTuple.get(0);
        String delimeter = DEFAULT_DELIMITER;
        if (inputTuple.size() == 2) {
            delimeter = (String)inputTuple.get(1);
        }
        StringBuilder buffer = new StringBuilder();
        try {
            for (Tuple t : bag) {
                if (t == null) continue;
                for (int i = 0; i < t.size(); ++i) {
                    if (buffer.length() > 0) {
                        buffer.append(delimeter);
                    }
                    buffer.append(t.get(i));
                }
            }
            return buffer.toString();
        }
        catch (Exception e) {
            String msg = "Encourntered error while flattening a bag " + this.getClass().getSimpleName();
            throw new ExecException(msg, 4, e);
        }
    }

    @Override
    public Schema outputSchema(Schema inputSchema) {
        try {
            if (inputSchema == null || inputSchema.size() != 1 && inputSchema.size() != 2) {
                throw new RuntimeException("Expecting 2 inputs, found: " + (inputSchema == null ? 0 : inputSchema.size()));
            }
            Schema.FieldSchema inputFieldSchema = inputSchema.getField(0);
            if (inputFieldSchema.type != 120) {
                throw new RuntimeException("Expecting a bag of tuples: {()}, found data type: " + DataType.findTypeName(inputFieldSchema.type));
            }
            Schema.FieldSchema firstFieldSchema = inputFieldSchema.schema.getField(0);
            if (firstFieldSchema == null || firstFieldSchema.schema == null || firstFieldSchema.schema.size() < 1) {
                throw new RuntimeException("Expecting a bag and a delimeter, found: " + inputSchema);
            }
            if (firstFieldSchema.type != 110) {
                throw new RuntimeException("Expecting a bag and a delimeter, found: " + inputSchema);
            }
            if (inputSchema.size() == 2) {
                Schema.FieldSchema secondInputFieldSchema = inputSchema.getField(1);
                if (secondInputFieldSchema.type != 55) {
                    throw new RuntimeException("Expecting a bag and a delimeter, found: " + inputSchema);
                }
            }
            return new Schema(new Schema.FieldSchema(null, 55));
        }
        catch (FrontendException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public boolean allowCompileTimeCalculation() {
        return true;
    }
}

