/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.data;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Iterator;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.Packager;
import org.apache.pig.data.DataBag;
import org.apache.pig.data.Tuple;
import org.apache.pig.impl.io.NullableTuple;
import org.apache.pig.impl.io.PigNullableWritable;

public class ReadOnceBag
implements DataBag {
    protected Packager pkgr;
    protected transient Iterator<NullableTuple> tupIter;
    protected PigNullableWritable keyWritable;
    private static final long serialVersionUID = 2L;

    public ReadOnceBag() {
    }

    public ReadOnceBag(Packager pkgr, Iterator<NullableTuple> tupIter, PigNullableWritable keyWritable) {
        this.pkgr = pkgr;
        this.tupIter = tupIter;
        this.keyWritable = keyWritable;
    }

    @Override
    public long getMemorySize() {
        return 0L;
    }

    @Override
    public long spill() {
        throw new RuntimeException("ReadOnceBag does not support spill operation");
    }

    @Override
    public void add(Tuple t) {
        throw new RuntimeException("ReadOnceBag does not support add operation");
    }

    @Override
    public void addAll(DataBag b) {
        throw new RuntimeException("ReadOnceBag does not support addAll operation");
    }

    @Override
    public void clear() {
        throw new RuntimeException("ReadOnceBag does not support clear operation");
    }

    @Override
    public boolean isDistinct() {
        throw new RuntimeException("ReadOnceBag does not support isDistinct operation");
    }

    @Override
    public boolean isSorted() {
        throw new RuntimeException("ReadOnceBag does not support isSorted operation");
    }

    @Override
    public Iterator<Tuple> iterator() {
        return new ReadOnceBagIterator();
    }

    @Override
    public void markStale(boolean stale) {
        throw new RuntimeException("ReadOnceBag does not support markStale operation");
    }

    @Override
    public long size() {
        throw new RuntimeException("ReadOnceBag does not support size operation");
    }

    public void readFields(DataInput in) throws IOException {
        throw new RuntimeException("ReadOnceBag does not support readFields operation");
    }

    public void write(DataOutput out) throws IOException {
        int errCode = 2142;
        String msg = "ReadOnceBag should never be serialized.";
        throw new ExecException(msg, errCode, 4);
    }

    public int compareTo(Object o) {
        throw new RuntimeException("ReadOnceBags cannot be compared");
    }

    public boolean equals(Object other) {
        if (other instanceof ReadOnceBag) {
            if (this.pkgr.getKeyTuple()) {
                return this.tupIter == ((ReadOnceBag)other).tupIter && this.pkgr.getKeyTuple() == ((ReadOnceBag)other).pkgr.getKeyTuple() && this.pkgr.getKeyAsTuple().equals(((ReadOnceBag)other).pkgr.getKeyAsTuple());
            }
            return this.tupIter == ((ReadOnceBag)other).tupIter && this.pkgr.getKey().equals(((ReadOnceBag)other).pkgr.getKey());
        }
        return false;
    }

    public int hashCode() {
        int hash = 7;
        hash = this.pkgr.getKeyTuple() ? hash * 31 + this.pkgr.getKeyAsTuple().hashCode() : hash * 31 + this.pkgr.getKey().hashCode();
        return hash;
    }

    protected class ReadOnceBagIterator
    implements Iterator<Tuple> {
        protected ReadOnceBagIterator() {
        }

        @Override
        public boolean hasNext() {
            return ReadOnceBag.this.tupIter.hasNext();
        }

        @Override
        public Tuple next() {
            NullableTuple ntup = ReadOnceBag.this.tupIter.next();
            byte index = ntup.getIndex();
            Tuple ret = null;
            try {
                ret = ReadOnceBag.this.pkgr.getValueTuple(ReadOnceBag.this.keyWritable, ntup, index);
            }
            catch (ExecException e) {
                throw new RuntimeException("ReadOnceBag failed to get value tuple : " + e.toString());
            }
            return ret;
        }

        @Override
        public void remove() {
            throw new RuntimeException("ReadOnceBag.iterator().remove() is not allowed");
        }
    }
}

