/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.newplan.logical.expression;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Deque;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.pig.ComparisonFunc;
import org.apache.pig.EvalFunc;
import org.apache.pig.FuncSpec;
import org.apache.pig.ResourceSchema;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.LogicalToPhysicalTranslatorException;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.PhysicalOperator;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.expressionOperators.Add;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.expressionOperators.BinaryComparisonOperator;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.expressionOperators.BinaryExpressionOperator;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.expressionOperators.Divide;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.expressionOperators.EqualToExpr;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.expressionOperators.ExpressionOperator;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.expressionOperators.GTOrEqualToExpr;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.expressionOperators.GreaterThanExpr;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.expressionOperators.LTOrEqualToExpr;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.expressionOperators.LessThanExpr;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.expressionOperators.Mod;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.expressionOperators.Multiply;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.expressionOperators.NotEqualToExpr;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.expressionOperators.POAnd;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.expressionOperators.POBinCond;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.expressionOperators.POCast;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.expressionOperators.POIsNull;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.expressionOperators.POMapLookUp;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.expressionOperators.PONegative;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.expressionOperators.PONot;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.expressionOperators.POOr;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.expressionOperators.POProject;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.expressionOperators.PORegexp;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.expressionOperators.PORelationToExprProject;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.expressionOperators.POUserComparisonFunc;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.expressionOperators.POUserFunc;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.expressionOperators.Subtract;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.plans.PhysicalPlan;
import org.apache.pig.data.DataType;
import org.apache.pig.impl.PigContext;
import org.apache.pig.impl.logicalLayer.FrontendException;
import org.apache.pig.impl.plan.NodeIdGenerator;
import org.apache.pig.impl.plan.OperatorKey;
import org.apache.pig.impl.plan.PlanException;
import org.apache.pig.newplan.DependencyOrderWalker;
import org.apache.pig.newplan.Operator;
import org.apache.pig.newplan.OperatorPlan;
import org.apache.pig.newplan.PlanWalker;
import org.apache.pig.newplan.logical.expression.AddExpression;
import org.apache.pig.newplan.logical.expression.AndExpression;
import org.apache.pig.newplan.logical.expression.BinCondExpression;
import org.apache.pig.newplan.logical.expression.BinaryExpression;
import org.apache.pig.newplan.logical.expression.CastExpression;
import org.apache.pig.newplan.logical.expression.ConstantExpression;
import org.apache.pig.newplan.logical.expression.DereferenceExpression;
import org.apache.pig.newplan.logical.expression.DivideExpression;
import org.apache.pig.newplan.logical.expression.EqualExpression;
import org.apache.pig.newplan.logical.expression.GreaterThanEqualExpression;
import org.apache.pig.newplan.logical.expression.GreaterThanExpression;
import org.apache.pig.newplan.logical.expression.IsNullExpression;
import org.apache.pig.newplan.logical.expression.LessThanEqualExpression;
import org.apache.pig.newplan.logical.expression.LessThanExpression;
import org.apache.pig.newplan.logical.expression.LogicalExpression;
import org.apache.pig.newplan.logical.expression.LogicalExpressionVisitor;
import org.apache.pig.newplan.logical.expression.MapLookupExpression;
import org.apache.pig.newplan.logical.expression.ModExpression;
import org.apache.pig.newplan.logical.expression.MultiplyExpression;
import org.apache.pig.newplan.logical.expression.NegativeExpression;
import org.apache.pig.newplan.logical.expression.NotEqualExpression;
import org.apache.pig.newplan.logical.expression.NotExpression;
import org.apache.pig.newplan.logical.expression.OrExpression;
import org.apache.pig.newplan.logical.expression.ProjectExpression;
import org.apache.pig.newplan.logical.expression.RegexExpression;
import org.apache.pig.newplan.logical.expression.ScalarExpression;
import org.apache.pig.newplan.logical.expression.SubtractExpression;
import org.apache.pig.newplan.logical.expression.UserFuncExpression;
import org.apache.pig.newplan.logical.relational.LOGenerate;
import org.apache.pig.newplan.logical.relational.LOInnerLoad;
import org.apache.pig.newplan.logical.relational.LogicalRelationalOperator;

public class ExpToPhyTranslationVisitor
extends LogicalExpressionVisitor {
    protected LogicalRelationalOperator currentOp;
    protected Map<Operator, PhysicalOperator> logToPhyMap;
    protected Deque<PhysicalPlan> currentPlans;
    protected PhysicalPlan currentPlan;
    protected NodeIdGenerator nodeGen = NodeIdGenerator.getGenerator();
    protected PigContext pc;

    public ExpToPhyTranslationVisitor(OperatorPlan plan, LogicalRelationalOperator op, PhysicalPlan phyPlan, Map<Operator, PhysicalOperator> map) throws FrontendException {
        this(plan, new DependencyOrderWalker(plan), op, phyPlan, map);
    }

    public ExpToPhyTranslationVisitor(OperatorPlan plan, PlanWalker walker, LogicalRelationalOperator op, PhysicalPlan phyPlan, Map<Operator, PhysicalOperator> map) throws FrontendException {
        super(plan, walker);
        this.currentOp = op;
        this.logToPhyMap = map;
        this.currentPlan = phyPlan;
        this.currentPlans = new LinkedList<PhysicalPlan>();
    }

    public void setPigContext(PigContext pc) {
        this.pc = pc;
    }

    public PhysicalPlan getPhysicalPlan() {
        return this.currentPlan;
    }

    private void attachBinaryComparisonOperator(BinaryExpression op, BinaryComparisonOperator exprOp) throws FrontendException {
        exprOp.setOperandType(op.getLhs().getType());
        exprOp.setLhs((ExpressionOperator)this.logToPhyMap.get(op.getLhs()));
        exprOp.setRhs((ExpressionOperator)this.logToPhyMap.get(op.getRhs()));
        OperatorPlan oPlan = op.getPlan();
        this.currentPlan.add(exprOp);
        this.logToPhyMap.put(op, exprOp);
        List<Operator> successors = oPlan.getSuccessors(op);
        if (successors == null) {
            return;
        }
        for (Operator lo : successors) {
            PhysicalOperator from = this.logToPhyMap.get(lo);
            try {
                this.currentPlan.connect(from, exprOp);
            }
            catch (PlanException e) {
                int errCode = 2015;
                String msg = "Invalid physical operators in the physical plan";
                throw new LogicalToPhysicalTranslatorException(msg, errCode, 4, (Throwable)e);
            }
        }
    }

    private void attachBinaryExpressionOperator(BinaryExpression op, BinaryExpressionOperator exprOp) throws FrontendException {
        exprOp.setResultType(op.getLhs().getType());
        exprOp.setLhs((ExpressionOperator)this.logToPhyMap.get(op.getLhs()));
        exprOp.setRhs((ExpressionOperator)this.logToPhyMap.get(op.getRhs()));
        OperatorPlan oPlan = op.getPlan();
        this.currentPlan.add(exprOp);
        this.logToPhyMap.put(op, exprOp);
        List<Operator> successors = oPlan.getSuccessors(op);
        if (successors == null) {
            return;
        }
        for (Operator lo : successors) {
            PhysicalOperator from = this.logToPhyMap.get(lo);
            try {
                this.currentPlan.connect(from, exprOp);
            }
            catch (PlanException e) {
                int errCode = 2015;
                String msg = "Invalid physical operators in the physical plan";
                throw new LogicalToPhysicalTranslatorException(msg, errCode, 4, (Throwable)e);
            }
        }
    }

    @Override
    public void visit(AndExpression op) throws FrontendException {
        POAnd exprOp = new POAnd(new OperatorKey("scope", this.nodeGen.getNextNodeId("scope")));
        this.attachBinaryComparisonOperator(op, exprOp);
    }

    @Override
    public void visit(OrExpression op) throws FrontendException {
        POOr exprOp = new POOr(new OperatorKey("scope", this.nodeGen.getNextNodeId("scope")));
        this.attachBinaryComparisonOperator(op, exprOp);
    }

    @Override
    public void visit(EqualExpression op) throws FrontendException {
        EqualToExpr exprOp = new EqualToExpr(new OperatorKey("scope", this.nodeGen.getNextNodeId("scope")));
        this.attachBinaryComparisonOperator(op, exprOp);
    }

    @Override
    public void visit(NotEqualExpression op) throws FrontendException {
        NotEqualToExpr exprOp = new NotEqualToExpr(new OperatorKey("scope", this.nodeGen.getNextNodeId("scope")));
        this.attachBinaryComparisonOperator(op, exprOp);
    }

    @Override
    public void visit(GreaterThanExpression op) throws FrontendException {
        GreaterThanExpr exprOp = new GreaterThanExpr(new OperatorKey("scope", this.nodeGen.getNextNodeId("scope")));
        this.attachBinaryComparisonOperator(op, exprOp);
    }

    @Override
    public void visit(GreaterThanEqualExpression op) throws FrontendException {
        GTOrEqualToExpr exprOp = new GTOrEqualToExpr(new OperatorKey("scope", this.nodeGen.getNextNodeId("scope")));
        this.attachBinaryComparisonOperator(op, exprOp);
    }

    @Override
    public void visit(LessThanExpression op) throws FrontendException {
        LessThanExpr exprOp = new LessThanExpr(new OperatorKey("scope", this.nodeGen.getNextNodeId("scope")));
        this.attachBinaryComparisonOperator(op, exprOp);
    }

    @Override
    public void visit(LessThanEqualExpression op) throws FrontendException {
        LTOrEqualToExpr exprOp = new LTOrEqualToExpr(new OperatorKey("scope", this.nodeGen.getNextNodeId("scope")));
        this.attachBinaryComparisonOperator(op, exprOp);
    }

    @Override
    public void visit(ProjectExpression op) throws FrontendException {
        POProject exprOp = op.getAttachedRelationalOp() instanceof LOGenerate && op.getPlan().getSuccessors(op) == null && !(op.findReferent() instanceof LOInnerLoad) ? new PORelationToExprProject(new OperatorKey("scope", this.nodeGen.getNextNodeId("scope"))) : new POProject(new OperatorKey("scope", this.nodeGen.getNextNodeId("scope")));
        if (op.getFieldSchema() == null && op.isRangeOrStarProject()) {
            exprOp.setResultType((byte)110);
        } else {
            exprOp.setResultType(op.getType());
        }
        if (op.isProjectStar()) {
            exprOp.setStar(op.isProjectStar());
        } else if (op.isRangeProject()) {
            if (op.getEndCol() != -1) {
                throw new AssertionError((Object)"project range that is not a project-to-end seen in translation to physical plan!");
            }
            exprOp.setProjectToEnd(op.getStartCol());
        } else {
            exprOp.setColumn(op.getColNum());
        }
        this.logToPhyMap.put(op, exprOp);
        this.currentPlan.add(exprOp);
    }

    @Override
    public void visit(MapLookupExpression op) throws FrontendException {
        POMapLookUp physOp = new POMapLookUp(new OperatorKey("scope", this.nodeGen.getNextNodeId("scope")));
        physOp.setLookUpKey(op.getLookupKey());
        physOp.setResultType(op.getType());
        physOp.addOriginalLocation(op.getFieldSchema().alias, op.getLocation());
        this.currentPlan.add(physOp);
        this.logToPhyMap.put(op, physOp);
        ExpressionOperator from = (ExpressionOperator)this.logToPhyMap.get(op.getMap());
        try {
            this.currentPlan.connect(from, physOp);
        }
        catch (PlanException e) {
            int errCode = 2015;
            String msg = "Invalid physical operators in the physical plan";
            throw new LogicalToPhysicalTranslatorException(msg, errCode, 4, (Throwable)e);
        }
    }

    @Override
    public void visit(ConstantExpression op) throws FrontendException {
        org.apache.pig.backend.hadoop.executionengine.physicalLayer.expressionOperators.ConstantExpression ce = new org.apache.pig.backend.hadoop.executionengine.physicalLayer.expressionOperators.ConstantExpression(new OperatorKey("scope", this.nodeGen.getNextNodeId("scope")));
        ce.setValue(op.getValue());
        ce.setResultType(op.getType());
        this.currentPlan.add(ce);
        this.logToPhyMap.put(op, ce);
    }

    @Override
    public void visit(CastExpression op) throws FrontendException {
        POCast pCast = new POCast(new OperatorKey("scope", this.nodeGen.getNextNodeId("scope")));
        pCast.addOriginalLocation(op.getFieldSchema().alias, op.getLocation());
        this.currentPlan.add(pCast);
        this.logToPhyMap.put(op, pCast);
        ExpressionOperator from = (ExpressionOperator)this.logToPhyMap.get(op.getExpression());
        pCast.setResultType(op.getType());
        pCast.setFieldSchema(new ResourceSchema.ResourceFieldSchema(op.getFieldSchema()));
        FuncSpec lfSpec = op.getFuncSpec();
        if (null != lfSpec) {
            try {
                pCast.setFuncSpec(lfSpec);
            }
            catch (IOException e) {
                int errCode = 1053;
                String msg = "Cannot resolve load function to use for casting from " + DataType.findTypeName(op.getExpression().getType()) + " to " + DataType.findTypeName(op.getType());
                throw new LogicalToPhysicalTranslatorException(msg, errCode, 4, (Throwable)e);
            }
        }
        try {
            this.currentPlan.connect(from, pCast);
        }
        catch (PlanException e) {
            int errCode = 2015;
            String msg = "Invalid physical operators in the physical plan";
            throw new LogicalToPhysicalTranslatorException(msg, errCode, 4, (Throwable)e);
        }
    }

    @Override
    public void visit(NotExpression op) throws FrontendException {
        PONot pNot = new PONot(new OperatorKey("scope", this.nodeGen.getNextNodeId("scope")));
        this.currentPlan.add(pNot);
        this.logToPhyMap.put(op, pNot);
        ExpressionOperator from = (ExpressionOperator)this.logToPhyMap.get(op.getExpression());
        pNot.setExpr(from);
        pNot.setResultType(op.getType());
        pNot.setOperandType(op.getType());
        try {
            this.currentPlan.connect(from, pNot);
        }
        catch (PlanException e) {
            int errCode = 2015;
            String msg = "Invalid physical operators in the physical plan";
            throw new LogicalToPhysicalTranslatorException(msg, errCode, 4, (Throwable)e);
        }
    }

    @Override
    public void visit(IsNullExpression op) throws FrontendException {
        POIsNull pIsNull = new POIsNull(new OperatorKey("scope", this.nodeGen.getNextNodeId("scope")));
        this.currentPlan.add(pIsNull);
        this.logToPhyMap.put(op, pIsNull);
        ExpressionOperator from = (ExpressionOperator)this.logToPhyMap.get(op.getExpression());
        pIsNull.setExpr(from);
        pIsNull.setResultType(op.getType());
        pIsNull.setOperandType(op.getExpression().getType());
        try {
            this.currentPlan.connect(from, pIsNull);
        }
        catch (PlanException e) {
            int errCode = 2015;
            String msg = "Invalid physical operators in the physical plan";
            throw new LogicalToPhysicalTranslatorException(msg, errCode, 4, (Throwable)e);
        }
    }

    @Override
    public void visit(NegativeExpression op) throws FrontendException {
        PONegative pNegative = new PONegative(new OperatorKey("scope", this.nodeGen.getNextNodeId("scope")));
        this.currentPlan.add(pNegative);
        this.logToPhyMap.put(op, pNegative);
        ExpressionOperator from = (ExpressionOperator)this.logToPhyMap.get(op.getExpression());
        pNegative.setExpr(from);
        pNegative.setResultType(op.getType());
        try {
            this.currentPlan.connect(from, pNegative);
        }
        catch (PlanException e) {
            int errCode = 2015;
            String msg = "Invalid physical operators in the physical plan";
            throw new LogicalToPhysicalTranslatorException(msg, errCode, 4, (Throwable)e);
        }
    }

    @Override
    public void visit(AddExpression op) throws FrontendException {
        Add exprOp = new Add(new OperatorKey("scope", this.nodeGen.getNextNodeId("scope")));
        this.attachBinaryExpressionOperator(op, exprOp);
    }

    @Override
    public void visit(RegexExpression op) throws FrontendException {
        PORegexp exprOp = new PORegexp(new OperatorKey("scope", this.nodeGen.getNextNodeId("scope")));
        this.attachBinaryExpressionOperator(op, exprOp);
        List<Operator> successors = op.getPlan().getSuccessors(op);
        if (successors.get(1) instanceof ConstantExpression) {
            exprOp.setConstExpr(true);
        }
    }

    @Override
    public void visit(SubtractExpression op) throws FrontendException {
        Subtract exprOp = new Subtract(new OperatorKey("scope", this.nodeGen.getNextNodeId("scope")));
        this.attachBinaryExpressionOperator(op, exprOp);
    }

    @Override
    public void visit(MultiplyExpression op) throws FrontendException {
        Multiply exprOp = new Multiply(new OperatorKey("scope", this.nodeGen.getNextNodeId("scope")));
        this.attachBinaryExpressionOperator(op, exprOp);
    }

    @Override
    public void visit(DivideExpression op) throws FrontendException {
        Divide exprOp = new Divide(new OperatorKey("scope", this.nodeGen.getNextNodeId("scope")));
        this.attachBinaryExpressionOperator(op, exprOp);
    }

    @Override
    public void visit(ModExpression op) throws FrontendException {
        Mod exprOp = new Mod(new OperatorKey("scope", this.nodeGen.getNextNodeId("scope")));
        this.attachBinaryExpressionOperator(op, exprOp);
    }

    @Override
    public void visit(BinCondExpression op) throws FrontendException {
        POBinCond exprOp = new POBinCond(new OperatorKey("scope", this.nodeGen.getNextNodeId("scope")));
        exprOp.setResultType(op.getType());
        exprOp.setCond((ExpressionOperator)this.logToPhyMap.get(op.getCondition()));
        exprOp.setLhs((ExpressionOperator)this.logToPhyMap.get(op.getLhs()));
        exprOp.setRhs((ExpressionOperator)this.logToPhyMap.get(op.getRhs()));
        OperatorPlan oPlan = op.getPlan();
        this.currentPlan.add(exprOp);
        this.logToPhyMap.put(op, exprOp);
        List<Operator> successors = oPlan.getSuccessors(op);
        if (successors == null) {
            return;
        }
        for (Operator lo : successors) {
            PhysicalOperator from = this.logToPhyMap.get(lo);
            try {
                this.currentPlan.connect(from, exprOp);
            }
            catch (PlanException e) {
                int errCode = 2015;
                String msg = "Invalid physical operators in the physical plan";
                throw new LogicalToPhysicalTranslatorException(msg, errCode, 4, (Throwable)e);
            }
        }
    }

    @Override
    public void visit(UserFuncExpression op) throws FrontendException {
        ExpressionOperator p;
        Object f = PigContext.instantiateFuncFromSpec(op.getFuncSpec());
        if (f instanceof EvalFunc) {
            Object shipFiles;
            List<String> cacheFiles;
            p = new POUserFunc(new OperatorKey("scope", this.nodeGen.getNextNodeId("scope")), -1, null, op.getFuncSpec(), (EvalFunc)f);
            ((POUserFunc)p).setSignature(op.getSignature());
            if (((POUserFunc)p).getFunc().getInputSchema() == null) {
                ((POUserFunc)p).setFuncInputSchema(op.getSignature());
                ((EvalFunc)f).setInputSchema(((POUserFunc)p).getFunc().getInputSchema());
            }
            if ((cacheFiles = ((EvalFunc)f).getCacheFiles()) != null) {
                ((POUserFunc)p).setCacheFiles(cacheFiles);
            }
            if ((shipFiles = ((EvalFunc)f).getShipFiles()) != null) {
                ((POUserFunc)p).setShipFiles((List<String>)shipFiles);
            }
        } else {
            p = new POUserComparisonFunc(new OperatorKey("scope", this.nodeGen.getNextNodeId("scope")), -1, null, op.getFuncSpec(), (ComparisonFunc)((Object)f));
        }
        p.setResultType(op.getType());
        this.currentPlan.add(p);
        List<LogicalExpression> fromList = op.getArguments();
        if (fromList != null) {
            for (LogicalExpression inputOperator : fromList) {
                PhysicalOperator from = this.logToPhyMap.get(inputOperator);
                try {
                    this.currentPlan.connect(from, p);
                }
                catch (PlanException e) {
                    int errCode = 2015;
                    String msg = "Invalid physical operators in the physical plan";
                    throw new LogicalToPhysicalTranslatorException(msg, errCode, 4, (Throwable)e);
                }
            }
        }
        this.logToPhyMap.put(op, p);
        if (op instanceof ScalarExpression) {
            Operator refOp = ((ScalarExpression)op).getImplicitReferencedOperator();
            ((POUserFunc)p).setReferencedOperator(this.logToPhyMap.get(refOp));
        }
    }

    @Override
    public void visit(DereferenceExpression op) throws FrontendException {
        POProject exprOp = new POProject(new OperatorKey("scope", this.nodeGen.getNextNodeId("scope")));
        exprOp.setResultType(op.getType());
        exprOp.setColumns((ArrayList)op.getBagColumns());
        exprOp.setStar(false);
        this.logToPhyMap.put(op, exprOp);
        this.currentPlan.add(exprOp);
        PhysicalOperator from = this.logToPhyMap.get(op.getReferredExpression());
        if (from != null) {
            this.currentPlan.connect(from, exprOp);
        }
    }
}

