/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io.parquet.serde;

import java.util.Map;
import org.apache.hadoop.hive.ql.io.parquet.serde.AbstractParquetMapInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.io.ArrayWritable;
import org.apache.hadoop.io.Writable;

public class DeepParquetHiveMapInspector
extends AbstractParquetMapInspector {
    public DeepParquetHiveMapInspector(ObjectInspector keyInspector, ObjectInspector valueInspector) {
        super(keyInspector, valueInspector);
    }

    public Object getMapValueElement(Object data, Object key) {
        if (data == null || key == null) {
            return null;
        }
        if (data instanceof ArrayWritable) {
            Writable[] mapArray;
            Writable[] mapContainer = ((ArrayWritable)data).get();
            if (mapContainer == null || mapContainer.length == 0) {
                return null;
            }
            for (Writable obj : mapArray = ((ArrayWritable)mapContainer[0]).get()) {
                ArrayWritable mapObj = (ArrayWritable)obj;
                Writable[] arr = mapObj.get();
                if (!key.equals(arr[0]) && !key.equals(((PrimitiveObjectInspector)this.keyInspector).getPrimitiveJavaObject((Object)arr[0])) && !key.equals(((PrimitiveObjectInspector)this.keyInspector).getPrimitiveWritableObject((Object)arr[0]))) continue;
                return arr[1];
            }
            return null;
        }
        if (data instanceof Map) {
            Map map = (Map)data;
            if (map.containsKey(key)) {
                return map.get(key);
            }
            for (Map.Entry entry : map.entrySet()) {
                if (!key.equals(((PrimitiveObjectInspector)this.keyInspector).getPrimitiveJavaObject(entry.getKey())) && !key.equals(((PrimitiveObjectInspector)this.keyInspector).getPrimitiveWritableObject(entry.getKey()))) continue;
                return entry.getValue();
            }
            return null;
        }
        throw new UnsupportedOperationException("Cannot inspect " + data.getClass().getCanonicalName());
    }
}

