/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.exec.FilterOperator;
import org.apache.hadoop.hive.ql.exec.GroupByOperator;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.exec.OperatorFactory;
import org.apache.hadoop.hive.ql.exec.ReduceSinkOperator;
import org.apache.hadoop.hive.ql.exec.SelectOperator;
import org.apache.hadoop.hive.ql.exec.TableScanOperator;
import org.apache.hadoop.hive.ql.lib.DefaultGraphWalker;
import org.apache.hadoop.hive.ql.lib.DefaultRuleDispatcher;
import org.apache.hadoop.hive.ql.lib.Node;
import org.apache.hadoop.hive.ql.lib.NodeProcessor;
import org.apache.hadoop.hive.ql.lib.NodeProcessorCtx;
import org.apache.hadoop.hive.ql.lib.Rule;
import org.apache.hadoop.hive.ql.lib.RuleRegExp;
import org.apache.hadoop.hive.ql.metadata.Partition;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.parse.OptimizeTezProcContext;
import org.apache.hadoop.hive.ql.parse.ParseContext;
import org.apache.hadoop.hive.ql.parse.PrunedPartitionList;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.plan.AggregationDesc;
import org.apache.hadoop.hive.ql.plan.DynamicPruningEventDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeColumnDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeConstantDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeDynamicListDesc;
import org.apache.hadoop.hive.ql.plan.FilterDesc;
import org.apache.hadoop.hive.ql.plan.GroupByDesc;
import org.apache.hadoop.hive.ql.plan.OperatorDesc;
import org.apache.hadoop.hive.ql.plan.PlanUtils;
import org.apache.hadoop.hive.ql.plan.ReduceSinkDesc;
import org.apache.hadoop.hive.ql.plan.SelectDesc;
import org.apache.hadoop.hive.ql.plan.TableScanDesc;

public class DynamicPartitionPruningOptimization
implements NodeProcessor {
    private static final Log LOG = LogFactory.getLog((String)DynamicPartitionPruningOptimization.class.getName());

    private String extractColName(ExprNodeDesc root) {
        if (root instanceof ExprNodeColumnDesc) {
            return ((ExprNodeColumnDesc)root).getColumn();
        }
        if (root.getChildren() == null) {
            return null;
        }
        String column = null;
        for (ExprNodeDesc d : root.getChildren()) {
            String candidate = this.extractColName(d);
            if (column != null && candidate != null) {
                return null;
            }
            if (candidate == null) continue;
            column = candidate;
        }
        return column;
    }

    @Override
    public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procCtx, Object ... nodeOutputs) throws SemanticException {
        OptimizeTezProcContext context = (OptimizeTezProcContext)procCtx;
        ParseContext parseContext = context.parseContext;
        FilterOperator filter = (FilterOperator)nd;
        FilterDesc desc = (FilterDesc)filter.getConf();
        TableScanOperator ts = null;
        if (!parseContext.getConf().getBoolVar(HiveConf.ConfVars.TEZ_DYNAMIC_PARTITION_PRUNING)) {
            return null;
        }
        DynamicPartitionPrunerContext removerContext = new DynamicPartitionPrunerContext();
        if (filter.getParentOperators().size() == 1 && filter.getParentOperators().get(0) instanceof TableScanOperator) {
            ts = (TableScanOperator)filter.getParentOperators().get(0);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Parent: " + filter.getParentOperators().get(0)));
            LOG.debug((Object)("Filter: " + desc.getPredicateString()));
            LOG.debug((Object)("TableScan: " + ts));
        }
        removerContext.dynLists.clear();
        this.walkExprTree(desc.getPredicate(), removerContext);
        for (DynamicListContext ctx : removerContext) {
            String column = this.extractColName(ctx.parent);
            if (ts != null && column != null) {
                Table table = ((TableScanDesc)ts.getConf()).getTableMetadata();
                if (table != null && table.isPartitionKey(column)) {
                    String alias = ((TableScanDesc)ts.getConf()).getAlias();
                    PrunedPartitionList plist = parseContext.getPrunedPartitions(alias, ts);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("alias: " + alias));
                        LOG.debug((Object)"pruned partition list: ");
                        if (plist != null) {
                            for (Partition p : plist.getPartitions()) {
                                LOG.debug((Object)p.getCompleteName());
                            }
                        }
                    }
                    if (plist == null || plist.getPartitions().size() != 0) {
                        LOG.info((Object)("Dynamic partitioning: " + table.getCompleteName() + "." + column));
                        this.generateEventOperatorPlan(ctx, parseContext, ts, column);
                    } else {
                        LOG.debug((Object)"No partition pruning necessary.");
                    }
                } else {
                    LOG.debug((Object)("Column " + column + " is not a partition column"));
                }
            }
            ExprNodeConstantDesc constNode = new ExprNodeConstantDesc(ctx.parent.getTypeInfo(), true);
            if (ctx.grandParent == null) {
                desc.setPredicate(constNode);
                continue;
            }
            int i = ctx.grandParent.getChildren().indexOf(ctx.parent);
            ctx.grandParent.getChildren().remove(i);
            ctx.grandParent.getChildren().add(i, constNode);
        }
        this.cleanTableScanFilters(ts);
        return false;
    }

    private void cleanTableScanFilters(TableScanOperator ts) throws SemanticException {
        if (ts == null || ts.getConf() == null || ((TableScanDesc)ts.getConf()).getFilterExpr() == null) {
            return;
        }
        DynamicPartitionPrunerContext removerContext = new DynamicPartitionPrunerContext();
        removerContext.dynLists.clear();
        this.walkExprTree(((TableScanDesc)ts.getConf()).getFilterExpr(), removerContext);
        for (DynamicListContext ctx : removerContext) {
            ExprNodeConstantDesc constNode = new ExprNodeConstantDesc(ctx.parent.getTypeInfo(), true);
            if (ctx.grandParent == null) {
                ((TableScanDesc)ts.getConf()).setFilterExpr(null);
                continue;
            }
            int i = ctx.grandParent.getChildren().indexOf(ctx.parent);
            ctx.grandParent.getChildren().remove(i);
            ctx.grandParent.getChildren().add(i, constNode);
        }
    }

    private void generateEventOperatorPlan(DynamicListContext ctx, ParseContext parseContext, TableScanOperator ts, String column) {
        Operator<OperatorDesc> parentOfRS = ctx.generator.getParentOperators().get(0);
        ExprNodeDesc key = ((ReduceSinkDesc)ctx.generator.getConf()).getKeyCols().get(ctx.desc.getKeyIndex());
        ExprNodeDesc partKey = ctx.parent.getChildren().get(0);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("key expr: " + key));
            LOG.debug((Object)("partition key expr: " + partKey));
        }
        ArrayList<ExprNodeDesc> keyExprs = new ArrayList<ExprNodeDesc>();
        keyExprs.add(key);
        ArrayList<String> outputNames = new ArrayList<String>();
        outputNames.add(HiveConf.getColumnInternalName((int)0));
        SelectDesc select = new SelectDesc(keyExprs, outputNames);
        SelectOperator selectOp = (SelectOperator)OperatorFactory.getAndMakeChild(select, parentOfRS);
        float groupByMemoryUsage = HiveConf.getFloatVar((Configuration)parseContext.getConf(), (HiveConf.ConfVars)HiveConf.ConfVars.HIVEMAPAGGRHASHMEMORY);
        float memoryThreshold = HiveConf.getFloatVar((Configuration)parseContext.getConf(), (HiveConf.ConfVars)HiveConf.ConfVars.HIVEMAPAGGRMEMORYTHRESHOLD);
        ArrayList<ExprNodeDesc> groupByExprs = new ArrayList<ExprNodeDesc>();
        ExprNodeColumnDesc groupByExpr = new ExprNodeColumnDesc(key.getTypeInfo(), outputNames.get(0), null, false);
        groupByExprs.add(groupByExpr);
        GroupByDesc groupBy = new GroupByDesc(GroupByDesc.Mode.HASH, outputNames, groupByExprs, new ArrayList<AggregationDesc>(), false, groupByMemoryUsage, memoryThreshold, null, false, 0, true);
        GroupByOperator groupByOp = (GroupByOperator)OperatorFactory.getAndMakeChild(groupBy, selectOp);
        HashMap<String, ExprNodeDesc> colMap = new HashMap<String, ExprNodeDesc>();
        colMap.put(outputNames.get(0), groupByExpr);
        groupByOp.setColumnExprMap(colMap);
        DynamicPruningEventDesc eventDesc = new DynamicPruningEventDesc();
        eventDesc.setTableScan(ts);
        eventDesc.setTable(PlanUtils.getReduceValueTableDesc(PlanUtils.getFieldSchemasFromColumnList(keyExprs, "key")));
        eventDesc.setTargetColumnName(column);
        eventDesc.setPartKey(partKey);
        OperatorFactory.getAndMakeChild(eventDesc, groupByOp);
    }

    private Map<Node, Object> walkExprTree(ExprNodeDesc pred, NodeProcessorCtx ctx) throws SemanticException {
        LinkedHashMap<Rule, NodeProcessor> exprRules = new LinkedHashMap<Rule, NodeProcessor>();
        exprRules.put(new RuleRegExp("R1", ExprNodeDynamicListDesc.class.getName() + "%"), new DynamicPartitionPrunerProc());
        DefaultRuleDispatcher disp = new DefaultRuleDispatcher(null, exprRules, ctx);
        DefaultGraphWalker egw = new DefaultGraphWalker(disp);
        ArrayList<Node> startNodes = new ArrayList<Node>();
        startNodes.add(pred);
        HashMap<Node, Object> outputMap = new HashMap<Node, Object>();
        egw.startWalking(startNodes, outputMap);
        return outputMap;
    }

    private static class DynamicPartitionPrunerContext
    implements NodeProcessorCtx,
    Iterable<DynamicListContext> {
        public List<DynamicListContext> dynLists = new ArrayList<DynamicListContext>();

        private DynamicPartitionPrunerContext() {
        }

        public void addDynamicList(ExprNodeDynamicListDesc desc, ExprNodeDesc parent, ExprNodeDesc grandParent, ReduceSinkOperator generator) {
            this.dynLists.add(new DynamicListContext(desc, parent, grandParent, generator));
        }

        @Override
        public Iterator<DynamicListContext> iterator() {
            return this.dynLists.iterator();
        }
    }

    private static class DynamicListContext {
        public ExprNodeDynamicListDesc desc;
        public ExprNodeDesc parent;
        public ExprNodeDesc grandParent;
        public ReduceSinkOperator generator;

        public DynamicListContext(ExprNodeDynamicListDesc desc, ExprNodeDesc parent, ExprNodeDesc grandParent, ReduceSinkOperator generator) {
            this.desc = desc;
            this.parent = parent;
            this.grandParent = grandParent;
            this.generator = generator;
        }
    }

    public static class DynamicPartitionPrunerProc
    implements NodeProcessor {
        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procCtx, Object ... nodeOutputs) throws SemanticException {
            ExprNodeDynamicListDesc desc = (ExprNodeDynamicListDesc)nd;
            DynamicPartitionPrunerContext context = (DynamicPartitionPrunerContext)procCtx;
            ExprNodeDesc parent = (ExprNodeDesc)stack.get(stack.size() - 2);
            ExprNodeDesc grandParent = stack.size() >= 3 ? (ExprNodeDesc)stack.get(stack.size() - 3) : null;
            context.addDynamicList(desc, parent, grandParent, (ReduceSinkOperator)desc.getSource());
            return context;
        }
    }
}

