/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.physical;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Stack;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hive.ql.exec.FilterOperator;
import org.apache.hadoop.hive.ql.exec.LimitOperator;
import org.apache.hadoop.hive.ql.exec.TableScanOperator;
import org.apache.hadoop.hive.ql.lib.DefaultGraphWalker;
import org.apache.hadoop.hive.ql.lib.Node;
import org.apache.hadoop.hive.ql.lib.NodeProcessor;
import org.apache.hadoop.hive.ql.lib.NodeProcessorCtx;
import org.apache.hadoop.hive.ql.lib.Rule;
import org.apache.hadoop.hive.ql.lib.RuleRegExp;
import org.apache.hadoop.hive.ql.optimizer.physical.MetadataOnlyOptimizer;
import org.apache.hadoop.hive.ql.optimizer.physical.NullScanTaskDispatcher;
import org.apache.hadoop.hive.ql.optimizer.physical.PhysicalContext;
import org.apache.hadoop.hive.ql.optimizer.physical.PhysicalPlanResolver;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.plan.ExprNodeConstantDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.ql.plan.FilterDesc;
import org.apache.hadoop.hive.ql.plan.LimitDesc;

public class NullScanOptimizer
implements PhysicalPlanResolver {
    private static final Log LOG = LogFactory.getLog((String)NullScanOptimizer.class.getName());

    @Override
    public PhysicalContext resolve(PhysicalContext pctx) throws SemanticException {
        LinkedHashMap<Rule, NodeProcessor> opRules = new LinkedHashMap<Rule, NodeProcessor>();
        opRules.put(new RuleRegExp("R1", TableScanOperator.getOperatorName() + "%.*" + FilterOperator.getOperatorName() + "%"), new WhereFalseProcessor());
        NullScanTaskDispatcher disp = new NullScanTaskDispatcher(pctx, opRules);
        DefaultGraphWalker ogw = new DefaultGraphWalker(disp);
        ArrayList<Node> topNodes = new ArrayList<Node>();
        topNodes.addAll(pctx.getRootTasks());
        ogw.startWalking(topNodes, null);
        opRules.clear();
        opRules.put(new RuleRegExp("R1", TableScanOperator.getOperatorName() + "%"), new TSMarker());
        opRules.put(new RuleRegExp("R2", LimitOperator.getOperatorName() + "%"), new Limit0Processor());
        disp = new NullScanTaskDispatcher(pctx, opRules);
        ogw = new DefaultGraphWalker(disp);
        topNodes = new ArrayList();
        topNodes.addAll(pctx.getRootTasks());
        ogw.startWalking(topNodes, null);
        return pctx;
    }

    private static class TSMarker
    implements NodeProcessor {
        private TSMarker() {
        }

        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procCtx, Object ... nodeOutputs) throws SemanticException {
            ((MetadataOnlyOptimizer.WalkerCtx)procCtx).setMayBeMetadataOnly((TableScanOperator)nd);
            return null;
        }
    }

    private static class Limit0Processor
    implements NodeProcessor {
        private Limit0Processor() {
        }

        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procCtx, Object ... nodeOutputs) throws SemanticException {
            if (((LimitDesc)((LimitOperator)nd).getConf()).getLimit() != 0) {
                return null;
            }
            LOG.info((Object)("Found Limit 0 TableScan. " + nd));
            ((MetadataOnlyOptimizer.WalkerCtx)procCtx).convertMetadataOnly();
            return null;
        }
    }

    private static class WhereFalseProcessor
    implements NodeProcessor {
        private WhereFalseProcessor() {
        }

        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procCtx, Object ... nodeOutputs) throws SemanticException {
            FilterOperator filter = (FilterOperator)nd;
            ExprNodeDesc condition = ((FilterDesc)filter.getConf()).getPredicate();
            if (!(condition instanceof ExprNodeConstantDesc)) {
                return null;
            }
            ExprNodeConstantDesc c = (ExprNodeConstantDesc)condition;
            if (!Boolean.FALSE.equals(c.getValue())) {
                return null;
            }
            MetadataOnlyOptimizer.WalkerCtx ctx = (MetadataOnlyOptimizer.WalkerCtx)procCtx;
            for (Node op : stack) {
                if (!(op instanceof TableScanOperator)) continue;
                ctx.setMayBeMetadataOnly((TableScanOperator)op);
                LOG.info((Object)("Found where false TableScan. " + op));
            }
            ctx.convertMetadataOnly();
            return null;
        }
    }
}

