/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.viewfs;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.FsConstants;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.viewfs.ConfigUtil;
import org.apache.hadoop.fs.viewfs.InodeTree;
import org.apache.hadoop.fs.viewfs.ViewFileSystem;
import org.apache.hadoop.io.DataInputBuffer;
import org.apache.hadoop.io.DataOutputBuffer;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class TestViewfsFileStatus {
    private static final File TEST_DIR = new File(System.getProperty("test.build.data", "/tmp"), TestViewfsFileStatus.class.getSimpleName());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFileStatusSerialziation() throws IOException, URISyntaxException {
        String testfilename = "testFileStatusSerialziation";
        TEST_DIR.mkdirs();
        File infile = new File(TEST_DIR, testfilename);
        byte[] content = "dingos".getBytes();
        try (FileOutputStream fos = null;){
            fos = new FileOutputStream(infile);
            fos.write(content);
        }
        Assert.assertEquals((long)content.length, (long)infile.length());
        Configuration conf = new Configuration();
        ConfigUtil.addLink((Configuration)conf, (String)"/foo/bar/baz", (URI)TEST_DIR.toURI());
        FileSystem vfs = FileSystem.get((URI)FsConstants.VIEWFS_URI, (Configuration)conf);
        Assert.assertEquals(ViewFileSystem.class, vfs.getClass());
        FileStatus stat = vfs.getFileStatus(new Path("/foo/bar/baz", testfilename));
        Assert.assertEquals((long)content.length, (long)stat.getLen());
        DataOutputBuffer dob = new DataOutputBuffer();
        stat.write((DataOutput)dob);
        DataInputBuffer dib = new DataInputBuffer();
        dib.reset(dob.getData(), 0, dob.getLength());
        FileStatus deSer = new FileStatus();
        deSer.readFields((DataInput)dib);
        Assert.assertEquals((long)content.length, (long)deSer.getLen());
    }

    @Test
    public void testGetFileChecksum() throws IOException {
        FileSystem mockFS = (FileSystem)Mockito.mock(FileSystem.class);
        InodeTree.ResolveResult res = new InodeTree.ResolveResult(null, (Object)mockFS, null, new Path("someFile"));
        InodeTree fsState = (InodeTree)Mockito.mock(InodeTree.class);
        Mockito.when((Object)fsState.resolve("/tmp/someFile", true)).thenReturn((Object)res);
        ViewFileSystem vfs = (ViewFileSystem)Mockito.mock(ViewFileSystem.class);
        vfs.fsState = fsState;
        Mockito.when((Object)vfs.getFileChecksum(new Path("/tmp/someFile"))).thenCallRealMethod();
        vfs.getFileChecksum(new Path("/tmp/someFile"));
        ((FileSystem)Mockito.verify((Object)mockFS)).getFileChecksum(new Path("someFile"));
    }

    @AfterClass
    public static void cleanup() throws IOException {
        FileUtil.fullyDelete((File)TEST_DIR);
    }
}

