/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.jmx;

import java.net.HttpURLConnection;
import java.net.URL;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.hadoop.http.HttpServer2;
import org.apache.hadoop.http.HttpServerFunctionalTest;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestJMXJsonServlet
extends HttpServerFunctionalTest {
    private static HttpServer2 server;
    private static URL baseUrl;

    @BeforeClass
    public static void setup() throws Exception {
        server = TestJMXJsonServlet.createTestServer();
        server.start();
        baseUrl = TestJMXJsonServlet.getServerURL(server);
    }

    @AfterClass
    public static void cleanup() throws Exception {
        server.stop();
    }

    public static void assertReFind(String re, String value) {
        Pattern p = Pattern.compile(re);
        Matcher m = p.matcher(value);
        TestJMXJsonServlet.assertTrue((String)("'" + p + "' does not match " + value), (boolean)m.find());
    }

    @Test
    public void testQury() throws Exception {
        String result = TestJMXJsonServlet.readOutput(new URL(baseUrl, "/jmx?qry=java.lang:type=Runtime"));
        TestJMXJsonServlet.assertReFind("\"name\"\\s*:\\s*\"java.lang:type=Runtime\"", result);
        TestJMXJsonServlet.assertReFind("\"modelerType\"", result);
        result = TestJMXJsonServlet.readOutput(new URL(baseUrl, "/jmx?qry=java.lang:type=Memory"));
        TestJMXJsonServlet.assertReFind("\"name\"\\s*:\\s*\"java.lang:type=Memory\"", result);
        TestJMXJsonServlet.assertReFind("\"modelerType\"", result);
        result = TestJMXJsonServlet.readOutput(new URL(baseUrl, "/jmx"));
        TestJMXJsonServlet.assertReFind("\"name\"\\s*:\\s*\"java.lang:type=Memory\"", result);
        result = TestJMXJsonServlet.readOutput(new URL(baseUrl, "/jmx?get=java.lang:type=Memory::HeapMemoryUsage"));
        TestJMXJsonServlet.assertReFind("\"name\"\\s*:\\s*\"java.lang:type=Memory\"", result);
        TestJMXJsonServlet.assertReFind("\"committed\"\\s*:", result);
        result = TestJMXJsonServlet.readOutput(new URL(baseUrl, "/jmx?get=java.lang:type=Memory::"));
        TestJMXJsonServlet.assertReFind("\"ERROR\"", result);
        HttpURLConnection conn = (HttpURLConnection)new URL(baseUrl, "/jmx?qry=java.lang:type=Memory").openConnection();
        TestJMXJsonServlet.assertEquals((Object)"GET", (Object)conn.getHeaderField("Access-Control-Allow-Methods"));
        TestJMXJsonServlet.assertNotNull((Object)conn.getHeaderField("Access-Control-Allow-Origin"));
    }
}

