/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.metrics2.impl;

import org.apache.commons.configuration.SubsetConfiguration;
import org.apache.hadoop.metrics2.AbstractMetric;
import org.apache.hadoop.metrics2.MetricsFilter;
import org.apache.hadoop.metrics2.MetricsTag;
import org.apache.hadoop.metrics2.filter.TestPatternFilter;
import org.apache.hadoop.metrics2.impl.ConfigBuilder;
import org.apache.hadoop.metrics2.impl.MetricsCollectorImpl;
import org.apache.hadoop.metrics2.impl.MetricsRecordBuilderImpl;
import org.apache.hadoop.metrics2.lib.Interns;
import org.junit.Assert;
import org.junit.Test;

public class TestMetricsCollectorImpl {
    @Test
    public void recordBuilderShouldNoOpIfFiltered() {
        SubsetConfiguration fc = new ConfigBuilder().add("p.exclude", "foo").subset("p");
        MetricsCollectorImpl mb = new MetricsCollectorImpl();
        mb.setRecordFilter((MetricsFilter)TestPatternFilter.newGlobFilter(fc));
        MetricsRecordBuilderImpl rb = mb.addRecord("foo");
        rb.tag(Interns.info((String)"foo", (String)""), "value").addGauge(Interns.info((String)"g0", (String)""), 1);
        Assert.assertEquals((String)"no tags", (long)0L, (long)rb.tags().size());
        Assert.assertEquals((String)"no metrics", (long)0L, (long)rb.metrics().size());
        Assert.assertNull((String)"null record", (Object)rb.getRecord());
        Assert.assertEquals((String)"no records", (long)0L, (long)mb.getRecords().size());
    }

    @Test
    public void testPerMetricFiltering() {
        SubsetConfiguration fc = new ConfigBuilder().add("p.exclude", "foo").subset("p");
        MetricsCollectorImpl mb = new MetricsCollectorImpl();
        mb.setMetricFilter((MetricsFilter)TestPatternFilter.newGlobFilter(fc));
        MetricsRecordBuilderImpl rb = mb.addRecord("foo");
        rb.tag(Interns.info((String)"foo", (String)""), "").addCounter(Interns.info((String)"c0", (String)""), 0).addGauge(Interns.info((String)"foo", (String)""), 1);
        Assert.assertEquals((String)"1 tag", (long)1L, (long)rb.tags().size());
        Assert.assertEquals((String)"1 metric", (long)1L, (long)rb.metrics().size());
        Assert.assertEquals((String)"expect foo tag", (Object)"foo", (Object)((MetricsTag)rb.tags().get(0)).name());
        Assert.assertEquals((String)"expect c0", (Object)"c0", (Object)((AbstractMetric)rb.metrics().get(0)).name());
    }
}

