/*
 * Decompiled with CFR 0.152.
 */
package sdsu.logging;

import java.io.Serializable;
import java.util.Hashtable;
import sdsu.util.ConversionException;
import sdsu.util.LabeledData;
import sdsu.util.Stringizable;
import sdsu.util.Stringizer;
import sdsu.util.TokenCharacters;

public abstract class LoggerMessage
implements Stringizable,
Serializable {
    protected static final String PAIR_SEPARATOR = ";";
    protected static final String KEY_VALUE_SEPARATOR = "=";
    protected static final TokenCharacters parseTable = new TokenCharacters(";=");
    protected static final String MESSAGE_KEY = "message";
    protected static final String CLASS_KEY = "class";
    protected static final String TYPE_KEY = "type";
    String message;

    public LoggerMessage(String string) {
        this.message = string;
    }

    public String displayString() {
        return String.valueOf(this.getMessageType()) + " " + this.message;
    }

    public void fromString(String string) throws ConversionException {
        LabeledData labeledData = new LabeledData();
        labeledData.fromString(string);
        if (!((Hashtable)labeledData).containsKey(MESSAGE_KEY)) {
            throw new ConversionException("Error in converting string to Message: Missing message Key");
        }
        this.message = labeledData.getData(MESSAGE_KEY);
    }

    public abstract String getMessageType();

    public LabeledData getMetaData() {
        LabeledData labeledData = new LabeledData();
        ((Hashtable)labeledData).put(CLASS_KEY, this.getClass().getName());
        return labeledData;
    }

    public String logString() {
        Stringizer stringizer = new Stringizer(parseTable);
        stringizer.appendToken((Object)TYPE_KEY, KEY_VALUE_SEPARATOR);
        stringizer.appendToken((Object)this.getMessageType(), PAIR_SEPARATOR);
        stringizer.appendToken((Object)MESSAGE_KEY, KEY_VALUE_SEPARATOR);
        stringizer.appendToken((Object)this.message, PAIR_SEPARATOR);
        return String.valueOf(stringizer.toString()) + PAIR_SEPARATOR;
    }

    public void setMetaData(LabeledData labeledData) {
    }

    public String toString() {
        return this.toString(null);
    }

    public String toString(String string) {
        LabeledData labeledData = new LabeledData();
        ((Hashtable)labeledData).put(MESSAGE_KEY, this.message);
        return labeledData.toString(string);
    }
}

