/*
 * Decompiled with CFR 0.152.
 */
package org.apache.curator.framework.imps;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.MapMaker;
import java.io.Closeable;
import java.lang.reflect.Field;
import java.util.concurrent.ConcurrentMap;
import org.apache.curator.framework.api.CuratorWatcher;
import org.apache.curator.framework.imps.CuratorFrameworkImpl;
import org.apache.curator.framework.imps.NamespaceWatcher;
import org.apache.zookeeper.Watcher;

class NamespaceWatcherMap
implements Closeable {
    private final ConcurrentMap<Object, NamespaceWatcher> map = new MapMaker().weakValues().makeMap();
    private final CuratorFrameworkImpl client;

    NamespaceWatcherMap(CuratorFrameworkImpl client) {
        this.client = client;
    }

    @Override
    public void close() {
        this.map.clear();
    }

    @VisibleForTesting
    void drain() throws Exception {
        Runtime.getRuntime().gc();
        Class<?> mapMakerInternalMapClass = Class.forName("com.google.common.collect.MapMakerInternalMap");
        Field drainThresholdField = mapMakerInternalMapClass.getDeclaredField("DRAIN_THRESHOLD");
        drainThresholdField.setAccessible(true);
        int drainThreshold = drainThresholdField.getInt(null) + 1;
        while (drainThreshold-- > 0) {
            this.map.get(new Object());
        }
    }

    @VisibleForTesting
    NamespaceWatcher get(Object key) {
        return (NamespaceWatcher)this.map.get(key);
    }

    @VisibleForTesting
    boolean isEmpty() {
        return this.map.isEmpty();
    }

    NamespaceWatcher getNamespaceWatcher(Watcher watcher) {
        return this.get(watcher, new NamespaceWatcher(this.client, watcher));
    }

    NamespaceWatcher getNamespaceWatcher(CuratorWatcher watcher) {
        return this.get(watcher, new NamespaceWatcher(this.client, watcher));
    }

    private NamespaceWatcher get(Object watcher, NamespaceWatcher newNamespaceWatcher) {
        NamespaceWatcher existingNamespaceWatcher = this.map.putIfAbsent(watcher, newNamespaceWatcher);
        return existingNamespaceWatcher != null ? existingNamespaceWatcher : newNamespaceWatcher;
    }
}

