/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.lib.partition;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.HadoopTestCase;
import org.apache.hadoop.mapred.Utils;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.MapReduceTestUtil;
import org.apache.hadoop.mapreduce.Reducer;
import org.apache.hadoop.mapreduce.lib.map.InverseMapper;
import org.apache.hadoop.mapreduce.lib.partition.KeyFieldBasedComparator;
import org.apache.hadoop.mapreduce.lib.partition.KeyFieldBasedPartitioner;

public class TestMRKeyFieldBasedComparator
extends HadoopTestCase {
    Configuration conf;
    String line1 = "123 -123 005120 123.9 0.01 0.18 010 10.0 4444.1 011 011 234";
    String line2 = "134 -12 005100 123.10 -1.01 0.19 02 10.1 4444";
    byte[] line1_bytes = this.line1.getBytes();
    byte[] line2_bytes = this.line2.getBytes();

    public TestMRKeyFieldBasedComparator() throws IOException {
        super(1, 4, 1, 1);
        this.conf = this.createJobConf();
        this.conf.set("mapreduce.map.output.key.field.separator", " ");
    }

    private void testComparator(String keySpec, int expect) throws Exception {
        String root = System.getProperty("test.build.data", "/tmp");
        Path inDir = new Path(root, "test_cmp/in");
        Path outDir = new Path(root, "test_cmp/out");
        this.conf.set("mapreduce.partition.keycomparator.options", keySpec);
        this.conf.set("mapreduce.partition.keypartitioner.options", "-k1.1,1.1");
        this.conf.set("mapreduce.map.output.key.field.separator", " ");
        Job job = MapReduceTestUtil.createJob(this.conf, inDir, outDir, 1, 1, this.line1 + "\n" + this.line2 + "\n");
        job.setMapperClass(InverseMapper.class);
        job.setReducerClass(Reducer.class);
        job.setOutputKeyClass(Text.class);
        job.setOutputValueClass(LongWritable.class);
        job.setSortComparatorClass(KeyFieldBasedComparator.class);
        job.setPartitionerClass(KeyFieldBasedPartitioner.class);
        job.waitForCompletion(true);
        TestMRKeyFieldBasedComparator.assertTrue((boolean)job.isSuccessful());
        Path[] outputFiles = FileUtil.stat2Paths((FileStatus[])this.getFileSystem().listStatus(outDir, (PathFilter)new Utils.OutputFileUtils.OutputFilesFilter()));
        if (outputFiles.length > 0) {
            FSDataInputStream is = this.getFileSystem().open(outputFiles[0]);
            BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)is));
            String line = reader.readLine();
            if (expect == 1) {
                TestMRKeyFieldBasedComparator.assertTrue((boolean)line.startsWith(this.line1));
            } else if (expect == 2) {
                TestMRKeyFieldBasedComparator.assertTrue((boolean)line.startsWith(this.line2));
            }
            line = reader.readLine();
            if (expect == 1) {
                TestMRKeyFieldBasedComparator.assertTrue((boolean)line.startsWith(this.line2));
            } else if (expect == 2) {
                TestMRKeyFieldBasedComparator.assertTrue((boolean)line.startsWith(this.line1));
            }
            reader.close();
        }
    }

    public void testBasicUnixComparator() throws Exception {
        this.testComparator("-k1,1n", 1);
        this.testComparator("-k2,2n", 1);
        this.testComparator("-k2.2,2n", 2);
        this.testComparator("-k3.4,3n", 2);
        this.testComparator("-k3.2,3.3n -k4,4n", 2);
        this.testComparator("-k3.2,3.3n -k4,4nr", 1);
        this.testComparator("-k2.4,2.4n", 2);
        this.testComparator("-k7,7", 1);
        this.testComparator("-k7,7n", 2);
        this.testComparator("-k8,8n", 1);
        this.testComparator("-k9,9", 2);
        this.testComparator("-k11,11", 2);
        this.testComparator("-k10,10", 2);
        this.testWithoutMRJob("-k9,9", 1);
        this.testWithoutMRJob("-k9n", 1);
    }

    public void testWithoutMRJob(String keySpec, int expect) throws Exception {
        KeyFieldBasedComparator keyFieldCmp = new KeyFieldBasedComparator();
        this.conf.set("mapreduce.partition.keycomparator.options", keySpec);
        keyFieldCmp.setConf(this.conf);
        int result = keyFieldCmp.compare(this.line1_bytes, 0, this.line1_bytes.length, this.line2_bytes, 0, this.line2_bytes.length);
        if (expect >= 0 && result < 0 || expect < 0 && result >= 0) {
            TestMRKeyFieldBasedComparator.fail();
        }
    }
}

