/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.backend.hadoop.executionengine.spark.running;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.JobID;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.input.FileSplit;
import org.apache.pig.backend.hadoop.executionengine.mapReduceLayer.PigHadoopLogger;
import org.apache.pig.backend.hadoop.executionengine.mapReduceLayer.PigInputFormat;
import org.apache.pig.backend.hadoop.executionengine.mapReduceLayer.PigMapReduce;
import org.apache.pig.backend.hadoop.executionengine.mapReduceLayer.PigSplit;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.PhysicalOperator;
import org.apache.pig.backend.hadoop.executionengine.shims.HadoopShims;
import org.apache.pig.backend.hadoop.executionengine.spark.SparkPigRecordReader;
import org.apache.pig.backend.hadoop.executionengine.spark.SparkPigSplit;
import org.apache.pig.backend.hadoop.executionengine.util.MapRedUtil;
import org.apache.pig.data.SchemaTupleBackend;
import org.apache.pig.data.Tuple;
import org.apache.pig.impl.PigContext;
import org.apache.pig.impl.util.ObjectSerializer;
import org.apache.pig.impl.util.UDFContext;
import org.apache.pig.tools.pigstats.spark.SparkCounters;

public class PigInputFormatSpark
extends PigInputFormat {
    @Override
    public RecordReader<Text, Tuple> createRecordReader(InputSplit split, TaskAttemptContext context) throws IOException, InterruptedException {
        this.resetUDFContext();
        PigSplit pigSplit = ((SparkPigSplit)split).getWrappedPigSplit();
        Configuration conf = context.getConfiguration();
        pigSplit.setConf(conf);
        if (PigMapReduce.sJobContext == null) {
            PigMapReduce.sJobContext = HadoopShims.createJobContext(conf, new JobID());
        }
        PigMapReduce.sJobContext.getConfiguration().setInt("pig.split.index", pigSplit.getSplitIndex());
        this.initialize(conf);
        SparkRecordReaderFactory sparkRecordReaderFactory = new SparkRecordReaderFactory(pigSplit, context);
        return sparkRecordReaderFactory.createRecordReader();
    }

    @Override
    public List<InputSplit> getSplits(JobContext jobcontext) throws IOException, InterruptedException {
        PigSplit split;
        ArrayList<InputSplit> sparkPigSplits = new ArrayList<InputSplit>();
        List<InputSplit> originalSplits = super.getSplits(jobcontext);
        boolean isFileSplits = true;
        for (InputSplit inputSplit : originalSplits) {
            split = (PigSplit)inputSplit;
            if (split.getWrappedSplit() instanceof FileSplit) continue;
            isFileSplits = false;
            break;
        }
        for (InputSplit inputSplit : originalSplits) {
            split = (PigSplit)inputSplit;
            if (!isFileSplits) {
                sparkPigSplits.add(new SparkPigSplit.GenericSparkPigSplit(split));
                continue;
            }
            sparkPigSplits.add((InputSplit)new SparkPigSplit.FileSparkPigSplit(split));
        }
        return sparkPigSplits;
    }

    private void initialize(Configuration jobConf) throws IOException {
        MapRedUtil.setupUDFContext(jobConf);
        PigContext pc = (PigContext)ObjectSerializer.deserialize(jobConf.get("pig.pigContext"));
        SchemaTupleBackend.initialize(jobConf, pc);
        PigMapReduce.sJobConfInternal.set(jobConf);
        PigHadoopLogger pigHadoopLogger = PigHadoopLogger.getInstance();
        pigHadoopLogger.setAggregate("true".equalsIgnoreCase(jobConf.get("aggregate.warning")));
        pigHadoopLogger.setReporter((SparkCounters)ObjectSerializer.deserialize(jobConf.get("pig.spark.counters")));
        PhysicalOperator.setPigLogger(pigHadoopLogger);
    }

    private void resetUDFContext() {
        UDFContext.getUDFContext().reset();
    }

    static class SparkRecordReaderFactory
    extends PigInputFormat.RecordReaderFactory {
        public SparkRecordReaderFactory(InputSplit split, TaskAttemptContext context) throws IOException {
            super(split, context);
        }

        @Override
        public RecordReader<Text, Tuple> createRecordReader() throws IOException, InterruptedException {
            return new SparkPigRecordReader(this.inputFormat, this.pigSplit, this.loadFunc, this.context, this.limit);
        }
    }
}

