/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.backend.hadoop.executionengine.tez.plan.operator;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.expressionOperators.ConstantExpression;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.expressionOperators.ExpressionOperator;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.expressionOperators.POProject;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.plans.PhysicalPlan;
import org.apache.pig.backend.hadoop.executionengine.tez.plan.TezCompiler;
import org.apache.pig.backend.hadoop.executionengine.tez.plan.operator.POLocalRearrangeTez;
import org.apache.pig.impl.plan.NodeIdGenerator;
import org.apache.pig.impl.plan.OperatorKey;
import org.apache.pig.impl.plan.PlanException;
import org.apache.pig.impl.util.Pair;

public class POLocalRearrangeTezFactory {
    private String scope;
    private NodeIdGenerator nig;

    public POLocalRearrangeTezFactory(String scope, NodeIdGenerator nig) {
        this.scope = scope;
        this.nig = nig;
    }

    public POLocalRearrangeTez create() throws PlanException {
        return this.create(0, LocalRearrangeType.STAR, null, (byte)0);
    }

    public POLocalRearrangeTez create(LocalRearrangeType type) throws PlanException {
        return this.create(0, type, null, (byte)0);
    }

    public POLocalRearrangeTez create(int index, LocalRearrangeType type) throws PlanException {
        return this.create(index, type, null, (byte)0);
    }

    public POLocalRearrangeTez create(int index, LocalRearrangeType type, List<PhysicalPlan> plans, byte keyType) throws PlanException {
        ExpressionOperator keyExpression = null;
        if (type == LocalRearrangeType.STAR) {
            keyExpression = new POProject(new OperatorKey(this.scope, this.nig.getNextNodeId(this.scope)));
            keyExpression.setResultType((byte)110);
            ((POProject)keyExpression).setStar(true);
        } else if (type == LocalRearrangeType.NULL) {
            keyExpression = new ConstantExpression(new OperatorKey(this.scope, this.nig.getNextNodeId(this.scope)));
            ((ConstantExpression)keyExpression).setValue(null);
            keyExpression.setResultType((byte)50);
        }
        PhysicalPlan addPlan = new PhysicalPlan();
        ArrayList addPlans = Lists.newArrayList();
        if (type == LocalRearrangeType.STAR || type == LocalRearrangeType.NULL) {
            addPlan.add(keyExpression);
            addPlans.add(addPlan);
        } else if (type == LocalRearrangeType.WITHPLAN) {
            addPlans.addAll(plans);
        }
        POLocalRearrangeTez lr = new POLocalRearrangeTez(new OperatorKey(this.scope, this.nig.getNextNodeId(this.scope)));
        try {
            lr.setIndex(index);
        }
        catch (ExecException e) {
            int errCode = 2058;
            String msg = "Unable to set index on the newly created POLocalRearrange.";
            throw new PlanException(msg, errCode, 4, (Throwable)e);
        }
        if (type == LocalRearrangeType.STAR) {
            lr.setKeyType((byte)110);
        } else if (type == LocalRearrangeType.NULL) {
            lr.setKeyType((byte)50);
        } else if (type == LocalRearrangeType.WITHPLAN) {
            Pair<POProject, Byte>[] fields = TezCompiler.getSortCols(plans);
            lr.setKeyType(fields == null || fields.length > 1 ? (byte)110 : keyType);
        }
        lr.setResultType((byte)110);
        lr.setPlans(addPlans);
        return lr;
    }

    public static enum LocalRearrangeType {
        STAR,
        NULL,
        NORMAL,
        WITHPLAN;

    }
}

