/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.newplan.logical.relational;

import java.util.ArrayList;
import java.util.List;
import org.apache.pig.impl.logicalLayer.FrontendException;
import org.apache.pig.newplan.Operator;
import org.apache.pig.newplan.OperatorPlan;
import org.apache.pig.newplan.PlanVisitor;
import org.apache.pig.newplan.logical.expression.LogicalExpression;
import org.apache.pig.newplan.logical.expression.LogicalExpressionPlan;
import org.apache.pig.newplan.logical.relational.LogicalRelationalNodesVisitor;
import org.apache.pig.newplan.logical.relational.LogicalRelationalOperator;
import org.apache.pig.newplan.logical.relational.LogicalSchema;

public class LORank
extends LogicalRelationalOperator {
    private static final String RANK_COL_NAME = "rank";
    private static final String SEPARATOR = "_";
    private List<LogicalExpressionPlan> rankColPlans;
    private List<Boolean> ascCols;
    private boolean isDenseRank = false;
    private boolean isRowNumber = false;
    private long rankColumnUid = -1L;

    public LORank(OperatorPlan plan) {
        super("LORank", plan);
    }

    public LORank(OperatorPlan plan, List<LogicalExpressionPlan> rankColPlans, List<Boolean> ascCols) {
        this(plan);
        this.rankColPlans = rankColPlans;
        this.ascCols = ascCols;
        this.rankColumnUid = -1L;
    }

    public List<LogicalExpressionPlan> getRankColPlans() {
        return this.rankColPlans;
    }

    public void setRankColPlan(List<LogicalExpressionPlan> rankColPlans) {
        this.rankColPlans = rankColPlans;
    }

    public List<Boolean> getAscendingCol() {
        return this.ascCols;
    }

    public void setAscendingCol(List<Boolean> ascCols) {
        this.ascCols = ascCols;
    }

    @Override
    public LogicalSchema getSchema() throws FrontendException {
        if (this.schema != null) {
            return this.schema;
        }
        LogicalRelationalOperator input = null;
        input = (LogicalRelationalOperator)this.plan.getPredecessors(this).get(0);
        if (input == null) {
            return null;
        }
        LogicalSchema inputSchema = input.getSchema();
        if (inputSchema == null) {
            this.schema = null;
            return this.schema;
        }
        ArrayList<LogicalSchema.LogicalFieldSchema> fss = new ArrayList<LogicalSchema.LogicalFieldSchema>();
        for (int i = 0; i < inputSchema.size(); ++i) {
            LogicalSchema.LogicalFieldSchema fs = inputSchema.getField(i);
            LogicalSchema.LogicalFieldSchema newFS = null;
            newFS = new LogicalSchema.LogicalFieldSchema(fs.alias, fs.schema, fs.type, fs.uid);
            fss.add(newFS);
        }
        this.schema = new LogicalSchema();
        this.rankColumnUid = this.rankColumnUid == -1L ? LogicalExpression.getNextUid() : this.rankColumnUid;
        this.schema.addField(new LogicalSchema.LogicalFieldSchema("rank_" + input.getAlias(), null, 15, this.rankColumnUid));
        for (LogicalSchema.LogicalFieldSchema fieldSchema : fss) {
            this.schema.addField(fieldSchema);
        }
        return this.schema;
    }

    @Override
    public void accept(PlanVisitor v) throws FrontendException {
        if (!(v instanceof LogicalRelationalNodesVisitor)) {
            throw new FrontendException("Expected LogicalPlanVisitor", 2223);
        }
        ((LogicalRelationalNodesVisitor)v).visit(this);
    }

    @Override
    public boolean isEqual(Operator other) throws FrontendException {
        if (other != null && other instanceof LORank) {
            LORank oR = (LORank)other;
            if (!this.rankColPlans.equals(oR.rankColPlans)) {
                return false;
            }
        } else {
            return false;
        }
        return this.checkEquality((LogicalRelationalOperator)other);
    }

    public boolean isDenseRank() {
        return this.isDenseRank;
    }

    public void setIsDenseRank(boolean isDenseRank) {
        this.isDenseRank = isDenseRank;
    }

    public boolean isRowNumber() {
        return this.isRowNumber;
    }

    public void setIsRowNumber(boolean rowNumber) {
        this.isRowNumber = rowNumber;
    }
}

