/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.backend.hadoop.executionengine.spark.converter;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.backend.hadoop.executionengine.spark.SparkPigContext;
import org.apache.pig.backend.hadoop.executionengine.spark.SparkUtil;
import org.apache.pig.backend.hadoop.executionengine.spark.converter.IndexedKey;
import org.apache.pig.backend.hadoop.executionengine.spark.converter.IteratorTransform;
import org.apache.pig.backend.hadoop.executionengine.spark.converter.PigSecondaryKeyComparatorSpark;
import org.apache.pig.backend.hadoop.executionengine.spark.converter.RDDConverter;
import org.apache.pig.backend.hadoop.executionengine.spark.operator.POGlobalRearrangeSpark;
import org.apache.pig.data.Tuple;
import org.apache.pig.data.TupleFactory;
import org.apache.spark.HashPartitioner;
import org.apache.spark.Partitioner;
import org.apache.spark.api.java.JavaPairRDD;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.function.FlatMapFunction;
import org.apache.spark.api.java.function.Function;
import org.apache.spark.rdd.CoGroupedRDD;
import org.apache.spark.rdd.RDD;
import scala.Function1;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.JavaConversions;
import scala.collection.Seq;
import scala.runtime.AbstractFunction1;

public class GlobalRearrangeConverter
implements RDDConverter<Tuple, Tuple, POGlobalRearrangeSpark> {
    private static final Log LOG = LogFactory.getLog(GlobalRearrangeConverter.class);
    private static final TupleFactory tf = TupleFactory.getInstance();

    @Override
    public RDD<Tuple> convert(List<RDD<Tuple>> predecessors, POGlobalRearrangeSpark op) throws IOException {
        SparkUtil.assertPredecessorSizeGreaterThan(predecessors, op, 0);
        SparkPigContext.get();
        int parallelism = SparkPigContext.getParallelism(predecessors, op);
        ArrayList<RDD> rddPairs = new ArrayList<RDD>();
        if (predecessors.size() == 1 && op.isUseSecondaryKey()) {
            rddPairs.add(this.handleSecondarySort(predecessors.get(0), op, parallelism).rdd());
        } else {
            for (RDD<Tuple> rDD : predecessors) {
                JavaRDD jrdd = JavaRDD.fromRDD(rDD, SparkUtil.getManifest(Tuple.class));
                JavaRDD rddPair = jrdd.map((Function)new ToKeyValueFunction());
                rddPairs.add(rddPair.rdd());
            }
        }
        CoGroupedRDD coGroupedRDD = new CoGroupedRDD(JavaConversions.asScalaBuffer(rddPairs).toSeq(), SparkUtil.getPartitioner(op.getCustomPartitioner(), parallelism), SparkUtil.getManifest(Object.class));
        RDD rDD = (RDD)coGroupedRDD;
        return rDD.toJavaRDD().map((Function)new ToGroupKeyValueFunction()).rdd();
    }

    private JavaRDD<Tuple2<IndexedKey, Tuple>> handleSecondarySort(RDD<Tuple> rdd, POGlobalRearrangeSpark op, int parallelism) {
        RDD rddPair = rdd.map((Function1)new ToKeyNullValueFunction(), SparkUtil.getTuple2Manifest());
        JavaPairRDD pairRDD = new JavaPairRDD(rddPair, SparkUtil.getManifest(Tuple.class), SparkUtil.getManifest(Object.class));
        JavaPairRDD sorted = pairRDD.repartitionAndSortWithinPartitions((Partitioner)new HashPartitioner(parallelism), (Comparator)new PigSecondaryKeyComparatorSpark(op.getSecondarySortOrder()));
        JavaRDD jrdd = sorted.keys();
        JavaRDD jrddPair = jrdd.map((Function)new ToKeyValueFunction(op));
        return jrddPair;
    }

    private static class IteratorUnion<T>
    implements Iterator<T> {
        private final Iterator<Iterator<T>> iterators;
        private Iterator<T> current;

        public IteratorUnion(Iterator<Iterator<T>> iterators) {
            this.iterators = iterators;
        }

        @Override
        public boolean hasNext() {
            if (this.current != null && this.current.hasNext()) {
                return true;
            }
            if (this.iterators.hasNext()) {
                this.current = this.iterators.next();
                return this.hasNext();
            }
            return false;
        }

        @Override
        public T next() {
            return this.current.next();
        }

        @Override
        public void remove() {
            this.current.remove();
        }
    }

    private static class ToGroupKeyValueFunction
    implements Function<Tuple2<IndexedKey, Seq<Seq<Tuple>>>, Tuple>,
    Serializable {
        private ToGroupKeyValueFunction() {
        }

        public Tuple call(Tuple2<IndexedKey, Seq<Seq<Tuple>>> input) {
            try {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("ToGroupKeyValueFunction in " + input));
                }
                Object key = ((IndexedKey)input._1()).getKey();
                Object obj = input._2();
                Seq[] bags = (Seq[])obj;
                int i = 0;
                ArrayList<1> tupleIterators = new ArrayList<1>();
                for (int j = 0; j < bags.length; ++j) {
                    Seq bag = bags[j];
                    Iterator iterator = JavaConversions.asJavaCollection((Iterable)bag).iterator();
                    final int index = i++;
                    tupleIterators.add(new IteratorTransform<Tuple, Tuple>(iterator){

                        @Override
                        protected Tuple transform(Tuple next) {
                            try {
                                Tuple tuple = tf.newTuple(3);
                                tuple.set(0, index);
                                tuple.set(1, next);
                                return tuple;
                            }
                            catch (ExecException e) {
                                throw new RuntimeException(e);
                            }
                        }
                    });
                }
                Tuple out = tf.newTuple(2);
                out.set(0, key);
                out.set(1, new IteratorUnion(tupleIterators.iterator()));
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("ToGroupKeyValueFunction out " + out));
                }
                return out;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    private static class ToKeyValueFunction
    implements Function<Tuple, Tuple2<IndexedKey, Tuple>>,
    Serializable {
        private POGlobalRearrangeSpark glrSpark = null;

        public ToKeyValueFunction(POGlobalRearrangeSpark glrSpark) {
            this.glrSpark = glrSpark;
        }

        public ToKeyValueFunction() {
        }

        public Tuple2<IndexedKey, Tuple> call(Tuple t) {
            try {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("ToKeyValueFunction in " + t));
                }
                Object key = null;
                key = this.glrSpark != null && this.glrSpark.isUseSecondaryKey() ? ((Tuple)t.get(1)).get(0) : t.get(1);
                Tuple2 out = new Tuple2((Object)new IndexedKey((Byte)t.get(0), key), (Object)((Tuple)t.get(2)));
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("ToKeyValueFunction out " + out));
                }
                return out;
            }
            catch (ExecException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private static class GroupTupleFunction
    implements Function<Tuple2<Object, java.lang.Iterable<Tuple>>, Tuple>,
    Serializable {
        public final POGlobalRearrangeSpark glrSpark;

        public GroupTupleFunction(POGlobalRearrangeSpark globalRearrangeSpark) {
            this.glrSpark = globalRearrangeSpark;
        }

        public Tuple call(Tuple2<Object, java.lang.Iterable<Tuple>> v1) {
            try {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("GroupTupleFunction in " + v1));
                }
                Tuple tuple = tf.newTuple(2);
                tuple.set(0, v1._1());
                tuple.set(1, ((java.lang.Iterable)v1._2()).iterator());
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("GroupTupleFunction out " + tuple));
                }
                return tuple;
            }
            catch (ExecException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private static class GetKeyFunction
    implements Function<Tuple, Object>,
    Serializable {
        public final POGlobalRearrangeSpark glrSpark;

        public GetKeyFunction(POGlobalRearrangeSpark globalRearrangeSpark) {
            this.glrSpark = globalRearrangeSpark;
        }

        public Object call(Tuple t) {
            try {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("GetKeyFunction in " + t));
                }
                Object key = this.glrSpark != null && this.glrSpark.isUseSecondaryKey() ? ((Tuple)t.get(1)).get(0) : t.get(1);
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("GetKeyFunction out " + key));
                }
                return key;
            }
            catch (ExecException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private static class ToKeyNullValueFunction
    extends AbstractFunction1<Tuple, Tuple2<Tuple, Object>>
    implements Serializable {
        private ToKeyNullValueFunction() {
        }

        public Tuple2<Tuple, Object> apply(Tuple t) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("ToKeyNullValueFunction in " + t));
            }
            Tuple2 out = new Tuple2((Object)t, null);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("ToKeyNullValueFunction out " + out));
            }
            return out;
        }
    }

    private static class RemoveValueFunction
    implements FlatMapFunction<Iterator<Tuple2<Tuple, Object>>, Tuple>,
    Serializable {
        private RemoveValueFunction() {
        }

        public java.lang.Iterable<Tuple> call(Iterator<Tuple2<Tuple, Object>> input) {
            return new Tuple2TransformIterable(input);
        }

        private class Tuple2TransformIterable
        implements java.lang.Iterable<Tuple> {
            Iterator<Tuple2<Tuple, Object>> in;

            Tuple2TransformIterable(Iterator<Tuple2<Tuple, Object>> input) {
                this.in = input;
            }

            @Override
            public Iterator<Tuple> iterator() {
                return new IteratorTransform<Tuple2<Tuple, Object>, Tuple>(this.in){

                    @Override
                    protected Tuple transform(Tuple2<Tuple, Object> next) {
                        return (Tuple)next._1();
                    }
                };
            }
        }
    }
}

