/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.backend.hadoop.executionengine.tez;

import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.LocalResource;
import org.apache.pig.backend.hadoop.executionengine.tez.TezSessionManager;
import org.apache.pig.backend.hadoop.executionengine.tez.plan.TezOpPlanVisitor;
import org.apache.pig.backend.hadoop.executionengine.tez.plan.TezOperPlan;
import org.apache.pig.backend.hadoop.executionengine.tez.plan.TezOperator;
import org.apache.pig.impl.plan.DependencyOrderWalker;
import org.apache.pig.impl.plan.PlanWalker;
import org.apache.pig.impl.plan.VisitorException;
import org.apache.pig.impl.util.UDFContext;
import org.apache.pig.tools.pigstats.tez.TezPigScriptStats;
import org.apache.tez.client.TezClient;
import org.apache.tez.common.counters.TezCounters;
import org.apache.tez.dag.api.DAG;
import org.apache.tez.dag.api.TezConfiguration;
import org.apache.tez.dag.api.TezException;
import org.apache.tez.dag.api.client.DAGClient;
import org.apache.tez.dag.api.client.DAGStatus;
import org.apache.tez.dag.api.client.Progress;
import org.apache.tez.dag.api.client.StatusGetOpts;
import org.apache.tez.dag.api.client.VertexStatus;

public class TezJob
implements Runnable {
    private static final Log log = LogFactory.getLog(TezJob.class);
    private TezConfiguration conf;
    private EnumSet<StatusGetOpts> statusGetOpts;
    private Map<String, LocalResource> requestAMResources;
    private ApplicationId appId;
    private DAG dag;
    private DAGClient dagClient;
    private DAGStatus dagStatus;
    private TezClient tezClient;
    private boolean reuseSession;
    private TezCounters dagCounters;
    private Timer timer;
    private TezJobConfig tezJobConf;
    private TezPigScriptStats pigStats;

    public TezJob(TezConfiguration conf, DAG dag, Map<String, LocalResource> requestAMResources, TezOperPlan tezPlan) throws IOException {
        this.conf = conf;
        this.dag = dag;
        this.requestAMResources = requestAMResources;
        this.reuseSession = conf.getBoolean("pig.tez.session.reuse", true);
        this.statusGetOpts = EnumSet.of(StatusGetOpts.GET_COUNTERS);
        this.tezJobConf = new TezJobConfig(tezPlan);
    }

    public DAG getDAG() {
        return this.dag;
    }

    public String getName() {
        return this.dag.getName();
    }

    public Configuration getConfiguration() {
        return this.conf;
    }

    public ApplicationId getApplicationId() {
        return this.appId;
    }

    public DAGStatus getDAGStatus() {
        return this.dagStatus;
    }

    public TezCounters getDAGCounters() {
        return this.dagCounters;
    }

    public float getDAGProgress() {
        Progress p = this.dagStatus.getDAGProgress();
        return p == null ? 0.0f : (float)p.getSucceededTaskCount() / (float)p.getTotalTaskCount();
    }

    public Map<String, Float> getVertexProgress() {
        HashMap vertexProgress = Maps.newHashMap();
        for (Map.Entry entry : this.dagStatus.getVertexProgress().entrySet()) {
            Progress p = (Progress)entry.getValue();
            float progress = (float)p.getSucceededTaskCount() / (float)p.getTotalTaskCount();
            vertexProgress.put(entry.getKey(), Float.valueOf(progress));
        }
        return vertexProgress;
    }

    public VertexStatus getVertexStatus(String vertexName) {
        VertexStatus vs = null;
        try {
            vs = this.dagClient.getVertexStatus(vertexName, this.statusGetOpts);
        }
        catch (Exception e) {
            log.warn((Object)("Cannot retrieve status for vertex " + vertexName), (Throwable)e);
        }
        return vs;
    }

    public void setPigStats(TezPigScriptStats pigStats) {
        this.pigStats = pigStats;
    }

    @Override
    public void run() {
        UDFContext udfContext = UDFContext.getUDFContext();
        try {
            this.tezClient = TezSessionManager.getClient(this.conf, this.requestAMResources, this.dag.getCredentials(), this.tezJobConf);
            log.info((Object)("Submitting DAG " + this.dag.getName()));
            this.dagClient = this.tezClient.submitDAG(this.dag);
            this.appId = this.tezClient.getAppMasterApplicationId();
            log.info((Object)("Submitted DAG " + this.dag.getName() + ". Application id: " + this.appId));
        }
        catch (Exception e) {
            if (this.tezClient != null) {
                log.error((Object)("Cannot submit DAG - Application id: " + this.tezClient.getAppMasterApplicationId()), (Throwable)e);
            } else {
                log.error((Object)"Cannot submit DAG", (Throwable)e);
            }
            return;
        }
        this.timer = new Timer();
        this.timer.schedule((TimerTask)new DAGStatusReporter(), 1000L, this.conf.getLong("pig.tez.dag.status.report.interval", 20L) * 1000L);
        while (true) {
            try {
                this.dagStatus = this.dagClient.getDAGStatus(null);
            }
            catch (Exception e) {
                log.info((Object)"Cannot retrieve DAG status", (Throwable)e);
                break;
            }
            if (this.dagStatus.isCompleted()) {
                try {
                    this.dagStatus = this.dagClient.getDAGStatus(this.statusGetOpts);
                }
                catch (Exception e) {
                    log.warn((Object)"Failed to retrieve DAG counters", (Throwable)e);
                }
                UDFContext.setUdfContext(udfContext);
                log.info((Object)("DAG Status: " + this.dagStatus));
                this.dagCounters = this.dagStatus.getDAGCounters();
                TezSessionManager.freeSession(this.tezClient);
                try {
                    this.pigStats.accumulateStats(this);
                }
                catch (Exception e) {
                    log.warn((Object)"Exception while gathering stats", (Throwable)e);
                }
                try {
                    if (!this.reuseSession) {
                        TezSessionManager.stopSession(this.tezClient);
                    }
                    this.tezClient = null;
                    this.dagClient = null;
                }
                catch (Exception e) {
                    log.info((Object)"Cannot stop Tez session", (Throwable)e);
                }
                break;
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {}
        }
        this.timer.cancel();
    }

    public void killJob() throws IOException {
        try {
            if (this.dagClient != null) {
                this.dagClient.tryKillDAG();
            }
            if (this.tezClient != null) {
                this.tezClient.stop();
            }
        }
        catch (TezException e) {
            throw new IOException("Cannot kill DAG - Application Id: " + this.appId, e);
        }
    }

    public String getDiagnostics() {
        try {
            if (this.dagClient != null && this.dagStatus == null) {
                this.dagStatus = this.dagClient.getDAGStatus(null);
            }
            if (this.dagStatus != null) {
                return StringUtils.join((Collection)this.dagStatus.getDiagnostics(), (String)"\n");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "";
    }

    private class DAGStatusReporter
    extends TimerTask {
        private String prevDAGStatus;

        private DAGStatusReporter() {
        }

        @Override
        public void run() {
            if (TezJob.this.dagStatus == null) {
                return;
            }
            String currDAGStatus = TezJob.this.dagStatus.toString();
            if (!currDAGStatus.equals(this.prevDAGStatus)) {
                log.info((Object)("DAG Status: " + currDAGStatus));
                this.prevDAGStatus = currDAGStatus;
            }
        }
    }

    private static class MaxOutputsFinder
    extends TezOpPlanVisitor {
        private int maxOutputsinSingleVertex = 1;
        private int totalVertices = 0;

        public MaxOutputsFinder(TezOperPlan plan) {
            super(plan, (PlanWalker<TezOperator, TezOperPlan>)new DependencyOrderWalker<TezOperator, TezOperPlan>(plan));
        }

        public int getMaxOutputsinSingleVertex() {
            return this.maxOutputsinSingleVertex;
        }

        public int getTotalVertices() {
            return this.totalVertices;
        }

        @Override
        public void visitTezOp(TezOperator tezOperator) throws VisitorException {
            if (!tezOperator.isVertexGroup()) {
                ++this.totalVertices;
                int outputs = tezOperator.outEdges.keySet().size();
                this.maxOutputsinSingleVertex = this.maxOutputsinSingleVertex > outputs ? this.maxOutputsinSingleVertex : outputs;
            }
        }
    }

    static class TezJobConfig {
        private int estimatedTotalParallelism = -1;
        private int maxOutputsinSingleVertex;
        private int totalVertices = 0;

        public TezJobConfig(TezOperPlan tezPlan) throws VisitorException {
            this.estimatedTotalParallelism = tezPlan.getEstimatedTotalParallelism();
            MaxOutputsFinder finder = new MaxOutputsFinder(tezPlan);
            finder.visit();
            this.maxOutputsinSingleVertex = finder.getMaxOutputsinSingleVertex();
            this.totalVertices = finder.getTotalVertices();
        }

        public int getEstimatedTotalParallelism() {
            return this.estimatedTotalParallelism;
        }

        public int getMaxOutputsinSingleVertex() {
            return this.maxOutputsinSingleVertex;
        }

        public int getTotalVertices() {
            return this.totalVertices;
        }
    }
}

