/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.newplan.logical.rules;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.backend.hadoop.datastorage.ConfigurationUtil;
import org.apache.pig.backend.hadoop.executionengine.mapReduceLayer.PigHadoopLogger;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.PhysicalOperator;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.plans.PhysicalPlan;
import org.apache.pig.impl.PigContext;
import org.apache.pig.impl.logicalLayer.FrontendException;
import org.apache.pig.impl.util.UDFContext;
import org.apache.pig.newplan.BaseOperatorPlan;
import org.apache.pig.newplan.DependencyOrderWalker;
import org.apache.pig.newplan.Operator;
import org.apache.pig.newplan.OperatorPlan;
import org.apache.pig.newplan.ReverseDependencyOrderWalkerWOSeenChk;
import org.apache.pig.newplan.logical.expression.AllSameExpressionVisitor;
import org.apache.pig.newplan.logical.expression.ConstantExpression;
import org.apache.pig.newplan.logical.expression.ExpToPhyTranslationVisitor;
import org.apache.pig.newplan.logical.expression.LogicalExpression;
import org.apache.pig.newplan.logical.expression.LogicalExpressionPlan;
import org.apache.pig.newplan.logical.expression.LogicalExpressionVisitor;
import org.apache.pig.newplan.logical.expression.UserFuncExpression;
import org.apache.pig.newplan.logical.optimizer.AllExpressionVisitor;
import org.apache.pig.newplan.logical.relational.LogicalRelationalOperator;
import org.apache.pig.newplan.optimizer.Rule;
import org.apache.pig.newplan.optimizer.Transformer;
import org.joda.time.DateTimeZone;

public abstract class ConstantCalculator
extends Rule {
    private List<LogicalRelationalOperator> processedOperators = new ArrayList<LogicalRelationalOperator>();
    private PigContext pc;

    public ConstantCalculator(String n, PigContext pc) {
        super(n, false);
        this.pc = pc;
    }

    @Override
    public Transformer getNewTransformer() {
        return new ConstantCalculatorTransformer(this.processedOperators, this.pc);
    }

    public static class ConstantCalculatorTransformer
    extends Transformer {
        private List<LogicalRelationalOperator> processedOperators = new ArrayList<LogicalRelationalOperator>();
        private OperatorPlan plan;
        private PigContext pc;

        public ConstantCalculatorTransformer(List<LogicalRelationalOperator> processedOperators, PigContext pc) {
            this.processedOperators = processedOperators;
            this.pc = pc;
        }

        @Override
        public boolean check(OperatorPlan matched) throws FrontendException {
            Iterator<Operator> operators = matched.getOperators();
            while (operators.hasNext()) {
                LogicalRelationalOperator operator = (LogicalRelationalOperator)operators.next();
                if (this.processedOperators.contains(operator)) continue;
                this.processedOperators.add(operator);
                return true;
            }
            return false;
        }

        @Override
        public void transform(OperatorPlan matched) throws FrontendException {
            ConstantCalculatorLogicalPlanVisitor expressionVisitor = new ConstantCalculatorLogicalPlanVisitor(matched, this.pc);
            expressionVisitor.visit();
        }

        @Override
        public OperatorPlan reportChanges() {
            return this.plan;
        }

        public static class ConstantCalculatorExpressionVisitor
        extends AllSameExpressionVisitor {
            private LogicalRelationalOperator currentOp;
            private PigContext pc;
            private DateTimeZone currentDTZ = null;

            public ConstantCalculatorExpressionVisitor(OperatorPlan expPlan, LogicalRelationalOperator currentOp, PigContext pc) throws FrontendException {
                super(expPlan, new ReverseDependencyOrderWalkerWOSeenChk(expPlan));
                this.currentOp = currentOp;
                this.pc = pc;
            }

            @Override
            protected void execute(LogicalExpression op) throws FrontendException {
                UserFuncExpression udf;
                if (op instanceof UserFuncExpression && !(udf = (UserFuncExpression)op).getEvalFunc().allowCompileTimeCalculation()) {
                    return;
                }
                boolean valSet = false;
                Object val = null;
                if (this.currentWalker.getPlan().getSuccessors(op) != null) {
                    for (Operator succ : this.currentWalker.getPlan().getSuccessors(op)) {
                        if (succ instanceof ConstantExpression) continue;
                        return;
                    }
                    LogicalExpressionPlan expLogicalPlan = new LogicalExpressionPlan();
                    ((BaseOperatorPlan)this.currentWalker.getPlan()).moveTree(op, expLogicalPlan);
                    PhysicalPlan expPhysicalPlan = new PhysicalPlan();
                    HashMap<Operator, PhysicalOperator> logToPhyMap = new HashMap<Operator, PhysicalOperator>();
                    ReverseDependencyOrderWalkerWOSeenChk childWalker = new ReverseDependencyOrderWalkerWOSeenChk(expLogicalPlan);
                    this.pushWalker(childWalker);
                    ExpToPhyTranslationVisitor expTranslationVisitor = new ExpToPhyTranslationVisitor(expLogicalPlan, childWalker, this.currentOp, expPhysicalPlan, logToPhyMap);
                    expTranslationVisitor.visit();
                    this.popWalker();
                    PhysicalOperator root = (PhysicalOperator)expPhysicalPlan.getLeaves().get(0);
                    try {
                        UDFContext.getUDFContext().addJobConf(ConfigurationUtil.toConfiguration(this.pc.getProperties(), true));
                        PigHadoopLogger pigHadoopLogger = PigHadoopLogger.getInstance();
                        PhysicalOperator.setPigLogger(pigHadoopLogger);
                        this.setDefaultTimeZone();
                        val = root.getNext((byte)root.getResultType()).result;
                        this.restoreDefaultTimeZone();
                        UDFContext.getUDFContext().addJobConf(null);
                    }
                    catch (ExecException e) {
                        throw new FrontendException(e);
                    }
                    valSet = true;
                } else if (op instanceof UserFuncExpression) {
                    UserFuncExpression udf2 = (UserFuncExpression)op;
                    try {
                        UDFContext.getUDFContext().addJobConf(ConfigurationUtil.toConfiguration(this.pc.getProperties(), true));
                        this.setDefaultTimeZone();
                        val = udf2.getEvalFunc().exec(null);
                        this.restoreDefaultTimeZone();
                        UDFContext.getUDFContext().addJobConf(null);
                    }
                    catch (IOException e) {
                        throw new FrontendException(e);
                    }
                    valSet = true;
                }
                if (valSet) {
                    ConstantExpression constantExpr = new ConstantExpression(this.currentWalker.getPlan(), val);
                    constantExpr.inheritSchema(op);
                    this.currentWalker.getPlan().replace(op, constantExpr);
                }
            }

            private void setDefaultTimeZone() {
                String dtzStr = this.pc.getProperties().getProperty("pig.datetime.default.tz");
                if (dtzStr != null && dtzStr.length() > 0) {
                    this.currentDTZ = DateTimeZone.getDefault();
                    DateTimeZone.setDefault(DateTimeZone.forID(dtzStr));
                }
            }

            private void restoreDefaultTimeZone() {
                if (this.currentDTZ != null) {
                    DateTimeZone.setDefault(this.currentDTZ);
                    this.currentDTZ = null;
                }
            }
        }

        public static class ConstantCalculatorLogicalPlanVisitor
        extends AllExpressionVisitor {
            private PigContext pc;

            public ConstantCalculatorLogicalPlanVisitor(OperatorPlan plan, PigContext pc) throws FrontendException {
                super(plan, new DependencyOrderWalker(plan));
                this.pc = pc;
            }

            @Override
            protected LogicalExpressionVisitor getVisitor(LogicalExpressionPlan expr) throws FrontendException {
                return new ConstantCalculatorExpressionVisitor(expr, this.currentOp, this.pc);
            }
        }
    }
}

