/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.tools.pigstats.spark;

import com.google.common.collect.Maps;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapred.Counters;
import org.apache.pig.PigWarning;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POLoad;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POStore;
import org.apache.pig.backend.hadoop.executionengine.spark.JobMetricsListener;
import org.apache.pig.backend.hadoop.executionengine.spark.plan.SparkOperator;
import org.apache.pig.impl.logicalLayer.FrontendException;
import org.apache.pig.newplan.PlanVisitor;
import org.apache.pig.tools.pigstats.InputStats;
import org.apache.pig.tools.pigstats.JobStats;
import org.apache.pig.tools.pigstats.OutputStats;
import org.apache.pig.tools.pigstats.PigStats;
import org.apache.pig.tools.pigstats.spark.SparkCounter;
import org.apache.pig.tools.pigstats.spark.SparkCounterGroup;
import org.apache.pig.tools.pigstats.spark.SparkCounters;
import org.apache.pig.tools.pigstats.spark.SparkPigStatusReporter;
import org.apache.pig.tools.pigstats.spark.SparkScriptState;
import org.apache.pig.tools.pigstats.spark.SparkStatsUtil;
import org.apache.spark.executor.InputMetrics;
import org.apache.spark.executor.OutputMetrics;
import org.apache.spark.executor.ShuffleReadMetrics;
import org.apache.spark.executor.ShuffleWriteMetrics;
import org.apache.spark.executor.TaskMetrics;
import scala.Option;

public class SparkJobStats
extends JobStats {
    private int jobId;
    private Map<String, Long> stats = Maps.newLinkedHashMap();
    private boolean disableCounter;
    private Counters counters = null;
    public static String FS_COUNTER_GROUP = "FS_GROUP";
    private Map<String, SparkCounter<Map<String, Long>>> warningCounters = null;

    protected SparkJobStats(int jobId, PigStats.JobGraph plan, Configuration conf) {
        this(String.valueOf(jobId), plan, conf);
        this.jobId = jobId;
    }

    protected SparkJobStats(String jobId, PigStats.JobGraph plan, Configuration conf) {
        super(jobId, plan);
        this.setConf(conf);
    }

    @Override
    public void setConf(Configuration conf) {
        super.setConf(conf);
        this.disableCounter = conf.getBoolean("pig.disable.counter", false);
        this.initializeHadoopCounter();
    }

    public void addOutputInfo(POStore poStore, boolean success, JobMetricsListener jobMetricsListener) {
        if (!poStore.isTmpStore()) {
            long bytes = SparkJobStats.getOutputSize(poStore, this.conf);
            long recordsCount = -1L;
            if (!this.disableCounter) {
                recordsCount = SparkStatsUtil.getRecordCount(poStore);
            }
            OutputStats outputStats = new OutputStats(poStore.getSFile().getFileName(), bytes, recordsCount, success);
            outputStats.setPOStore(poStore);
            outputStats.setConf(this.conf);
            this.outputs.add(outputStats);
        }
    }

    public void addInputStats(POLoad po, boolean success, boolean singleInput) {
        long recordsCount = -1L;
        if (!this.disableCounter) {
            recordsCount = SparkStatsUtil.getRecordCount(po);
        }
        long bytesRead = -1L;
        if (singleInput && this.stats.get("BytesRead") != null) {
            bytesRead = this.stats.get("BytesRead");
        }
        InputStats inputStats = new InputStats(po.getLFile().getFileName(), bytesRead, recordsCount, success);
        inputStats.setConf(this.conf);
        this.inputs.add(inputStats);
    }

    public void collectStats(JobMetricsListener jobMetricsListener) {
        if (jobMetricsListener != null) {
            Map<String, List<TaskMetrics>> taskMetrics = jobMetricsListener.getJobMetric(this.jobId);
            if (taskMetrics == null) {
                throw new RuntimeException("No task metrics available for jobId " + this.jobId);
            }
            this.stats = this.combineTaskMetrics(taskMetrics);
        }
    }

    public Map<String, Long> getStats() {
        return this.stats;
    }

    private Map<String, Long> combineTaskMetrics(Map<String, List<TaskMetrics>> jobMetric) {
        LinkedHashMap results = Maps.newLinkedHashMap();
        long executorDeserializeTime = 0L;
        long executorRunTime = 0L;
        long resultSize = 0L;
        long jvmGCTime = 0L;
        long resultSerializationTime = 0L;
        long memoryBytesSpilled = 0L;
        long diskBytesSpilled = 0L;
        long bytesRead = 0L;
        long bytesWritten = 0L;
        long remoteBlocksFetched = 0L;
        long localBlocksFetched = 0L;
        long fetchWaitTime = 0L;
        long remoteBytesRead = 0L;
        long shuffleBytesWritten = 0L;
        long shuffleWriteTime = 0L;
        boolean inputMetricExist = false;
        boolean outputMetricExist = false;
        boolean shuffleReadMetricExist = false;
        boolean shuffleWriteMetricExist = false;
        for (List<TaskMetrics> stageMetric : jobMetric.values()) {
            if (stageMetric == null) continue;
            for (TaskMetrics taskMetrics : stageMetric) {
                Option shuffleWriteMetricsOption;
                Option shuffleReadMetricsOption;
                if (taskMetrics == null) continue;
                executorDeserializeTime += taskMetrics.executorDeserializeTime();
                executorRunTime += taskMetrics.executorRunTime();
                resultSize += taskMetrics.resultSize();
                jvmGCTime += taskMetrics.jvmGCTime();
                resultSerializationTime += taskMetrics.resultSerializationTime();
                memoryBytesSpilled += taskMetrics.memoryBytesSpilled();
                diskBytesSpilled += taskMetrics.diskBytesSpilled();
                if (!taskMetrics.inputMetrics().isEmpty()) {
                    inputMetricExist = true;
                    bytesRead += ((InputMetrics)taskMetrics.inputMetrics().get()).bytesRead();
                }
                if (!taskMetrics.outputMetrics().isEmpty()) {
                    outputMetricExist = true;
                    bytesWritten += ((OutputMetrics)taskMetrics.outputMetrics().get()).bytesWritten();
                }
                if (!(shuffleReadMetricsOption = taskMetrics.shuffleReadMetrics()).isEmpty()) {
                    shuffleReadMetricExist = true;
                    remoteBlocksFetched += (long)((ShuffleReadMetrics)shuffleReadMetricsOption.get()).remoteBlocksFetched();
                    localBlocksFetched += (long)((ShuffleReadMetrics)shuffleReadMetricsOption.get()).localBlocksFetched();
                    fetchWaitTime += ((ShuffleReadMetrics)shuffleReadMetricsOption.get()).fetchWaitTime();
                    remoteBytesRead += ((ShuffleReadMetrics)shuffleReadMetricsOption.get()).remoteBytesRead();
                }
                if ((shuffleWriteMetricsOption = taskMetrics.shuffleWriteMetrics()).isEmpty()) continue;
                shuffleWriteMetricExist = true;
                shuffleBytesWritten += ((ShuffleWriteMetrics)shuffleWriteMetricsOption.get()).shuffleBytesWritten();
                shuffleWriteTime += ((ShuffleWriteMetrics)shuffleWriteMetricsOption.get()).shuffleWriteTime();
            }
        }
        results.put("EexcutorDeserializeTime", executorDeserializeTime);
        results.put("ExecutorRunTime", executorRunTime);
        results.put("ResultSize", resultSize);
        results.put("JvmGCTime", jvmGCTime);
        results.put("ResultSerializationTime", resultSerializationTime);
        results.put("MemoryBytesSpilled", memoryBytesSpilled);
        results.put("DiskBytesSpilled", diskBytesSpilled);
        if (inputMetricExist) {
            results.put("BytesRead", bytesRead);
            this.hdfsBytesRead = bytesRead;
            this.counters.incrCounter(FS_COUNTER_GROUP, "HDFS_BYTES_READ", this.hdfsBytesRead);
        }
        if (outputMetricExist) {
            results.put("BytesWritten", bytesWritten);
            this.hdfsBytesWritten = bytesWritten;
            this.counters.incrCounter(FS_COUNTER_GROUP, "HDFS_BYTES_WRITTEN", this.hdfsBytesWritten);
        }
        if (shuffleReadMetricExist) {
            results.put("RemoteBlocksFetched", remoteBlocksFetched);
            results.put("LocalBlocksFetched", localBlocksFetched);
            results.put("TotalBlocksFetched", localBlocksFetched + remoteBlocksFetched);
            results.put("FetchWaitTime", fetchWaitTime);
            results.put("RemoteBytesRead", remoteBytesRead);
        }
        if (shuffleWriteMetricExist) {
            results.put("ShuffleBytesWritten", shuffleBytesWritten);
            results.put("ShuffleWriteTime", shuffleWriteTime);
        }
        return results;
    }

    @Override
    public String getJobId() {
        return String.valueOf(this.jobId);
    }

    @Override
    public void accept(PlanVisitor v) throws FrontendException {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getDisplayString() {
        return null;
    }

    @Override
    public int getNumberMaps() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getNumberReduces() {
        throw new UnsupportedOperationException();
    }

    @Override
    public long getMaxMapTime() {
        throw new UnsupportedOperationException();
    }

    @Override
    public long getMinMapTime() {
        throw new UnsupportedOperationException();
    }

    @Override
    public long getAvgMapTime() {
        throw new UnsupportedOperationException();
    }

    @Override
    public long getMaxReduceTime() {
        throw new UnsupportedOperationException();
    }

    @Override
    public long getMinReduceTime() {
        throw new UnsupportedOperationException();
    }

    @Override
    public long getAvgREduceTime() {
        throw new UnsupportedOperationException();
    }

    @Override
    public long getMapInputRecords() {
        throw new UnsupportedOperationException();
    }

    @Override
    public long getMapOutputRecords() {
        throw new UnsupportedOperationException();
    }

    @Override
    public long getReduceInputRecords() {
        throw new UnsupportedOperationException();
    }

    @Override
    public long getReduceOutputRecords() {
        throw new UnsupportedOperationException();
    }

    @Override
    public long getSMMSpillCount() {
        throw new UnsupportedOperationException();
    }

    @Override
    public long getProactiveSpillCountObjects() {
        throw new UnsupportedOperationException();
    }

    @Override
    public long getProactiveSpillCountRecs() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Counters getHadoopCounters() {
        return this.counters;
    }

    @Override
    public Map<String, Long> getMultiStoreCounters() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Map<String, Long> getMultiInputCounters() {
        throw new UnsupportedOperationException();
    }

    public void setAlias(SparkOperator sparkOperator) {
        SparkScriptState ss = (SparkScriptState)SparkScriptState.get();
        SparkScriptState.SparkScriptInfo sparkScriptInfo = ss.getScriptInfo();
        this.annotate("JobStatistics:alias", sparkScriptInfo.getAlias(sparkOperator));
        this.annotate("JobStatistics:alias_location", sparkScriptInfo.getAliasLocation(sparkOperator));
        this.annotate("JobStatistics:feature", sparkScriptInfo.getPigFeatures(sparkOperator));
    }

    private void initializeHadoopCounter() {
        this.counters = new Counters();
        Counters.Group fsGrp = (Counters.Group)this.counters.addGroup(FS_COUNTER_GROUP, FS_COUNTER_GROUP);
        fsGrp.addCounter("HDFS_BYTES_READ", "HDFS_BYTES_READ", 0L);
        fsGrp.addCounter("HDFS_BYTES_WRITTEN", "HDFS_BYTES_WRITTEN", 0L);
    }

    public Map<String, SparkCounter<Map<String, Long>>> getWarningCounters() {
        return this.warningCounters;
    }

    public void initWarningCounters() {
        SparkCounters counters = SparkPigStatusReporter.getInstance().getCounters();
        SparkCounterGroup sparkCounterGroup = counters.getSparkCounterGroups().get(PigWarning.class.getCanonicalName());
        if (sparkCounterGroup != null) {
            this.warningCounters = sparkCounterGroup.getSparkCounters();
        }
    }
}

