/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.util;

public class Stat {
    long max = Long.MIN_VALUE;
    long min = Long.MAX_VALUE;
    long sum = 0L;
    int count = 0;
    double partialStdDev = 0.0;

    public void addStat(long stat) {
        if (stat > this.max) {
            this.max = stat;
        }
        if (stat < this.min) {
            this.min = stat;
        }
        this.sum += stat;
        this.partialStdDev += (double)(stat * stat);
        ++this.count;
    }

    public long getMin() {
        return this.min;
    }

    public long getMax() {
        return this.max;
    }

    public double getAverage() {
        return (double)this.sum / (double)this.count;
    }

    public double getStdDev() {
        return Math.sqrt(this.partialStdDev / (double)this.count - this.getAverage() * this.getAverage());
    }

    public String toString() {
        return String.format("%,d %,d %,.2f %,d", this.getMin(), this.getMax(), this.getAverage(), this.count);
    }

    public void clear() {
        this.sum = 0L;
        this.count = 0;
        this.partialStdDev = 0.0;
    }

    public long getSum() {
        return this.sum;
    }
}

