/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.util.shell.commands;

import java.util.Map;
import org.apache.accumulo.core.constraints.Constraint;
import org.apache.accumulo.core.util.shell.Shell;
import org.apache.accumulo.core.util.shell.ShellCommandException;
import org.apache.accumulo.core.util.shell.commands.OptUtil;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;

public class ConstraintCommand
extends Shell.Command {
    @Override
    public int execute(String fullCommand, CommandLine cl, Shell shellState) throws Exception {
        String tableName = OptUtil.getTableOpt(cl, shellState);
        switch (OptUtil.getAldOpt(cl)) {
            case ADD: {
                for (String constraint : cl.getArgs()) {
                    if (!shellState.getConnector().tableOperations().testClassLoad(tableName, constraint, Constraint.class.getName())) {
                        throw new ShellCommandException(ShellCommandException.ErrorCode.INITIALIZATION_FAILURE, "Servers are unable to load " + constraint + " as type " + Constraint.class.getName());
                    }
                    int i = shellState.getConnector().tableOperations().addConstraint(tableName, constraint);
                    shellState.getReader().printString("Added constraint " + constraint + " to table " + tableName + " with number " + i + "\n");
                }
                break;
            }
            case DELETE: {
                for (String constraint : cl.getArgs()) {
                    int i = Integer.parseInt(constraint);
                    shellState.getConnector().tableOperations().removeConstraint(tableName, i);
                    shellState.getReader().printString("Removed constraint " + i + " from table " + tableName + "\n");
                }
                break;
            }
            case LIST: {
                for (Map.Entry<String, Integer> property : shellState.getConnector().tableOperations().listConstraints(tableName).entrySet()) {
                    shellState.getReader().printString(property.toString() + "\n");
                }
                break;
            }
        }
        return 0;
    }

    @Override
    public String description() {
        return "adds, deletes, or lists constraints for a table";
    }

    @Override
    public int numArgs() {
        return -1;
    }

    @Override
    public String usage() {
        return this.getName() + " <constraint>{ <constraint>}";
    }

    @Override
    public Options getOptions() {
        Options o = new Options();
        o.addOptionGroup(OptUtil.addListDeleteGroup("constraint"));
        o.addOption(OptUtil.tableOpt("table to add, delete, or list constraints for"));
        return o;
    }
}

