/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.util.shell.commands;

import java.util.EnumSet;
import org.apache.accumulo.core.iterators.IteratorUtil;
import org.apache.accumulo.core.util.shell.Shell;
import org.apache.accumulo.core.util.shell.commands.OptUtil;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;

public class DeleteIterCommand
extends Shell.Command {
    private Option mincScopeOpt;
    private Option majcScopeOpt;
    private Option scanScopeOpt;
    private Option nameOpt;

    @Override
    public int execute(String fullCommand, CommandLine cl, Shell shellState) throws Exception {
        String tableName = OptUtil.getTableOpt(cl, shellState);
        String name = cl.getOptionValue(this.nameOpt.getOpt());
        if (!shellState.getConnector().tableOperations().listIterators(tableName).containsKey(name)) {
            Shell.log.warn((Object)"no iterators found that match your criteria");
            return 0;
        }
        EnumSet<IteratorUtil.IteratorScope> scopes = EnumSet.noneOf(IteratorUtil.IteratorScope.class);
        if (cl.hasOption(this.mincScopeOpt.getOpt())) {
            scopes.add(IteratorUtil.IteratorScope.minc);
        }
        if (cl.hasOption(this.majcScopeOpt.getOpt())) {
            scopes.add(IteratorUtil.IteratorScope.majc);
        }
        if (cl.hasOption(this.scanScopeOpt.getOpt())) {
            scopes.add(IteratorUtil.IteratorScope.scan);
        }
        if (scopes.isEmpty()) {
            throw new IllegalArgumentException("You must select at least one scope to configure");
        }
        shellState.getConnector().tableOperations().removeIterator(tableName, name, scopes);
        return 0;
    }

    @Override
    public String description() {
        return "deletes a table-specific iterator";
    }

    @Override
    public Options getOptions() {
        Options o = new Options();
        this.nameOpt = new Option("n", "name", true, "iterator to delete");
        this.nameOpt.setArgName("itername");
        this.nameOpt.setRequired(true);
        this.mincScopeOpt = new Option(IteratorUtil.IteratorScope.minc.name(), "minor-compaction", false, "remove from minor compaction scope");
        this.majcScopeOpt = new Option(IteratorUtil.IteratorScope.majc.name(), "major-compaction", false, "remove from major compaction scope");
        this.scanScopeOpt = new Option(IteratorUtil.IteratorScope.scan.name(), "scan-time", false, "remove from scan scope");
        o.addOption(OptUtil.tableOpt("table to delete the iterator from"));
        o.addOption(this.nameOpt);
        o.addOption(this.mincScopeOpt);
        o.addOption(this.majcScopeOpt);
        o.addOption(this.scanScopeOpt);
        return o;
    }

    @Override
    public int numArgs() {
        return 0;
    }
}

