/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import net.sf.saxon.event.Outputter;
import net.sf.saxon.expr.Component;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.OperandRole;
import net.sf.saxon.expr.UnaryExpression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.XPathContextMajor;
import net.sf.saxon.expr.elab.Elaborator;
import net.sf.saxon.expr.elab.ItemEvaluator;
import net.sf.saxon.expr.elab.PullElaborator;
import net.sf.saxon.expr.elab.PullEvaluator;
import net.sf.saxon.expr.elab.PushEvaluator;
import net.sf.saxon.expr.instruct.TailCall;
import net.sf.saxon.expr.instruct.UserFunction;
import net.sf.saxon.expr.parser.ContextItemStaticInfo;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.parser.RebindingMap;
import net.sf.saxon.om.GroundedValue;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.SequenceTool;
import net.sf.saxon.trans.UncheckedXPathException;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.ItemType;

public final class TailCallLoop
extends UnaryExpression {
    UserFunction containingFunction;

    public TailCallLoop(UserFunction function, Expression body) {
        super(body);
        this.containingFunction = function;
    }

    public UserFunction getContainingFunction() {
        return this.containingFunction;
    }

    @Override
    public Expression typeCheck(ExpressionVisitor visitor, ContextItemStaticInfo contextInfo) throws XPathException {
        this.getOperand().typeCheck(visitor, contextInfo);
        return this;
    }

    @Override
    public int getImplementationMethod() {
        return this.getBaseExpression().getImplementationMethod();
    }

    @Override
    protected OperandRole getOperandRole() {
        return OperandRole.SAME_FOCUS_ACTION;
    }

    @Override
    public Expression copy(RebindingMap rebindings) {
        throw new UnsupportedOperationException("TailCallLoop.copy()");
    }

    @Override
    public SequenceIterator iterate(XPathContext context) throws XPathException {
        return this.makeElaborator().elaborateForPull().iterate(context);
    }

    @Override
    public Item evaluateItem(XPathContext context) throws XPathException {
        return this.makeElaborator().elaborateForItem().eval(context);
    }

    private UserFunction establishTargetFunction(TailCallInfo tail, XPathContextMajor cm) {
        if (tail instanceof TailCallFunction) {
            return ((TailCallFunction)tail).function;
        }
        if (tail instanceof TailCallComponent) {
            Component targetComponent = ((TailCallComponent)tail).component;
            cm.setCurrentComponent(targetComponent);
            return (UserFunction)targetComponent.getActor();
        }
        throw new AssertionError();
    }

    @Override
    public void process(Outputter output, XPathContext context) throws XPathException {
        TailCall tc = this.makeElaborator().elaborateForPush().processLeavingTail(output, context);
        assert (tc == null);
    }

    private Sequence tailCallDifferentFunction(UserFunction userFunction, XPathContextMajor cm) throws XPathException {
        cm.resetStackFrameMap(userFunction.getStackFrameMap(), userFunction.getArity());
        try {
            return userFunction.getBodyEvaluator().evaluate(cm);
        }
        catch (XPathException err) {
            throw err.maybeWithLocation(this.getLocation()).maybeWithContext(cm);
        }
    }

    @Override
    public ItemType getItemType() {
        return this.getBaseExpression().getItemType();
    }

    @Override
    public String getExpressionName() {
        return "tailCallLoop";
    }

    @Override
    public Elaborator getElaborator() {
        return new TailCallLoopElaborator();
    }

    private static class TailCallLoopElaborator
    extends PullElaborator {
        private TailCallLoopElaborator() {
        }

        @Override
        public PullEvaluator elaborateForPull() {
            TailCallLoop expr = (TailCallLoop)this.getExpression();
            PullEvaluator contentEval = expr.getBaseExpression().makeElaborator().elaborateForPull();
            return context -> {
                try {
                    TailCallInfo tail;
                    UserFunction target;
                    XPathContextMajor cm = (XPathContextMajor)context;
                    do {
                        SequenceIterator iter = contentEval.iterate(context);
                        GroundedValue extent = SequenceTool.toGroundedValue(iter);
                        tail = cm.getTailCallInfo();
                        if (tail != null) continue;
                        return extent.iterate();
                    } while ((target = expr.establishTargetFunction(tail, cm)) == expr.containingFunction);
                    return expr.tailCallDifferentFunction(target, cm).iterate();
                }
                catch (UncheckedXPathException e) {
                    throw e.getXPathException().maybeWithContext(context).maybeWithLocation(expr.getLocation());
                }
            };
        }

        @Override
        public PushEvaluator elaborateForPush() {
            TailCallLoop expr = (TailCallLoop)this.getExpression();
            PushEvaluator contentPush = expr.getBaseExpression().makeElaborator().elaborateForPush();
            return (output, context) -> {
                TailCallInfo tail;
                UserFunction target;
                XPathContextMajor cm = (XPathContextMajor)context;
                do {
                    TailCall tc = contentPush.processLeavingTail(output, context);
                    assert (tc == null);
                    tail = cm.getTailCallInfo();
                    if (tail != null) continue;
                    return null;
                } while ((target = expr.establishTargetFunction(tail, cm)) == expr.containingFunction);
                SequenceTool.process(expr.tailCallDifferentFunction(target, cm), output, expr.getLocation());
                return null;
            };
        }

        @Override
        public ItemEvaluator elaborateForItem() {
            TailCallLoop expr = (TailCallLoop)this.getExpression();
            ItemEvaluator contentEval = expr.getBaseExpression().makeElaborator().elaborateForItem();
            return context -> {
                TailCallInfo tail;
                UserFunction target;
                XPathContextMajor cm = (XPathContextMajor)context;
                do {
                    Item item = contentEval.eval(context);
                    tail = cm.getTailCallInfo();
                    if (tail != null) continue;
                    return item;
                } while ((target = expr.establishTargetFunction(tail, cm)) == expr.containingFunction);
                return expr.tailCallDifferentFunction(target, cm).head();
            };
        }
    }

    public static class TailCallFunction
    implements TailCallInfo {
        public UserFunction function;
    }

    public static class TailCallComponent
    implements TailCallInfo {
        public Component component;
        public UserFunction function;
    }

    public static interface TailCallInfo {
    }
}

